/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.util.Locale;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintRequestAttribute;

public class Margins
implements DocAttribute,
PrintRequestAttribute,
PrintJobAttribute {
    private float top;
    private float left;
    private float right;
    private float bottom;
    private static final long serialVersionUID = 5343792322705104289L;

    public Margins(float f, float f2, float f3, float f4) {
        if ((double)f < 0.0 || (double)f2 < 0.0 || (double)f3 < 0.0 || (double)f4 < 0.0) {
            throw new IllegalArgumentException("Invalid margin.");
        }
        float f5 = new Integer(this.getUnits()).floatValue();
        this.top = f * f5;
        this.left = f2 * f5;
        this.right = f3 * f5;
        this.bottom = f4 * f5;
    }

    private int getUnits() {
        String string = Locale.getDefault().getCountry();
        if ("".equals(string) || Locale.US.getCountry().equals(string) || Locale.CANADA.getCountry().equals(string)) {
            return 25400;
        }
        return 1000;
    }

    public float[] getMargins(int n) {
        switch (n) {
            case 1000: 
            case 25400: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid units.");
            }
        }
        return new float[]{this.getTop(n), this.getLeft(n), this.getRight(n), this.getBottom(n)};
    }

    public float getTop(int n) {
        return this.convertFromMicrometers(this.top, n);
    }

    public float getLeft(int n) {
        return this.convertFromMicrometers(this.left, n);
    }

    public float getRight(int n) {
        return this.convertFromMicrometers(this.right, n);
    }

    public float getBottom(int n) {
        return this.convertFromMicrometers(this.bottom, n);
    }

    @Override
    public final Class<? extends Attribute> getCategory() {
        return Margins.class;
    }

    @Override
    public final String getName() {
        return "margins";
    }

    private float convertFromMicrometers(float f, int n) {
        return f / new Integer(n).floatValue();
    }

    public String toString() {
        return this.toString(25400);
    }

    public String toString(int n) {
        String string = "";
        switch (n) {
            case 25400: {
                string = "in";
                break;
            }
            case 1000: {
                string = "mm";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid units.");
            }
        }
        float[] fArray = this.getMargins(n);
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("Margins(").append(string).append(")[top:").append(fArray[0]).append(", left:");
        stringBuilder.append(fArray[1]).append(", right:").append(fArray[2]).append(", bottom:").append(fArray[3]).append(']');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Margins) {
            Margins margins = (Margins)object;
            if (this.top == margins.top && this.left == margins.left && this.bottom == margins.bottom && this.right == margins.right) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return new Float(this.top).intValue() + 37 * new Float(this.left).intValue() + 43 * new Float(this.right).intValue() + 47 * new Float(this.bottom).intValue();
    }
}

