#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger-web
version: 1.15
id: hledger-web-1.15-8lqG9wFqAzG2vhFhoFUX26
key: hledger-web-1.15-8lqG9wFqAzG2vhFhoFUX26
license: GPL-3.0-only
maintainer: Simon Michael <simon@joyful.com>
author: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Web interface for the hledger accounting tool
description:
    This is hledger'\''s web interface.
    It provides a more user-friendly and collaborative UI than the
    command-line or curses-style interfaces.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance
abi: 7d300ed480c14ebb1713a4b23e69d14f
exposed: True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Foundation
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Json Hledger.Web.Main
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common
hidden-modules: Paths_hledger_web
import-dirs: /usr/lib/ghc-8.6.5/site-local/hledger-web-1.15
library-dirs: /usr/lib/ghc-8.6.5/site-local/hledger-web-1.15
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/hledger-web
hs-libraries: HShledger-web-1.15-8lqG9wFqAzG2vhFhoFUX26
depends:
    Decimal-0.5.1-4FeZt58Uuh79syDeoBiHXf
    aeson-1.4.6.0-53gmO5YtU8gIZiWG8EtnAc base-4.12.0.0
    blaze-html-0.9.1.2-HwoBmHvd8MidwTYIDsO4n
    blaze-markup-0.8.2.3-ATcS0IRQcDMCxhB8vW9N1d bytestring-0.10.8.2
    case-insensitive-1.2.1.0-L7BR5PaOPZy5cAHpLYQKhk
    clientsession-0.9.1.2-EM3b0Z05jU5GAgTvKJTt2
    cmdargs-0.10.20-HFOpHQTj4XE8aEWjoI1u1
    conduit-1.3.1.1-7rushQ980336tJPFaKI7Kn
    conduit-extra-1.3.4-Hpz3g3HVeraCM2NDO7b1k4 containers-0.6.0.1
    data-default-0.7.1.1-5JZ15VDIkjR94TfgciXLrQ directory-1.3.3.0
    filepath-1.4.2.1 hjsmin-0.2.0.4-JdaGi79JbWbIYBzLTeX5ol
    hledger-1.15.2-8LEi9LljjYcJubBLsav9WX
    hledger-lib-1.15.2-LgRZmckJdhvE9bKyyuSz4a
    http-client-0.6.4-IjjBqxaHkliH8n6zGH1bzH
    http-conduit-2.3.7.3-KkpdXvsmPBU66hcGZFDRUG
    http-types-0.12.3-KiHBR3VW7LN81D4RBDuP1U
    json-0.9.3-KMo6fueTh6fHhtSWtpDb75
    megaparsec-7.0.5-CZJNdrmae7v2Ggr9WXcTF8 mtl-2.2.2
    shakespeare-2.0.23-DSplswuwE23Detqyo7k6pM template-haskell-2.14.0.0
    text-1.2.3.1 time-1.8.0.2 transformers-0.5.6.2
    wai-3.2.2.1-LiO6tjlOPxLE7Ud9tulQOy
    wai-extra-3.0.28-G1GZQLp66ug2OMsgLytpZV
    wai-handler-launch-3.0.2.4-EHkkjxfB4APEWXmx9duKEW
    warp-3.3.4-4ymAS5EXdWkKGdLOBS3Jix
    yaml-0.11.2.0-mayno9TEw0ClN9SfBCSHE
    yesod-1.6.0-6dPULuUtTvQGx1QNHXGAhH
    yesod-core-1.6.16.1-CnjctK5jU6WAJRiz7znykh
    yesod-form-1.6.7-Dsr0hX255zP1rIk5G7HKjG
    yesod-static-1.6.0.1-4aSBHdt6i6hGTCgZ8qeG6Q
haddock-interfaces: /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html: /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

