/*
 * Decompiled with CFR 0.152.
 */
package org.grails.test.report.junit;

import groovy.lang.Binding;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.grails.test.report.junit.JUnitReports;
import org.grails.test.report.junit.PlainFormatter;
import org.grails.test.report.junit.XMLFormatter;

public class JUnitReportsFactory {
    public static final String XML = "xml";
    public static final String PLAIN = "plain";
    protected final String phaseName;
    protected final String typeName;
    protected final File reportsDir;
    protected final List<String> formats;

    public static JUnitReportsFactory createFromBuildBinding(Binding buildBinding) {
        return new JUnitReportsFactory((String)buildBinding.getProperty("currentTestPhaseName"), (String)buildBinding.getProperty("currentTestTypeName"), (File)buildBinding.getProperty("testReportsDir"), (List)buildBinding.getProperty("reportFormats"));
    }

    public JUnitReportsFactory(String phaseName, String typeName, File reportsDir, List<String> formats) {
        this.phaseName = phaseName;
        this.typeName = typeName;
        this.reportsDir = reportsDir;
        this.formats = formats;
    }

    public JUnitReports createReports(String name) {
        JUnitResultFormatter[] formatters = new JUnitResultFormatter[this.formats.size()];
        for (int i = 0; i < this.formats.size(); ++i) {
            formatters[i] = this.createReport(this.formats.get(i), name);
        }
        return new JUnitReports(formatters);
    }

    protected JUnitResultFormatter createReport(String format, String name) {
        String prefix = "TEST-" + this.phaseName + "-" + this.typeName + "-" + name;
        if (format.equals(PLAIN)) {
            return new PlainFormatter(prefix, new File(this.reportsDir, "plain/" + prefix + ".txt"));
        }
        if (format.equals(XML)) {
            return new XMLFormatter(new File(this.reportsDir, prefix + ".xml"));
        }
        throw new IllegalArgumentException("Unknown format type: " + format);
    }
}

