/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.internal.locklistener.FileLockPacketType;

public class FileLockPacketPayload {
    public static final int MAX_BYTES = 10;
    private static final byte PROTOCOL_VERSION = 1;
    private static final ImmutableList<FileLockPacketType> TYPES = ImmutableList.copyOf((Object[])FileLockPacketType.values());
    private final long lockId;
    private final FileLockPacketType type;

    private FileLockPacketPayload(long lockId, FileLockPacketType type) {
        this.lockId = lockId;
        this.type = type;
    }

    public long getLockId() {
        return this.lockId;
    }

    public FileLockPacketType getType() {
        return this.type;
    }

    public static byte[] encode(long lockId, FileLockPacketType type) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(out);
        try {
            dataOutput.writeByte(1);
            dataOutput.writeLong(lockId);
            dataOutput.writeByte(type.ordinal());
            dataOutput.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to encode lockId " + lockId + " and type " + (Object)((Object)type), (Throwable)e);
        }
        return out.toByteArray();
    }

    public static FileLockPacketPayload decode(byte[] bytes, int length) throws IOException {
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(bytes));
        byte version = dataInput.readByte();
        if (version != 1) {
            throw new IllegalArgumentException(String.format("Unexpected protocol version %s received in lock contention notification message", version));
        }
        long lockId = dataInput.readLong();
        FileLockPacketType type = FileLockPacketPayload.readType(dataInput, length);
        return new FileLockPacketPayload(lockId, type);
    }

    private static FileLockPacketType readType(DataInputStream dataInput, int length) throws IOException {
        if (length < 10) {
            return FileLockPacketType.UNKNOWN;
        }
        try {
            byte ordinal = dataInput.readByte();
            if (ordinal < TYPES.size()) {
                return (FileLockPacketType)((Object)TYPES.get((int)ordinal));
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return FileLockPacketType.UNKNOWN;
    }
}

