/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.tasks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompileSpecFactory;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.file.Deleter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;
import org.gradle.util.GFileUtils;

public abstract class AbstractScalaCompile
extends AbstractCompile {
    protected static final Logger LOGGER = Logging.getLogger(AbstractScalaCompile.class);
    private final BaseScalaCompileOptions scalaCompileOptions;
    private final CompileOptions compileOptions;
    private final RegularFileProperty analysisMappingFile;
    private final ConfigurableFileCollection analysisFiles;

    protected AbstractScalaCompile(BaseScalaCompileOptions scalaCompileOptions) {
        ObjectFactory objectFactory = (ObjectFactory)this.getServices().get(ObjectFactory.class);
        this.analysisMappingFile = objectFactory.fileProperty();
        this.analysisFiles = this.getProject().files(new Object[0]);
        this.compileOptions = (CompileOptions)objectFactory.newInstance(CompileOptions.class, new Object[0]);
        this.scalaCompileOptions = scalaCompileOptions;
        this.scalaCompileOptions.setIncrementalOptions((IncrementalCompileOptions)objectFactory.newInstance(IncrementalCompileOptions.class, new Object[0]));
        CompilerForkUtils.doNotCacheIfForkingViaExecutable((CompileOptions)this.compileOptions, (TaskOutputs)this.getOutputs());
    }

    @Nested
    public BaseScalaCompileOptions getScalaCompileOptions() {
        return this.scalaCompileOptions;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    protected abstract Compiler<ScalaJavaJointCompileSpec> getCompiler(ScalaJavaJointCompileSpec var1);

    @TaskAction
    public void compile() {
        ScalaJavaJointCompileSpec spec = this.createSpec();
        this.configureIncrementalCompilation(spec);
        CleaningJavaCompiler compiler = this.getCompiler(spec);
        if (this.isNonIncrementalCompilation()) {
            compiler = new CleaningJavaCompiler(compiler, this.getOutputs(), this.getDeleter());
        }
        compiler.execute((CompileSpec)spec);
    }

    private boolean isNonIncrementalCompilation() {
        File analysisFile = (File)this.getScalaCompileOptions().getIncrementalOptions().getAnalysisFile().getAsFile().get();
        if (!analysisFile.exists()) {
            LOGGER.info("Zinc is doing a full recompile since the analysis file doesn't exist");
            return true;
        }
        return false;
    }

    protected ScalaJavaJointCompileSpec createSpec() {
        DefaultScalaJavaJointCompileSpec spec = (DefaultScalaJavaJointCompileSpec)new DefaultScalaJavaJointCompileSpecFactory(this.compileOptions).create();
        spec.setSourceFiles(this.getSource().getFiles());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List)ImmutableList.copyOf((Iterable)this.getClasspath()));
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setCompileOptions(this.getOptions());
        spec.setScalaCompileOptions(this.scalaCompileOptions);
        spec.setAnnotationProcessorPath((List)(this.compileOptions.getAnnotationProcessorPath() == null ? ImmutableList.of() : ImmutableList.copyOf((Iterable)this.compileOptions.getAnnotationProcessorPath())));
        spec.setBuildStartTimestamp(((BuildStartedTime)this.getServices().get(BuildStartedTime.class)).getStartTime());
        return spec;
    }

    private void configureIncrementalCompilation(ScalaCompileSpec spec) {
        IncrementalCompileOptions incrementalOptions = this.scalaCompileOptions.getIncrementalOptions();
        File analysisFile = (File)incrementalOptions.getAnalysisFile().getAsFile().get();
        Map<File, File> globalAnalysisMap = this.resolveAnalysisMappingsForOtherProjects();
        spec.setAnalysisMap(globalAnalysisMap);
        spec.setAnalysisFile(analysisFile);
        if (incrementalOptions.getPublishedCode().isPresent()) {
            File publishedCode = (File)incrementalOptions.getPublishedCode().getAsFile().get();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("scala-incremental Analysis file: {}", (Object)analysisFile);
                LOGGER.debug("scala-incremental Published code: {}", (Object)publishedCode);
            }
            File analysisMapping = (File)this.getAnalysisMappingFile().getAsFile().get();
            GFileUtils.writeFile((String)(publishedCode.getAbsolutePath() + "\n" + analysisFile.getAbsolutePath()), (File)analysisMapping);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("scala-incremental Analysis map: {}", globalAnalysisMap);
        }
    }

    private Map<File, File> resolveAnalysisMappingsForOtherProjects() {
        HashMap analysisMap = Maps.newHashMap();
        for (File mapping : this.analysisFiles.getFiles()) {
            if (!mapping.exists()) continue;
            try {
                List lines = Files.readLines((File)mapping, (Charset)Charset.defaultCharset());
                assert (lines.size() == 2);
                analysisMap.put(new File((String)lines.get(0)), new File((String)lines.get(1)));
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        return analysisMap;
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileTree getSource() {
        return super.getSource();
    }

    @Input
    protected String getJvmVersion() {
        return JavaVersion.current().getMajorVersion();
    }

    @Internal
    public ConfigurableFileCollection getAnalysisFiles() {
        return this.analysisFiles;
    }

    @LocalState
    public RegularFileProperty getAnalysisMappingFile() {
        return this.analysisMappingFile;
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }
}

