define(["loading","globalize","events","viewManager","layoutManager","skinManager","pluginManager","backdrop","browser","pageJs","appSettings","apphost","connectionManager"],function(loading,globalize,events,viewManager,layoutManager,skinManager,pluginManager,backdrop,browser,page,appSettings,appHost,connectionManager){"use strict";var currentViewLoadRequest,currentRouteInfo,isHandlingBackToDefault,isDummyBackToHome,firstConnectionResult,appRouter={showLocalLogin:function(serverId,manualLogin){show("/startup/"+(manualLogin?"manuallogin":"login")+".html?serverid="+serverId)},showSelectServer:function(){show("/startup/selectserver.html")},showWelcome:function(){show("/startup/welcome.html")},showConnectLogin:function(){show("/startup/connectlogin.html")},showSettings:function(){show("/settings/settings.html")},showUserMenu:function(){skinManager.getCurrentSkin().showUserMenu()},showSearch:function(){skinManager.getCurrentSkin().search()},showGuide:function(){appRouter.show(appRouter.getRouteUrl("livetv",{serverId:connectionManager.currentApiClient().serverId(),section:"guide"}))},showLiveTV:function(){appRouter.show(appRouter.getRouteUrl("livetv",{serverId:connectionManager.currentApiClient().serverId()}))},showRecordedTV:function(){appRouter.show(appRouter.getRouteUrl("recordedtv",{serverId:connectionManager.currentApiClient().serverId()}))},showFavorites:function(){invokeShortcut("favorites_"+connectionManager.currentApiClient().serverId())},showNowPlaying:function(){skinManager.getCurrentSkin().showNowPlaying()}};function beginConnectionWizard(){backdrop.clear(),loading.show(),connectionManager.connect({enableAutoLogin:appSettings.enableAutoLogin()}).then(function(result){handleConnectionResult(result,loading)})}function handleConnectionResult(result,loading){switch(result.State){case"SignedIn":loading.hide(),skinManager.loadUserSkin();break;case"ServerSignIn":result.ApiClient.getPublicUsers().then(function(users){users.length?appRouter.showLocalLogin(result.Servers[0].Id):appRouter.showLocalLogin(result.Servers[0].Id,!0)});break;case"ServerSelection":appRouter.showSelectServer();break;case"ConnectSignIn":appRouter.showWelcome();break;case"ServerUpdateNeeded":appRouter.showSelectServer()}}function loadContentUrl(ctx,route,request){var url;-1===(url=route.contentPath&&"function"==typeof route.contentPath?route.contentPath(ctx.querystring):route.contentPath||route.path).indexOf("://")&&(0!==url.indexOf("/")&&(url="/"+url),url=baseUrl()+url),ctx.querystring&&route.enableContentQueryString&&(url+="?"+ctx.querystring),require(["text!"+url],function(html){!function(ctx,route,html,request){request.view=globalize.translateDocument(html,route.dictionary),viewManager.loadView(request),currentRouteInfo={route:route,path:ctx.path},ctx.handled=!0}(ctx,route,html,request)})}function handleRoute(ctx,route){!function(ctx,route,callback){var firstResult=firstConnectionResult;if(firstResult&&(firstConnectionResult=null,"SignedIn"!==firstResult.State&&!route.anonymous))return handleConnectionResult(firstResult,loading);var apiClient=connectionManager.currentApiClient(),pathname=ctx.pathname.toLowerCase();console.log("appRouter - processing path request "+pathname);var isCurrentRouteStartup=!currentRouteInfo||currentRouteInfo.route.startup,shouldExitApp=ctx.isBack&&route.isDefaultRoute&&isCurrentRouteStartup;if(!(shouldExitApp||apiClient&&apiClient.isLoggedIn()||route.anonymous))return console.log("appRouter - route does not allow anonymous access, redirecting to login"),beginConnectionWizard();if(shouldExitApp)return appHost.supports("exit")&&appHost.exit();if(apiClient&&apiClient.isLoggedIn()){if(console.log("appRouter - user is authenticated"),ctx.isBack&&(route.isDefaultRoute||route.startup)&&!isCurrentRouteStartup)return function(){if(!appHost.supports("exitmenu")&&appHost.supports("exit"))return appHost.exit();if(isDummyBackToHome=!0,skinManager.loadUserSkin(),isHandlingBackToDefault)return;skinManager.getCurrentSkin().showBackMenu().then(function(){isHandlingBackToDefault=!1})}();if(route.isDefaultRoute)return console.log("appRouter - loading skin home page"),function(ctx){require(["queryString"],function(queryString){var params=queryString.parse(ctx.querystring);skinManager.loadUserSkin({start:params.start})})}(ctx);if(route.roles)return function(apiClient,roles){return Promise.all(roles.split(",").map(function(role){return function(apiClient,role){return"admin"!==role?Promise.resolve():apiClient.getCurrentUser().then(function(user){return user.Policy.IsAdministrator?Promise.resolve():Promise.reject()})}(apiClient,role)}))}(apiClient,route.roles).then(function(){callback()},beginConnectionWizard)}console.log("appRouter - proceeding to "+pathname),callback()}(ctx,route,function(){!function(ctx,route){function onInitComplete(controllerFactory){!function(ctx,route,controllerFactory){if(isDummyBackToHome&&"home"===route.type)return isDummyBackToHome=!1;!function(){var currentRequest=currentViewLoadRequest;currentRequest&&(currentRequest.cancel=!0)}();var isBackNav=ctx.isBack,currentRequest=Object.assign({},route);if(currentRequest.url=baseUrl()+ctx.path,currentRequest.controllerFactory=controllerFactory,currentRequest.state=ctx.state,currentRequest.isBack=isBackNav,currentViewLoadRequest=currentRequest,!isBackNav)return loadContentUrl(ctx,route,currentRequest);viewManager.tryRestoreView(currentRequest,function(){currentRouteInfo={route:route,path:ctx.path}}).catch(function(result){result&&result.cancelled||loadContentUrl(ctx,route,currentRequest)})}(ctx,route,controllerFactory)}require(route.dependencies||[],function(){route.controller?require([route.controller],onInitComplete):onInitComplete()})}(ctx,route)})}function onBeforeExit(e){browser.web0s&&page.restorePreviousState()}function normalizeImageOptions(options){var setQuality,scaleFactor=browser.tv?.8:1;if(options.maxWidth&&(options.maxWidth=Math.round(options.maxWidth*scaleFactor),setQuality=!0),options.width&&(options.width=Math.round(options.width*scaleFactor),setQuality=!0),options.maxHeight&&(options.maxHeight=Math.round(options.maxHeight*scaleFactor),setQuality=!0),options.height&&(options.height=Math.round(options.height*scaleFactor),setQuality=!0),setQuality){var quality=100,type=options.type||"Primary";quality=browser.tv||browser.slow?browser.chrome?"Primary"===type?40:50:"Backdrop"===type?60:50:"Backdrop"===type?70:90,options.quality=quality}}function getMaxBandwidth(){var connection=navigator.connection;if(connection){var downlink=connection.downlink;if(downlink&&0<downlink&&downlink<Number.POSITIVE_INFINITY)return downlink*=1e6,downlink*=.7,downlink=parseInt(downlink);if((downlink=connection.downlinkMax)&&0<downlink&&downlink<Number.POSITIVE_INFINITY)return downlink*=1e6,downlink*=.7,downlink=parseInt(downlink)}return browser.iOS?15e5:null}function onApiClientCreated(e,newApiClient){newApiClient.normalizeImageOptions=normalizeImageOptions,newApiClient.getMaxBandwidth=getMaxBandwidth}function initApiClient(apiClient){onApiClientCreated(0,apiClient)}function onAppResume(){var apiClient=connectionManager.currentApiClient();apiClient&&apiClient.ensureWebSocket()}function getRequestFile(){var path=self.location.pathname||"",index=path.lastIndexOf("/");return(path=-1!==index?path.substring(index):"/"+path)&&"/"!==path||(path="/index.html"),path}function endsWith(str,srch){return str.lastIndexOf(srch)===srch.length-1}appHost.supports("multiserver")&&navigator.connection&&navigator.connection.addEventListener&&navigator.connection.addEventListener("change",function(){connectionManager.onNetworkChanged()});var resolveOnNextShow,baseRoute=self.location.href.split("?")[0].replace(getRequestFile(),"");function baseUrl(){return baseRoute}function show(path,options){0!==path.indexOf("/")&&-1===path.indexOf("://")&&(path="/"+path);var baseRoute=baseUrl();return path=path.replace(baseRoute,""),currentRouteInfo&&currentRouteInfo.path===path&&"home"!==currentRouteInfo.route.type?(loading.hide(),Promise.resolve()):new Promise(function(resolve,reject){resolveOnNextShow=resolve,page.show(path,options)})}function current(){return currentRouteInfo?currentRouteInfo.route:null}endsWith(baseRoute=baseRoute.split("#")[0],"/")&&!endsWith(baseRoute,"://")&&(baseRoute=baseRoute.substring(0,baseRoute.length-1)),document.addEventListener("viewshow",function(){var resolve=resolveOnNextShow;resolve&&(resolveOnNextShow=null,resolve())});var backdropContainer,backgroundContainer,allRoutes=[];function invokeShortcut(id){0===id.indexOf("library-")?(id=(id=id.replace("library-","")).split("_"),appRouter.showItem(id[0],id[1])):0===id.indexOf("item-")?(id=(id=id.replace("item-","")).split("_"),appRouter.showItem(id[0],id[1])):(id=id.split("_"),appRouter.show(appRouter.getRouteUrl(id[0],{serverId:id[1]})))}return function(){var baseRoute=self.location.pathname.replace(getRequestFile(),"");baseRoute.lastIndexOf("/")===baseRoute.length-1&&(baseRoute=baseRoute.substring(0,baseRoute.length-1)),console.log("Setting page base to "+baseRoute),page.base(baseRoute)}(),appRouter.addRoute=function(path,newRoute){page(path,newRoute,handleRoute),allRoutes.push(newRoute)},appRouter.param=function(name,url){name=name.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");var results=new RegExp("[\\?&]"+name+"=([^&#]*)","i").exec(url||function(){var currentPath=currentRouteInfo&&currentRouteInfo.path||"",index=currentPath.indexOf("?"),search="";return-1!==index&&(search=currentPath.substring(index)),search||""}());return null==results?"":decodeURIComponent(results[1].replace(/\+/g," "))},appRouter.back=function(){page.back()},appRouter.show=show,appRouter.start=function(options){loading.show(),connectionManager.getApiClients().forEach(initApiClient),events.on(connectionManager,"apiclientcreated",onApiClientCreated),events.on(appHost,"beforeexit",onBeforeExit),events.on(appHost,"resume",onAppResume),connectionManager.connect({enableAutoLogin:appSettings.enableAutoLogin()}).then(function(result){firstConnectionResult=result,loading.hide(),page({click:!1!==(options=options||{}).click,hashbang:!1!==options.hashbang,enableHistory:function(){if(browser.xboxOne&&!browser.edgeUwp)return!1;if(browser.orsay)return!1;return!0}()})})},appRouter.baseUrl=baseUrl,appRouter.canGoBack=function(){var curr=current();return!!curr&&("home"!==curr.type&&page.canGoBack())},appRouter.current=current,appRouter.beginConnectionWizard=beginConnectionWizard,appRouter.goHome=function(){var skin=skinManager.getCurrentSkin();if(skin.getHomeRoute){var homePath=skin.getHomeRoute();return show(pluginManager.mapRoute(skin,homePath))}var homeRoute=skin.getRoutes().filter(function(r){return"home"===r.type})[0];return show(pluginManager.mapRoute(skin,homeRoute))},appRouter.showItem=function(item,serverId,options){if("string"==typeof item){var apiClient=serverId?connectionManager.getApiClient(serverId):connectionManager.currentApiClient();apiClient.getItem(apiClient.getCurrentUserId(),item).then(function(item){appRouter.showItem(item,options)})}else{2===arguments.length&&(options=serverId);var url=appRouter.getRouteUrl(item,options);appRouter.show(url,{item:item})}},appRouter.setTitle=function(title){require(["appHeader"],function(appHeader){appHeader.setTitle(title)})},appRouter.setTransparency=function(level){backdropContainer=backdropContainer||document.querySelector(".backdropContainer"),backgroundContainer=backgroundContainer||document.querySelector(".backgroundContainer"),"full"===level||2===level?(backdrop.clear(!0),document.documentElement.classList.add("transparentDocument"),backgroundContainer.classList.add("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):"backdrop"===level||1===level?(backdrop.externalBackdrop(!0),document.documentElement.classList.add("transparentDocument"),backgroundContainer.classList.add("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):(backdrop.externalBackdrop(!1),document.documentElement.classList.remove("transparentDocument"),backgroundContainer.classList.remove("backgroundContainer-transparent"),backdropContainer.classList.remove("hide"))},appRouter.getRoutes=function(){return allRoutes},appRouter.getRouteUrl=function(item,options){return"downloads"===item?"offline/offline.html":"managedownloads"===item?"offline/managedownloads.html":"settings"===item?"settings/settings.html":skinManager.getCurrentSkin().getRouteUrl(item,options)},appRouter.pushState=function(state,title,url){state.navigate=!1,page.pushState(state,title,url)},appRouter.enableNativeHistory=function(){return page.enableNativeHistory()},appRouter.showVideoOsd=function(){var skin=skinManager.getCurrentSkin(),homeRoute=skin.getRoutes().filter(function(r){return"video-osd"===r.type})[0];return show(pluginManager.mapRoute(skin,homeRoute))},appRouter.handleAnchorClick=page.handleAnchorClick,appRouter.TransparencyLevel={None:0,Backdrop:1,Full:2},appRouter.invokeShortcut=invokeShortcut,appRouter});