define(["events","globalize","playbackManager","connectionManager","playMethodHelper","layoutManager","serverNotifications","paper-icon-button-light","css!./playerstats"],function(events,globalize,playbackManager,connectionManager,playMethodHelper,layoutManager,serverNotifications){"use strict";function translateReason(reason){return globalize.translate(""+reason)}function getDisplayBitrate(bitrate){return 1e6<bitrate?(bitrate/1e6).toFixed(1)+" Mbps":Math.floor(bitrate/1e3)+" kbps"}function getStats(instance,player){var statsPromise=player.getStats?player.getStats():Promise.resolve({}),sessionPromise=function(instance,player){if((new Date).getTime()-(instance.lastSessionTime||0)<1e4)return Promise.resolve(instance.lastSession);var apiClient=connectionManager.getApiClient(playbackManager.currentItem(player).ServerId);return apiClient.getSessions({deviceId:apiClient.deviceId()}).then(function(sessions){return instance.lastSession=sessions[0]||{},instance.lastSessionTime=(new Date).getTime(),Promise.resolve(instance.lastSession)},function(){return Promise.resolve({})})}(instance,player);return Promise.all([statsPromise,sessionPromise]).then(function(responses){var playerStats=responses[0].categories||[],session=responses[1],displayPlayMethod=playMethodHelper.getDisplayPlayMethod(session),baseCategory={stats:[],name:"Playback Info"};baseCategory.stats.unshift({label:"Play method:",value:displayPlayMethod}),baseCategory.stats.unshift({label:"Player:",value:player.name});var categories=[];categories.push(baseCategory);for(var i=0,length=playerStats.length;i<length;i++){var category=playerStats[i];"audio"===category.type?category.name="Audio Info":"video"===category.type&&(category.name="Video Info"),categories.push(category)}return session.TranscodingInfo&&categories.push({stats:function(session,player,displayPlayMethod){var videoCodec,audioCodec,totalBitrate,sessionStats=[];return session.TranscodingInfo&&(videoCodec=session.TranscodingInfo.VideoCodec,audioCodec=session.TranscodingInfo.AudioCodec,totalBitrate=session.TranscodingInfo.Bitrate,session.TranscodingInfo.AudioChannels),videoCodec&&sessionStats.push({label:"Video codec:",value:session.TranscodingInfo.IsVideoDirect?videoCodec.toUpperCase()+" (direct)":videoCodec.toUpperCase()}),audioCodec&&sessionStats.push({label:"Audio codec:",value:session.TranscodingInfo.IsAudioDirect?audioCodec.toUpperCase()+" (direct)":audioCodec.toUpperCase()}),"Transcode"===displayPlayMethod&&(totalBitrate&&sessionStats.push({label:"Bitrate:",value:getDisplayBitrate(totalBitrate)}),session.TranscodingInfo.CompletionPercentage&&sessionStats.push({label:"Transcoding progress:",value:session.TranscodingInfo.CompletionPercentage.toFixed(1)+"%"}),session.TranscodingInfo.Framerate&&sessionStats.push({label:"Transcoding framerate:",value:session.TranscodingInfo.Framerate+" fps"}),session.TranscodingInfo.TranscodeReasons&&session.TranscodingInfo.TranscodeReasons.length&&sessionStats.push({label:"Reason for transcoding:",value:session.TranscodingInfo.TranscodeReasons.map(translateReason).join("<br/>")})),sessionStats}(session,0,displayPlayMethod),name:"Transcode"===displayPlayMethod?"Transcoding Info":"Direct Stream Info"}),categories.push({stats:function(session,player){var sessionStats=[],mediaSource=playbackManager.currentMediaSource(player)||{},totalBitrate=mediaSource.Bitrate;mediaSource.Container&&sessionStats.push({label:"Container:",value:mediaSource.Container}),totalBitrate&&sessionStats.push({label:"Bitrate:",value:getDisplayBitrate(totalBitrate)});var videoStream=(mediaSource.MediaStreams||[]).filter(function(s){return"Video"===s.Type})[0]||{},videoCodec=videoStream.Codec,audioStreamIndex=playbackManager.getAudioStreamIndex(player),audioStream=playbackManager.audioTracks(player).filter(function(s){return"Audio"===s.Type&&s.Index===audioStreamIndex})[0]||{},audioCodec=audioStream.Codec,audioChannels=audioStream.Channels,videoInfos=[];videoCodec&&videoInfos.push(videoCodec.toUpperCase()),videoStream.Profile&&videoInfos.push(videoStream.Profile),videoInfos.length&&sessionStats.push({label:"Video codec:",value:videoInfos.join(" ")}),videoStream.BitRate&&sessionStats.push({label:"Video bitrate:",value:getDisplayBitrate(videoStream.BitRate)}),(videoStream.AverageFrameRate||videoStream.RealFrameRate)&&sessionStats.push({label:"Video framerate:",value:(videoStream.AverageFrameRate||videoStream.RealFrameRate)+" fps"});var audioInfos=[];return audioCodec&&audioInfos.push(audioCodec.toUpperCase()),audioStream.Profile&&audioInfos.push(audioStream.Profile),audioInfos.length&&sessionStats.push({label:"Audio codec:",value:audioInfos.join(" ")}),audioStream.BitRate&&sessionStats.push({label:"Audio bitrate:",value:getDisplayBitrate(audioStream.BitRate)}),audioChannels&&sessionStats.push({label:"Audio channels:",value:audioChannels}),audioStream.SampleRate&&sessionStats.push({label:"Audio sample rate:",value:audioStream.SampleRate+" Hz"}),audioStream.BitDepth&&sessionStats.push({label:"Audio bit depth:",value:audioStream.BitDepth}),sessionStats}(0,player),name:"Original Media Info"}),Promise.resolve(categories)})}function bindEvents(instance,player){function localOnTimeUpdate(){!function(instance,player){var now=(new Date).getTime();now-(instance.lastRender||0)<700||(instance.lastRender=now,getStats(instance,player).then(function(stats){var elem=instance.element;elem&&function(elem,categories){elem.querySelector(".playerStats-stats").innerHTML=categories.map(function(category){var categoryHtml="",stats=category.stats;stats.length&&category.name&&(categoryHtml+='<div class="playerStats-stat playerStats-stat-header">',categoryHtml+='<div class="playerStats-stat-label">',categoryHtml+=category.name,categoryHtml+="</div>",categoryHtml+='<div class="playerStats-stat-value">',categoryHtml+=category.subText||"",categoryHtml+="</div>",categoryHtml+="</div>");for(var i=0,length=stats.length;i<length;i++){categoryHtml+='<div class="playerStats-stat">';var stat=stats[i];categoryHtml+='<div class="playerStats-stat-label">',categoryHtml+=stat.label,categoryHtml+="</div>",categoryHtml+='<div class="playerStats-stat-value">',categoryHtml+=stat.value,categoryHtml+="</div>",categoryHtml+="</div>"}return categoryHtml}).join("")}(elem,stats)}))}(instance,player)}instance.onTimeUpdate=localOnTimeUpdate,events.on(player,"timeupdate",localOnTimeUpdate)}function unbindEvents(instance,player){var localOnTimeUpdate=instance.onTimeUpdate;localOnTimeUpdate&&events.off(player,"timeupdate",localOnTimeUpdate)}function PlayerStats(options){this.options=options,function(instance){var button,parent=document.createElement("div");parent.classList.add("playerStats"),layoutManager.tv&&parent.classList.add("playerStats-tv"),parent.classList.add("hide"),button=layoutManager.tv?"":'<button type="button" is="paper-icon-button-light" class="playerStats-closeButton"><i class="md-icon">close</i></button>';var contentClass=layoutManager.tv?"playerStats-content playerStats-content-tv":"playerStats-content";parent.innerHTML='<div class="'+contentClass+'">'+button+'<div class="playerStats-stats"></div></div>',(button=parent.querySelector(".playerStats-closeButton"))&&button.addEventListener("click",function(){this.enabled(!1)}.bind(instance)),document.body.appendChild(parent),instance.element=parent}(this),this.enabled(!0)}return PlayerStats.prototype.enabled=function(enabled){if(null==enabled)return this._enabled;var options=this.options;options&&((this._enabled=enabled)?(this.element.classList.remove("hide"),bindEvents(this,options.player)):(this.element.classList.add("hide"),unbindEvents(this,options.player)))},PlayerStats.prototype.toggle=function(){this.enabled(!this.enabled())},PlayerStats.prototype.destroy=function(){var options=this.options;options&&(this.options=null,unbindEvents(this,options.player));var elem=this.element;elem&&(elem.parentNode.removeChild(elem),this.element=null)},PlayerStats});