define(["dom","layoutManager","browser","css!./headroom"],function(dom,layoutManager,browser){"use strict";window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame;function Headroom(elems,options){options=options||{},this.lastKnownScrollY=0,this.elems=elems,this.scrollElementForEvents=options.scroller||window,this.scroller=this.scrollElementForEvents,this.debouncer=this.update.bind(this),this.offset=options.offset,this.initialised=!1}var toleranceLevel=browser.iOS?14:4;return Headroom.prototype={constructor:Headroom,init:function(){if(this.onHeadroomClearedExternallyFn=function(){this.transform=null}.bind(this),this.onHeadroomForceClearedExternallyFn=function(){this.transform=null,this.setTransform(0)}.bind(this),browser.supportsCssAnimation()){for(var i=0,length=this.elems.length;i<length;i++){var elem=this.elems[i];this.initElem(elem)}this.attachEvent()}return this},add:function(elem){var elems=this.elems;browser.supportsCssAnimation()&&-1===elems.indexOf(elem)&&(this.initElem(elem),elems.push(elem))},initElem:function(elem){elem.classList.add("headroom");var onHeadroomClearedExternallyFn=this.onHeadroomClearedExternallyFn,onHeadroomForceClearedExternallyFn=this.onHeadroomForceClearedExternallyFn;elem.addEventListener("clearheadroom",onHeadroomClearedExternallyFn),elem.addEventListener("forceclearheadroom",onHeadroomForceClearedExternallyFn)},remove:function(elem){elem.classList.remove("headroom");var onHeadroomClearedExternallyFn=this.onHeadroomClearedExternallyFn,onHeadroomForceClearedExternallyFn=this.onHeadroomForceClearedExternallyFn;elem.removeEventListener("clearheadroom",onHeadroomClearedExternallyFn),elem.removeEventListener("forceclearheadroom",onHeadroomForceClearedExternallyFn);var i=this.elems.indexOf(elem);-1!==i&&this.elems.splice(i,1)},pause:function(){this.paused=!0},resume:function(){this.paused=!1},destroy:function(){this.initialised=!1;for(var i=0,length=this.elems.length;i<length;i++){this.elems[i].classList.remove("headroom")}var scroller=this.scrollElementForEvents;if(scroller){var scrollEventName=scroller.getScrollEventName?scroller.getScrollEventName():"scroll";dom.removeEventListener(scroller,scrollEventName,this.debouncer,{capture:!1,passive:!0})}this.scrollElementForEvents=null,this.scroller=null},attachEvent:function(){if(!this.initialised){this.lastKnownScrollY=this.getScrollY(),this.initialised=!0;var scroller=this.scrollElementForEvents,scrollEventName=scroller.getScrollEventName?scroller.getScrollEventName():"scroll";dom.addEventListener(scroller,scrollEventName,this.debouncer,{capture:!1,passive:!0}),this.update()}},setTransform:function(value,currentScrollY){if(value!==this.transform){value=0===(this.transform=value)?"none":1===value?"translateY(-100%)":"translateY(-"+value+"px)";for(var elems=this.elems,i=0,length=elems.length;i<length;i++){elems[i].style.transform=value}}},getScrollY:function(){var scroller=this.scroller;if(scroller.getScrollPosition)return scroller.getScrollPosition();var scrollTop=scroller.scrollTop;return void 0!==scrollTop?scrollTop:(document.scrollingElement||document.documentElement||document.body).scrollTop},shouldUnpin:function(currentScrollY){var scrollingDown=currentScrollY>this.lastKnownScrollY,pastOffset=currentScrollY>=this.offset;return scrollingDown&&pastOffset},update:function(){if(!this.paused){var currentScrollY=this.getScrollY();if(currentScrollY<0)this.ticking=!1;else{var lastKnownScrollY=this.lastKnownScrollY,isTv=layoutManager.tv,max=isTv?130:90;if(currentScrollY<=(isTv?max:0))this.setTransform(0,currentScrollY);else if(!isTv&&currentScrollY<lastKnownScrollY){Math.abs(currentScrollY-lastKnownScrollY)>=toleranceLevel&&this.setTransform(0,currentScrollY)}else{var transformValue=currentScrollY;transformValue<=0?transformValue=0:max<=transformValue&&(transformValue=1),this.setTransform(transformValue,currentScrollY)}this.lastKnownScrollY=currentScrollY,this.ticking=!1}}}},Headroom});