define(["browser","layoutManager","globalize","datetime","playbackManager","connectionManager","require","mainTabsManager","serverNotifications","appRouter","apphost","events","headroom-window","paper-icon-button-light","material-icons","css!./appheader"],function(browser,layoutManager,globalize,datetime,playbackManager,connectionManager,require,mainTabsManager,serverNotifications,appRouter,appHost,events,windowHeadroom){"use strict";var headerHomeButton,headerMenuButton,headerBackButton,headerCastButton,selectedPlayerText,headerLeft,headerRight,currentServerId,libraryMenu,boundLayoutModeChangeFn,skinHeaderElement=document.querySelector(".skinHeader"),hasPhysicalBackButton=appHost.supports("physicalbackbutton"),userSignedIn=!1;function updateClock(){var clock=this.clockElement;clock&&(clock.innerHTML=datetime.getDisplayTime(new Date).toLowerCase())}function onLocalUserSignedOut(e){userSignedIn=!1,document.querySelector(".headerSearchButton").classList.add("hide"),updateUserInHeader(null),setRemoteControlVisibility()}function updateUserInHeader(user){var userImageUrl,headerUserButton=document.querySelector(".headerUserButton"),headerManageServerButton=document.querySelector(".headerManageServerButton");user&&user.PrimaryImageTag&&(userImageUrl=function(user,apiClient,options){return(options=options||{}).type="Primary",user.PrimaryImageTag?(options.tag=user.PrimaryImageTag,apiClient.getUserImageUrl(user.Id,options)):null}(user,connectionManager.getApiClient(user.ServerId),{height:Math.round(38*Math.max(window.devicePixelRatio||1,2))}));headerUserButton.innerHTML=userImageUrl?'<img class="headerUserButtonImage paper-icon-button-img" src="'+userImageUrl+'" />':'<i class="md-icon">&#xE7FD;</i>',user?(headerUserButton.classList.remove("hide"),user.Policy.IsAdministrator&&self.Dashboard&&!layoutManager.tv?headerManageServerButton.classList.remove("hide"):headerManageServerButton.classList.add("hide")):(headerUserButton.classList.add("hide"),headerManageServerButton.classList.add("hide"))}function onUserUpdated(e,apiClient,data){apiClient.getCurrentUserId()===data.Id&&apiClient.serverId()===currentServerId&&apiClient.isMinServerVersion("3.6.0.32")&&updateUserInHeader(data)}function resetPremiereButton(){window.AndroidAppHost||window.webkit&&window.webkit.messageHandlers||window.Dashboard&&require(["registrationServices","emby-button"],function(registrationServices){registrationServices.validateFeature("themes",{viewOnly:!0,showDialog:!1}).then(removePremiereButton,function(){!function(registrationServices){var html='<button is="emby-button" class="raised button-submit btnHeaderPremiere headerButton" style="margin-right:1em;padding-top:.5em;padding-bottom:.5em;">'+globalize.translate("HeaderBecomeProjectSupporter")+"</button>";if(document.querySelector(".btnHeaderPremiere"))return;document.querySelector(".headerRight").insertAdjacentHTML("afterbegin",html),document.querySelector(".btnHeaderPremiere").addEventListener("click",function(){registrationServices.validateFeature("themes",{viewOnly:!0}).then(resetPremiereButton)})}(registrationServices)})})}function removePremiereButton(){var btn=document.querySelector(".btnHeaderPremiere");btn&&btn.parentNode.removeChild(btn)}function onLocalUserSignedIn(e,serverId,userId){currentServerId=serverId,userSignedIn=!0,document.querySelector(".headerSearchButton").classList.remove("hide"),connectionManager.getApiClient(serverId).getUser(userId).then(updateUserInHeader),resetPremiereButton(),setRemoteControlVisibility()}function onHeaderMenuButtonClick(){libraryMenu?libraryMenu.onHardwareMenuButtonClick():require(["libraryMenu"],function(a){(libraryMenu=a).onHardwareMenuButtonClick()})}function onHomeClick(){appRouter.goHome()}function onBackClick(){appRouter.back()}function onSearchClick(){appRouter.showSearch()}function onNowPlayingClick(){appRouter.showNowPlaying()}function onUserButtonClick(){appRouter.showUserMenu()}function onManageServerButtonClick(){Dashboard.navigate("dashboard.html")}function onCastButtonClick(){var btn=this;require(["playerSelectionMenu"],function(playerSelectionMenu){playerSelectionMenu.show(btn)})}function updateSkinHeaderBackdropFilter(){browser.android||layoutManager.tv?skinHeaderElement.classList.add("nobackdropfilter"):skinHeaderElement.classList.remove("nobackdropfilter")}function updateCastIcon(){var btnCast=headerCastButton;if(btnCast){var info=playbackManager.getPlayerInfo();info&&!info.isLocalPlayer?(btnCast.querySelector("i").innerHTML="&#xE308;",btnCast.classList.add("active"),selectedPlayerText.innerHTML=info.deviceName||info.name):(btnCast.querySelector("i").innerHTML="&#xE307;",btnCast.classList.remove("active"),selectedPlayerText.innerHTML="")}}function onPlaybackStart(e,player,state){layoutManager.tv&&state.NowPlayingItem&&"Audio"===state.NowPlayingItem.MediaType?(document.querySelector(".headerAudioPlayerButton").classList.remove("hide"),state.IsFirstItem&&state.IsFullscreen&&onNowPlayingClick()):document.querySelector(".headerAudioPlayerButton").classList.add("hide")}function onPlaybackStop(e,stopInfo){"Audio"!==stopInfo.nextMediaType&&document.querySelector(".headerAudioPlayerButton").classList.add("hide")}function setRemoteControlVisibility(){appHost.supports("remotecontrol")&&!layoutManager.tv&&userSignedIn?(headerCastButton.classList.remove("hide"),selectedPlayerText.classList.remove("hide")):(headerCastButton.classList.add("hide"),selectedPlayerText.classList.add("hide"))}function onViewShow(e){var skinHeader=skinHeaderElement;!1===e.detail.headerBackground&&skinHeader.classList.remove("skinHeader-withBackground"),skinHeader.dispatchEvent(new CustomEvent("forceclearheadroom",{cancelable:!1})),e.detail.autoHideHeader?windowHeadroom.add(skinHeader):windowHeadroom.remove(skinHeader),function(e){var backButtonConfig=e.detail.backButton;!1!==backButtonConfig&&appRouter.canGoBack()?hasPhysicalBackButton&&!0!==backButtonConfig?headerBackButton.classList.add("hide"):headerBackButton.classList.remove("hide"):headerBackButton.classList.add("hide")}(e),function(e){userSignedIn&&!layoutManager.tv&&!1!==e.detail.homeButton?headerHomeButton.classList.remove("hide"):headerHomeButton.classList.add("hide")}(e),function(e,view){self.Dashboard&&!layoutManager.tv&&userSignedIn&&!1!==e.detail.secondaryHeaderFeatures&&!view.classList.contains("type-interior")?headerMenuButton.classList.remove("hide"):headerMenuButton.classList.add("hide")}(e,e.target),this.setTransparent(e.detail.transparentHeader),function(header,e){!1===e.detail.secondaryHeaderFeatures?headerRight.classList.add("hide"):headerRight.classList.remove("hide")}(0,e,e.target),function(header,e,view){if(e.detail.defaultTitle)header.setDefaultTitle();else{var title=e.detail.title||view.getAttribute("data-title");title&&header.setTitle(title)}}(this,e,e.target)}function onViewBeforeShow(e){e.detail.headerTabs?(headerLeft.classList.add("headerPartFixedWidth"),headerRight.classList.add("headerPartFixedWidth")):(mainTabsManager.setTabs(null),headerLeft.classList.remove("headerPartFixedWidth"),headerRight.classList.remove("headerPartFixedWidth"));var skinHeader=skinHeaderElement;skinHeader.dispatchEvent(new CustomEvent("clearheadroom",{cancelable:!1})),!1!==e.detail.headerBackground&&skinHeader.classList.add("skinHeader-withBackground")}function bindEvents(instance){var parent=instance.element;headerBackButton=parent.querySelector(".headerBackButton"),headerHomeButton=parent.querySelector(".headerHomeButton"),headerMenuButton=parent.querySelector(".headerMenuButton"),headerCastButton=parent.querySelector(".headerCastButton"),selectedPlayerText=parent.querySelector(".headerSelectedPlayer"),headerLeft=parent.querySelector(".headerLeft"),headerRight=parent.querySelector(".headerRight"),headerBackButton.addEventListener("click",onBackClick),headerHomeButton.addEventListener("click",onHomeClick),parent.querySelector(".headerSearchButton").addEventListener("click",onSearchClick),parent.querySelector(".headerAudioPlayerButton").addEventListener("click",onNowPlayingClick),headerCastButton.addEventListener("click",onCastButtonClick),parent.querySelector(".headerUserButton").addEventListener("click",onUserButtonClick),parent.querySelector(".headerManageServerButton").addEventListener("click",onManageServerButtonClick),headerMenuButton.addEventListener("click",onHeaderMenuButtonClick),boundLayoutModeChangeFn=function(){updateSkinHeaderBackdropFilter(),this.destroyClock(),this.loadClock()}.bind(instance),events.on(layoutManager,"modechange",boundLayoutModeChangeFn),events.on(playbackManager,"playerchange",updateCastIcon),events.on(playbackManager,"playbackstart",onPlaybackStart),events.on(playbackManager,"playbackstop",onPlaybackStop),events.on(connectionManager,"localusersignedin",onLocalUserSignedIn),events.on(connectionManager,"localusersignedout",onLocalUserSignedOut),events.on(serverNotifications,"UserUpdated",onUserUpdated),document.addEventListener("viewbeforeshow",onViewBeforeShow),document.addEventListener("viewshow",onViewShow.bind(instance)),resetPremiereButton(),events.on(connectionManager,"resetregistrationinfo",resetPremiereButton)}function AppHeader(){}return AppHeader.prototype.init=function(){return function(instance){return instance.element=skinHeaderElement,updateSkinHeaderBackdropFilter(instance.element),require(["text!./appheader.template.html"]).then(function(responses){instance.element.innerHTML=globalize.translateHtml(responses[0]),bindEvents(instance),setRemoteControlVisibility(),instance.loadClock()})}(this)},AppHeader.prototype.loadClock=function(){if(layoutManager.tv){var elem=document.querySelector(".headerClock");elem.classList.remove("hide"),this.clockElement=elem,this.clockInterval=setInterval(updateClock.bind(this),5e4),updateClock.call(this)}else this.destroyClock()},AppHeader.prototype.setDefaultTitle=function(title){var pageTitleElement=this.pageTitleElement;(pageTitleElement=pageTitleElement||(this.pageTitleElement=document.querySelector(".pageTitle")))&&(pageTitleElement.classList.add("pageTitleWithLogo"),pageTitleElement.classList.add("pageTitleWithDefaultLogo"),pageTitleElement.style.backgroundImage=null,pageTitleElement.innerHTML=""),document.title="Emby"},AppHeader.prototype.setTitle=function(title){if(null!=title){"-"===title&&(title="");var html=title,pageTitleElement=this.pageTitleElement;(pageTitleElement=pageTitleElement||(this.pageTitleElement=document.querySelector(".pageTitle")))&&(pageTitleElement.classList.remove("pageTitleWithLogo"),pageTitleElement.classList.remove("pageTitleWithDefaultLogo"),pageTitleElement.style.backgroundImage=null,pageTitleElement.innerHTML=html||""),document.title=title||"Emby"}else this.setDefaultTitle()},AppHeader.prototype.setTransparent=function(transparent){transparent?skinHeaderElement.classList.add("semiTransparent"):skinHeaderElement.classList.remove("semiTransparent")},AppHeader.prototype.destroyClock=function(){var interval=this.clockInterval;interval&&clearInterval(interval);var elem=this.clockElement;elem&&elem.classList.add("hide"),this.clockElement=null,this.clockInterval=null},AppHeader.prototype.destroy=function(){this.destroyClock(),function(instance){var parent=instance.element;parent&&(parent.querySelector(".headerBackButton").removeEventListener("click",onBackClick),parent.querySelector(".headerHomeButton").removeEventListener("click",onHomeClick),parent.querySelector(".headerSearchButton").removeEventListener("click",onSearchClick),parent.querySelector(".headerAudioPlayerButton").removeEventListener("click",onNowPlayingClick),parent.querySelector(".headerCastButton").removeEventListener("click",onCastButtonClick),parent.querySelector(".headerUserButton").removeEventListener("click",onUserButtonClick),parent.querySelector(".headerManageServerButton").removeEventListener("click",onManageServerButtonClick),parent.querySelector(".headerMenuButton").removeEventListener("click",onHeaderMenuButtonClick)),events.off(layoutManager,"modechange",boundLayoutModeChangeFn),events.off(playbackManager,"playerchange",updateCastIcon),events.off(playbackManager,"playbackstart",onPlaybackStart),events.off(playbackManager,"playbackstop",onPlaybackStop),events.off(connectionManager,"localusersignedin",onLocalUserSignedIn),events.off(connectionManager,"localusersignedout",onLocalUserSignedOut),events.off(serverNotifications,"UserUpdated",onUserUpdated),events.off(connectionManager,"resetregistrationinfo",resetPremiereButton),document.removeEventListener("viewbeforeshow",onViewBeforeShow),document.removeEventListener("viewshow",onViewShow)}(this),this.element=null},new AppHeader});