/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AStoreable;
import org.objectweb.asm.Label;

public class PSubNullSafeField
extends AStoreable {
    private AStoreable guarded;

    public PSubNullSafeField(Location location, AStoreable guarded) {
        super(location);
        this.guarded = guarded;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        throw this.createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    void analyze(Locals locals) {
        if (this.write) {
            throw this.createError(new IllegalArgumentException("Can't write to null safe reference"));
        }
        this.guarded.read = this.read;
        this.guarded.analyze(locals);
        this.actual = this.guarded.actual;
        if (this.actual.isPrimitive()) {
            throw new IllegalArgumentException("Result of null safe operator must be nullable");
        }
    }

    @Override
    int accessElementCount() {
        return this.guarded.accessElementCount();
    }

    @Override
    boolean isDefOptimized() {
        return this.guarded.isDefOptimized();
    }

    @Override
    void updateActual(Class<?> actual) {
        this.guarded.updateActual(actual);
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        Label end = new Label();
        writer.dup();
        writer.ifNull(end);
        this.guarded.write(writer, globals);
        writer.mark(end);
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
        throw this.createError(new IllegalArgumentException("Can't write to null safe field"));
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        throw this.createError(new IllegalArgumentException("Can't write to null safe field"));
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        throw this.createError(new IllegalArgumentException("Can't write to null safe field"));
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.guarded);
    }
}

