/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.ui.wizards;

import java.util.Set;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.internal.jsch.ui.wizards.JSchConnectionPage;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.widgets.Shell;

public class JSchConnectionWizard
extends Wizard
implements IRemoteUIConnectionWizard {
    private final Shell fShell;
    private final JSchConnectionPage fPage;

    public JSchConnectionWizard(Shell shell, IRemoteConnectionType connectionType) {
        this.fShell = shell;
        this.fPage = new JSchConnectionPage(connectionType);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.fPage);
    }

    public IRemoteConnectionWorkingCopy open() {
        WizardDialog dialog = new WizardDialog(this.fShell, (IWizard)this);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            return this.fPage.getConnection();
        }
        return null;
    }

    public IRemoteConnectionWorkingCopy getConnection() {
        return this.fPage.getConnection();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        return true;
    }

    public void setConnection(IRemoteConnectionWorkingCopy connection) {
        this.fPage.setConnection(connection);
    }

    public void setConnectionName(String name) {
        this.fPage.setConnectionName(name);
    }

    public void setInvalidConnectionNames(Set<String> names) {
        this.fPage.setInvalidConnectionNames(names);
    }
}

