/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Dispatch;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.visitor.Visitor;

public class FieldAccess
extends Dispatch {
    private Variable field;
    public static final ChildPropertyDescriptor DISPATCHER_PROPERTY = new ChildPropertyDescriptor(FieldAccess.class, "dispatcher", VariableBase.class, true, true);
    public static final ChildPropertyDescriptor FIELD_PROPERTY = new ChildPropertyDescriptor(FieldAccess.class, "field", Variable.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(2);
        propertyList.add(FIELD_PROPERTY);
        propertyList.add(DISPATCHER_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Override
    ChildPropertyDescriptor getDispatcherProperty() {
        return DISPATCHER_PROPERTY;
    }

    public FieldAccess(int start, int end, AST ast, VariableBase dispatcher, Variable field) {
        super(start, end, ast, dispatcher);
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this.setField(field);
    }

    public FieldAccess(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.getDispatcher().accept(visitor);
        this.field.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getDispatcher().accept(visitor);
        this.field.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.getDispatcher().traverseBottomUp(visitor);
        this.field.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<FieldAccess");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Dispatcher>\n");
        this.getDispatcher().toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Dispatcher>\n");
        buffer.append("\t").append(tab).append("<Property>\n");
        this.field.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Property>\n");
        buffer.append(tab).append("</FieldAccess>");
    }

    @Override
    public int getType() {
        return 24;
    }

    public Variable getField() {
        return this.field;
    }

    @Override
    public VariableBase getMember() {
        return this.getField();
    }

    public void setField(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException();
        }
        Variable oldChild = this.field;
        this.preReplaceChild(oldChild, variable, FIELD_PROPERTY);
        this.field = variable;
        this.postReplaceChild(oldChild, variable, FIELD_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == FIELD_PROPERTY) {
            if (get) {
                return this.getField();
            }
            this.setField((Variable)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        VariableBase dispatcher = ASTNode.copySubtree(target, this.getDispatcher());
        Variable field = ASTNode.copySubtree(target, this.getField());
        FieldAccess result = new FieldAccess(this.getStart(), this.getEnd(), target, dispatcher, field);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IVariableBinding resolveFieldBinding() {
        return this.ast.getBindingResolver().resolveField(this);
    }
}

