/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class AddLibraryDialog
extends SelectionStatusDialog {
    private String newName;
    private String[] libraries;
    private IPluginModelBase model;
    private static String init = "library.jar";
    private Text text;
    private Image libImage;
    private TableViewer libraryViewer;
    private DuplicateStatusValidator validator;

    public AddLibraryDialog(Shell shell, String[] libraries, IPluginModelBase model) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setLibraryNames(libraries);
        this.setPluginModel(model);
        this.initializeImages();
        this.initializeValidator();
        this.setStatusLineAboveButtons(true);
    }

    public void setPluginModel(IPluginModelBase model) {
        this.model = model;
    }

    private void initializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.libImage = provider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
    }

    public void setLibraryNames(String[] libraries) {
        this.libraries = libraries;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.BuildEditor_AddLibraryDialog_label);
        label.setLayoutData((Object)new GridData(768));
        this.text = new Text(container, 2052);
        this.text.addModifyListener(e -> this.updateStatus(this.validator.validate(this.text.getText())));
        this.text.setLayoutData((Object)new GridData(768));
        Table table = new Table(container, 67584);
        GridData gd = new GridData(1808);
        gd.heightHint = 125;
        table.setLayoutData((Object)gd);
        this.libraryViewer = new TableViewer(table);
        this.libraryViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.libraryViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.libraryViewer.addSelectionChangedListener(e -> {
            IStructuredSelection sel = e.getStructuredSelection();
            IPluginLibrary obj = (IPluginLibrary)sel.getFirstElement();
            this.text.setText(obj != null ? obj.getName() : "");
        });
        this.libraryViewer.setInput((Object)this.model);
        AddLibraryDialog.applyDialogFont((Control)container);
        return container;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.build_add_library_dialog");
    }

    public int open() {
        this.text.setText(init);
        this.text.selectAll();
        return super.open();
    }

    protected void computeResult() {
    }

    public String getNewName() {
        return this.newName;
    }

    protected void okPressed() {
        this.newName = this.text.getText();
        super.okPressed();
    }

    private void initializeValidator() {
        this.validator = new DuplicateStatusValidator();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, PDEUIMessages.ManifestEditor_addActionText, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    class DuplicateStatusValidator {
        DuplicateStatusValidator() {
        }

        public IStatus validate(String text) {
            if (text.length() == 0) {
                return new Status(4, PDEPlugin.getPluginId(), 4, PDEUIMessages.AddLibraryDialog_emptyLibraries, null);
            }
            if (text.indexOf(32) != -1) {
                return new Status(4, PDEPlugin.getPluginId(), 4, PDEUIMessages.AddLibraryDialog_nospaces, null);
            }
            if (AddLibraryDialog.this.libraries == null || AddLibraryDialog.this.libraries.length == 0) {
                return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
            }
            if (!(text.endsWith(".jar") || text.endsWith("/") || text.equals("."))) {
                text = String.valueOf(text) + "/";
            }
            String[] stringArray = AddLibraryDialog.this.libraries;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String library = stringArray[n2];
                if (library.equals(text)) {
                    return new Status(4, PDEPlugin.getPluginId(), 4, PDEUIMessages.BuildEditor_RuntimeInfoSection_duplicateLibrary, null);
                }
                ++n2;
            }
            return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof IPluginModelBase) {
                return ((IPluginModelBase)input).getPluginBase().getLibraries();
            }
            return new Object[0];
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return ((IPluginLibrary)obj).getName();
        }

        public Image getColumnImage(Object obj, int index) {
            return AddLibraryDialog.this.libImage;
        }
    }
}

