/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourcePermissionOwner;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceOrigin;
import org.jkiss.dbeaver.registry.DataSourcePreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.FilterMapping;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.encode.ContentEncrypter;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

class DataSourceSerializerModern
implements DataSourceSerializer {
    private static final Log log = Log.getLog(DataSourceSerializerModern.class);
    private static final String NODE_CONNECTION = "#connection";
    private static Gson CONFIG_GSON = new GsonBuilder().setLenient().serializeNulls().setPrettyPrinting().create();
    private static Gson SECURE_GSON = new GsonBuilder().setLenient().serializeNulls().create();
    private boolean passwordReadCanceled = false;
    private boolean passwordWriteCanceled = false;
    private final DataSourceRegistry registry;
    private Map<String, Map<String, Map<String, String>>> secureProperties = new LinkedHashMap<String, Map<String, Map<String, String>>>();

    public DataSourceSerializerModern(DataSourceRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void saveDataSources(DBRProgressMonitor monitor, DataSourceOrigin origin, List<DataSourceDescriptor> localDataSources, IFile configFile) throws DBException, IOException {
        ByteArrayOutputStream dsConfigBuffer = new ByteArrayOutputStream(10000);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dsConfigBuffer, StandardCharsets.UTF_8);){
                Throwable throwable2 = null;
                Object var10_16 = null;
                try (JsonWriter jsonWriter = CONFIG_GSON.newJsonWriter((Writer)osw);){
                    jsonWriter.setIndent("\t");
                    jsonWriter.beginObject();
                    if (origin.isDefault()) {
                        jsonWriter.name("folders");
                        jsonWriter.beginObject();
                        for (DataSourceFolder folder : this.registry.getAllFolders()) {
                            DataSourceSerializerModern.saveFolder(jsonWriter, folder);
                        }
                        jsonWriter.endObject();
                    }
                    LinkedHashMap<String, DBVModel> virtualModels = new LinkedHashMap<String, DBVModel>();
                    LinkedHashMap<String, DBPConnectionType> connectionTypes = new LinkedHashMap<String, DBPConnectionType>();
                    LinkedHashMap<String, Map> drivers = new LinkedHashMap<String, Map>();
                    jsonWriter.name("connections");
                    jsonWriter.beginObject();
                    for (DataSourceDescriptor dataSource : localDataSources) {
                        if (dataSource.isTemporary()) continue;
                        this.saveDataSource(jsonWriter, dataSource);
                        if (dataSource.getVirtualModel().hasValuableData()) {
                            virtualModels.put(dataSource.getVirtualModel().getId(), dataSource.getVirtualModel());
                        }
                        DBPConnectionType dBPConnectionType = dataSource.getConnectionConfiguration().getConnectionType();
                        connectionTypes.put(dBPConnectionType.getId(), dBPConnectionType);
                        DriverDescriptor driver = dataSource.getDriver();
                        if (!driver.isCustom() || driver.getProviderDescriptor().isTemporary()) continue;
                        Map driverMap = drivers.computeIfAbsent(driver.getProviderId(), s -> new LinkedHashMap());
                        driverMap.put(driver.getId(), driver);
                    }
                    jsonWriter.endObject();
                    if (origin.isDefault()) {
                        List<DBSObjectFilter> savedFilters;
                        List<DBWNetworkProfile> profiles;
                        if (!virtualModels.isEmpty()) {
                            jsonWriter.name("virtual-models");
                            jsonWriter.beginObject();
                            for (DBVModel model : virtualModels.values()) {
                                model.serialize(monitor, jsonWriter);
                            }
                            jsonWriter.endObject();
                        }
                        if (!CommonUtils.isEmpty(profiles = this.registry.getNetworkProfiles())) {
                            jsonWriter.name("network-profiles");
                            jsonWriter.beginObject();
                            for (DBWNetworkProfile np : profiles) {
                                jsonWriter.name(np.getProfileName());
                                jsonWriter.beginObject();
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"description", (String)np.getProfileDescription());
                                jsonWriter.name("handlers");
                                jsonWriter.beginObject();
                                for (DBWHandlerConfiguration configuration : np.getConfigurations()) {
                                    if (!configuration.hasValuableInfo()) continue;
                                    this.saveNetworkHandlerConfiguration(jsonWriter, null, np, configuration);
                                }
                                jsonWriter.endObject();
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        if (!CommonUtils.isEmpty(savedFilters = this.registry.getSavedFilters())) {
                            jsonWriter.name("saved-filters");
                            jsonWriter.beginArray();
                            for (DBSObjectFilter dBSObjectFilter : savedFilters) {
                                if (dBSObjectFilter.isEmpty()) continue;
                                DataSourceSerializerModern.saveObjectFiler(jsonWriter, null, null, dBSObjectFilter);
                            }
                            jsonWriter.endArray();
                        }
                        if (!CommonUtils.isEmpty(connectionTypes)) {
                            jsonWriter.name("connection-types");
                            jsonWriter.beginObject();
                            for (DBPConnectionType dBPConnectionType : connectionTypes.values()) {
                                jsonWriter.name(dBPConnectionType.getId());
                                jsonWriter.beginObject();
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"name", (String)dBPConnectionType.getName());
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"color", (String)dBPConnectionType.getColor());
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"description", (String)dBPConnectionType.getDescription());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"auto-commit", (boolean)dBPConnectionType.isAutocommit());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"confirm-execute", (boolean)dBPConnectionType.isConfirmExecute());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"confirm-data-change", (boolean)dBPConnectionType.isConfirmDataChange());
                                this.serializeModifyPermissions(jsonWriter, (DBPDataSourcePermissionOwner)dBPConnectionType);
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        if (!CommonUtils.isEmpty(drivers)) {
                            jsonWriter.name("drivers");
                            jsonWriter.beginObject();
                            for (Map.Entry entry : drivers.entrySet()) {
                                jsonWriter.name((String)entry.getKey());
                                jsonWriter.beginObject();
                                for (DBPDriver driver : ((Map)entry.getValue()).values()) {
                                    ((DriverDescriptor)driver).serialize(jsonWriter, true);
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                    }
                    jsonWriter.endObject();
                    jsonWriter.flush();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"IO error while saving datasources json", (Throwable)e);
        }
        String jsonString = new String(dsConfigBuffer.toByteArray(), StandardCharsets.UTF_8);
        boolean encryptProject = CommonUtils.toBoolean((Object)this.registry.getProject().getProjectProperty("secureProject"));
        this.saveConfigFile(monitor.getNestedMonitor(), configFile, jsonString, false, encryptProject);
        try {
            configFile.setHidden(true);
        }
        catch (CoreException e) {
            log.debug((Object)e);
        }
        this.saveSecureCredentialsFile(monitor.getNestedMonitor(), (IFolder)configFile.getParent(), origin);
    }

    private String loadConfigFile(IFile file, boolean decrypt) throws IOException {
        ByteArrayOutputStream credBuffer = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream crdStream = file.getContents();){
                IOUtils.copyStream((InputStream)crdStream, (OutputStream)credBuffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading secure credentials file", (Throwable)e);
        }
        if (!decrypt) {
            return new String(credBuffer.toByteArray(), StandardCharsets.UTF_8);
        }
        ContentEncrypter encrypter = new ContentEncrypter(this.registry.getProject().getSecureStorage().getLocalSecretKey());
        try {
            return encrypter.decrypt(credBuffer.toByteArray());
        }
        catch (Exception e) {
            throw new IOException("Error decrypting encrypted file", e);
        }
    }

    private void saveConfigFile(IProgressMonitor monitor, IFile configFile, String contents, boolean teamPrivate, boolean encrypt) {
        try {
            byte[] binaryContents;
            if (encrypt) {
                ContentEncrypter encrypter = new ContentEncrypter(this.registry.getProject().getSecureStorage().getLocalSecretKey());
                binaryContents = encrypter.encrypt(contents);
            } else {
                binaryContents = contents.getBytes(StandardCharsets.UTF_8);
            }
            ByteArrayInputStream ifs = new ByteArrayInputStream(binaryContents);
            if (!configFile.exists()) {
                int updateFlags = 4097;
                if (teamPrivate) {
                    updateFlags |= 0x800;
                }
                configFile.create((InputStream)ifs, updateFlags, monitor);
            } else {
                configFile.setContents((InputStream)ifs, true, false, monitor);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error saving configuration file " + configFile.getLocation().toFile().getAbsolutePath()), (Throwable)e);
        }
    }

    private void saveSecureCredentialsFile(IProgressMonitor monitor, IFolder parent, DataSourceOrigin origin) {
        IFile credFile = parent.getFile("credentials-config" + origin.getConfigSuffix() + ".json");
        try {
            if (this.secureProperties.isEmpty()) {
                credFile.delete(true, false, monitor);
            } else {
                String jsonString = SECURE_GSON.toJson(this.secureProperties, Map.class);
                this.saveConfigFile(monitor, credFile, jsonString, true, true);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving secure credentials", (Throwable)e);
        }
    }

    @Override
    public void parseDataSources(IFile configFile, DataSourceOrigin origin, boolean refresh, DataSourceRegistry.ParseResults parseResults) throws IOException {
        IFile credFile;
        IFolder mdFolder = this.registry.getProject().getMetadataFolder(false);
        if (mdFolder.exists() && (credFile = mdFolder.getFile("credentials-config" + origin.getConfigSuffix() + ".json")).exists()) {
            try {
                String credJson = this.loadConfigFile(credFile, true);
                Map res = (Map)CONFIG_GSON.fromJson(credJson, new TypeToken<Map<String, Map<String, Map<String, String>>>>(){}.getType());
                this.secureProperties.putAll(res);
            }
            catch (Exception e) {
                log.error((Object)"Error decrypting secure credentials", (Throwable)e);
            }
        }
        boolean decryptProject = CommonUtils.toBoolean((Object)this.registry.getProject().getProjectProperty("secureProject"));
        String configJson = this.loadConfigFile(configFile, decryptProject);
        Map jsonMap = JSONUtils.parseMap((Gson)CONFIG_GSON, (Reader)new StringReader(configJson));
        for (Map.Entry folderMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"folders")) {
            DataSourceFolder folder;
            String name = (String)folderMap.getKey();
            String description = (String)JSONUtils.getObjectProperty(folderMap.getValue(), (String)"description");
            String parentFolder = (String)JSONUtils.getObjectProperty(folderMap.getValue(), (String)"parent");
            DataSourceFolder parent = parentFolder == null ? null : this.registry.findFolderByPath(parentFolder, true);
            DataSourceFolder dataSourceFolder = folder = parent == null ? this.registry.findFolderByPath(name, true) : parent.getChild(name);
            if (folder == null) {
                folder = new DataSourceFolder(this.registry, parent, name, description);
                this.registry.addDataSourceFolder(folder);
                continue;
            }
            folder.setDescription(description);
        }
        for (Map.Entry ctMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"connection-types")) {
            String id = (String)ctMap.getKey();
            Map ctConfig = (Map)ctMap.getValue();
            String name = (String)JSONUtils.getObjectProperty((Object)ctConfig, (String)"name");
            String description = (String)JSONUtils.getObjectProperty((Object)ctConfig, (String)"description");
            String color = (String)JSONUtils.getObjectProperty((Object)ctConfig, (String)"color");
            Boolean autoCommit = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"auto-commit");
            Boolean confirmExecute = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"confirm-execute");
            Boolean confirmDataChange = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"confirm-data-change");
            DBPConnectionType ct = DBWorkbench.getPlatform().getDataSourceProviderRegistry().getConnectionType(id, null);
            if (ct == null) {
                ct = new DBPConnectionType(id, name, color, description, CommonUtils.toBoolean((Object)autoCommit), CommonUtils.toBoolean((Object)confirmExecute), CommonUtils.toBoolean((Object)confirmDataChange));
                DBWorkbench.getPlatform().getDataSourceProviderRegistry().addConnectionType(ct);
            }
            this.deserializeModifyPermissions(ctConfig, (DBPDataSourcePermissionOwner)ct);
        }
        LinkedHashMap<String, DBVModel> modelMap = new LinkedHashMap<String, DBVModel>();
        for (Map.Entry vmMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"virtual-models")) {
            String id = (String)vmMap.getKey();
            DBVModel model = new DBVModel(id, (Map)vmMap.getValue());
            modelMap.put(id, model);
        }
        for (Map.Entry vmMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"network-profiles")) {
            String profileName = (String)vmMap.getKey();
            Map profileMap = (Map)vmMap.getValue();
            DBWNetworkProfile profile = new DBWNetworkProfile();
            profile.setProfileName(profileName);
            profile.setProperties(JSONUtils.deserializeStringMap((Map)profileMap, (String)"properties"));
            for (Map.Entry handlerMap : JSONUtils.getNestedObjects((Map)profileMap, (String)"handlers")) {
                DBWHandlerConfiguration configuration = this.parseNetworkHandlerConfig(null, profile, handlerMap);
                if (configuration == null) continue;
                profile.updateConfiguration(configuration);
            }
            this.registry.updateNetworkProfile(profile);
        }
        for (Map.Entry conMap : JSONUtils.getNestedObjects((Map)jsonMap, (String)"connections")) {
            int keepAlive;
            String userPassword;
            String userName;
            DataSourceDescriptor dataSource;
            boolean newDataSource;
            String driverId;
            DriverDescriptor driver;
            Map conObject = (Map)conMap.getValue();
            String id = (String)conMap.getKey();
            String dsProviderID = CommonUtils.toString(conObject.get("provider"));
            if (CommonUtils.isEmpty((String)dsProviderID)) {
                log.warn((Object)("Empty datasource provider for datasource '" + id + "'"));
                continue;
            }
            DataSourceProviderDescriptor provider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(dsProviderID);
            if (provider == null) {
                log.warn((Object)("Can't find datasource provider " + dsProviderID + " for datasource '" + id + "'"));
                provider = (DataSourceProviderDescriptor)DataSourceProviderRegistry.getInstance().makeFakeProvider(dsProviderID);
            }
            if ((driver = provider.getDriver(driverId = CommonUtils.toString(conObject.get("driver")))) == null) {
                log.warn((Object)("Can't find driver " + driverId + " in datasource provider " + provider.getId() + " for datasource '" + id + "'. Create new driver"));
                driver = provider.createDriver(driverId);
                driver.setName(driverId);
                driver.setDescription("Missing driver " + driverId);
                driver.setDriverClassName("java.sql.Driver");
                driver.setTemporary(true);
                provider.addDriver(driver);
            }
            boolean bl = newDataSource = (dataSource = this.registry.getDataSource(id)) == null;
            if (newDataSource) {
                dataSource = new DataSourceDescriptor(this.registry, origin, id, driver, new DBPConnectionConfiguration());
            } else {
                dataSource.getConnectionConfiguration().setProperties(Collections.emptyMap());
                dataSource.getConnectionConfiguration().setHandlers(Collections.emptyList());
                dataSource.clearFilters();
            }
            dataSource.setName(JSONUtils.getString((Map)conObject, (String)"name"));
            dataSource.setSavePassword(JSONUtils.getBoolean((Map)conObject, (String)"save-password"));
            dataSource.setShowSystemObjects(JSONUtils.getBoolean((Map)conObject, (String)"show-system-objects"));
            dataSource.setShowUtilityObjects(JSONUtils.getBoolean((Map)conObject, (String)"show-util-objects"));
            dataSource.setConnectionReadOnly(JSONUtils.getBoolean((Map)conObject, (String)"read-only"));
            String folderPath = JSONUtils.getString((Map)conObject, (String)"folder");
            if (folderPath != null) {
                dataSource.setFolder(this.registry.findFolderByPath(folderPath, true));
            }
            dataSource.setLockPasswordHash(CommonUtils.toString(conObject.get("lockPassword")));
            Map cfgObject = JSONUtils.getObject((Map)conObject, (String)"configuration");
            DBPConnectionConfiguration config = dataSource.getConnectionConfiguration();
            config.setHostName(JSONUtils.getString((Map)cfgObject, (String)"host"));
            config.setHostPort(JSONUtils.getString((Map)cfgObject, (String)"port"));
            config.setServerName(JSONUtils.getString((Map)cfgObject, (String)"server"));
            config.setDatabaseName(JSONUtils.getString((Map)cfgObject, (String)"database"));
            config.setUrl(JSONUtils.getString((Map)cfgObject, (String)"url"));
            if (!this.passwordReadCanceled) {
                String[] creds = this.readSecuredCredentials(cfgObject, dataSource, null, null);
                config.setUserName(creds[0]);
                if (dataSource.isSavePassword()) {
                    config.setUserPassword(creds[1]);
                }
            }
            if (!CommonUtils.isEmpty((String)(userName = JSONUtils.getString((Map)cfgObject, (String)"user")))) {
                config.setUserName(userName);
            }
            if (!CommonUtils.isEmpty((String)(userPassword = JSONUtils.getString((Map)cfgObject, (String)"password")))) {
                config.setUserPassword(userPassword);
            }
            config.setClientHomeId(JSONUtils.getString((Map)cfgObject, (String)"home"));
            config.setConfigProfileName(JSONUtils.getString((Map)cfgObject, (String)"config-profile"));
            config.setUserProfileName(JSONUtils.getString((Map)cfgObject, (String)"user-profile"));
            config.setConnectionType(DataSourceProviderRegistry.getInstance().getConnectionType(JSONUtils.getString((Map)cfgObject, (String)"type"), DBPConnectionType.DEFAULT_TYPE));
            String colorValue = JSONUtils.getString((Map)cfgObject, (String)"color");
            if (!CommonUtils.isEmpty((String)colorValue)) {
                config.setConnectionColor(colorValue);
            }
            if ((keepAlive = JSONUtils.getInteger((Map)cfgObject, (String)"keepAlive")) > 0) {
                config.setKeepAliveInterval(keepAlive);
            }
            config.setProperties(JSONUtils.deserializeStringMap((Map)cfgObject, (String)"properties"));
            config.setProviderProperties(JSONUtils.deserializeStringMap((Map)cfgObject, (String)"provider-properties"));
            for (Map.Entry eventObject : JSONUtils.getNestedObjects((Map)cfgObject, (String)"events")) {
                DBPConnectionEventType eventType = (DBPConnectionEventType)CommonUtils.valueOf(DBPConnectionEventType.class, (String)((String)eventObject.getKey()), (Enum)DBPConnectionEventType.BEFORE_CONNECT);
                Map eventCfg = (Map)eventObject.getValue();
                DBRShellCommand command = new DBRShellCommand("");
                command.setEnabled(JSONUtils.getBoolean((Map)eventCfg, (String)"enabled"));
                command.setShowProcessPanel(JSONUtils.getBoolean((Map)eventCfg, (String)"show-panel"));
                command.setWaitProcessFinish(JSONUtils.getBoolean((Map)eventCfg, (String)"wait-process"));
                if (command.isWaitProcessFinish()) {
                    command.setWaitProcessTimeoutMs(JSONUtils.getInteger((Map)eventCfg, (String)"wait-process-timeout"));
                }
                command.setTerminateAtDisconnect(JSONUtils.getBoolean((Map)eventCfg, (String)"terminate-at-disconnect"));
                command.setPauseAfterExecute(JSONUtils.getInteger((Map)eventCfg, (String)"pauseAfterExecute"));
                command.setWorkingDirectory(JSONUtils.getString((Map)eventCfg, (String)"workingDirectory"));
                command.setCommand(JSONUtils.getString((Map)eventCfg, (String)"command"));
                config.setEvent(eventType, command);
            }
            for (Map.Entry handlerObject : JSONUtils.getNestedObjects((Map)cfgObject, (String)"handlers")) {
                DBWHandlerConfiguration configuration = this.parseNetworkHandlerConfig(dataSource, null, handlerObject);
                if (configuration == null) continue;
                dataSource.getConnectionConfiguration().updateHandler(configuration);
            }
            Map bootstrapCfg = JSONUtils.getObject((Map)cfgObject, (String)"bootstrap");
            if (bootstrapCfg.containsKey("autocommit")) {
                config.getBootstrap().setDefaultAutoCommit(Boolean.valueOf(JSONUtils.getBoolean((Map)bootstrapCfg, (String)"autocommit")));
            }
            if (bootstrapCfg.containsKey("txnIsolation")) {
                config.getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(JSONUtils.getInteger((Map)bootstrapCfg, (String)"txnIsolation")));
            }
            config.getBootstrap().setDefaultObjectName(JSONUtils.getString((Map)bootstrapCfg, (String)"defaultObject"));
            if (bootstrapCfg.containsKey("ignoreErrors")) {
                config.getBootstrap().setIgnoreErrors(JSONUtils.getBoolean((Map)bootstrapCfg, (String)"ignoreErrors"));
            }
            config.getBootstrap().setInitQueries((Collection)JSONUtils.deserializeStringList((Map)bootstrapCfg, (String)"query"));
            this.deserializeModifyPermissions(conObject, (DBPDataSourcePermissionOwner)dataSource);
            for (Map filterCfg : JSONUtils.getObjectList((Map)conObject, (String)"filters")) {
                String typeName = JSONUtils.getString((Map)filterCfg, (String)"type");
                String objectID = JSONUtils.getString((Map)filterCfg, (String)"id");
                if (CommonUtils.isEmpty((String)typeName)) continue;
                DBSObjectFilter filter = DataSourceSerializerModern.readObjectFiler(filterCfg);
                dataSource.updateObjectFilter(typeName, objectID, filter);
            }
            dataSource.getPreferenceStore().getProperties().putAll(JSONUtils.deserializeStringMap((Map)conObject, (String)"custom-properties"));
            String vmID = CommonUtils.toString(conObject.get("virtual-model-id"), (String)id);
            DBVModel dbvModel = (DBVModel)modelMap.get(vmID);
            if (dbvModel != null) {
                dataSource.setVirtualModel(dbvModel);
            }
            if (newDataSource) {
                this.registry.addDataSourceToList(dataSource);
                parseResults.addedDataSources.add(dataSource);
                continue;
            }
            parseResults.updatedDataSources.add(dataSource);
        }
        for (Map ctMap : JSONUtils.getObjectList((Map)jsonMap, (String)"saved-filters")) {
            DBSObjectFilter filter = DataSourceSerializerModern.readObjectFiler(ctMap);
            this.registry.addSavedFilter(filter);
        }
    }

    private void deserializeModifyPermissions(Map<String, Object> conObject, DBPDataSourcePermissionOwner permissionOwner) {
        List permissionRestrictions;
        Map securityCfg = JSONUtils.getObject(conObject, (String)"security");
        if (!CommonUtils.isEmpty((Map)securityCfg) && !CommonUtils.isEmpty((Collection)(permissionRestrictions = JSONUtils.deserializeStringList((Map)securityCfg, (String)"permission-restrictions")))) {
            ArrayList<DBPDataSourcePermission> permissions = new ArrayList<DBPDataSourcePermission>();
            for (String perm : permissionRestrictions) {
                try {
                    DBPDataSourcePermission permission = DBPDataSourcePermission.getById((String)perm);
                    if (permission == null) continue;
                    permissions.add(permission);
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)e);
                }
            }
            if (!permissions.isEmpty()) {
                permissionOwner.setModifyPermissions(permissions);
            }
        }
    }

    @Nullable
    private DBWHandlerConfiguration parseNetworkHandlerConfig(@Nullable DataSourceDescriptor dataSource, @Nullable DBWNetworkProfile profile, @NotNull Map.Entry<String, Map<String, Object>> handlerObject) {
        Map properties;
        String userPassword;
        String userName;
        String handlerId = handlerObject.getKey();
        Map<String, Object> handlerCfg = handlerObject.getValue();
        NetworkHandlerDescriptor handlerDescriptor = NetworkHandlerRegistry.getInstance().getDescriptor(handlerId);
        if (handlerDescriptor == null) {
            log.warn((Object)("Can't find network handler '" + handlerId + "'"));
            return null;
        }
        DBWHandlerConfiguration curNetworkHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)handlerDescriptor, (DBPDriver)(dataSource == null ? null : dataSource.getDriver()));
        curNetworkHandler.setEnabled(JSONUtils.getBoolean(handlerCfg, (String)"enabled"));
        curNetworkHandler.setSavePassword(JSONUtils.getBoolean(handlerCfg, (String)"save-password"));
        if (!this.passwordReadCanceled) {
            String[] creds = this.readSecuredCredentials(handlerCfg, dataSource, profile, "network/" + handlerId);
            curNetworkHandler.setUserName(creds[0]);
            if (curNetworkHandler.isSavePassword()) {
                curNetworkHandler.setPassword(creds[1]);
            }
        }
        if (!CommonUtils.isEmpty((String)(userName = JSONUtils.getString(handlerCfg, (String)"user")))) {
            curNetworkHandler.setUserName(userName);
        }
        if (!CommonUtils.isEmpty((String)(userPassword = JSONUtils.getString(handlerCfg, (String)"password")))) {
            curNetworkHandler.setPassword(userPassword);
        }
        if ((properties = JSONUtils.deserializeProperties(handlerCfg, (String)"properties")) != null) {
            curNetworkHandler.setProperties(properties);
        }
        return curNetworkHandler;
    }

    private static DBSObjectFilter readObjectFiler(Map<String, Object> map) {
        DBSObjectFilter filter = new DBSObjectFilter();
        filter.setName(JSONUtils.getString(map, (String)"name"));
        filter.setDescription(JSONUtils.getString(map, (String)"description"));
        filter.setEnabled(JSONUtils.getBoolean(map, (String)"enabled"));
        filter.setInclude(JSONUtils.deserializeStringList(map, (String)"include"));
        filter.setExclude(JSONUtils.deserializeStringList(map, (String)"exclude"));
        return filter;
    }

    private static void saveFolder(JsonWriter json, DataSourceFolder folder) throws IOException {
        json.name(folder.getName());
        json.beginObject();
        if (folder.getParent() != null) {
            JSONUtils.field((JsonWriter)json, (String)"parent", (String)folder.getParent().getFolderPath());
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)folder.getDescription());
        json.endObject();
    }

    /*
     * WARNING - void declaration
     */
    private void saveDataSource(@NotNull JsonWriter json, @NotNull DataSourceDescriptor dataSource) throws IOException {
        void var7_10;
        DBPConnectionBootstrap bootstrap;
        String lockPasswordHash;
        json.name(dataSource.getId());
        json.beginObject();
        JSONUtils.field((JsonWriter)json, (String)"provider", (String)dataSource.getDriver().getProviderDescriptor().getId());
        JSONUtils.field((JsonWriter)json, (String)"driver", (String)dataSource.getDriver().getId());
        JSONUtils.field((JsonWriter)json, (String)"name", (String)dataSource.getName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)dataSource.getDescription());
        JSONUtils.field((JsonWriter)json, (String)"save-password", (boolean)dataSource.isSavePassword());
        if (dataSource.isShowSystemObjects()) {
            JSONUtils.field((JsonWriter)json, (String)"show-system-objects", (boolean)dataSource.isShowSystemObjects());
        }
        if (dataSource.isShowUtilityObjects()) {
            JSONUtils.field((JsonWriter)json, (String)"show-util-objects", (boolean)dataSource.isShowUtilityObjects());
        }
        JSONUtils.field((JsonWriter)json, (String)"read-only", (boolean)dataSource.isConnectionReadOnly());
        if (dataSource.getFolder() != null) {
            JSONUtils.field((JsonWriter)json, (String)"folder", (String)dataSource.getFolder().getFolderPath());
        }
        if (!CommonUtils.isEmpty((String)(lockPasswordHash = dataSource.getLockPasswordHash()))) {
            JSONUtils.field((JsonWriter)json, (String)"lockPassword", (String)lockPasswordHash);
        }
        if (dataSource.hasSharedVirtualModel()) {
            JSONUtils.field((JsonWriter)json, (String)"virtual-model-id", (String)dataSource.getVirtualModel().getId());
        }
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        json.name("configuration");
        json.beginObject();
        JSONUtils.fieldNE((JsonWriter)json, (String)"host", (String)connectionInfo.getHostName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"port", (String)connectionInfo.getHostPort());
        JSONUtils.fieldNE((JsonWriter)json, (String)"server", (String)connectionInfo.getServerName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"database", (String)connectionInfo.getDatabaseName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"url", (String)connectionInfo.getUrl());
        this.saveSecuredCredentials(dataSource, null, null, connectionInfo.getUserName(), dataSource.isSavePassword() ? connectionInfo.getUserPassword() : null);
        JSONUtils.fieldNE((JsonWriter)json, (String)"home", (String)connectionInfo.getClientHomeId());
        if (connectionInfo.getConnectionType() != null) {
            JSONUtils.field((JsonWriter)json, (String)"type", (String)connectionInfo.getConnectionType().getId());
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"color", (String)connectionInfo.getConnectionColor());
        if (connectionInfo.getKeepAliveInterval() > 0) {
            JSONUtils.field((JsonWriter)json, (String)"keepAlive", (long)connectionInfo.getKeepAliveInterval());
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"config-profile", (String)connectionInfo.getConfigProfileName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"user-profile", (String)connectionInfo.getUserProfileName());
        JSONUtils.serializeProperties((JsonWriter)json, (String)"properties", (Map)connectionInfo.getProperties());
        JSONUtils.serializeProperties((JsonWriter)json, (String)"provider-properties", (Map)connectionInfo.getProviderProperties());
        if (!ArrayUtils.isEmpty((Object[])connectionInfo.getDeclaredEvents())) {
            json.name("events");
            json.beginObject();
            DBPConnectionEventType[] dBPConnectionEventTypeArray = connectionInfo.getDeclaredEvents();
            int n = dBPConnectionEventTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBPConnectionEventType eventType = dBPConnectionEventTypeArray[n2];
                DBRShellCommand command = connectionInfo.getEvent(eventType);
                if (command.isEnabled()) {
                    json.name(eventType.name());
                    json.beginObject();
                    JSONUtils.field((JsonWriter)json, (String)"enabled", (boolean)command.isEnabled());
                    JSONUtils.field((JsonWriter)json, (String)"show-panel", (boolean)command.isShowProcessPanel());
                    JSONUtils.field((JsonWriter)json, (String)"wait-process", (boolean)command.isWaitProcessFinish());
                    if (command.isWaitProcessFinish()) {
                        JSONUtils.field((JsonWriter)json, (String)"wait-process-timeout", (long)command.getWaitProcessTimeoutMs());
                    }
                    JSONUtils.field((JsonWriter)json, (String)"terminate-at-disconnect", (boolean)command.isTerminateAtDisconnect());
                    JSONUtils.field((JsonWriter)json, (String)"pauseAfterExecute", (long)command.getPauseAfterExecute());
                    JSONUtils.fieldNE((JsonWriter)json, (String)"workingDirectory", (String)command.getWorkingDirectory());
                    JSONUtils.fieldNE((JsonWriter)json, (String)"command", (String)command.getCommand());
                    json.endObject();
                }
                ++n2;
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty((Collection)connectionInfo.getHandlers())) {
            json.name("handlers");
            json.beginObject();
            for (DBWHandlerConfiguration configuration : connectionInfo.getHandlers()) {
                if (!configuration.isEnabled()) continue;
                this.saveNetworkHandlerConfiguration(json, dataSource, null, configuration);
            }
            json.endObject();
        }
        if ((bootstrap = connectionInfo.getBootstrap()).hasData()) {
            json.name("bootstrap");
            json.beginObject();
            if (bootstrap.getDefaultAutoCommit() != null) {
                JSONUtils.field((JsonWriter)json, (String)"autocommit", (boolean)bootstrap.getDefaultAutoCommit());
            }
            if (bootstrap.getDefaultTransactionIsolation() != null) {
                JSONUtils.field((JsonWriter)json, (String)"txnIsolation", (Number)bootstrap.getDefaultTransactionIsolation());
            }
            JSONUtils.fieldNE((JsonWriter)json, (String)"defaultObject", (String)bootstrap.getDefaultObjectName());
            if (bootstrap.isIgnoreErrors()) {
                JSONUtils.field((JsonWriter)json, (String)"ignoreErrors", (boolean)true);
            }
            JSONUtils.serializeStringList((JsonWriter)json, (String)"query", (Collection)bootstrap.getInitQueries());
            json.endObject();
        }
        json.endObject();
        this.serializeModifyPermissions(json, (DBPDataSourcePermissionOwner)dataSource);
        Collection<FilterMapping> filterMappings = dataSource.getObjectFilters();
        if (!CommonUtils.isEmpty(filterMappings)) {
            json.name("filters");
            json.beginArray();
            for (FilterMapping filter : filterMappings) {
                if (filter.defaultFilter != null && !filter.defaultFilter.isEmpty()) {
                    DataSourceSerializerModern.saveObjectFiler(json, filter.typeName, null, filter.defaultFilter);
                }
                for (Map.Entry entry : filter.customFilters.entrySet()) {
                    if (((DBSObjectFilter)entry.getValue()).isEmpty()) continue;
                    DataSourceSerializerModern.saveObjectFiler(json, filter.typeName, (String)entry.getKey(), (DBSObjectFilter)entry.getValue());
                }
            }
            json.endArray();
        }
        DataSourcePreferenceStore prefStore = dataSource.getPreferenceStore();
        TreeMap<String, String> props = new TreeMap<String, String>();
        String[] stringArray = prefStore.preferenceNames();
        int n3 = stringArray.length;
        boolean bl = false;
        while (var7_10 < n3) {
            String propName = stringArray[var7_10];
            String propValue = prefStore.getString(propName);
            String defValue = prefStore.getDefaultString(propName);
            if (propValue != null && !CommonUtils.equalObjects((Object)propValue, (Object)defValue)) {
                props.put(propName, propValue);
            }
            ++var7_10;
        }
        if (!props.isEmpty()) {
            JSONUtils.serializeProperties((JsonWriter)json, (String)"custom-properties", props);
        }
        json.endObject();
    }

    private void serializeModifyPermissions(@NotNull JsonWriter json, DBPDataSourcePermissionOwner permissionOwner) throws IOException {
        List permissions = permissionOwner.getModifyPermission();
        if (!CommonUtils.isEmpty((Collection)permissions)) {
            json.name("security");
            json.beginObject();
            ArrayList<String> permIds = new ArrayList<String>(permissions.size());
            for (DBPDataSourcePermission perm : permissions) {
                permIds.add(perm.getId());
            }
            JSONUtils.serializeStringList((JsonWriter)json, (String)"permission-restrictions", permIds);
            json.endObject();
        }
    }

    private void saveNetworkHandlerConfiguration(@NotNull JsonWriter json, @Nullable DataSourceDescriptor dataSource, @Nullable DBWNetworkProfile profile, @NotNull DBWHandlerConfiguration configuration) throws IOException {
        json.name(CommonUtils.notEmpty((String)configuration.getId()));
        json.beginObject();
        JSONUtils.field((JsonWriter)json, (String)"type", (String)configuration.getType().name());
        JSONUtils.field((JsonWriter)json, (String)"enabled", (boolean)configuration.isEnabled());
        JSONUtils.field((JsonWriter)json, (String)"save-password", (boolean)configuration.isSavePassword());
        if (!CommonUtils.isEmpty((String)configuration.getUserName()) || !CommonUtils.isEmpty((String)configuration.getPassword())) {
            this.saveSecuredCredentials(dataSource, profile, "network/" + configuration.getId(), configuration.getUserName(), configuration.isSavePassword() ? configuration.getPassword() : null);
        }
        JSONUtils.serializeProperties((JsonWriter)json, (String)"properties", (Map)configuration.getProperties());
        json.endObject();
    }

    private static void saveObjectFiler(JsonWriter json, String typeName, String objectID, DBSObjectFilter filter) throws IOException {
        json.beginObject();
        JSONUtils.fieldNE((JsonWriter)json, (String)"id", (String)objectID);
        JSONUtils.fieldNE((JsonWriter)json, (String)"type", (String)typeName);
        JSONUtils.fieldNE((JsonWriter)json, (String)"name", (String)filter.getName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)filter.getDescription());
        JSONUtils.field((JsonWriter)json, (String)"enabled", (boolean)filter.isEnabled());
        JSONUtils.serializeStringList((JsonWriter)json, (String)"include", (Collection)filter.getInclude());
        JSONUtils.serializeStringList((JsonWriter)json, (String)"exclude", (Collection)filter.getExclude());
        json.endObject();
    }

    private void saveSecuredCredentials(@Nullable DataSourceDescriptor dataSource, @Nullable DBWNetworkProfile profile, @Nullable String subNode, @Nullable String userName, @Nullable String password) {
        boolean saved;
        assert (dataSource != null || profile != null);
        boolean bl = saved = !this.passwordWriteCanceled && DataSourceRegistry.saveCredentialsInSecuredStorage(this.registry.getProject(), dataSource, subNode, userName, password);
        if (!saved) {
            String topNodeId;
            this.passwordWriteCanceled = true;
            String string = topNodeId = profile != null ? "profile:" + profile.getProfileName() : dataSource.getId();
            if (subNode == null) {
                subNode = NODE_CONNECTION;
            }
            Map nodeMap = this.secureProperties.computeIfAbsent(topNodeId, s -> new LinkedHashMap());
            Map propMap = nodeMap.computeIfAbsent(subNode, s -> new LinkedHashMap());
            if (!CommonUtils.isEmpty((String)userName)) {
                propMap.put("user", CommonUtils.notEmpty((String)userName));
            }
            if (!CommonUtils.isEmpty((String)password)) {
                propMap.put("password", password);
            }
        }
    }

    private String[] readSecuredCredentials(@NotNull Map<String, Object> map, @Nullable DataSourceDescriptor dataSource, @Nullable DBWNetworkProfile profile, @Nullable String subNode) {
        Map<String, String> propMap;
        Map<String, Map<String, String>> subMap;
        String topNodeId;
        String[] creds = new String[2];
        DBASecureStorage secureStorage = dataSource == null ? DBWorkbench.getPlatform().getSecureStorage() : dataSource.getProject().getSecureStorage();
        try {
            if (secureStorage.useSecurePreferences()) {
                ISecurePreferences prefNode;
                ISecurePreferences iSecurePreferences = prefNode = dataSource == null ? secureStorage.getSecurePreferences() : dataSource.getSecurePreferences();
                if (subNode != null) {
                    String[] stringArray = subNode.split("/");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String nodeName = stringArray[n2];
                        prefNode = prefNode.node(nodeName);
                        ++n2;
                    }
                }
                creds[0] = prefNode.get("user", null);
                creds[1] = prefNode.get("password", null);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Can't read password from secure storage", e);
            this.passwordReadCanceled = true;
        }
        String string = topNodeId = profile != null ? "profile:" + profile.getProfileName() : dataSource.getId();
        if (subNode == null) {
            subNode = NODE_CONNECTION;
        }
        if ((subMap = this.secureProperties.get(topNodeId)) != null && (propMap = subMap.get(subNode)) != null) {
            if (CommonUtils.isEmpty((String)creds[0])) {
                creds[0] = propMap.get("user");
            }
            if (CommonUtils.isEmpty((String)creds[1])) {
                creds[1] = propMap.get("password");
            }
        }
        return creds;
    }
}

