/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreSequenceManager
extends SQLObjectEditor<PostgreTableBase, PostgreSchema>
implements DBEObjectRenamer<PostgreTableBase> {
    public DBSObjectCache<? extends DBSObject, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreTableContainer)object.getContainer()).getSchema().tableCache;
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((PostgreTableBase)command.getObject()).getName())) {
            throw new DBException("Sequence name cannot be empty");
        }
    }

    protected PostgreSequence createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new PostgreSequence((PostgreSchema)container);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceSequenceQuery(actions, (PostgreTableBase)command.getObject());
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceSequenceQuery(actionList, (PostgreTableBase)command.getObject());
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop sequence", "DROP SEQUENCE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    private void createOrReplaceSequenceQuery(List<DBEPersistAction> actions, PostgreTableBase sequence) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create sequence", "CREATE SEQUENCE " + sequence.getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename sequence", "ALTER SEQUENCE " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableBase object, String newName) throws DBException {
        SQLObjectEditor.ObjectRenameCommand command = new SQLObjectEditor.ObjectRenameCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_rename_object, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new SQLObjectEditor.RenameObjectReflector((SQLObjectEditor)this), true);
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreTableBase, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        if (command.getProperty((Object)"description") != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment sequence", "COMMENT ON SEQUENCE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((PostgreTableBase)command.getObject()).getDescription())));
        }
    }
}

