(function() {
  var cloneObject, ipcHelpers,
    slice = [].slice;

  ipcHelpers = require('./ipc-helpers');

  cloneObject = function(object) {
    var clone, key, value;
    clone = {};
    for (key in object) {
      value = object[key];
      clone[key] = value;
    }
    return clone;
  };

  module.exports = function(arg) {
    var ApplicationDelegate, AtomEnvironment, Clipboard, CompileCache, FindParentDir, TextEditor, blobStore, buildAtomEnvironment, buildDefaultApplicationDelegate, clipboard, env, error, exitWithStatusCode, exportsPath, getWindowLoadSettings, handleKeydown, headless, ipcRenderer, legacyTestRunner, legacyTestRunnerPath, logFile, packageMetadata, packageRoot, path, promise, ref, ref1, remote, testPaths, testRunner, testRunnerPath, updateProcessEnv, util;
    blobStore = arg.blobStore;
    remote = require('electron').remote;
    exitWithStatusCode = function(status) {
      remote.app.emit('will-quit');
      return remote.process.exit(status);
    };
    try {
      path = require('path');
      ipcRenderer = require('electron').ipcRenderer;
      getWindowLoadSettings = require('./get-window-load-settings');
      CompileCache = require('./compile-cache');
      AtomEnvironment = require('../src/atom-environment');
      ApplicationDelegate = require('../src/application-delegate');
      Clipboard = require('../src/clipboard');
      TextEditor = require('../src/text-editor');
      updateProcessEnv = require('./update-process-env').updateProcessEnv;
      require('./electron-shims');
      ipcRenderer.on('environment', function(event, env) {
        return updateProcessEnv(env);
      });
      ref = getWindowLoadSettings(), testRunnerPath = ref.testRunnerPath, legacyTestRunnerPath = ref.legacyTestRunnerPath, headless = ref.headless, logFile = ref.logFile, testPaths = ref.testPaths, env = ref.env;
      if (headless) {
        util = require('util');
        Object.defineProperties(process, {
          stdout: {
            value: remote.process.stdout
          },
          stderr: {
            value: remote.process.stderr
          }
        });
        console.log = function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          return process.stdout.write((util.format.apply(util, args)) + "\n");
        };
        console.error = function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          return process.stderr.write((util.format.apply(util, args)) + "\n");
        };
      } else {
        remote.getCurrentWindow().show();
      }
      handleKeydown = function(event) {
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 82) {
          ipcHelpers.call('window-method', 'reload');
        }
        if (event.keyCode === 73 && ((process.platform === 'darwin' && event.metaKey && event.altKey) || (process.platform !== 'darwin' && event.ctrlKey && event.shiftKey))) {
          ipcHelpers.call('window-method', 'toggleDevTools');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 87) {
          ipcHelpers.call('window-method', 'close');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 67) {
          return ipcHelpers.call('window-method', 'copy');
        }
      };
      window.addEventListener('keydown', handleKeydown, true);
      exportsPath = path.join(getWindowLoadSettings().resourcePath, 'exports');
      require('module').globalPaths.push(exportsPath);
      process.env.NODE_PATH = exportsPath;
      updateProcessEnv(env);
      FindParentDir = require('find-parent-dir');
      if (packageRoot = FindParentDir.sync(testPaths[0], 'package.json')) {
        packageMetadata = require(path.join(packageRoot, 'package.json'));
        if (packageMetadata.atomTranspilers) {
          CompileCache.addTranspilerConfigForPath(packageRoot, packageMetadata.name, packageMetadata, packageMetadata.atomTranspilers);
        }
      }
      document.title = "Spec Suite";
      clipboard = new Clipboard;
      TextEditor.setClipboard(clipboard);
      TextEditor.viewForItem = function(item) {
        return atom.views.getView(item);
      };
      testRunner = require(testRunnerPath);
      legacyTestRunner = require(legacyTestRunnerPath);
      buildDefaultApplicationDelegate = function() {
        return new ApplicationDelegate();
      };
      buildAtomEnvironment = function(params) {
        var atomEnvironment;
        params = cloneObject(params);
        if (!params.hasOwnProperty("clipboard")) {
          params.clipboard = clipboard;
        }
        if (!params.hasOwnProperty("blobStore")) {
          params.blobStore = blobStore;
        }
        if (!params.hasOwnProperty("onlyLoadBaseStyleSheets")) {
          params.onlyLoadBaseStyleSheets = true;
        }
        atomEnvironment = new AtomEnvironment(params);
        atomEnvironment.initialize(params);
        TextEditor.setScheduler(atomEnvironment.views);
        return atomEnvironment;
      };
      promise = testRunner({
        logFile: logFile,
        headless: headless,
        testPaths: testPaths,
        buildAtomEnvironment: buildAtomEnvironment,
        buildDefaultApplicationDelegate: buildDefaultApplicationDelegate,
        legacyTestRunner: legacyTestRunner
      });
      return promise.then(function(statusCode) {
        if (getWindowLoadSettings().headless) {
          return exitWithStatusCode(statusCode);
        }
      });
    } catch (error1) {
      error = error1;
      if (getWindowLoadSettings().headless) {
        console.error((ref1 = error.stack) != null ? ref1 : error);
        return exitWithStatusCode(1);
      } else {
        throw error;
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
