Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _humanizePlus = require('humanize-plus');

var _humanizePlus2 = _interopRequireDefault(_humanizePlus);

var _symbolsView = require('./symbols-view');

var _symbolsView2 = _interopRequireDefault(_symbolsView);

var _tagReader = require('./tag-reader');

var _tagReader2 = _interopRequireDefault(_tagReader);

var _getTagsFile = require('./get-tags-file');

var _getTagsFile2 = _interopRequireDefault(_getTagsFile);

var ProjectView = (function (_SymbolsView) {
  _inherits(ProjectView, _SymbolsView);

  function ProjectView(stack) {
    _classCallCheck(this, ProjectView);

    _get(Object.getPrototypeOf(ProjectView.prototype), 'constructor', this).call(this, stack, 'Project has no tags file or it is empty', 10);
    this.reloadTags = true;
  }

  _createClass(ProjectView, [{
    key: 'destroy',
    value: function destroy() {
      this.stopTask();
      this.unwatchTagsFiles();
      return _get(Object.getPrototypeOf(ProjectView.prototype), 'destroy', this).call(this);
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel.isVisible()) {
        this.cancel();
      } else {
        this.populate();
        this.attach();
      }
    }
  }, {
    key: 'populate',
    value: _asyncToGenerator(function* () {
      var _this = this;

      if (this.tags) {
        yield this.selectListView.update({ items: this.tags });
      }

      if (this.reloadTags) {
        this.reloadTags = false;
        this.startTask();

        if (this.tags) {
          yield this.selectListView.update({
            loadingMessage: 'Reloading project symbols…'
          });
        } else {
          yield* (function* () {
            yield _this.selectListView.update({
              loadingMessage: 'Loading project symbols…',
              loadingBadge: 0
            });
            var tagsRead = 0;
            _this.loadTagsTask.on('tags', function (tags) {
              tagsRead += tags.length;
              _this.selectListView.update({ loadingBadge: _humanizePlus2['default'].intComma(tagsRead) });
            });
          })();
        }
      }
    })
  }, {
    key: 'stopTask',
    value: function stopTask() {
      if (this.loadTagsTask) {
        this.loadTagsTask.terminate();
      }
    }
  }, {
    key: 'startTask',
    value: function startTask() {
      var _this2 = this;

      this.stopTask();

      this.loadTagsTask = _tagReader2['default'].getAllTags(function (tags) {
        _this2.tags = tags;
        _this2.reloadTags = _this2.tags.length === 0;
        _this2.selectListView.update({
          loadingMessage: null,
          loadingBadge: null,
          items: _this2.tags
        });
      });

      this.watchTagsFiles();
    }
  }, {
    key: 'watchTagsFiles',
    value: function watchTagsFiles() {
      var _this3 = this;

      this.unwatchTagsFiles();

      this.tagsFileSubscriptions = new _atom.CompositeDisposable();
      var reloadTags = function reloadTags() {
        _this3.reloadTags = true;
        _this3.watchTagsFiles();
      };

      for (var projectPath of Array.from(atom.project.getPaths())) {
        var tagsFilePath = (0, _getTagsFile2['default'])(projectPath);
        if (tagsFilePath) {
          var tagsFile = new _atom.File(tagsFilePath);
          this.tagsFileSubscriptions.add(tagsFile.onDidChange(reloadTags));
          this.tagsFileSubscriptions.add(tagsFile.onDidDelete(reloadTags));
          this.tagsFileSubscriptions.add(tagsFile.onDidRename(reloadTags));
        }
      }
    }
  }, {
    key: 'unwatchTagsFiles',
    value: function unwatchTagsFiles() {
      if (this.tagsFileSubscriptions) {
        this.tagsFileSubscriptions.dispose();
      }
      this.tagsFileSubscriptions = null;
    }
  }]);

  return ProjectView;
})(_symbolsView2['default']);

exports['default'] = ProjectView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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