(function() {
  var CompositeDisposable, LARGE_FILE_SIZE, SpellCheckView, spellCheckViews,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  CompositeDisposable = require('atom').CompositeDisposable;

  SpellCheckView = null;

  spellCheckViews = {};

  LARGE_FILE_SIZE = 2 * 1024 * 1024;

  module.exports = {
    activate: function() {
      var manager;
      this.subs = new CompositeDisposable;
      this.globalArgs = {
        locales: atom.config.get('spell-check.locales'),
        localePaths: atom.config.get('spell-check.localePaths'),
        useLocales: atom.config.get('spell-check.useLocales'),
        knownWords: atom.config.get('spell-check.knownWords'),
        addKnownWords: atom.config.get('spell-check.addKnownWords'),
        checkerPaths: []
      };
      manager = this.getInstance(this.globalArgs);
      this.excludedScopeRegexLists = [];
      this.subs.add(atom.config.observe('spell-check.excludedScopes', (function(_this) {
        return function(excludedScopes) {
          _this.excludedScopeRegexLists = excludedScopes.map(function(excludedScope) {
            var className, i, len, ref, results;
            ref = excludedScope.split(/\s+/)[0].split('.');
            results = [];
            for (i = 0, len = ref.length; i < len; i++) {
              className = ref[i];
              if (className) {
                results.push(new RegExp("\\b" + className + "\\b"));
              }
            }
            return results;
          });
          return _this.updateViews();
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.locales', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.locales = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.localePaths', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.localePaths = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.useLocales', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.useLocales = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.knownWords', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.knownWords = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.addKnownWords', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.addKnownWords = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.commands.add('atom-workspace', {
        'spell-check:toggle': (function(_this) {
          return function() {
            return _this.toggle();
          };
        })(this)
      }));
      this.viewsByEditor = new WeakMap;
      this.contextMenuEntries = [];
      return this.subs.add(atom.workspace.observeTextEditors((function(_this) {
        return function(editor) {
          var destroySub, editorId, spellCheckView;
          if (_this.viewsByEditor.has(editor)) {
            return;
          }
          if (editor.getBuffer().getLength() > LARGE_FILE_SIZE) {
            return;
          }
          if (SpellCheckView == null) {
            SpellCheckView = require('./spell-check-view');
          }
          spellCheckView = new SpellCheckView(editor, _this, manager);
          editorId = editor.id;
          spellCheckViews[editorId] = {
            view: spellCheckView,
            active: true,
            editor: editor
          };
          destroySub = editor.onDidDestroy(function() {
            spellCheckView.destroy();
            delete spellCheckViews[editorId];
            return _this.subs.remove(destroySub);
          });
          _this.subs.add(destroySub);
          return _this.viewsByEditor.set(editor, spellCheckView);
        };
      })(this)));
    },
    deactivate: function() {
      var editorId, ref, view;
      if ((ref = this.instance) != null) {
        ref.deactivate();
      }
      this.instance = null;
      for (editorId in spellCheckViews) {
        view = spellCheckViews[editorId].view;
        view.destroy();
      }
      spellCheckViews = {};
      this.viewsByEditor = new WeakMap;
      return this.subs.dispose();
    },
    consumeSpellCheckers: function(checkerPaths) {
      var checkerPath, i, len, ref, results;
      if (!(checkerPaths instanceof Array)) {
        checkerPaths = [checkerPaths];
      }
      results = [];
      for (i = 0, len = checkerPaths.length; i < len; i++) {
        checkerPath = checkerPaths[i];
        if (indexOf.call(this.globalArgs.checkerPaths, checkerPath) < 0) {
          if ((ref = this.instance) != null) {
            ref.addCheckerPath(checkerPath);
          }
          results.push(this.globalArgs.checkerPaths.push(checkerPath));
        } else {
          results.push(void 0);
        }
      }
      return results;
    },
    misspellingMarkersForEditor: function(editor) {
      return this.viewsByEditor.get(editor).markerLayer.getMarkers();
    },
    updateViews: function() {
      var editorId, results, view;
      results = [];
      for (editorId in spellCheckViews) {
        view = spellCheckViews[editorId];
        if (view['active']) {
          results.push(view['view'].updateMisspellings());
        } else {
          results.push(void 0);
        }
      }
      return results;
    },
    getInstance: function(globalArgs) {
      var SpellCheckerManager, checkerPath, i, len, ref;
      if (!this.instance) {
        SpellCheckerManager = require('./spell-check-manager');
        this.instance = SpellCheckerManager;
        this.instance.setGlobalArgs(globalArgs);
        ref = globalArgs.checkerPaths;
        for (i = 0, len = ref.length; i < len; i++) {
          checkerPath = ref[i];
          this.instance.addCheckerPath(checkerPath);
        }
      }
      return this.instance;
    },
    toggle: function() {
      var editorId;
      if (!atom.workspace.getActiveTextEditor()) {
        return;
      }
      editorId = atom.workspace.getActiveTextEditor().id;
      if (!spellCheckViews.hasOwnProperty(editorId)) {
        return;
      }
      if (spellCheckViews[editorId]['active']) {
        spellCheckViews[editorId]['active'] = false;
        return spellCheckViews[editorId]['view'].unsubscribeFromBuffer();
      } else {
        spellCheckViews[editorId]['active'] = true;
        return spellCheckViews[editorId]['view'].subscribeToBuffer();
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
