"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _githubDotcomMarkdown = _interopRequireDefault(require("./github-dotcom-markdown"));

var _emojiReactionsController = _interopRequireDefault(require("../controllers/emoji-reactions-controller"));

var _helpers = require("../helpers");

var _actionableReviewView = _interopRequireDefault(require("./actionable-review-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReviewCommentView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "renderComment", showActionsMenu => {
      const comment = this.props.comment;

      if (comment.isMinimized) {
        return _react["default"].createElement("div", {
          className: "github-Review-comment github-Review-comment--hidden",
          key: comment.id
        }, _react["default"].createElement(_octicon["default"], {
          icon: 'fold',
          className: "github-Review-icon"
        }), _react["default"].createElement("em", null, "This comment was hidden"));
      }

      const commentClass = (0, _classnames["default"])('github-Review-comment', {
        'github-Review-comment--pending': comment.state === 'PENDING'
      });
      const author = comment.author || _helpers.GHOST_USER;
      return _react["default"].createElement("div", {
        className: commentClass
      }, _react["default"].createElement("header", {
        className: "github-Review-header"
      }, _react["default"].createElement("div", {
        className: "github-Review-header-authorData"
      }, _react["default"].createElement("img", {
        className: "github-Review-avatar",
        src: author.avatarUrl,
        alt: author.login
      }), _react["default"].createElement("a", {
        className: "github-Review-username",
        href: author.url
      }, author.login), _react["default"].createElement("a", {
        className: "github-Review-timeAgo",
        href: comment.url
      }, _react["default"].createElement(_timeago["default"], {
        displayStyle: "long",
        time: comment.createdAt
      })), this.props.renderEditedLink(comment), this.props.renderAuthorAssociation(comment), comment.state === 'PENDING' && _react["default"].createElement("span", {
        className: "github-Review-pendingBadge badge badge-warning"
      }, "pending")), _react["default"].createElement(_octicon["default"], {
        icon: "ellipses",
        className: "github-Review-actionsMenu",
        onClick: event => showActionsMenu(event, comment, author)
      })), _react["default"].createElement("div", {
        className: "github-Review-text"
      }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
        html: comment.bodyHTML,
        switchToIssueish: this.props.openIssueish,
        openIssueishLinkInNewTab: this.props.openIssueishLinkInNewTab
      }), _react["default"].createElement(_emojiReactionsController["default"], {
        reactable: comment,
        tooltips: this.props.tooltips,
        reportRelayError: this.props.reportRelayError
      })));
    });

    this.refEditor = new _refHolder["default"]();
  }

  render() {
    return _react["default"].createElement(_actionableReviewView["default"], {
      originalContent: this.props.comment,
      isPosting: this.props.isPosting,
      confirm: this.props.confirm,
      commands: this.props.commands,
      contentUpdater: this.props.updateComment,
      render: this.renderComment
    });
  }

}

exports["default"] = ReviewCommentView;

_defineProperty(ReviewCommentView, "propTypes", {
  // Model
  comment: _propTypes["default"].object.isRequired,
  isPosting: _propTypes["default"].bool.isRequired,
  // Atom environment
  confirm: _propTypes["default"].func.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  // Render props
  renderEditedLink: _propTypes["default"].func.isRequired,
  renderAuthorAssociation: _propTypes["default"].func.isRequired,
  // Action methods
  openIssueish: _propTypes["default"].func.isRequired,
  openIssueishLinkInNewTab: _propTypes["default"].func.isRequired,
  updateComment: _propTypes["default"].func.isRequired,
  reportRelayError: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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