"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryErrorTile extends _react["default"].Component {
  componentDidMount() {
    // eslint-disable-next-line no-console
    console.error('Error encountered in subquery', this.props.error);
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-QueryErrorTile"
    }, _react["default"].createElement("div", {
      className: "github-QueryErrorTile-messages"
    }, this.renderMessages()));
  }

  renderMessages() {
    if (this.props.error.errors) {
      return this.props.error.errors.map((error, index) => {
        return this.renderMessage(error.message, index, 'alert');
      });
    }

    if (this.props.error.response) {
      return this.renderMessage(this.props.error.responseText, '0', 'alert');
    }

    if (this.props.error.network) {
      return this.renderMessage('Offline', '0', 'alignment-unalign');
    }

    return this.renderMessage(this.props.error.toString(), '0', 'alert');
  }

  renderMessage(body, key, icon) {
    return _react["default"].createElement("p", {
      key: key,
      className: "github-QueryErrorTile-message"
    }, _react["default"].createElement(_octicon["default"], {
      icon: icon
    }), body);
  }

}

exports["default"] = QueryErrorTile;

_defineProperty(QueryErrorTile, "propTypes", {
  error: _propTypes["default"].shape({
    response: _propTypes["default"].shape({
      status: _propTypes["default"].number.isRequired
    }),
    responseText: _propTypes["default"].string,
    network: _propTypes["default"].bool,
    errors: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      message: _propTypes["default"].string.isRequired
    }))
  }).isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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