"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/addReactionMutation.graphql");

  if (node.hash && node.hash !== "fc238aed25f2d7e854162002cb00b57f") {
    console.error("The definition of 'addReactionMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/addReactionMutation.graphql");
};

let placeholderID = 0;

var _default = (environment, subjectId, content) => {
  const variables = {
    input: {
      content,
      subjectId
    }
  };

  function optimisticUpdater(store) {
    const subject = store.get(subjectId);
    const reactionGroups = subject.getLinkedRecords('reactionGroups') || [];
    const reactionGroup = reactionGroups.find(group => group.getValue('content') === content);

    if (!reactionGroup) {
      const group = store.create(`add-reaction:reaction-group:${placeholderID++}`, 'ReactionGroup');
      group.setValue(true, 'viewerHasReacted');
      group.setValue(content, 'content');
      const conn = store.create(`add-reaction:reacting-user-conn:${placeholderID++}`, 'ReactingUserConnection');
      conn.setValue(1, 'totalCount');
      group.setLinkedRecord(conn, 'users');
      subject.setLinkedRecords([...reactionGroups, group], 'reactionGroups');
      return;
    }

    reactionGroup.setValue(true, 'viewerHasReacted');
    const conn = reactionGroup.getLinkedRecord('users');
    conn.setValue(conn.getValue('totalCount') + 1, 'totalCount');
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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