"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _remote = require("./remote");

var _helpers = require("../helpers");

class RemoteSet {
  constructor(iterable = []) {
    this.byName = new Map();
    this.byDotcomRepo = new Map();
    this.protocolCount = new Map();

    for (const remote of iterable) {
      this.add(remote);
    }
  }

  add(remote) {
    this.byName.set(remote.getName(), remote);

    if (remote.isGithubRepo()) {
      (0, _helpers.pushAtKey)(this.byDotcomRepo, remote.getSlug(), remote);
    }

    if (remote.getProtocol()) {
      const count = this.protocolCount.get(remote.getProtocol()) || 0;
      this.protocolCount.set(remote.getProtocol(), count + 1);
    }
  }

  isEmpty() {
    return this.byName.size === 0;
  }

  size() {
    return this.byName.size;
  }

  withName(name) {
    return this.byName.get(name) || _remote.nullRemote;
  }

  [Symbol.iterator]() {
    return this.byName.values();
  }

  filter(predicate) {
    return new this.constructor(Array.from(this).filter(predicate));
  }

  matchingGitHubRepository(owner, name) {
    return this.byDotcomRepo.get(`${owner}/${name}`) || [];
  }

  mostUsedProtocol(choices) {
    let best = choices[0];
    let bestCount = 0;

    for (const protocol of choices) {
      const count = this.protocolCount.get(protocol) || 0;

      if (count > bestCount) {
        bestCount = count;
        best = protocol;
      }
    }

    return best;
  }

}

exports["default"] = RemoteSet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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