"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _net = _interopRequireDefault(require("net"));

var _eventKit = require("event-kit");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

class GitPromptServer {
  constructor(gitTempDir) {
    this.emitter = new _eventKit.Emitter();
    this.gitTempDir = gitTempDir;
  }

  async start(promptForInput) {
    this.promptForInput = promptForInput;
    await this.gitTempDir.ensure();
    this.server = await this.startListening(this.gitTempDir.getSocketPath());
  }

  startListening(socketPath) {
    return new Promise(resolve => {
      const server = _net["default"].createServer(connection => {
        connection.setEncoding('utf8');
        const parts = [];
        connection.on('data', data => {
          const nullIndex = data.indexOf('\u0000');

          if (nullIndex === -1) {
            parts.push(data);
          } else {
            parts.push(data.substring(0, nullIndex));
            this.handleData(connection, parts.join(''));
          }
        });
      });

      server.listen(socketPath, () => resolve(server));
    });
  }

  handleData(connection, data) {
    let query;

    try {
      query = JSON.parse(data);
    } catch (e) {
      this.emitter.emit('did-cancel');
    }

    Promise.resolve(this.promptForInput(query)).then(answer => connection.end(JSON.stringify(answer), 'utf-8'))["catch"](() => this.emitter.emit('did-cancel', {
      handlerPid: query.pid
    }));
  }

  onDidCancel(cb) {
    return this.emitter.on('did-cancel', cb);
  }

  async terminate() {
    await new Promise(resolve => this.server.close(resolve));
    this.emitter.dispose();
  }

}

exports["default"] = GitPromptServer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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