"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareReviewSummariesAccumulator = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _moment = _interopRequireDefault(require("moment"));

var _reactRelay = require("react-relay");

var _helpers = require("../../helpers");

var _propTypes2 = require("../../prop-types");

var _accumulator = _interopRequireDefault(require("./accumulator"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareReviewSummariesAccumulator extends _react["default"].Component {
  render() {
    const resultBatch = this.props.pullRequest.reviews.edges.map(edge => edge.node);
    return _react["default"].createElement(_accumulator["default"], {
      relay: this.props.relay,
      resultBatch: resultBatch,
      onDidRefetch: this.props.onDidRefetch,
      pageSize: _helpers.PAGE_SIZE,
      waitTimeMs: _helpers.PAGINATION_WAIT_TIME_MS
    }, (error, results, loading) => {
      const summaries = results.sort((a, b) => (0, _moment["default"])(a.submittedAt, _moment["default"].ISO_8601) - (0, _moment["default"])(b.submittedAt, _moment["default"].ISO_8601));
      return this.props.children({
        error,
        summaries,
        loading
      });
    });
  }

}

exports.BareReviewSummariesAccumulator = BareReviewSummariesAccumulator;

_defineProperty(BareReviewSummariesAccumulator, "propTypes", {
  // Relay props
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  pullRequest: _propTypes["default"].shape({
    reviews: (0, _propTypes2.RelayConnectionPropType)(_propTypes["default"].object)
  }),
  // Render prop. Called with {error: error or null, summaries: array of all reviews, loading}
  children: _propTypes["default"].func.isRequired,
  // Called right after refetch happens
  onDidRefetch: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createPaginationContainer)(BareReviewSummariesAccumulator, {
  pullRequest: function () {
    const node = require("./__generated__/reviewSummariesAccumulator_pullRequest.graphql");

    if (node.hash && node.hash !== "4ac732c2325cedd6e8e90bb5c140cc1a") {
      console.error("The definition of 'reviewSummariesAccumulator_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewSummariesAccumulator_pullRequest.graphql");
  }
}, {
  direction: 'forward',

  /* istanbul ignore next */
  getConnectionFromProps(props) {
    return props.pullRequest.reviews;
  },

  /* istanbul ignore next */
  getFragmentVariables(prevVars, totalCount) {
    return _objectSpread({}, prevVars, {
      totalCount
    });
  },

  /* istanbul ignore next */
  getVariables(props, {
    count,
    cursor
  }) {
    return {
      url: props.pullRequest.url,
      reviewCount: count,
      reviewCursor: cursor
    };
  },

  query: function () {
    const node = require("./__generated__/reviewSummariesAccumulatorQuery.graphql");

    if (node.hash && node.hash !== "74bb2a56369e3c54b76c4ce7c17f328e") {
      console.error("The definition of 'reviewSummariesAccumulatorQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewSummariesAccumulatorQuery.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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