"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Accumulator extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "attemptToLoadMore", () => {
      this.loadMoreSub.dispose();
      this.nextUpdateID = null;
      /* istanbul ignore if */

      if (!this.props.relay.hasMore() || this.props.relay.isLoading()) {
        return;
      }

      this.loadMoreSub = this.props.relay.loadMore(this.props.pageSize, this.accumulate);
    });

    _defineProperty(this, "accumulate", error => {
      if (error) {
        this.setState({
          error
        });
      } else {
        if (this.props.waitTimeMs > 0 && this.nextUpdateID === null) {
          this.nextUpdateID = setTimeout(this.attemptToLoadMore, this.props.waitTimeMs);
          this.nextUpdateSub = new _eventKit.Disposable(() => {
            clearTimeout(this.nextUpdateID);
            this.nextUpdateID = null;
          });
        } else {
          this.attemptToLoadMore();
        }
      }
    });

    this.refetchSub = new _eventKit.Disposable();
    this.loadMoreSub = new _eventKit.Disposable();
    this.nextUpdateSub = new _eventKit.Disposable();
    this.nextUpdateID = null;
    this.state = {
      error: null
    };
  }

  componentDidMount() {
    this.refetchSub = this.props.onDidRefetch(this.attemptToLoadMore);
    this.attemptToLoadMore();
  }

  componentWillUnmount() {
    this.refetchSub.dispose();
    this.loadMoreSub.dispose();
    this.nextUpdateSub.dispose();
  }

  render() {
    return this.props.children(this.state.error, this.props.resultBatch, this.props.relay.hasMore());
  }

}

exports["default"] = Accumulator;

_defineProperty(Accumulator, "propTypes", {
  // Relay props
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  resultBatch: _propTypes["default"].arrayOf(_propTypes["default"].any).isRequired,
  // Control props
  pageSize: _propTypes["default"].number.isRequired,
  waitTimeMs: _propTypes["default"].number.isRequired,
  // Render prop. Called with (error, full result list, loading) each time more results arrive. Return value is
  // rendered as a child element.
  children: _propTypes["default"].func,
  // Called right after refetch happens
  onDidRefetch: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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