/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.security.KeyStore;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.dynssl.SslCertificateUtils;

public class DynSSLParam
extends AbstractParam {
    static final String PARAM_ROOT_CA = "dynssl.param.rootca";
    private KeyStore rootca = null;
    private static final Logger logger = Logger.getLogger(DynSSLParam.class);

    @Override
    protected void parse() {
        String rootcastr = this.getString(PARAM_ROOT_CA, null);
        if (rootcastr != null) {
            this.rootca = DynSSLParam.createKeyStore(rootcastr);
        }
    }

    private static KeyStore createKeyStore(String rootcastr) {
        try {
            return SslCertificateUtils.string2Keystore(rootcastr);
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't create Root CA KeyStore from String: " + rootcastr), (Throwable)e);
            return null;
        }
    }

    public void setRootca(String rootca) {
        this.setRootca(DynSSLParam.createKeyStore(rootca));
    }

    public KeyStore getRootca() {
        return this.rootca;
    }

    public void setRootca(KeyStore rootca) {
        this.rootca = rootca;
        if (rootca != null) {
            try {
                this.getConfig().setProperty(PARAM_ROOT_CA, (Object)SslCertificateUtils.keyStore2String(rootca));
            }
            catch (Exception e) {
                logger.error((Object)"Couldn't save Root CA parameter.", (Throwable)e);
            }
        }
    }
}

