"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("@wireapp/commons");
var electron_1 = require("electron");
var WindowStateKeeper = require("electron-window-state");
var fileUrl = require("file-url");
var fs = require("fs-extra");
var get_proxy_settings_1 = require("get-proxy-settings");
var minimist = require("minimist");
var path = require("path");
var url_1 = require("url");
var CertificateVerifyProcManager_1 = require("./lib/CertificateVerifyProcManager");
var CoreProtocol_1 = require("./lib/CoreProtocol");
var download_1 = require("./lib/download");
var eventType_1 = require("./lib/eventType");
var LocalAccountDeletion_1 = require("./lib/LocalAccountDeletion");
var webViewFocus_1 = require("./lib/webViewFocus");
var locale = require("./locale/locale");
var getLogger_1 = require("./logging/getLogger");
var initRaygun_1 = require("./logging/initRaygun");
var loggerUtils_1 = require("./logging/loggerUtils");
var developer_1 = require("./menu/developer");
var systemMenu = require("./menu/system");
var TrayHandler_1 = require("./menu/TrayHandler");
var EnvironmentUtil = require("./runtime/EnvironmentUtil");
var lifecycle = require("./runtime/lifecycle");
var OriginValidator_1 = require("./runtime/OriginValidator");
var config_1 = require("./settings/config");
var ConfigurationPersistence_1 = require("./settings/ConfigurationPersistence");
var SettingsType_1 = require("./settings/SettingsType");
var SingleSignOn_1 = require("./sso/SingleSignOn");
var AboutWindow_1 = require("./window/AboutWindow");
var ProxyPromptWindow_1 = require("./window/ProxyPromptWindow");
var WindowManager_1 = require("./window/WindowManager");
var WindowUtil_1 = require("./window/WindowUtil");
var APP_PATH = path.join(electron_1.app.getAppPath(), config_1.config.electronDirectory);
var INDEX_HTML = path.join(APP_PATH, 'renderer/index.html');
var LOG_DIR = path.join(electron_1.app.getPath('userData'), 'logs');
var LOG_FILE = path.join(LOG_DIR, 'electron.log');
var PRELOAD_JS = path.join(APP_PATH, 'dist/renderer/preload.js');
var PRELOAD_RENDERER_JS = path.join(APP_PATH, 'renderer/static/webview-preload.js');
var WRAPPER_CSS = path.join(APP_PATH, 'css/wrapper.css');
var WINDOW_SIZE = {
    DEFAULT_HEIGHT: 768,
    DEFAULT_WIDTH: 1024,
    MIN_HEIGHT: 512,
    MIN_WIDTH: 760,
};
var authenticatedProxyInfo;
var customProtocolHandler = new CoreProtocol_1.CustomProtocolHandler();
var argv = minimist(process.argv.slice(1));
var BASE_URL = EnvironmentUtil.web.getWebappUrl(argv.env);
var logger = getLogger_1.getLogger(__filename);
if (argv.version) {
    console.log(config_1.config.version);
    process.exit();
}
if (argv['proxy-server-auth']) {
    try {
        authenticatedProxyInfo = new url_1.URL(argv['proxy-server-auth']);
        if (authenticatedProxyInfo.origin === 'null') {
            authenticatedProxyInfo = undefined;
            throw new Error('No protocol for the proxy server specified.');
        }
    }
    catch (error) {
        logger.error("Could not parse authenticated proxy URL: \"" + error.message + "\"");
    }
}
var ICON = "wire." + (EnvironmentUtil.platform.IS_WINDOWS ? 'ico' : 'png');
var ICON_PATH = path.join(APP_PATH, 'img', ICON);
var tray;
var isFullScreen = false;
var isQuitting = false;
var triedProxy = false;
var main;
Object.entries(config_1.config).forEach(function (_a) {
    var _b = __read(_a, 2), key = _b[0], value = _b[1];
    if (typeof value === 'undefined' || (typeof value === 'number' && isNaN(value))) {
        logger.warn("Configuration key \"" + key + "\" not defined.");
    }
});
var bindIpcEvents = function () {
    electron_1.ipcMain.on(eventType_1.EVENT_TYPE.ACTION.SAVE_PICTURE, function (event, bytes, timestamp) {
        return download_1.downloadImage(bytes, timestamp);
    });
    electron_1.ipcMain.on(eventType_1.EVENT_TYPE.ACTION.NOTIFICATION_CLICK, function () {
        WindowManager_1.WindowManager.showPrimaryWindow();
    });
    electron_1.ipcMain.on(eventType_1.EVENT_TYPE.UI.BADGE_COUNT, function (event, count) {
        tray.showUnreadCount(main, count);
    });
    electron_1.ipcMain.on(eventType_1.EVENT_TYPE.ACCOUNT.DELETE_DATA, function (event, id, accountId, partitionId) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, LocalAccountDeletion_1.deleteAccount(id, accountId, partitionId)];
                case 1:
                    _a.sent();
                    main.webContents.send(eventType_1.EVENT_TYPE.ACCOUNT.DATA_DELETED);
                    return [2];
            }
        });
    }); });
    electron_1.ipcMain.on(eventType_1.EVENT_TYPE.WRAPPER.RELAUNCH, lifecycle.relaunch);
    electron_1.ipcMain.on(eventType_1.EVENT_TYPE.ABOUT.SHOW, AboutWindow_1.AboutWindow.showWindow);
    electron_1.ipcMain.on(eventType_1.EVENT_TYPE.UI.TOGGLE_MENU, systemMenu.toggleMenuBar);
};
var checkConfigV0FullScreen = function (mainWindowState) {
    if (typeof mainWindowState.isMaximized === 'undefined' && isFullScreen === true) {
        main.maximize();
    }
};
var initWindowStateKeeper = function () {
    var loadedWindowBounds = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.WINDOW_BOUNDS, {
        height: WINDOW_SIZE.DEFAULT_HEIGHT,
        width: WINDOW_SIZE.DEFAULT_WIDTH,
    });
    var showInFullScreen = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.FULL_SCREEN, 'not-set-in-v0');
    var stateKeeperOptions = {
        defaultHeight: loadedWindowBounds.height,
        defaultWidth: loadedWindowBounds.width,
        path: path.join(electron_1.app.getPath('userData'), 'config'),
    };
    if (showInFullScreen !== 'not-set-in-v0') {
        stateKeeperOptions.fullScreen = showInFullScreen;
        stateKeeperOptions.maximize = showInFullScreen;
        isFullScreen = showInFullScreen;
    }
    return WindowStateKeeper(stateKeeperOptions);
};
var showMainWindow = function (mainWindowState) {
    var showMenuBar = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.SHOW_MENU_BAR, true);
    var options = {
        autoHideMenuBar: !showMenuBar,
        backgroundColor: '#f7f8fa',
        height: mainWindowState.height,
        icon: ICON_PATH,
        minHeight: WINDOW_SIZE.MIN_HEIGHT,
        minWidth: WINDOW_SIZE.MIN_WIDTH,
        show: false,
        title: config_1.config.name,
        titleBarStyle: 'hiddenInset',
        webPreferences: {
            backgroundThrottling: false,
            nodeIntegration: false,
            preload: PRELOAD_JS,
            webviewTag: true,
        },
        width: mainWindowState.width,
        x: mainWindowState.x,
        y: mainWindowState.y,
    };
    main = new electron_1.BrowserWindow(options);
    mainWindowState.manage(main);
    CertificateVerifyProcManager_1.attachTo(main);
    checkConfigV0FullScreen(mainWindowState);
    var webappURL = "" + BASE_URL + (BASE_URL.includes('?') ? '&' : '?') + "hl=" + locale.getCurrent();
    if (getLogger_1.ENABLE_LOGGING) {
        webappURL += "&enableLogging=@wireapp/*";
    }
    if (customProtocolHandler.hashLocation) {
        webappURL += "#" + customProtocolHandler.hashLocation;
    }
    if (argv.devtools) {
        main.webContents.openDevTools({ mode: 'detach' });
    }
    main.loadURL(fileUrl(INDEX_HTML) + "?env=" + encodeURIComponent(webappURL));
    if (!argv.startup && !argv.hidden) {
        if (!WindowUtil_1.WindowUtil.isInView(main)) {
            main.center();
        }
        WindowManager_1.WindowManager.setPrimaryWindowId(main.id);
        setTimeout(function () { return main.show(); }, 800);
    }
    main.webContents.on('will-navigate', function (event, url) {
        event.preventDefault();
    });
    main.webContents.on('new-window', function (event, _url) {
        event.preventDefault();
        if (typeof event.sender.viewInstanceId !== 'undefined') {
            logger.log('New window was created from a webview, aborting.');
            return;
        }
        electron_1.shell.openExternal(_url);
    });
    main.webContents.on('dom-ready', function () {
        main.webContents.insertCSS(fs.readFileSync(WRAPPER_CSS, 'utf8'));
    });
    main.on('focus', function () {
        systemMenu.registerShortcuts();
        main.flashFrame(false);
    });
    main.on('blur', function () { return systemMenu.unregisterShortcuts(); });
    main.on('page-title-updated', function () { return tray.showUnreadCount(main); });
    main.on('close', function (event) {
        if (!isQuitting) {
            event.preventDefault();
            logger.log('Closing window...');
            if (main.isFullScreen()) {
                logger.log('Fullscreen detected, leaving full screen before hiding...');
                main.once('leave-full-screen', function () { return main.hide(); });
                main.setFullScreen(false);
            }
            else {
                main.hide();
            }
        }
        systemMenu.unregisterShortcuts();
    });
    main.webContents.on('crashed', function (event) {
        logger.error('WebContents crashed. Will reload the window.');
        logger.error(event);
        main.reload();
    });
    electron_1.app.on('gpu-process-crashed', function (event) {
        logger.error('GPU process crashed. Will reload the window.');
        logger.error(event);
        main.reload();
    });
};
var handleAppEvents = function () {
    electron_1.app.on('window-all-closed', function () {
        if (!EnvironmentUtil.platform.IS_MAC_OS) {
            lifecycle.quit();
        }
    });
    electron_1.app.on('activate', function () {
        if (main) {
            main.show();
        }
    });
    electron_1.app.on('before-quit', function () {
        ConfigurationPersistence_1.settings.persistToFile();
        isQuitting = true;
    });
    electron_1.app.on('login', function (event, webContents, request, authInfo, callback) { return __awaiter(_this, void 0, void 0, function () {
        var username, password, systemProxy, systemProxySettings, _a, username, password, protocol;
        var _this = this;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (!authInfo.isProxy) return [3, 2];
                    event.preventDefault();
                    if (authenticatedProxyInfo) {
                        username = authenticatedProxyInfo.username, password = authenticatedProxyInfo.password;
                        logger.info('Sending provided credentials to authenticated proxy ...');
                        return [2, callback(username, password)];
                    }
                    return [4, get_proxy_settings_1.getProxySettings()];
                case 1:
                    systemProxy = _b.sent();
                    systemProxySettings = systemProxy && (systemProxy.http || systemProxy.https);
                    if (systemProxySettings) {
                        _a = systemProxySettings.credentials, username = _a.username, password = _a.password, protocol = systemProxySettings.protocol;
                        authenticatedProxyInfo = new url_1.URL(protocol + "//" + username + ":" + password + "@" + authInfo.host);
                        return [2, callback(username, password)];
                    }
                    electron_1.ipcMain.once(eventType_1.EVENT_TYPE.PROXY_PROMPT.SUBMITTED, function (event, promptData) {
                        var username = promptData.username, password = promptData.password;
                        logger.log('Proxy prompt was submitted');
                        var _a = __read(argv['proxy-server'] || argv['proxy-server-auth'] || ['http://'], 1), originalProxyValue = _a[0];
                        var protocol = /^[^:]+:\/\//.exec(originalProxyValue);
                        authenticatedProxyInfo = new url_1.URL("" + protocol + username + ":" + password + "@" + authInfo.host);
                        callback(username, password);
                    });
                    electron_1.ipcMain.once(eventType_1.EVENT_TYPE.PROXY_PROMPT.CANCELED, function () { return __awaiter(_this, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            logger.log('Proxy prompt was canceled');
                            webContents.session.setProxy({
                                pacScript: '',
                                proxyBypassRules: '',
                                proxyRules: '',
                            }, function () {
                                callback('', '');
                                main.reload();
                            });
                            return [2];
                        });
                    }); });
                    if (!triedProxy) {
                        ProxyPromptWindow_1.ProxyPromptWindow.showWindow();
                        triedProxy = true;
                    }
                    _b.label = 2;
                case 2: return [2];
            }
        });
    }); });
    electron_1.app.on('ready', function () {
        var mainWindowState = initWindowStateKeeper();
        var appMenu = systemMenu.createMenu(isFullScreen);
        if (EnvironmentUtil.app.IS_DEVELOPMENT) {
            appMenu.append(developer_1.menuItem);
        }
        electron_1.Menu.setApplicationMenu(appMenu);
        tray = new TrayHandler_1.TrayHandler();
        if (!EnvironmentUtil.platform.IS_MAC_OS) {
            tray.initTray();
        }
        showMainWindow(mainWindowState);
    });
};
var renameFileExtensions = function (files, oldExtension, newExtension) {
    var e_1, _a;
    try {
        for (var files_1 = __values(files), files_1_1 = files_1.next(); !files_1_1.done; files_1_1 = files_1.next()) {
            var file = files_1_1.value;
            try {
                var fileStat = fs.statSync(file);
                if (fileStat.isFile() && file.endsWith(oldExtension)) {
                    fs.renameSync(file, file.replace(oldExtension, newExtension));
                }
            }
            catch (error) {
                logger.error("Failed to rename log file: \"" + error.message + "\"");
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (files_1_1 && !files_1_1.done && (_a = files_1.return)) _a.call(files_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
};
var renameWebViewLogFiles = function () {
    try {
        var logFiles = loggerUtils_1.getLogFiles(LOG_DIR, true);
        renameFileExtensions(logFiles, '.log', '.old');
    }
    catch (error) {
        logger.log("Failed to read log directory with error: " + error.message);
    }
};
var addLinuxWorkarounds = function () {
    if (EnvironmentUtil.platform.IS_LINUX) {
        if (EnvironmentUtil.linuxDesktop.isUbuntuUnity ||
            EnvironmentUtil.linuxDesktop.isPopOS ||
            EnvironmentUtil.linuxDesktop.isGnomeX11) {
            process.env.XDG_CURRENT_DESKTOP = 'Unity';
        }
    }
};
var handlePortableFlags = function () {
    if (argv.user_data_dir || argv.portable) {
        var USER_PATH = argv.user_data_dir
            ? path.resolve(argv.user_data_dir)
            : path.join(process.env.APPIMAGE || process.execPath, '../Data');
        logger.log("Saving user data to \"" + USER_PATH + "\".");
        electron_1.app.setPath('userData', USER_PATH);
    }
};
var getWebViewId = function (contents) {
    try {
        var currentLocation = new url_1.URL(contents.getURL());
        var webViewId = currentLocation.searchParams.get('id');
        return webViewId && commons_1.ValidationUtil.isUUIDv4(webViewId) ? webViewId : undefined;
    }
    catch (error) {
        return undefined;
    }
};
var ElectronWrapperInit = (function () {
    function ElectronWrapperInit() {
        this.logger = commons_1.LogFactory.getLogger('ElectronWrapperInit', { logFilePath: LOG_FILE });
    }
    ElectronWrapperInit.prototype.run = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.logger.log('webviewProtection init');
                this.webviewProtection();
                return [2];
            });
        });
    };
    ElectronWrapperInit.prototype.webviewProtection = function () {
        var _this = this;
        var openLinkInNewWindow = function (event, url, frameName, disposition, options) {
            event.preventDefault();
            if (SingleSignOn_1.SingleSignOn.isSingleSignOnLoginWindow(frameName) && SingleSignOn_1.SingleSignOn.isBackendOrigin(url)) {
                return new SingleSignOn_1.SingleSignOn(main, event, url, options).init();
            }
            _this.logger.log("Opening an external window from a webview.");
            return electron_1.shell.openExternal(url);
        };
        var willNavigateInWebview = function (event, _url) {
            if (OriginValidator_1.OriginValidator.isMatchingHost(_url, BASE_URL)) {
                _this.logger.log("Navigating inside webview. URL: " + _url);
            }
            else {
                _this.logger.log("Preventing navigation inside <webview>. URL: " + _url);
                event.preventDefault();
            }
        };
        electron_1.app.on('web-contents-created', function (webviewEvent, contents) { return __awaiter(_this, void 0, void 0, function () {
            var proxyURL_1, isLocalhostEnvironment, filter, listener;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        webViewFocus_1.WebViewFocus.bindTracker(webviewEvent, contents);
                        if (!(authenticatedProxyInfo && authenticatedProxyInfo.origin && contents.session)) return [3, 2];
                        proxyURL_1 = authenticatedProxyInfo.protocol + "//" + authenticatedProxyInfo.origin;
                        logger.info("Setting proxy to URL \"" + proxyURL_1 + "\" ...");
                        contents.session.allowNTLMCredentialsForDomains(authenticatedProxyInfo.hostname);
                        return [4, new Promise(function (resolve) {
                                return contents.session.setProxy({
                                    pacScript: '',
                                    proxyBypassRules: '',
                                    proxyRules: proxyURL_1,
                                }, function () { return resolve(); });
                            })];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        switch (contents.getType()) {
                            case 'window': {
                                contents.on('will-attach-webview', function (event, webPreferences, params) {
                                    var _url = params.src;
                                    if (!OriginValidator_1.OriginValidator.isMatchingHost(_url, BASE_URL)) {
                                        event.preventDefault();
                                        _this.logger.log("Prevented to show an unauthorized <webview>. URL: " + _url);
                                        return;
                                    }
                                    params.autosize = false;
                                    params.contextIsolation = true;
                                    params.plugins = false;
                                    webPreferences.allowRunningInsecureContent = false;
                                    webPreferences.nodeIntegration = false;
                                    webPreferences.preloadURL = fileUrl(PRELOAD_RENDERER_JS);
                                    webPreferences.webSecurity = true;
                                });
                                break;
                            }
                            case 'webview': {
                                contents.on('new-window', openLinkInNewWindow);
                                contents.on('will-navigate', willNavigateInWebview);
                                if (getLogger_1.ENABLE_LOGGING) {
                                    contents.on('console-message', function (event, level, message) { return __awaiter(_this, void 0, void 0, function () {
                                        var webViewId, logFilePath, error_1;
                                        return __generator(this, function (_a) {
                                            switch (_a.label) {
                                                case 0:
                                                    webViewId = getWebViewId(contents);
                                                    if (!webViewId) return [3, 4];
                                                    logFilePath = path.join(electron_1.app.getPath('userData'), 'logs', webViewId, config_1.config.logFileName);
                                                    _a.label = 1;
                                                case 1:
                                                    _a.trys.push([1, 3, , 4]);
                                                    return [4, commons_1.LogFactory.writeMessage(message, logFilePath)];
                                                case 2:
                                                    _a.sent();
                                                    return [3, 4];
                                                case 3:
                                                    error_1 = _a.sent();
                                                    logger.log("Cannot write to log file \"" + logFilePath + "\": " + error_1.message, error_1);
                                                    return [3, 4];
                                                case 4: return [2];
                                            }
                                        });
                                    }); });
                                }
                                contents.session.setCertificateVerifyProc(CertificateVerifyProcManager_1.setCertificateVerifyProc);
                                isLocalhostEnvironment = EnvironmentUtil.getEnvironment() == EnvironmentUtil.BackendTypeLabel.LOCALHOST.toUpperCase();
                                if (isLocalhostEnvironment) {
                                    filter = {
                                        urls: config_1.config.backendOrigins.map(function (value) { return value + "/*"; }),
                                    };
                                    listener = function (details, callback) {
                                        var responseHeaders = __assign({}, details.responseHeaders, { 'Access-Control-Allow-Credentials': ['true'], 'Access-Control-Allow-Origin': ['http://localhost:8081'] });
                                        callback({
                                            cancel: false,
                                            responseHeaders: responseHeaders,
                                        });
                                    };
                                    contents.session.webRequest.onHeadersReceived(filter, listener);
                                }
                                contents.on('before-input-event', function (event, input) {
                                    if (input.type === 'keyUp' && input.key === 'Alt') {
                                        electron_1.ipcMain.emit(eventType_1.EVENT_TYPE.UI.TOGGLE_MENU);
                                    }
                                });
                                break;
                            }
                        }
                        return [2];
                }
            });
        }); });
    };
    return ElectronWrapperInit;
}());
customProtocolHandler.registerCoreProtocol();
initRaygun_1.Raygun.initClient();
handlePortableFlags();
lifecycle.checkSingleInstance();
lifecycle.checkForUpdate();
if (lifecycle.isFirstInstance) {
    addLinuxWorkarounds();
    bindIpcEvents();
    handleAppEvents();
    renameWebViewLogFiles();
    fs.ensureFileSync(LOG_FILE);
    new ElectronWrapperInit().run().catch(function (error) { return logger.error(error); });
}
//# sourceMappingURL=main.js.map