/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.sdk.flavors.WindowsStoreServiceKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0002\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"findInstallLocationForPackage", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageName", "", "findPowerShell", "reportError", "", "command", "error", "process", "Ljava/lang/Process;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
public final class WindowsStoreServiceKt {
    private static final VirtualFile findPowerShell() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        String string = System.getenv("WINDIR");
        if (string == null) {
            return null;
        }
        String winDir = string;
        VirtualFile virtualFile = fs.findFileByPath(winDir);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"fs.findFileByPath(winDir) ?: return null");
        VirtualFile winDirFile = virtualFile;
        return winDirFile.findFileByRelativePath("/System32/WindowsPowerShell/v1.0/powershell.exe");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final VirtualFile findInstallLocationForPackage(@NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        if (!SystemInfo.isWin10OrNewer) {
            return null;
        }
        alphaNumeric = new Regex("^[a-zA-Z0-9]+$");
        splitLine = new Regex("^[$]_.InstallLocation\\s*:\\s*(.+)$");
        v0 = Logger.getFactory().getLoggerInstance("findPackage");
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"Logger.getFactory().getL\u2026erInstance(\"findPackage\")");
        logger = v0;
        var4_4 = packageName;
        var5_7 = false;
        if (!(StringsKt.isBlank((CharSequence)var4_4) == false)) ** GOTO lbl-1000
        var4_4 = packageName;
        var5_7 = false;
        if (alphaNumeric.matches(var4_4)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        var4_5 = v1;
        var5_7 = false;
        if (_Assertions.ENABLED && !var4_5) {
            $i$a$-assert-WindowsStoreServiceKt$findInstallLocationForPackage$1 = false;
            $i$a$-assert-WindowsStoreServiceKt$findInstallLocationForPackage$1 = "Only alphanumeric packages are supported";
            throw (Throwable)new AssertionError((Object)$i$a$-assert-WindowsStoreServiceKt$findInstallLocationForPackage$1);
        }
        v2 /* !! */  = WindowsStoreServiceKt.findPowerShell();
        if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getPath()) == null) {
            v2 /* !! */  = "powershell.exe";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)v2 /* !! */ , (String)"findPowerShell()?.path ?: \"powershell.exe\"");
        powershell /* !! */  = v2 /* !! */ ;
        command = "\"Get-AppxPackage | Where-Object {$_.Name -like '*" + packageName + "*'} | Select-Object {$_.InstallLocation} | Format-List\"";
        process = null;
        try {
            v3 = Runtime.getRuntime().exec(new String[]{powershell /* !! */ , "-Command", command});
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"Runtime.getRuntime().exe\u2026ll, \"-Command\", command))");
            process = v3;
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            return null;
        }
        result = process.waitFor(5L, TimeUnit.SECONDS);
        if (!result) {
            WindowsStoreServiceKt.reportError(command, "Process still runs after timeout", process, logger);
            return null;
        }
        exitValue = process.exitValue();
        if (exitValue != 0) {
            WindowsStoreServiceKt.reportError(command, "Process exited " + exitValue, process, logger);
            return null;
        }
        v4 = process.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"process.inputStream");
        var10_15 = v4;
        var11_16 = Charsets.UTF_8;
        var12_17 = false;
        var13_18 /* !! */  = var10_15;
        var14_19 = 0;
        var13_18 /* !! */  = new InputStreamReader(var13_18 /* !! */ , var11_16);
        var14_19 = 8192;
        var15_20 = false;
        v5 = (var13_18 /* !! */  instanceof BufferedReader != false ? (BufferedReader)var13_18 /* !! */  : new BufferedReader((Reader)var13_18 /* !! */ , var14_19)).lines().filter(findInstallLocationForPackage.line.1.INSTANCE).findFirst().orElse(null);
        if (v5 == null) {
            return null;
        }
        line = v5;
        v6 = Regex.find$default((Regex)splitLine, (CharSequence)line, (int)0, (int)2, null);
        if (v6 == null || (v6 = v6.getGroupValues()) == null) {
            return null;
        }
        groupValues = v6;
        if (groupValues.size() != 2) {
            logger.warn("Strange output: " + line);
            return null;
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath((String)groupValues.get(1));
    }

    private static final void reportError(String command, String error, Process process2, Logger logger) {
        logger.warn(error);
        logger.warn(command);
        InputStream inputStream = process2.getErrorStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.errorStream");
        InputStream inputStream2 = inputStream;
        Logger logger2 = logger;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable = inputStream2;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl2 = false;
        BufferedReader bufferedReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        logger2.warn(TextStreamsKt.readText((Reader)bufferedReader));
        InputStream inputStream3 = process2.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream3, (String)"process.inputStream");
        inputStream2 = inputStream3;
        logger2 = logger;
        charset = Charsets.UTF_8;
        bl = false;
        closeable = inputStream2;
        n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        bl2 = false;
        bufferedReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        logger2.warn(TextStreamsKt.readText((Reader)bufferedReader));
    }
}

