/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushController;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.PushActionBase;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPushDialog
extends DialogWrapper
implements VcsPushUi,
DataProvider {
    private static final String ID = "Vcs.Push.Dialog";
    protected final Project myProject;
    private final PushLog myListPanel;
    protected final PushController myController;
    private final Map<PushSupport, VcsPushOptionsPanel> myAdditionalPanels;
    private Action myPushAction;
    @NotNull
    private final List<ActionWrapper> myAdditionalActions;

    public VcsPushDialog(@NotNull Project project, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        if (project == null) {
            VcsPushDialog.$$$reportNull$$$0(0);
        }
        if (selectedRepositories == null) {
            VcsPushDialog.$$$reportNull$$$0(1);
        }
        super(project, true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myProject = project;
        this.myController = new PushController(project, this, selectedRepositories, currentRepo);
        this.myAdditionalPanels = this.myController.createAdditionalPanels();
        this.myListPanel = this.myController.getPushPanelLog();
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Vcs.Push.Actions");
        this.myAdditionalActions = StreamEx.of((Object[])group.getChildren(null)).select(PushActionBase.class).map(action -> new ActionWrapper(this.myProject, this, (PushActionBase)((Object)action))).toList();
        this.init();
        this.updateOkActions();
        this.setOKButtonText("Push");
        this.setOKButtonMnemonic(80);
        this.setTitle("Push Commits");
    }

    protected JComponent createCenterPanel() {
        JPanel optionsPanel = this.createOptionsPanel();
        return JBUI.Panels.simplePanel((int)0, (int)2).addToCenter((Component)this.myListPanel).addToBottom((Component)optionsPanel);
    }

    @NotNull
    protected JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 0 0, flowx"));
        for (VcsPushOptionsPanel panel2 : this.myAdditionalPanels.values()) {
            optionsPanel.add((Component)panel2);
        }
        optionsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)6));
        JPanel jPanel = optionsPanel;
        if (jPanel == null) {
            VcsPushDialog.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    protected String getDimensionServiceKey() {
        return ID;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateOkActions();
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        this.push(false);
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.myPushAction = new ComplexPushAction(this.myAdditionalActions);
        this.myPushAction.putValue("DefaultAction", Boolean.TRUE);
        actions.add(this.myPushAction);
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            VcsPushDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    @Override
    public boolean canPush() {
        return this.myController.isPushAllowed();
    }

    @Override
    @NotNull
    public Map<PushSupport, Collection<PushInfo>> getSelectedPushSpecs() {
        Map<PushSupport, Collection<PushInfo>> map2 = this.myController.getSelectedPushSpecs();
        if (map2 == null) {
            VcsPushDialog.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myPushAction;
        if (action == null) {
            VcsPushDialog.$$$reportNull$$$0(5);
        }
        return action;
    }

    protected String getHelpId() {
        return ID;
    }

    @Override
    public void push(final boolean forcePush) {
        this.executeAfterRunningPrePushHandlers(new Task.Backgroundable(this.myProject, "Pushing...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsPushDialog.this.myController.push(forcePush);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/ui/VcsPushDialog$1", "run"));
            }
        });
    }

    @Override
    public void executeAfterRunningPrePushHandlers(@NotNull Task.Backgroundable activity) {
        PrePushHandler.Result result2;
        if (activity == null) {
            VcsPushDialog.$$$reportNull$$$0(6);
        }
        if ((result2 = this.runPrePushHandlersInModalTask()) == PrePushHandler.Result.OK) {
            activity.queue();
            this.close(0);
        } else if (result2 == PrePushHandler.Result.ABORT_AND_CLOSE) {
            this.doCancelAction();
        } else if (result2 == PrePushHandler.Result.ABORT) {
            // empty if block
        }
    }

    public PrePushHandler.Result runPrePushHandlersInModalTask() {
        FileDocumentManager.getInstance().saveAllDocuments();
        final AtomicReference<PrePushHandler.Result> result2 = new AtomicReference<PrePushHandler.Result>(PrePushHandler.Result.OK);
        new Task.Modal(this.myController.getProject(), "Checking Commits...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                result2.set(VcsPushDialog.this.myController.executeHandlers(indicator));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (error instanceof PushController.HandlerException) {
                    String suggestionMessage;
                    PushController.HandlerException handlerException = (PushController.HandlerException)error;
                    Throwable cause = handlerException.getCause();
                    String failedHandler = handlerException.getFailedHandlerName();
                    List<String> skippedHandlers = handlerException.getSkippedHandlers();
                    if (cause instanceof ProcessCanceledException) {
                        suggestionMessage = failedHandler + " has been cancelled.\n";
                    } else {
                        super.onThrowable(cause);
                        suggestionMessage = failedHandler + " has failed. See log for more details.\n";
                    }
                    suggestionMessage = skippedHandlers.isEmpty() ? suggestionMessage + "Would you like to push anyway or cancel the push completely?" : suggestionMessage + "Would you like to skip all remaining pre-push steps and push, or cancel the push completely?";
                    this.suggestToSkipOrPush(suggestionMessage);
                } else {
                    super.onThrowable(error);
                }
            }

            public void onCancel() {
                super.onCancel();
                this.suggestToSkipOrPush("Would you like to skip all pre-push steps and push, or cancel the push completely?");
            }

            private void suggestToSkipOrPush(@NotNull String message) {
                if (message == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)"Push", (String)"&Push Anyway", (String)"&Cancel", (Icon)UIUtil.getWarningIcon()) == 0) {
                    result2.set(PrePushHandler.Result.OK);
                } else {
                    result2.set(PrePushHandler.Result.ABORT);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "suggestToSkipOrPush";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
        return result2.get();
    }

    public void updateOkActions() {
        this.myPushAction.setEnabled(this.canPush());
        for (ActionWrapper wrapper : this.myAdditionalActions) {
            wrapper.update();
        }
    }

    public void enableOkActions(boolean value) {
        this.myPushAction.setEnabled(value);
    }

    @Override
    @Nullable
    public VcsPushOptionValue getAdditionalOptionValue(@NotNull PushSupport support) {
        VcsPushOptionsPanel panel2;
        if (support == null) {
            VcsPushDialog.$$$reportNull$$$0(7);
        }
        return (panel2 = this.myAdditionalPanels.get(support)) == null ? null : panel2.getValue();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            VcsPushDialog.$$$reportNull$$$0(8);
        }
        if (VcsPushUi.VCS_PUSH_DIALOG.is(dataId)) {
            return this;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepositories";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPushSpecs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeAfterRunningPrePushHandlers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalOptionValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionWrapper
    extends AbstractAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsPushUi myDialog;
        @NotNull
        private final PushActionBase myRealAction;

        ActionWrapper(@NotNull Project project, @NotNull VcsPushUi dialog, @NotNull PushActionBase realAction) {
            if (project == null) {
                ActionWrapper.$$$reportNull$$$0(0);
            }
            if (dialog == null) {
                ActionWrapper.$$$reportNull$$$0(1);
            }
            if (realAction == null) {
                ActionWrapper.$$$reportNull$$$0(2);
            }
            super(realAction.getTemplatePresentation().getTextWithMnemonic());
            this.myProject = project;
            this.myDialog = dialog;
            this.myRealAction = realAction;
            this.putValue("AnAction", (Object)realAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myRealAction.actionPerformed(this.myProject, this.myDialog);
        }

        public void update() {
            boolean enabled = this.myRealAction.isEnabled(this.myDialog);
            this.setEnabled(enabled);
            this.putValue("ShortDescription", this.myRealAction.getDescription(this.myDialog, enabled));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "realAction";
                    break;
                }
            }
            objectArray[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$ActionWrapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ComplexPushAction
    extends AbstractAction
    implements OptionAction {
        private final List<? extends ActionWrapper> myOptions;

        private ComplexPushAction(List<? extends ActionWrapper> additionalActions) {
            if (additionalActions == null) {
                ComplexPushAction.$$$reportNull$$$0(0);
            }
            super("&Push");
            this.myOptions = additionalActions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VcsPushDialog.this.push(false);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            for (Action action : this.myOptions) {
                action.setEnabled(isEnabled);
            }
        }

        @NotNull
        public Action[] getOptions() {
            Action[] actionArray = VcsPushDialog.this.myAdditionalActions.toArray(new ActionWrapper[0]);
            if (actionArray == null) {
                ComplexPushAction.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalActions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

