/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.action.TerminalSessionContextMenuActionBase;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/action/RenameTerminalSessionAction;", "Lorg/jetbrains/plugins/terminal/action/TerminalSessionContextMenuActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "terminalToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "content", "Lcom/intellij/ui/content/Content;", "showRenamePopup", "baseLabel", "Lcom/intellij/openapi/wm/impl/content/BaseLabel;", "intellij.terminal"})
public final class RenameTerminalSessionAction
extends TerminalSessionContextMenuActionBase
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow terminalToolWindow, @Nullable Content content) {
        BaseLabel baseLabel;
        BaseLabel baseLabel2;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)terminalToolWindow, (String)"terminalToolWindow");
        Object object = e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (!(object instanceof BaseLabel)) {
            object = null;
        }
        if ((baseLabel2 = (baseLabel = (BaseLabel)object)) == null || (baseLabel2 = baseLabel2.getContent()) == null) {
            return;
        }
        BaseLabel contextContent = baseLabel2;
        this.showRenamePopup(baseLabel, (Content)contextContent);
    }

    private final void showRenamePopup(BaseLabel baseLabel, Content content) {
        JTextField textField = new JTextField(content.getDisplayName());
        textField.selectAll();
        JBLabel label = new JBLabel("Enter new session name:");
        label.setFont(UIUtil.getLabelFont().deriveFont(1));
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{(Component)label, Box.createVerticalStrut(JBUI.scale((int)2)), textField});
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"SwingHelper.newLeftAlign\u2026BUI.scale(2)), textField)");
        JPanel panel = jPanel;
        panel.addFocusListener(new FocusAdapter(textField){
            final /* synthetic */ JTextField $textField;

            public void focusGained(@Nullable FocusEvent e) {
                IdeFocusManager.findInstance().requestFocus((Component)this.$textField, false);
            }
            {
                this.$textField = $captured_local_variable$0;
            }
        });
        Balloon balloon = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)panel, null).setShowCallout(true).setCloseButtonEnabled(false).setAnimationCycle(0).setDisposable((Disposable)content).setHideOnKeyOutside(true).setHideOnClickOutside(true).setRequestFocus(true).setBlockClicksThroughBalloon(true).createBalloon();
        Intrinsics.checkExpressionValueIsNotNull((Object)balloon, (String)"JBPopupFactory.getInstan\u2026e)\n      .createBalloon()");
        Balloon balloon2 = balloon;
        textField.addKeyListener(new KeyAdapter(content, textField, balloon2){
            final /* synthetic */ Content $content;
            final /* synthetic */ JTextField $textField;
            final /* synthetic */ Balloon $balloon;

            public void keyPressed(@Nullable KeyEvent e) {
                if (e != null && e.getKeyCode() == 10) {
                    if (!Disposer.isDisposed((Disposable)((Disposable)this.$content))) {
                        this.$content.setDisplayName(this.$textField.getText());
                    }
                    this.$balloon.hide();
                }
            }
            {
                this.$content = $captured_local_variable$0;
                this.$textField = $captured_local_variable$1;
                this.$balloon = $captured_local_variable$2;
            }
        });
        balloon2.show(new RelativePoint((Component)baseLabel, new Point(baseLabel.getWidth() / 2, 0)), Balloon.Position.above);
    }
}

