/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitConfigUtil;
import git4idea.merge.GitConflictResolver;
import git4idea.ui.StashInfo;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import git4idea.util.StringScanner;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0000\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0007\u001a&\u0010\n\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a8\u0010\n\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0013"}, d2={"loadStashStack", "", "Lgit4idea/ui/StashInfo;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "consumer", "Lcom/intellij/util/Consumer;", "unstash", "handler", "Lgit4idea/commands/GitLineHandler;", "conflictResolver", "Lgit4idea/merge/GitConflictResolver;", "roots", "", "handlerProvider", "Lkotlin/Function1;", "intellij.vcs.git"})
@JvmName(name="GitStashUtils")
public final class GitStashUtils {
    public static final void unstash(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLineHandler handler, @NotNull GitConflictResolver conflictResolver) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)conflictResolver, (String)"conflictResolver");
        GitStashUtils.unstash(project, CollectionsKt.listOf((Object)root), (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)new Function1<VirtualFile, GitLineHandler>(handler){
            final /* synthetic */ GitLineHandler $handler;

            @NotNull
            public final GitLineHandler invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$handler;
            }
            {
                this.$handler = gitLineHandler;
                super(1);
            }
        }), conflictResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void unstash(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots, @NotNull Function1<? super VirtualFile, ? extends GitLineHandler> handlerProvider, @NotNull GitConflictResolver conflictResolver) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        Intrinsics.checkParameterIsNotNull(handlerProvider, (String)"handlerProvider");
        Intrinsics.checkParameterIsNotNull((Object)conflictResolver, (String)"conflictResolver");
        Closeable closeable = (Closeable)DvcsUtil.workingTreeChangeStarted((Project)project, (String)"Unstash");
        boolean bl = false;
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)closeable;
            boolean bl2 = false;
            for (VirtualFile virtualFile : roots) {
                void result2;
                GitLineHandler handler = (GitLineHandler)handlerProvider.invoke((Object)virtualFile);
                GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT_ON_UNSTASH);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(virtualFile);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(virtualFile, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                handler.addLineListener(conflictDetector);
                handler.addLineListener(untrackedFilesDetector);
                handler.addLineListener(localChangesDetector);
                Intrinsics.checkExpressionValueIsNotNull((Object)Git.getInstance().runCommand((Computable<? extends GitLineHandler>)((Computable)new Computable<GitLineHandler>(handler){
                    final /* synthetic */ GitLineHandler $handler;

                    @NotNull
                    public final GitLineHandler compute() {
                        return this.$handler;
                    }
                    {
                        this.$handler = gitLineHandler;
                    }
                })), (String)"Git.getInstance().runCommand { handler }");
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
                if (conflictDetector.hasHappened()) {
                    boolean conflictsResolved = conflictResolver.merge();
                    if (conflictsResolved) continue;
                    return;
                }
                if (untrackedFilesDetector.wasMessageDetected()) {
                    GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, virtualFile, (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), "unstash", null);
                    return;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, virtualFile, "unstash", (Collection<String>)localChangesDetector.getRelativeFilePaths());
                    return;
                }
                if (result2.success()) continue;
                VcsNotifier.getInstance((Project)project).notifyError("Unstash Failed", result2.getErrorOutputAsHtmlString());
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Deprecated(message="use the simpler overloading method which returns a list")
    public static final void loadStashStack(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<StashInfo> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        for (StashInfo stash : GitStashUtils.loadStashStack(project, root)) {
            consumer2.consume((Object)stash);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StashInfo> loadStashStack(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Charset charset = Charset.forName(GitConfigUtil.getLogEncoding(project, root));
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.STASH.readLockingCommand());
        h.setSilent(true);
        h.addParameters("list");
        h.setCharset(charset);
        String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Git.getInstance().runCommand(h).getOutputOrThrow()");
        String out = string;
        boolean bl = false;
        List result2 = new ArrayList();
        StringScanner s = new StringScanner(out);
        while (s.hasMoreData()) {
            String string2;
            void $this$trim$iv;
            String string3 = s.boundedToken(':');
            String string4 = s.boundedToken(':');
            Intrinsics.checkExpressionValueIsNotNull((Object)s.line(), (String)"s.line()");
            String string5 = string4;
            String string6 = string3;
            List list = result2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string7 = string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String string8 = string5;
            String string9 = string6;
            list.add(new StashInfo(string9, string8, string7));
        }
        return result2;
    }
}

