/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitAbortRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitAbortRebaseProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsNotifier myNotifier;
    @Nullable
    private final GitRepository myRepositoryToAbort;
    @NotNull
    private final Map<GitRepository, String> myRepositoriesToRollback;
    @NotNull
    private final Map<GitRepository, String> myInitialCurrentBranches;
    @NotNull
    private final ProgressIndicator myIndicator;
    @Nullable
    private final GitChangesSaver mySaver;
    private final boolean myNotifySuccess;

    GitAbortRebaseProcess(@NotNull Project project, @Nullable GitRepository repositoryToAbort, @NotNull Map<GitRepository, String> repositoriesToRollback, @NotNull Map<GitRepository, String> initialCurrentBranches, @NotNull ProgressIndicator progressIndicator, @Nullable GitChangesSaver changesSaver, boolean notifySuccess2) {
        if (project == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(0);
        }
        if (repositoriesToRollback == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(1);
        }
        if (initialCurrentBranches == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myRepositoryToAbort = repositoryToAbort;
        this.myRepositoriesToRollback = repositoriesToRollback;
        this.myInitialCurrentBranches = initialCurrentBranches;
        this.myIndicator = progressIndicator;
        this.mySaver = changesSaver;
        this.myNotifySuccess = notifySuccess2;
        this.myGit = Git.getInstance();
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    void abortWithConfirmation() {
        LOG.info("Abort rebase. " + (this.myRepositoryToAbort == null ? "Nothing to abort" : DvcsUtil.getShortRepositoryName((Repository)this.myRepositoryToAbort)) + ". Roots to rollback: " + DvcsUtil.joinShortNames(this.myRepositoriesToRollback.keySet()));
        Ref ref = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)this.confirmAbort()));
        LOG.info("User choice: " + ref.get());
        if (ref.get() == AbortChoice.ROLLBACK_AND_ABORT) {
            this.doAbort(true);
        } else if (ref.get() == AbortChoice.ABORT) {
            this.doAbort(false);
        }
    }

    @NotNull
    private AbortChoice confirmAbort() {
        String title = "Abort Rebase";
        if (this.myRepositoryToAbort != null) {
            if (this.myRepositoriesToRollback.isEmpty()) {
                int choice;
                String message = "Abort rebase" + GitUtil.mention(this.myRepositoryToAbort) + "?";
                if (Messages.canShowMacSheetPanel()) {
                    title = message;
                    message = "";
                }
                if ((choice = DialogManager.showOkCancelDialog(this.myProject, message, title, "Abort", CommonBundle.getCancelButtonText(), Messages.getQuestionIcon())) == 0) {
                    AbortChoice abortChoice = AbortChoice.ABORT;
                    if (abortChoice == null) {
                        GitAbortRebaseProcess.$$$reportNull$$$0(4);
                    }
                    return abortChoice;
                }
            } else {
                int choice;
                String message = String.format("Abort rebase in %s only or also rollback rebase in %s?", DvcsUtil.getShortRepositoryName((Repository)this.myRepositoryToAbort), DvcsUtil.joinShortNames(this.myRepositoriesToRollback.keySet(), (int)5));
                if (Messages.canShowMacSheetPanel()) {
                    title = message;
                    message = "";
                }
                if ((choice = DialogManager.showYesNoCancelDialog(this.myProject, message, title, "Abort and Rollback", "Abort Only", CommonBundle.getCancelButtonText(), Messages.getQuestionIcon())) == 0) {
                    AbortChoice abortChoice = AbortChoice.ROLLBACK_AND_ABORT;
                    if (abortChoice == null) {
                        GitAbortRebaseProcess.$$$reportNull$$$0(5);
                    }
                    return abortChoice;
                }
                if (choice == 1) {
                    AbortChoice abortChoice = AbortChoice.ABORT;
                    if (abortChoice == null) {
                        GitAbortRebaseProcess.$$$reportNull$$$0(6);
                    }
                    return abortChoice;
                }
            }
        } else if (this.myRepositoriesToRollback.isEmpty()) {
            LOG.error(new Throwable());
        } else {
            String description = "Do you want to rollback the successful rebase" + GitUtil.mention(this.myRepositoriesToRollback.keySet()) + "?";
            int choice = DialogManager.showOkCancelDialog(this.myProject, description, title, "Rollback", CommonBundle.getCancelButtonText(), Messages.getQuestionIcon());
            if (choice == 0) {
                AbortChoice abortChoice = AbortChoice.ROLLBACK_AND_ABORT;
                if (abortChoice == null) {
                    GitAbortRebaseProcess.$$$reportNull$$$0(7);
                }
                return abortChoice;
            }
        }
        AbortChoice abortChoice = AbortChoice.CANCEL;
        if (abortChoice == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(8);
        }
        return abortChoice;
    }

    private void doAbort(boolean rollback) {
        new GitFreezingProcess(this.myProject, "rebase", () -> {
            ArrayList<GitRepository> repositoriesToRefresh = new ArrayList<GitRepository>();
            try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)"Rebase");){
                if (this.myRepositoryToAbort != null) {
                    this.myIndicator.setText2("git rebase --abort" + GitUtil.mention(this.myRepositoryToAbort));
                    GitRebaseCommandResult result2 = this.myGit.rebaseAbort(this.myRepositoryToAbort, new GitLineHandlerListener[0]);
                    repositoriesToRefresh.add(this.myRepositoryToAbort);
                    if (!result2.success()) {
                        this.myNotifier.notifyError("Rebase Abort Failed", result2.getErrorOutputAsHtmlString() + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver));
                        return;
                    }
                }
                if (rollback) {
                    for (GitRepository repo : this.myRepositoriesToRollback.keySet()) {
                        String initialBranchPosition;
                        this.myIndicator.setText2("git reset --keep" + GitUtil.mention(repo));
                        GitCommandResult res = this.myGit.reset(repo, GitResetMode.KEEP, this.myRepositoriesToRollback.get(repo), new GitLineHandlerListener[0]);
                        repositoriesToRefresh.add(repo);
                        if (res.success() && (initialBranchPosition = this.myInitialCurrentBranches.get(repo)) != null && !initialBranchPosition.equals(repo.getCurrentBranchName())) {
                            this.myIndicator.setText2("git checkout " + initialBranchPosition + GitUtil.mention(repo));
                            res = this.myGit.checkout(repo, initialBranchPosition, null, true, false, new GitLineHandlerListener[0]);
                        }
                        if (res.success()) continue;
                        String description = this.myRepositoryToAbort != null ? "Rebase abort was successful" + GitUtil.mention(this.myRepositoryToAbort) + ", but rollback failed" : "Rollback failed";
                        description = description + GitUtil.mention(repo) + ":" + res.getErrorOutputAsHtmlString() + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
                        this.myNotifier.notifyImportantWarning("Rebase Rollback Failed", description);
                        return;
                    }
                }
                if (this.mySaver != null) {
                    this.mySaver.load();
                }
                if (!this.myNotifySuccess) return;
                this.myNotifier.notifySuccess("Rebase abort succeeded");
                return;
            }
            finally {
                GitAbortRebaseProcess.refresh(repositoriesToRefresh);
            }
        }).execute();
    }

    private static void refresh(@NotNull List<? extends GitRepository> toRefresh) {
        if (toRefresh == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(9);
        }
        for (GitRepository gitRepository : toRefresh) {
            gitRepository.update();
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(GitUtil.getRootsFromRepositories(toRefresh)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoriesToRollback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialCurrentBranches";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitAbortRebaseProcess";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRefresh";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitAbortRebaseProcess";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "confirmAbort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum AbortChoice {
        ABORT,
        ROLLBACK_AND_ABORT,
        CANCEL;

    }
}

