/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.DefaultGitLogFullRecordBuilder;
import git4idea.history.GitLogParser;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/history/GitLogHistoryHandler;", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getRename", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler$Rename;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "beforeHash", "Lcom/intellij/vcs/log/Hash;", "afterHash", "intellij.vcs.git"})
public final class GitLogHistoryHandler
implements VcsLogFileHistoryHandler {
    private final Logger LOG;
    private final Project project;

    @Nullable
    public VcsLogFileHistoryHandler.Rename getRename(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull Hash beforeHash, @NotNull Hash afterHash) throws VcsException {
        VcsFileStatusInfo info;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)beforeHash, (String)"beforeHash");
        Intrinsics.checkParameterIsNotNull((Object)afterHash, (String)"afterHash");
        GitLineHandler h = new GitLineHandler(this.project, root, GitCommand.DIFF);
        h.setWithMediator(false);
        h.setStdoutSuppressed(true);
        h.addParameters("-M", "--diff-filter=R", "--name-status", "--encoding=UTF-8", "--follow", beforeHash.asString() + ".." + afterHash.asString());
        h.endOptions();
        h.addRelativePaths(filePath);
        DefaultGitLogFullRecordBuilder recordBuilder = new DefaultGitLogFullRecordBuilder();
        GitLogParser.PathsParser parser = new GitLogParser.PathsParser(GitLogParser.NameStatus.STATUS, recordBuilder);
        h.addLineListener(new GitLineHandlerListener(parser){
            final /* synthetic */ GitLogParser.PathsParser $parser;

            public final void onLineAvailable(String line, Key<Object> outputType) {
                if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                    this.$parser.parseLine(line);
                }
            }
            {
                this.$parser = pathsParser;
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        List<VcsFileStatusInfo> statuses = recordBuilder.getStatuses$intellij_vcs_git();
        if (statuses.size() > 1) {
            this.LOG.error("Unexpected multiple renames found. Command [" + h.printableCommandLine() + "].\n" + "Output [" + statuses + "].");
        }
        VcsFileStatusInfo vcsFileStatusInfo = info = (VcsFileStatusInfo)CollectionsKt.singleOrNull(statuses);
        if ((vcsFileStatusInfo != null ? vcsFileStatusInfo.getSecondPath() : null) != null) {
            FilePath firstPath = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getFirstPath()), (boolean)false);
            FilePath secondPath = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getSecondPath()), (boolean)false);
            FilePath filePath2 = firstPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)filePath2, (String)"firstPath");
            FilePath filePath3 = secondPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)filePath3, (String)"secondPath");
            return new VcsLogFileHistoryHandler.Rename(filePath2, filePath3, beforeHash, afterHash);
        }
        return null;
    }

    public GitLogHistoryHandler(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(GitLogHistoryHandler.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(GitLo\u2026storyHandler::class.java)");
        this.LOG = logger;
    }
}

