/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.actions;

import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.codeInsight.template.emmet.actions.EmmetEditPointUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoToEditPointAction
extends EditorAction
implements DumbAware {
    protected GoToEditPointAction(EditorActionHandler defaultHandler) {
        super(defaultHandler);
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        super.update(editor, presentation, dataContext);
        PsiFile file = GoToEditPointAction.getFile(dataContext);
        if (!XmlGtTypedHandler.fileContainsXmlLanguage(file)) {
            presentation.setEnabledAndVisible(false);
        }
    }

    private static PsiFile getFile(DataContext context) {
        return (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
    }

    public static class Backward
    extends GoToEditPointAction {
        public Backward() {
            super(new EditorActionHandler(true){

                protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                    if (editor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    EmmetEditPointUtil.moveBackward(editor, GoToEditPointAction.getFile(dataContext));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/actions/GoToEditPointAction$Backward$1", "doExecute"));
                }
            });
        }
    }

    public static class Forward
    extends GoToEditPointAction {
        public Forward() {
            super(new EditorActionHandler(true){

                protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                    if (editor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    EmmetEditPointUtil.moveForward(editor, GoToEditPointAction.getFile(dataContext));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/actions/GoToEditPointAction$Forward$1", "doExecute"));
                }
            });
        }
    }
}

