/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Url;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010 \u001a\u00020\u0015H\u0016R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lorg/jetbrains/debugger/ScriptBase;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lorg/jetbrains/debugger/Script;", "type", "Lorg/jetbrains/debugger/Script$Type;", "url", "Lcom/intellij/util/Url;", "line", "", "column", "endLine", "(Lorg/jetbrains/debugger/Script$Type;Lcom/intellij/util/Url;III)V", "getColumn", "()I", "getEndLine", "isWorker", "", "()Z", "getLine", "source", "Lorg/jetbrains/concurrency/Promise;", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "getSourceMap", "()Lorg/jetbrains/debugger/sourcemap/SourceMap;", "setSourceMap", "(Lorg/jetbrains/debugger/sourcemap/SourceMap;)V", "getType", "()Lorg/jetbrains/debugger/Script$Type;", "getUrl", "()Lcom/intellij/util/Url;", "toString", "intellij.platform.scriptDebugger.backend"})
public abstract class ScriptBase
extends UserDataHolderBase
implements Script {
    private final int line;
    private volatile Promise<String> source;
    @Nullable
    private SourceMap sourceMap;
    private final boolean isWorker = false;
    @NotNull
    private final Script.Type type;
    @NotNull
    private final Url url;
    private final int column;
    private final int endLine;

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    @Nullable
    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    @Override
    public void setSourceMap(@Nullable SourceMap sourceMap) {
        this.sourceMap = sourceMap;
    }

    @NotNull
    public String toString() {
        return "[url=" + this.getUrl() + ", lineRange=[" + this.getLine() + ';' + this.getEndLine() + "]]";
    }

    @Override
    public boolean isWorker() {
        return this.isWorker;
    }

    @Override
    @NotNull
    public Script.Type getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Url getUrl() {
        return this.url;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public ScriptBase(@NotNull Script.Type type, @NotNull Url url, int line2, int column, int endLine) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.type = type;
        this.url = url;
        this.column = column;
        this.endLine = endLine;
        this.line = Math.max(line2, 0);
    }

    @Override
    @Nullable
    public String getFunctionName() {
        return Script.DefaultImpls.getFunctionName(this);
    }
}

