/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"move.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiReference reference2;
        if (project == null) {
            MoveHandler.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            element = file2;
        }
        if ((reference2 = MoveHandler.findReferenceAtCaret(element, offset)) != null) {
            PsiElement refElement = reference2.resolve();
            for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (refElement == null || !delegate.tryToMove(refElement, project, dataContext, reference2, editor)) continue;
                return;
            }
        }
        List<MoveHandlerDelegate> candidateHandlers = MoveHandler.findHandlersForLanguage(element);
        while (true) {
            if (element == null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.at.the.class.method.or.field.to.be.refactored"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
                return;
            }
            for (MoveHandlerDelegate delegate : candidateHandlers) {
                if (!delegate.tryToMove(element, project, dataContext, null, editor)) continue;
                return;
            }
            element = element.getParent();
        }
    }

    private static PsiReference findReferenceAtCaret(PsiElement element, int caretOffset) {
        TextRange range2 = element.getTextRange();
        if (range2 != null) {
            int relative = caretOffset - range2.getStartOffset();
            return element.findReferenceAt(relative);
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, DataContext dataContext) {
        if (project == null) {
            MoveHandler.$$$reportNull$$$0(1);
        }
        if (elements2 == null) {
            MoveHandler.$$$reportNull$$$0(2);
        }
        PsiElement targetContainer = dataContext == null ? null : (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
        HashSet<PsiElement> filesOrDirs = new HashSet<PsiElement>();
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(dataContext) || !delegate.isValidTarget(targetContainer, elements2)) continue;
            delegate.collectFilesOrDirsFromContext(dataContext, filesOrDirs);
        }
        if (!filesOrDirs.isEmpty()) {
            for (PsiElement element : elements2) {
                if (element instanceof PsiDirectory) {
                    filesOrDirs.add(element);
                    continue;
                }
                PsiFile containingFile = element.getContainingFile();
                if (containingFile == null) continue;
                filesOrDirs.add((PsiElement)containingFile);
            }
            MoveFilesOrDirectoriesUtil.doMove(project, PsiUtilCore.toPsiElementArray(filesOrDirs), new PsiElement[]{targetContainer}, null);
            return;
        }
        MoveHandler.doMove(project, elements2, targetContainer, dataContext, null);
    }

    public static void doMove(Project project, @NotNull PsiElement[] elements2, PsiElement targetContainer, DataContext dataContext, MoveCallback callback2) {
        if (elements2 == null) {
            MoveHandler.$$$reportNull$$$0(3);
        }
        if (elements2.length == 0) {
            return;
        }
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(elements2, targetContainer, null)) continue;
            delegate.doMove(project, elements2, delegate.adjustTargetForMove(dataContext, targetContainer), callback2);
            break;
        }
    }

    @Nullable
    public static PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(sourceElements, targetElement, null)) continue;
            return delegate.adjustForMove(project, sourceElements, targetElement);
        }
        return sourceElements;
    }

    public static boolean canMove(@NotNull PsiElement[] elements2, PsiElement targetContainer) {
        if (elements2 == null) {
            MoveHandler.$$$reportNull$$$0(4);
        }
        return MoveHandler.findDelegate(elements2, targetContainer, null) != null;
    }

    @Nullable
    private static MoveHandlerDelegate findDelegate(@NotNull PsiElement[] elements2, @Nullable PsiElement targetContainer, @Nullable PsiReference reference2) {
        if (elements2 == null) {
            MoveHandler.$$$reportNull$$$0(5);
        }
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(elements2, targetContainer, reference2)) continue;
            return delegate;
        }
        return null;
    }

    @Nullable
    public static String getActionName(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            MoveHandler.$$$reportNull$$$0(6);
        }
        if ((editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR)) != null) {
            MoveHandlerDelegate refDelegate;
            PsiElement refElement;
            PsiReference reference2;
            Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                return null;
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return null;
            }
            PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
            if (element == null) {
                element = file2;
            }
            if ((reference2 = MoveHandler.findReferenceAtCaret(element, editor.getCaretModel().getOffset())) != null && (refElement = reference2.resolve()) != null && (refDelegate = MoveHandler.findDelegate(new PsiElement[]{refElement}, null, reference2)) != null) {
                return refDelegate.getActionName(new PsiElement[]{refElement});
            }
            List<MoveHandlerDelegate> candidateHandlers = MoveHandler.findHandlersForLanguage(element);
            while (element != null) {
                PsiElement[] elementArray = new PsiElement[]{element};
                for (MoveHandlerDelegate handler2 : candidateHandlers) {
                    if (!handler2.canMove(elementArray, null, reference2)) continue;
                    return handler2.getActionName(elementArray);
                }
                element = element.getParent();
            }
            return null;
        }
        PsiElement[] elements2 = BaseRefactoringAction.getPsiElementArray(dataContext);
        List delegates = MoveHandlerDelegate.EP_NAME.getExtensionList();
        for (MoveHandlerDelegate delegate : delegates) {
            if (!delegate.canMove(elements2, null, null)) continue;
            return delegate.getActionName(elements2);
        }
        return null;
    }

    @NotNull
    private static List<MoveHandlerDelegate> findHandlersForLanguage(@NotNull PsiElement element) {
        if (element == null) {
            MoveHandler.$$$reportNull$$$0(7);
        }
        List list2 = ContainerUtil.filter((Collection)MoveHandlerDelegate.EP_NAME.getExtensionList(), delegate -> delegate.supportsLanguage(element.getLanguage()));
        if (list2 == null) {
            MoveHandler.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public static boolean isValidTarget(PsiElement psiElement, PsiElement[] elements2) {
        if (psiElement != null) {
            for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!delegate.isValidTarget(psiElement, elements2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canMove(DataContext dataContext) {
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(dataContext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMoveRedundant(PsiElement source, PsiElement target2) {
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.isMoveRedundant(source, target2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/MoveHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/MoveHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findHandlersForLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canMove";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDelegate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findHandlersForLanguage";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

