/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.profile.codeInspection.ui.ScopeOrderComparator;
import com.intellij.ui.JBColor;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MultiScopeSeverityIcon
implements Icon {
    private final LinkedHashMap<String, HighlightDisplayLevel> myScopeToAverageSeverityMap;
    private final String myDefaultScopeName;

    MultiScopeSeverityIcon(@NotNull Map<String, HighlightSeverity> scopeToAverageSeverityMap, String defaultScopeName, @NotNull InspectionProfileImpl inspectionProfile) {
        if (scopeToAverageSeverityMap == null) {
            MultiScopeSeverityIcon.$$$reportNull$$$0(0);
        }
        if (inspectionProfile == null) {
            MultiScopeSeverityIcon.$$$reportNull$$$0(1);
        }
        this.myDefaultScopeName = defaultScopeName;
        ArrayList<String> sortedScopeNames = new ArrayList<String>(scopeToAverageSeverityMap.keySet());
        this.myScopeToAverageSeverityMap = new LinkedHashMap();
        Collections.sort(sortedScopeNames, new ScopeOrderComparator(inspectionProfile));
        sortedScopeNames.remove(defaultScopeName);
        sortedScopeNames.add(defaultScopeName);
        for (String scopeName : sortedScopeNames) {
            HighlightDisplayLevel level;
            HighlightSeverity severity = scopeToAverageSeverityMap.get(scopeName);
            if (severity == null || (level = HighlightDisplayLevel.find((HighlightSeverity)severity)) == null) continue;
            this.myScopeToAverageSeverityMap.put(scopeName, level);
        }
    }

    private static JBColor getMixedSeverityColor() {
        return JBColor.DARK_GRAY;
    }

    public String getDefaultScopeName() {
        return this.myDefaultScopeName;
    }

    public LinkedHashMap<String, HighlightDisplayLevel> getScopeToAverageSeverityMap() {
        return this.myScopeToAverageSeverityMap;
    }

    @Override
    public void paintIcon(Component c2, Graphics g, int i, int j) {
        int partWidth = this.getIconWidth() / this.myScopeToAverageSeverityMap.size();
        Collection<HighlightDisplayLevel> values = this.myScopeToAverageSeverityMap.values();
        int idx = 0;
        for (HighlightDisplayLevel level : values) {
            Icon icon = level.getIcon();
            g.setColor(icon instanceof HighlightDisplayLevel.ColoredIcon ? ((HighlightDisplayLevel.ColoredIcon)icon).getColor() : MultiScopeSeverityIcon.getMixedSeverityColor());
            int x = i + partWidth * idx;
            g.fillRect(x, j, partWidth, this.getIconHeight());
            ++idx;
        }
    }

    @Override
    public int getIconWidth() {
        return HighlightDisplayLevel.getEmptyIconDim();
    }

    @Override
    public int getIconHeight() {
        return HighlightDisplayLevel.getEmptyIconDim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scopeToAverageSeverityMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionProfile";
                break;
            }
        }
        objectArray[1] = "com/intellij/profile/codeInspection/ui/inspectionsTree/MultiScopeSeverityIcon";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

