/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.dnd.DnDAware;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.openapi.wm.impl.PaintersHelper;
import com.intellij.openapi.wm.impl.WindowShadowPainter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;

public class IdeGlassPaneImpl
extends JPanel
implements IdeGlassPaneEx,
IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.IdeGlassPaneImpl");
    private static final String PREPROCESSED_CURSOR_KEY = "SuperCursor";
    private final DisposableWrapperList<EventListener> myMouseListeners = new DisposableWrapperList();
    private final Set<EventListener> mySortedMouseListeners = new TreeSet<EventListener>((o1, o2) -> {
        double weight1 = 0.0;
        if (o1 instanceof Weighted) {
            weight1 = ((Weighted)o1).getWeight();
        }
        double weight2 = 0.0;
        if (o2 instanceof Weighted) {
            weight2 = ((Weighted)o2).getWeight();
        }
        return weight1 > weight2 ? 1 : (weight1 < weight2 ? -1 : this.myMouseListeners.indexOf(o1) - this.myMouseListeners.indexOf(o2));
    });
    private final JRootPane myRootPane;
    private final Map<String, PaintersHelper> myNamedPainters = FactoryMap.create(key -> new PaintersHelper(this));
    private boolean myPreprocessorActive;
    private final Map<Object, Cursor> myListener2Cursor = new LinkedHashMap<Object, Cursor>();
    private Component myLastCursorComponent;
    private Cursor myLastOriginalCursor;
    private MouseEvent myPrevPressEvent;
    WindowShadowPainter myWindowShadowPainter;

    public IdeGlassPaneImpl(JRootPane rootPane) {
        this(rootPane, false);
    }

    public IdeGlassPaneImpl(JRootPane rootPane, boolean installPainters) {
        this.myRootPane = rootPane;
        this.setOpaque(false);
        this.setVisible(false);
        this.setLayout(null);
        if (installPainters) {
            IdeBackgroundUtil.initFramePainters(this);
            IdeBackgroundUtil.initEditorPainters(this);
        }
        if (SystemInfo.isWindows && Registry.is((String)"ide.window.shadow.painter")) {
            this.myWindowShadowPainter = new WindowShadowPainter();
            this.getPainters().addPainter((Painter)this.myWindowShadowPainter, null);
        }
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        boolean dispatched;
        if (e == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(0);
        }
        JRootPane eventRootPane = this.myRootPane;
        if (e instanceof MouseEvent) {
            Container parentWindow;
            MouseEvent me = (MouseEvent)e;
            Window eventWindow = UIUtil.getWindow((Component)me.getComponent());
            if (IdeGlassPaneImpl.isContextMenu(eventWindow)) {
                return false;
            }
            Window thisGlassWindow = SwingUtilities.getWindowAncestor(this.myRootPane);
            if (eventWindow instanceof JWindow && (eventRootPane = ((JWindow)eventWindow).getRootPane()) != null && !(eventRootPane.getGlassPane() instanceof IdeGlassPane) && (parentWindow = eventWindow.getParent()) instanceof Window) {
                eventWindow = (Window)parentWindow;
            }
            if (eventWindow != thisGlassWindow) {
                return false;
            }
        }
        if (e.getID() == 506 && ApplicationManager.getApplication() != null) {
            IdeTooltipManager.getInstance().hideCurrent((MouseEvent)e);
        }
        if (e.getID() == 501 || e.getID() == 502 || e.getID() == 500) {
            dispatched = this.preprocess((MouseEvent)e, false, eventRootPane);
        } else if (e.getID() == 503 || e.getID() == 506) {
            dispatched = this.preprocess((MouseEvent)e, true, eventRootPane);
        } else if (e.getID() == 505 || e.getID() == 504) {
            dispatched = this.preprocess((MouseEvent)e, false, eventRootPane);
        } else {
            return false;
        }
        MouseEvent me = (MouseEvent)e;
        Component meComponent = me.getComponent();
        if (!dispatched && meComponent != null) {
            boolean pureMouse1Event;
            Window eventWindow = UIUtil.getWindow((Component)meComponent);
            if (eventWindow != SwingUtilities.getWindowAncestor(this.myRootPane)) {
                return false;
            }
            int button1 = 1040;
            boolean bl = pureMouse1Event = (me.getModifiersEx() | button1) == button1;
            if (pureMouse1Event && me.getClickCount() <= 1 && !me.isPopupTrigger()) {
                Point targetPoint;
                boolean overSelection;
                Component target2;
                Point point = SwingUtilities.convertPoint(meComponent, me.getPoint(), this.myRootPane.getContentPane());
                JMenuBar menuBar = this.myRootPane.getJMenuBar();
                if (menuBar != null && menuBar.isVisible()) {
                    point.y += menuBar.getHeight();
                }
                if ((target2 = SwingUtilities.getDeepestComponentAt(this.myRootPane.getContentPane().getParent(), point.x, point.y)) instanceof DnDAware && (overSelection = ((DnDAware)target2).isOverSelection(targetPoint = SwingUtilities.convertPoint(this.myRootPane.getContentPane().getParent(), point.x, point.y, target2)))) {
                    MouseListener[] listeners = (MouseListener[])target2.getListeners(MouseListener.class);
                    MouseEvent mouseEvent = MouseEventAdapter.convert((MouseEvent)me, (Component)target2);
                    switch (me.getID()) {
                        case 501: {
                            AWTEventListener[] eventListeners;
                            if (target2.isFocusable()) {
                                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(target2, true));
                            }
                            boolean consumed = false;
                            for (MouseListener listener2 : listeners) {
                                String className = listener2.getClass().getName();
                                if (className.contains("BasicTreeUI$") || className.contains("MacTreeUI$")) continue;
                                IdeGlassPaneImpl.fireMouseEvent(listener2, mouseEvent);
                                if (!mouseEvent.isConsumed()) continue;
                                consumed = true;
                                break;
                            }
                            if (!mouseEvent.isConsumed() && (eventListeners = Toolkit.getDefaultToolkit().getAWTEventListeners(16L)) != null && eventListeners.length > 0) {
                                for (AWTEventListener eventListener : eventListeners) {
                                    eventListener.eventDispatched(me);
                                    if (me.isConsumed()) break;
                                }
                                if (me.isConsumed()) {
                                    consumed = true;
                                    break;
                                }
                            }
                            if (!consumed) {
                                this.myPrevPressEvent = mouseEvent;
                            } else {
                                me.consume();
                            }
                            dispatched = true;
                            break;
                        }
                        case 502: {
                            if (this.myPrevPressEvent == null || this.myPrevPressEvent.getComponent() != target2) break;
                            for (MouseListener listener3 : listeners) {
                                String className = listener3.getClass().getName();
                                if (className.contains("BasicTreeUI$") || className.contains("MacTreeUI$")) {
                                    IdeGlassPaneImpl.fireMouseEvent(listener3, this.myPrevPressEvent);
                                    IdeGlassPaneImpl.fireMouseEvent(listener3, mouseEvent);
                                    if (mouseEvent.isConsumed()) break;
                                }
                                IdeGlassPaneImpl.fireMouseEvent(listener3, mouseEvent);
                                if (mouseEvent.isConsumed()) break;
                            }
                            if (mouseEvent.isConsumed()) {
                                me.consume();
                            }
                            this.myPrevPressEvent = null;
                            dispatched = true;
                            break;
                        }
                        default: {
                            this.myPrevPressEvent = null;
                        }
                    }
                }
            }
        }
        if (this.isVisible() && this.getComponentCount() == 0) {
            boolean cursorSet = false;
            if (meComponent != null) {
                Component target3;
                Point point = SwingUtilities.convertPoint(meComponent, me.getPoint(), this.myRootPane.getContentPane());
                if (this.myRootPane.getMenuBar() != null && this.myRootPane.getMenuBar().isVisible()) {
                    point.y += this.myRootPane.getMenuBar().getHeight();
                }
                if ((target3 = SwingUtilities.getDeepestComponentAt(this.myRootPane.getContentPane().getParent(), point.x, point.y)) != null) {
                    UIUtil.setCursor((Component)this, (Cursor)target3.getCursor());
                    cursorSet = true;
                }
            }
            if (!cursorSet) {
                UIUtil.setCursor((Component)this, (Cursor)Cursor.getDefaultCursor());
            }
        }
        return dispatched;
    }

    private static boolean isContextMenu(Window window) {
        if (window instanceof JWindow) {
            JLayeredPane layeredPane = ((JWindow)window).getLayeredPane();
            for (Component component : layeredPane.getComponents()) {
                if (!(component instanceof JPanel) || ContainerUtil.findInstance((Object[])((JPanel)component).getComponents(), JPopupMenu.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean preprocess(MouseEvent e, boolean motion, JRootPane eventRootPane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setCursor(@NotNull Component target2, Cursor cursor) {
        if (target2 == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(1);
        }
        if (target2 instanceof EditorComponentImpl) {
            ((EditorComponentImpl)target2).getEditor().setCustomCursor(IdeGlassPaneImpl.class, cursor);
        } else {
            if (target2 instanceof JComponent) {
                IdeGlassPaneImpl.savePreProcessedCursor((JComponent)target2, target2.getCursor());
            }
            UIUtil.setCursor((Component)target2, (Cursor)cursor);
        }
    }

    private static void resetCursor(@NotNull Component target2, Cursor lastCursor) {
        if (target2 == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(2);
        }
        if (target2 instanceof EditorComponentImpl) {
            ((EditorComponentImpl)target2).getEditor().setCustomCursor(IdeGlassPaneImpl.class, null);
        } else {
            Cursor cursor = null;
            if (target2 instanceof JComponent) {
                JComponent jComponent = (JComponent)target2;
                cursor = (Cursor)jComponent.getClientProperty(PREPROCESSED_CURSOR_KEY);
                jComponent.putClientProperty(PREPROCESSED_CURSOR_KEY, null);
            }
            cursor = cursor != null ? cursor : lastCursor;
            UIUtil.setCursor((Component)target2, (Cursor)cursor);
        }
    }

    private static boolean canProcessCursorFor(Component target2) {
        return !(target2 instanceof JMenuItem) && !(target2 instanceof Divider) && !(target2 instanceof JSeparator) && (!(target2 instanceof JEditorPane) || !(((JEditorPane)target2).getEditorKit() instanceof HTMLEditorKit));
    }

    private static Component getCompWithCursor(Component c2) {
        for (Component eachParentWithCursor = c2; eachParentWithCursor != null; eachParentWithCursor = eachParentWithCursor.getParent()) {
            if (!eachParentWithCursor.isCursorSet()) continue;
            return eachParentWithCursor;
        }
        return null;
    }

    private void restoreLastComponent(Component newC) {
        if (this.myLastCursorComponent != null && this.myLastCursorComponent != newC) {
            IdeGlassPaneImpl.resetCursor(this.myLastCursorComponent, this.myLastOriginalCursor);
        }
    }

    public static boolean hasPreProcessedCursor(@NotNull JComponent component) {
        if (component == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(3);
        }
        return component.getClientProperty(PREPROCESSED_CURSOR_KEY) != null;
    }

    public static boolean savePreProcessedCursor(@NotNull JComponent component, @NotNull Cursor cursor) {
        if (component == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(4);
        }
        if (cursor == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(5);
        }
        if (IdeGlassPaneImpl.hasPreProcessedCursor(component)) {
            return false;
        }
        component.putClientProperty(PREPROCESSED_CURSOR_KEY, cursor);
        return true;
    }

    public void setCursor(Cursor cursor, @NotNull Object requestor) {
        if (requestor == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(6);
        }
        if (cursor == null) {
            this.myListener2Cursor.remove(requestor);
        } else {
            this.myListener2Cursor.put(requestor, cursor);
        }
    }

    private static void fireMouseEvent(MouseListener listener2, MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                listener2.mousePressed(event);
                break;
            }
            case 502: {
                listener2.mouseReleased(event);
                break;
            }
            case 504: {
                listener2.mouseEntered(event);
                break;
            }
            case 505: {
                listener2.mouseExited(event);
                break;
            }
            case 500: {
                listener2.mouseClicked(event);
            }
        }
    }

    private static void fireMouseMotion(MouseMotionListener listener2, MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                listener2.mouseDragged(event);
            }
            case 503: {
                listener2.mouseMoved(event);
            }
        }
    }

    public void addMousePreprocessor(@NotNull MouseListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(8);
        }
        this._addListener(listener2, parent);
    }

    public void addMouseMotionPreprocessor(@NotNull MouseMotionListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(10);
        }
        this._addListener(listener2, parent);
    }

    private void _addListener(@NotNull EventListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(12);
        }
        if (!this.myMouseListeners.contains((Object)listener2)) {
            Disposable listenerDisposable = this.myMouseListeners.add((Object)listener2, parent);
            Disposer.register((Disposable)listenerDisposable, () -> UIUtil.invokeLaterIfNeeded(() -> this.removeListener(listener2)));
            this.updateSortedList();
        }
        this.activateIfNeeded();
    }

    public void removeMouseMotionPreprocessor(@NotNull MouseMotionListener listener2) {
        if (listener2 == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(13);
        }
        this.removeListener(listener2);
    }

    private void removeListener(@NotNull EventListener listener2) {
        if (listener2 == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(14);
        }
        if (this.myMouseListeners.remove((Object)listener2)) {
            this.updateSortedList();
        }
        this.deactivateIfNeeded();
    }

    private void updateSortedList() {
        this.mySortedMouseListeners.clear();
        this.mySortedMouseListeners.addAll((Collection<EventListener>)this.myMouseListeners);
    }

    private void deactivateIfNeeded() {
        if (this.myPreprocessorActive && this.myMouseListeners.isEmpty()) {
            this.myPreprocessorActive = false;
        }
        this.applyActivationState();
    }

    private void activateIfNeeded() {
        if (!this.myPreprocessorActive && !this.myMouseListeners.isEmpty()) {
            this.myPreprocessorActive = true;
        }
        this.applyActivationState();
    }

    private void applyActivationState() {
        IdeEventQueue queue;
        boolean hasWork;
        boolean wasVisible = this.isVisible();
        boolean bl = hasWork = this.getPainters().hasPainters() || this.getComponentCount() > 0;
        if (wasVisible != hasWork) {
            this.setVisible(hasWork);
        }
        if (!(queue = IdeEventQueue.getInstance()).containsDispatcher(this) && (this.myPreprocessorActive || this.isVisible())) {
            queue.addDispatcher(this, null);
        } else if (queue.containsDispatcher(this) && !this.myPreprocessorActive && !this.isVisible()) {
            queue.removeDispatcher(this);
        }
        if (wasVisible != this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    @NotNull
    PaintersHelper getNamedPainters(@NotNull String name) {
        if (name == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(15);
        }
        PaintersHelper paintersHelper = this.myNamedPainters.get(name);
        if (paintersHelper == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(16);
        }
        return paintersHelper;
    }

    @NotNull
    private PaintersHelper getPainters() {
        PaintersHelper paintersHelper = this.getNamedPainters("glass");
        if (paintersHelper == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(17);
        }
        return paintersHelper;
    }

    public void addPainter(Component component, @NotNull Painter painter, @NotNull Disposable parent) {
        if (painter == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(18);
        }
        if (parent == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(19);
        }
        this.getPainters().addPainter(painter, component);
        this.activateIfNeeded();
        Disposer.register((Disposable)parent, () -> SwingUtilities.invokeLater(() -> this.removePainter(painter)));
    }

    private void removePainter(@NotNull Painter painter) {
        if (painter == null) {
            IdeGlassPaneImpl.$$$reportNull$$$0(20);
        }
        this.getPainters().removePainter(painter);
        this.deactivateIfNeeded();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        SwingUtilities.invokeLater(() -> this.activateIfNeeded());
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        SwingUtilities.invokeLater(() -> this.deactivateIfNeeded());
    }

    @Override
    public boolean isInModalContext() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof GlassPaneDialogWrapperPeer.TransparentLayeredPane)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.getPainters().paint(g);
    }

    public Component getTargetComponentFor(MouseEvent e) {
        Component candidate = IdeGlassPaneImpl.findComponent(e, this.myRootPane.getLayeredPane());
        if (candidate != null) {
            return candidate;
        }
        candidate = IdeGlassPaneImpl.findComponent(e, this.myRootPane.getContentPane());
        if (candidate != null) {
            return candidate;
        }
        return e.getComponent();
    }

    private static Component findComponent(MouseEvent e, Container container) {
        Point lpPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), container);
        return SwingUtilities.getDeepestComponentAt(container, lpPoint.x, lpPoint.y);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.getPainters().hasPainters() && super.isOptimizedDrawingEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cursor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeGlassPaneImpl";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeGlassPaneImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedPainters";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPainters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 1: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetCursor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasPreProcessedCursor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "savePreProcessedCursor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMousePreprocessor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMouseMotionPreprocessor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "_addListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeMouseMotionPreprocessor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNamedPainters";
                break;
            }
            case 16: 
            case 17: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addPainter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removePainter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

