/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.largeFilesEditor.Utils;
import com.intellij.largeFilesEditor.editor.EditorManager;
import com.intellij.largeFilesEditor.search.Position;
import com.intellij.largeFilesEditor.search.SearchManager;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.SearchResultsPanelManagerAccessor;
import com.intellij.largeFilesEditor.search.actions.FindAllAction;
import com.intellij.largeFilesEditor.search.actions.FindForwardBackwardAction;
import com.intellij.largeFilesEditor.search.actions.PrevNextOccurrenceAction;
import com.intellij.largeFilesEditor.search.actions.StatusTextAction;
import com.intellij.largeFilesEditor.search.actions.ToggleAction;
import com.intellij.largeFilesEditor.search.searchResultsPanel.SearchResultsToolWindow;
import com.intellij.largeFilesEditor.search.searchTask.CloseSearchTask;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.RangeSearchTask;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskBase;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskCallback;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class SearchManagerImpl
implements SearchManager,
SearchTaskCallback {
    private static final int CONTEXT_ONE_SIDE_LENGTH = 100;
    private static final long STATUS_TEXT_LIFE_TIME = 3000L;
    private static final Logger logger = Logger.getInstance(SearchManagerImpl.class);
    private static final long PROGRESS_STATUS_UPDATE_PERIOD = 150L;
    private final EditorManager editorManager;
    private final FileDataProviderForSearch fileDataProviderForSearch;
    private final SearchResultsPanelManagerAccessor searchResultsPanelManagerAccessor;
    private final JBList<SearchResult> closeSearchResultsList;
    private SearchTaskBase lastExecutedSearchTask;
    private boolean notFoundState;
    private long lastProgressStatusUpdateTime;
    private SearchReplaceComponent searchManageGUI;
    private FindAllAction findAllAction;
    private FindForwardBackwardAction findForwardAction;
    private FindForwardBackwardAction findBackwardAction;
    private PrevNextOccurrenceAction nextOccurrenceAction;
    private PrevNextOccurrenceAction prevOccurrenceAction;
    private ToggleAction toggleCaseSensitiveAction;
    private ToggleAction toggleWholeWordsAction;
    private StatusTextAction statusTextAction;
    private String statusText;
    private boolean isStatusTextHidden;
    private long lastTimeStatusTextWasChanged;

    public SearchManagerImpl(@NotNull EditorManager editorManager, FileDataProviderForSearch fileDataProviderForSearch, @NotNull SearchResultsPanelManagerAccessor searchResultsPanelManagerAccessor) {
        if (editorManager == null) {
            SearchManagerImpl.$$$reportNull$$$0(0);
        }
        if (searchResultsPanelManagerAccessor == null) {
            SearchManagerImpl.$$$reportNull$$$0(1);
        }
        this.lastProgressStatusUpdateTime = System.currentTimeMillis();
        this.editorManager = editorManager;
        this.fileDataProviderForSearch = fileDataProviderForSearch;
        this.searchResultsPanelManagerAccessor = searchResultsPanelManagerAccessor;
        this.createActions();
        this.createSearchManageGUI();
        this.attachListenersToSearchManageGUI();
        this.closeSearchResultsList = this.createCloseSearchResultsList();
        this.lastExecutedSearchTask = null;
        this.notFoundState = false;
        this.statusText = "";
        this.isStatusTextHidden = true;
        this.lastTimeStatusTextWasChanged = System.currentTimeMillis();
    }

    @Override
    public SearchReplaceComponent getSearchManageGUI() {
        return this.searchManageGUI;
    }

    @Override
    public SearchTaskBase getLastExecutedSearchTask() {
        return this.lastExecutedSearchTask;
    }

    @Override
    public void onSearchActionHandlerExecuted() {
        this.editorManager.getEditor().setHeaderComponent((JComponent)this.searchManageGUI);
        this.searchManageGUI.requestFocusInTheSearchFieldAndSelectContent(this.editorManager.getProject());
        this.searchManageGUI.getSearchTextComponent().selectAll();
    }

    @Override
    @NotNull
    public EditorManager getEditorManager() {
        EditorManager editorManager = this.editorManager;
        if (editorManager == null) {
            SearchManagerImpl.$$$reportNull$$$0(2);
        }
        return editorManager;
    }

    @Override
    public void launchNewRangeSearch(long fromPageNumber, long toPageNumber, boolean forwardDirection) {
        long pageNumber;
        SearchResultsToolWindow searchResultsToolWindow = this.searchResultsPanelManagerAccessor.getSearchResultsToolWindow(true, this.editorManager.getProject(), this.editorManager.getVirtualFile());
        if (searchResultsToolWindow == null) {
            logger.warn("launchNewRangeSearch(...): searchResultsToolWindow is null, however it shouldn't be.");
            Messages.showWarningDialog((String)"Can't show tool window with search results. Unexpected problem. Search is stopped.", (String)"Error");
            return;
        }
        this.searchResultsPanelManagerAccessor.showSearchResultsToolWindow(searchResultsToolWindow);
        searchResultsToolWindow.clearAllResults();
        if (forwardDirection) {
            pageNumber = fromPageNumber;
            if (pageNumber == -1L) {
                pageNumber = 0L;
            }
        } else {
            pageNumber = toPageNumber;
            if (pageNumber == -1L) {
                try {
                    pageNumber = this.fileDataProviderForSearch.getPagesAmount();
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                    Messages.showWarningDialog((String)"Can't launch range search because of error of working with file.", (String)"Error");
                    return;
                }
            }
        }
        searchResultsToolWindow.setLeftBorderPageNumber(pageNumber);
        searchResultsToolWindow.setRightBorderPageNumber(pageNumber);
        SearchTaskOptions options = new SearchTaskOptions().setStringToFind(this.searchManageGUI.getSearchTextComponent().getText()).setSearchDirectionForward(forwardDirection).setSearchBounds(fromPageNumber, -1, toPageNumber, -1).setCaseSensetive(this.toggleCaseSensitiveAction.isSelected(null)).setWholeWords(this.toggleWholeWordsAction.isSelected(null)).setContextOneSideLength(100);
        searchResultsToolWindow.setSearchTaskOptions(options);
        searchResultsToolWindow.updateTabName();
        this.launchRangeSearch(options, true);
    }

    @Override
    public void launchRangeSearch(SearchTaskOptions searchTaskOptions, boolean needToClearPrevSearchResults) {
        long pagesAmount;
        this.stopSearchTaskIfItExists();
        SearchResultsToolWindow searchResultsToolWindow = this.searchResultsPanelManagerAccessor.getSearchResultsToolWindow(true, this.editorManager.getProject(), this.editorManager.getVirtualFile());
        if (searchResultsToolWindow == null) {
            logger.warn("launchRangeSearch(...): searchResultsToolWindow is null, however it shouldn't be.");
            Messages.showWarningDialog((String)"Can't show tool window with search results. Unexpected problem. Search is stopped.", (String)"Error");
            return;
        }
        this.searchResultsPanelManagerAccessor.showSearchResultsToolWindow(searchResultsToolWindow);
        searchResultsToolWindow.setSearchTaskOptions(searchTaskOptions);
        searchResultsToolWindow.setAdditionalStatusText(null);
        try {
            pagesAmount = this.fileDataProviderForSearch.getPagesAmount();
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            Messages.showWarningDialog((String)"Working with file error.", (String)"Error");
            return;
        }
        if (needToClearPrevSearchResults) {
            searchResultsToolWindow.clearAllResults();
            searchResultsToolWindow.setLeftBorderPageNumber(searchTaskOptions.leftBoundPageNumber == -1L ? 0L : searchTaskOptions.leftBoundPageNumber);
            searchResultsToolWindow.setRightBorderPageNumber(searchTaskOptions.rightBoundPageNumber == -1L ? pagesAmount - 1L : searchTaskOptions.rightBoundPageNumber);
            searchResultsToolWindow.updateSearchFurtherBtns();
        }
        final RangeSearchTask newRangeSearchTask = new RangeSearchTask(searchTaskOptions, this.editorManager.getProject(), this.fileDataProviderForSearch, this);
        this.lastExecutedSearchTask = newRangeSearchTask;
        String title = newRangeSearchTask.getTitleForBackgroundableTask();
        Task.Backgroundable task2 = new Task.Backgroundable(null, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                newRangeSearchTask.setProgressIndicator(indicator);
                newRangeSearchTask.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/largeFilesEditor/search/SearchManagerImpl$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    @Override
    public void gotoNextOccurrence(boolean directionForward) {
        int gotoSearchResultIndex = SearchManagerImpl.getNextOccurrenceIndexIfCan(directionForward, this.editorManager.getCaretPageNumber(), this.editorManager.getCaretPageOffset(), this.closeSearchResultsList);
        if (gotoSearchResultIndex == -1) {
            boolean launchedLoopedCloseSearch = false;
            SearchTaskOptions normalCloseSearchOptions = this.generateOptionsForNormalCloseSearch(directionForward, false);
            if (this.notFoundState) {
                this.notFoundState = false;
                launchedLoopedCloseSearch = this.launchLoopedCloseSearchTaskIfNeeded(normalCloseSearchOptions);
            }
            if (!launchedLoopedCloseSearch) {
                this.launchCloseSearch(normalCloseSearchOptions);
            }
        } else {
            this.closeSearchResultsList.setSelectedIndex(gotoSearchResultIndex);
            this.setNewStatusText("");
        }
    }

    private void launchCloseSearch(SearchTaskOptions options) {
        if (StringUtil.isEmpty((String)options.stringToFind)) {
            return;
        }
        this.stopSearchTaskIfItExists();
        this.lastExecutedSearchTask = new CloseSearchTask(options, this.editorManager.getProject(), this.fileDataProviderForSearch, this);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.lastExecutedSearchTask);
    }

    private boolean launchLoopedCloseSearchTaskIfNeeded(SearchTaskOptions normalCloseSearchOptions) {
        SearchTaskOptions loopedOptions;
        if (!(this.lastExecutedSearchTask instanceof CloseSearchTask)) {
            return false;
        }
        if (!this.lastExecutedSearchTask.isFinished()) {
            return false;
        }
        SearchTaskOptions oldOptions = this.lastExecutedSearchTask.getOptions();
        if (oldOptions.loopedPhase) {
            return false;
        }
        if (!normalCloseSearchOptions.stringToFind.equals(oldOptions.stringToFind) || normalCloseSearchOptions.onlyOnePageSearch != oldOptions.onlyOnePageSearch || normalCloseSearchOptions.wholeWords != oldOptions.wholeWords || normalCloseSearchOptions.caseSensitive != oldOptions.caseSensitive || normalCloseSearchOptions.searchForwardDirection != oldOptions.searchForwardDirection || normalCloseSearchOptions.leftBoundPageNumber != oldOptions.leftBoundPageNumber || normalCloseSearchOptions.leftBoundCaretPageOffset != oldOptions.leftBoundCaretPageOffset || normalCloseSearchOptions.rightBoundPageNumber != oldOptions.rightBoundPageNumber || normalCloseSearchOptions.rightBoundCaretPageOffset != oldOptions.rightBoundCaretPageOffset) {
            return false;
        }
        try {
            loopedOptions = normalCloseSearchOptions.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.warn((Throwable)e);
            Messages.showWarningDialog((String)"Error while searching.", (String)"Search Error");
            return false;
        }
        loopedOptions.loopedPhase = true;
        if (loopedOptions.searchForwardDirection) {
            loopedOptions.setSearchBounds(0L, -1, normalCloseSearchOptions.leftBoundPageNumber, normalCloseSearchOptions.leftBoundCaretPageOffset);
        } else {
            loopedOptions.setSearchBounds(normalCloseSearchOptions.rightBoundPageNumber, normalCloseSearchOptions.rightBoundCaretPageOffset, -1L, -1);
        }
        this.launchCloseSearch(loopedOptions);
        return true;
    }

    private SearchTaskOptions generateOptionsForNormalCloseSearch(boolean directionForward, boolean onlyOnePageSearch) {
        SearchTaskOptions options = new SearchTaskOptions().setOnlyOnePageSearch(onlyOnePageSearch).setSearchDirectionForward(directionForward).setStringToFind(this.searchManageGUI.getSearchTextComponent().getText()).setCaseSensetive(this.toggleCaseSensitiveAction.isSelected(null)).setWholeWords(this.toggleWholeWordsAction.isSelected(null)).setContextOneSideLength(100);
        if (onlyOnePageSearch) {
            long pageNumber = this.editorManager.getCaretPageNumber();
            options.setSearchBounds(pageNumber, -1, pageNumber, -1);
        } else if (!this.closeSearchResultsList.isEmpty() && this.closeSearchResultsList.getSelectedIndex() != -1) {
            Position position = ((SearchResult)this.closeSearchResultsList.getSelectedValue()).startPosition;
            if (directionForward) {
                options.setSearchBounds(position.pageNumber + 1L, 0, -1L, -1);
            } else {
                options.setSearchBounds(-1L, -1, position.pageNumber, position.symbolOffsetInPage);
            }
        } else {
            long caretPageNumber = this.editorManager.getCaretPageNumber();
            int caretPageOffset = this.editorManager.getCaretPageOffset();
            if (directionForward) {
                options.setSearchBounds(caretPageNumber, caretPageOffset, -1L, -1);
            } else {
                options.setSearchBounds(-1L, -1, caretPageNumber, caretPageOffset);
            }
        }
        return options;
    }

    @Override
    public void tellFrameSearchResultsFound(RangeSearchTask caller, ArrayList<SearchResult> allMatchesAtFrame) {
        if (!allMatchesAtFrame.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                SearchTaskOptions options = caller.getOptions();
                if (!caller.isShouldStop()) {
                    SearchResultsToolWindow searchResultsToolWindow = this.searchResultsPanelManagerAccessor.getSearchResultsToolWindow(false, this.editorManager.getProject(), this.editorManager.getVirtualFile());
                    if (searchResultsToolWindow == null) {
                        caller.shouldStop();
                        logger.warn("tellFrameSearchResultsFound(...): searchResultsToolWindow is null, however it should be created when the searching was launched.");
                        Messages.showWarningDialog((String)"Can't show tool window with search results. Unexpected problem. Search is stopped.", (String)"Error");
                        return;
                    }
                    if (options.searchForwardDirection) {
                        searchResultsToolWindow.addSearchResultsIntoEnd(allMatchesAtFrame);
                    } else {
                        searchResultsToolWindow.addSearchResultsIntoBeginning(allMatchesAtFrame);
                    }
                    if (searchResultsToolWindow.getAmountOfStoredSearchResults() > options.criticalAmountOfSearchResults) {
                        this.stopSearchTaskIfItExists();
                        if (options.searchForwardDirection) {
                            searchResultsToolWindow.setRightBorderPageNumber(((SearchResult)allMatchesAtFrame.get((int)0)).startPosition.pageNumber);
                        } else {
                            searchResultsToolWindow.setLeftBorderPageNumber(((SearchResult)allMatchesAtFrame.get((int)0)).startPosition.pageNumber);
                        }
                        searchResultsToolWindow.setAdditionalStatusText("Search stopped because too many results were found.");
                        searchResultsToolWindow.updateSearchFurtherBtns();
                    }
                }
            });
        }
    }

    @Override
    public void tellSearchProgress(SearchTaskBase caller, long curPageNumber, long pagesAmount) {
        long time = System.currentTimeMillis();
        if (time - this.lastProgressStatusUpdateTime > 150L || curPageNumber == 0L || curPageNumber == pagesAmount - 1L) {
            this.lastProgressStatusUpdateTime = time;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!caller.isShouldStop()) {
                    if (caller instanceof CloseSearchTask) {
                        this.setNewStatusText("Searching at " + Utils.calculatePagePositionPercent(curPageNumber, pagesAmount) + "% of file ...");
                    } else {
                        SearchResultsToolWindow searchResultsToolWindow = this.searchResultsPanelManagerAccessor.getSearchResultsToolWindow(false, this.editorManager.getProject(), this.editorManager.getVirtualFile());
                        if (searchResultsToolWindow != null) {
                            if (caller.getOptions().searchForwardDirection) {
                                searchResultsToolWindow.setRightBorderPageNumber(curPageNumber);
                            } else {
                                searchResultsToolWindow.setLeftBorderPageNumber(curPageNumber);
                            }
                            searchResultsToolWindow.updateSearchFurtherBtns();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void tellClosestResultFound(CloseSearchTask caller, ArrayList<SearchResult> allMatchesAtFrame, int indexOfClosestResult) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!caller.isShouldStop()) {
                this.setNewStatusText("");
                SearchResult closestResult = (SearchResult)allMatchesAtFrame.get(indexOfClosestResult);
                this.editorManager.getEditorModel().showSearchResult(closestResult);
                this.editorManager.getEditorModel().setHighlightingCloseSearchResultsEnabled(true);
            }
        });
    }

    @Override
    public void tellSearchIsFinished(SearchTaskBase caller, long lastScannedPageNumber) {
        ApplicationManager.getApplication().invokeLater(() -> {
            SearchTaskOptions options = caller.getOptions();
            if (!caller.isShouldStop()) {
                if (caller instanceof CloseSearchTask) {
                    if (options.loopedPhase) {
                        this.setNewStatusText("Search complete. No more matches.");
                        this.searchManageGUI.setNotFoundBackground();
                        if (!(this.editorManager.getEditor().getHeaderComponent() instanceof SearchReplaceComponent)) {
                            String message = "\"" + options.stringToFind + "\" not found";
                            SearchManagerImpl.showSimpleHintInEditor(message, this.editorManager.getEditor());
                        }
                    } else if (options.onlyOnePageSearch) {
                        if (!this.closeSearchResultsList.isEmpty() && ((SearchResult)this.closeSearchResultsList.getModel().getElementAt((int)0)).startPosition.pageNumber != lastScannedPageNumber) {
                            ((CollectionListModel)this.closeSearchResultsList.getModel()).removeAll();
                        }
                    } else {
                        this.notFoundState = true;
                        AnAction action2 = ActionManager.getInstance().getAction(options.searchForwardDirection ? "FindNext" : "FindPrevious");
                        String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2);
                        String findAgainFromText = options.searchForwardDirection ? "start" : "end";
                        this.setNewStatusText("");
                        String message = !shortcutsText.isEmpty() ? String.format("\"%s\" not found, press %s to search from the %s", options.stringToFind, shortcutsText, findAgainFromText) : String.format("\"%s\" not found, perform \"%s\" action again to search from the %s", options.stringToFind, action2.getTemplatePresentation().getText(), findAgainFromText);
                        SearchManagerImpl.showSimpleHintInEditor(message, this.editorManager.getEditor());
                    }
                } else {
                    SearchResultsToolWindow searchResultsToolWindow = this.searchResultsPanelManagerAccessor.getSearchResultsToolWindow(false, this.editorManager.getProject(), this.editorManager.getVirtualFile());
                    if (searchResultsToolWindow != null) {
                        if (options.searchForwardDirection) {
                            searchResultsToolWindow.setRightBorderPageNumber(lastScannedPageNumber);
                        } else {
                            searchResultsToolWindow.setLeftBorderPageNumber(lastScannedPageNumber);
                        }
                        searchResultsToolWindow.setAdditionalStatusText("Search complete.");
                        searchResultsToolWindow.updateSearchFurtherBtns();
                    }
                }
            }
        });
    }

    private static void showSimpleHintInEditor(String message, Editor editor) {
        JComponent hintComponent = HintUtil.createInformationLabel(message);
        LightweightHint hint = new LightweightHint(hintComponent);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }

    @Override
    public void tellSearchWasStopped(SearchTaskBase caller, long curPageNumber) {
        if (caller instanceof RangeSearchTask) {
            ApplicationManager.getApplication().invokeLater(() -> {
                SearchResultsToolWindow searchResultsToolWindow = this.searchResultsPanelManagerAccessor.getSearchResultsToolWindow(false, this.editorManager.getProject(), this.editorManager.getVirtualFile());
                if (searchResultsToolWindow != null) {
                    searchResultsToolWindow.updateSearchFurtherBtns();
                }
            });
        }
    }

    @Override
    public void tellSearchWasCatchedException(SearchTaskBase caller, IOException e) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!caller.isShouldStop()) {
                if (caller instanceof CloseSearchTask) {
                    this.setNewStatusText("Search stopped because something went wrong.");
                } else {
                    SearchResultsToolWindow searchResultsToolWindow = this.searchResultsPanelManagerAccessor.getSearchResultsToolWindow(false, this.editorManager.getProject(), this.editorManager.getVirtualFile());
                    if (searchResultsToolWindow != null) {
                        searchResultsToolWindow.setAdditionalStatusText("Search stopped because something went wrong.");
                    }
                }
            }
        });
    }

    @Override
    public void onEscapePressed() {
        if (this.lastExecutedSearchTask != null && !this.lastExecutedSearchTask.isShouldStop() && !this.lastExecutedSearchTask.isFinished()) {
            this.stopSearchTaskIfItExists();
            if (this.lastExecutedSearchTask instanceof CloseSearchTask) {
                this.setNewStatusText("Stopped by user.");
            }
        } else {
            this.stopSearchTaskIfItExists();
            IdeFocusManager.getInstance((Project)this.editorManager.getProject()).requestFocus((Component)this.editorManager.getEditor().getContentComponent(), false);
            this.editorManager.getEditorModel().setHighlightingCloseSearchResultsEnabled(false);
            if (this.editorManager.getEditor().getHeaderComponent() instanceof SearchReplaceComponent) {
                this.editorManager.getEditor().setHeaderComponent(null);
            }
        }
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public void updateStatusText() {
        if (this.isStatusTextHidden) {
            return;
        }
        if (System.currentTimeMillis() - this.lastTimeStatusTextWasChanged > 3000L) {
            this.statusText = "";
            this.isStatusTextHidden = true;
        }
    }

    @Override
    public void updateSearchManageGUIActions() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.searchManageGUI.updateActions();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> this.searchManageGUI.updateActions());
        }
    }

    @Override
    public void onSearchParametersChanged() {
        if (this.lastExecutedSearchTask instanceof CloseSearchTask) {
            this.lastExecutedSearchTask.shouldStop();
            this.setNewStatusText("");
        }
        this.searchManageGUI.setRegularBackground();
        this.editorManager.getEditorModel().setHighlightingCloseSearchResultsEnabled(false);
    }

    @Override
    public void onCaretPositionChanged(CaretEvent e) {
        if (this.closeSearchResultsList.getSelectedIndex() != -1 && e.getEditor().getCaretModel().getOffset() != ((SearchResult)this.closeSearchResultsList.getSelectedValue()).startPosition.symbolOffsetInPage && e.getEditor().getCaretModel().getOffset() != 0) {
            this.closeSearchResultsList.clearSelection();
        }
    }

    @Override
    public void dispose() {
        SearchResultsToolWindow searchResultsToolWindow;
        if (this.lastExecutedSearchTask instanceof RangeSearchTask && !this.lastExecutedSearchTask.isShouldStop() && !this.lastExecutedSearchTask.isFinished() && (searchResultsToolWindow = this.searchResultsPanelManagerAccessor.getSearchResultsToolWindow(false, this.editorManager.getProject(), this.editorManager.getVirtualFile())) != null) {
            searchResultsToolWindow.setAdditionalStatusText("Search stopped because the editor was closed.");
        }
        this.stopSearchTaskIfItExists();
    }

    @Override
    public void tellSearchResultsToolWindowWasClosed() {
        if (this.lastExecutedSearchTask instanceof RangeSearchTask) {
            this.lastExecutedSearchTask.shouldStop();
        }
    }

    @Override
    public List<TextRange> getAllSearchResultsInDocument(Document document) {
        FindResult findResult;
        SearchTaskOptions options = this.generateOptionsForNormalCloseSearch(true, false);
        if (StringUtil.isEmpty((String)options.stringToFind)) {
            return null;
        }
        FindModel findModel = options.generateFindModel();
        String documentText = document.getText();
        int offset = 0;
        ArrayList<TextRange> resultsList = new ArrayList<TextRange>();
        while ((findResult = FindManager.getInstance((Project)this.editorManager.getProject()).findString((CharSequence)documentText, offset, findModel)).isStringFound()) {
            resultsList.add((TextRange)findResult);
            offset = findResult.getEndOffset();
        }
        return resultsList;
    }

    @Override
    public boolean isSearchWorkingNow() {
        return this.lastExecutedSearchTask != null && !this.lastExecutedSearchTask.isFinished();
    }

    private void createActions() {
        this.nextOccurrenceAction = new PrevNextOccurrenceAction(this, true);
        this.prevOccurrenceAction = new PrevNextOccurrenceAction(this, false);
        this.findAllAction = new FindAllAction(this);
        this.findForwardAction = new FindForwardBackwardAction(true, this);
        this.findBackwardAction = new FindForwardBackwardAction(false, this);
        this.toggleCaseSensitiveAction = new ToggleAction(this, "Match &Case");
        this.toggleWholeWordsAction = new ToggleAction(this, "W&ords");
        this.statusTextAction = new StatusTextAction(this);
    }

    private void createSearchManageGUI() {
        this.searchManageGUI = SearchReplaceComponent.buildFor(this.editorManager.getProject(), this.editorManager.getEditor().getContentComponent()).addPrimarySearchActions(new AnAction[]{this.prevOccurrenceAction, this.nextOccurrenceAction, new Separator(), this.findAllAction, this.findBackwardAction, this.findForwardAction}).addExtraSearchActions(new AnAction[]{this.toggleCaseSensitiveAction, this.toggleWholeWordsAction, this.statusTextAction}).withCloseAction(this::onEscapePressed).build();
    }

    private void attachListenersToSearchManageGUI() {
        this.searchManageGUI.addListener(new SearchReplaceComponent.Listener(){

            @Override
            public void searchFieldDocumentChanged() {
                SearchManagerImpl.this.onSearchParametersChanged();
            }

            @Override
            public void replaceFieldDocumentChanged() {
            }

            @Override
            public void multilineStateChanged() {
            }
        });
    }

    private JBList<SearchResult> createCloseSearchResultsList() {
        CollectionListModel model2 = new CollectionListModel((Object[])new SearchResult[0]);
        JBList list2 = new JBList((ListModel)model2);
        list2.addListSelectionListener((ListSelectionListener)new CloseSearchResultsListSelectionListener((JBList<SearchResult>)list2));
        return list2;
    }

    private void stopSearchTaskIfItExists() {
        if (this.lastExecutedSearchTask != null) {
            this.lastExecutedSearchTask.shouldStop();
        }
    }

    private void setNewStatusText(String newStatusText) {
        this.statusText = newStatusText;
        this.lastTimeStatusTextWasChanged = System.currentTimeMillis();
        this.isStatusTextHidden = StringUtil.isEmpty((String)newStatusText);
        this.updateSearchManageGUIActions();
    }

    private static int getNextOccurrenceIndexIfCan(boolean directionForward, long currentPageNumber, int caretPageOffset, JBList<SearchResult> listResult) {
        int index;
        ListModel model2 = listResult.getModel();
        if (model2.getSize() == -1) {
            return -1;
        }
        if (listResult.getSelectedIndex() != -1) {
            index = listResult.getSelectedIndex();
            index = directionForward ? ++index : --index;
        } else {
            index = 0;
            while (true) {
                if (index >= model2.getSize()) {
                    if (directionForward) {
                        return -1;
                    }
                    return model2.getSize() - 1;
                }
                SearchResult searchResult = (SearchResult)model2.getElementAt(index);
                if (currentPageNumber <= searchResult.startPosition.pageNumber && (currentPageNumber != searchResult.startPosition.pageNumber || caretPageOffset < searchResult.startPosition.symbolOffsetInPage)) break;
                ++index;
            }
            if (!directionForward) {
                --index;
            }
        }
        if (index < 0 || index >= model2.getSize()) {
            return -1;
        }
        return index;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchResultsPanelManagerAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/largeFilesEditor/search/SearchManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/largeFilesEditor/search/SearchManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloseSearchResultsListSelectionListener
    implements ListSelectionListener {
        private final JBList<SearchResult> list;

        CloseSearchResultsListSelectionListener(JBList<SearchResult> list2) {
            this.list = list2;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SearchResult selectedSearchResult;
            if (!e.getValueIsAdjusting() && (selectedSearchResult = (SearchResult)this.list.getSelectedValue()) != null) {
                SearchManagerImpl.this.editorManager.showSearchResult(selectedSearchResult);
            }
        }
    }
}

