/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataValidator;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.impl.dataRules.CopyProviderRule;
import com.intellij.ide.impl.dataRules.CutProviderRule;
import com.intellij.ide.impl.dataRules.FileEditorRule;
import com.intellij.ide.impl.dataRules.FileTextRule;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.ide.impl.dataRules.InactiveEditorRule;
import com.intellij.ide.impl.dataRules.NavigatableArrayRule;
import com.intellij.ide.impl.dataRules.PasteProviderRule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.reference.SoftReference;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DataManagerImpl
extends DataManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.DataManagerImpl");
    private final ConcurrentMap<String, GetDataRule> myDataConstantToRuleMap = new ConcurrentHashMap<String, GetDataRule>();
    private WindowManagerEx myWindowManager;
    private static final Set<String> ourSafeKeys = new HashSet<String>(Arrays.asList(CommonDataKeys.PROJECT.getName(), CommonDataKeys.EDITOR.getName(), PlatformDataKeys.IS_MODAL_CONTEXT.getName(), PlatformDataKeys.CONTEXT_COMPONENT.getName(), PlatformDataKeys.MODALITY_STATE.getName()));

    public DataManagerImpl() {
        this.registerRules();
    }

    @Nullable
    private Object getData(@NotNull String dataId, Component focusedComponent) {
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(0);
        }
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            for (Component c2 = focusedComponent; c2 != null; c2 = c2.getParent()) {
                Object data;
                DataProvider dataProvider = DataManagerImpl.getDataProviderEx(c2);
                if (dataProvider == null || (data = this.getDataFromProvider(dataProvider, dataId, null)) == null) continue;
                Object object = data;
                return object;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getDataFromProvider(@NotNull DataProvider provider, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds) {
        if (provider == null) {
            DataManagerImpl.$$$reportNull$$$0(1);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        if (alreadyComputedIds != null && alreadyComputedIds.contains(dataId)) {
            return null;
        }
        try {
            Object data = provider.getData(dataId);
            if (data != null) {
                Object object = DataManagerImpl.validated(data, dataId, provider);
                return object;
            }
            GetDataRule dataRule = this.getDataRule(dataId);
            if (dataRule != null) {
                THashSet ids = alreadyComputedIds == null ? new THashSet() : alreadyComputedIds;
                ids.add(dataId);
                data = dataRule.getData(arg_0 -> this.lambda$getDataFromProvider$0(provider, (Set)ids, arg_0));
                if (data != null) {
                    Object object = DataManagerImpl.validated(data, dataId, provider);
                    return object;
                }
            }
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            if (alreadyComputedIds != null) {
                alreadyComputedIds.remove(dataId);
            }
        }
    }

    @Nullable
    public static DataProvider getDataProviderEx(Object component) {
        DataProvider dataProvider = null;
        if (component instanceof DataProvider) {
            dataProvider = (DataProvider)component;
        } else if (component instanceof TypeSafeDataProvider) {
            dataProvider = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)component);
        } else if (component instanceof JComponent) {
            dataProvider = DataManagerImpl.getDataProvider((JComponent)((JComponent)component));
        }
        return dataProvider;
    }

    @Nullable
    public GetDataRule getDataRule(@NotNull String dataId) {
        GetDataRule rule;
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(3);
        }
        if ((rule = this.getRuleFromMap(dataId)) != null) {
            return rule;
        }
        GetDataRule plainRule = this.getRuleFromMap(AnActionEvent.uninjectedId((String)dataId));
        if (plainRule != null) {
            return dataProvider -> plainRule.getData(id -> dataProvider.getData(AnActionEvent.injectedId((String)id)));
        }
        return null;
    }

    @Nullable
    private GetDataRule getRuleFromMap(@NotNull String dataId) {
        GetDataRule rule;
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(4);
        }
        if ((rule = (GetDataRule)this.myDataConstantToRuleMap.get(dataId)) == null && !this.myDataConstantToRuleMap.containsKey(dataId)) {
            for (KeyedLazyInstanceEP ruleEP : (KeyedLazyInstanceEP[])GetDataRule.EP_NAME.getExtensions()) {
                if (!ruleEP.key.equals(dataId)) continue;
                rule = (GetDataRule)ruleEP.getInstance();
            }
            if (rule != null) {
                this.myDataConstantToRuleMap.putIfAbsent(dataId, rule);
            }
        }
        return rule;
    }

    @Nullable
    private static Object validated(@NotNull Object data, @NotNull String dataId, @NotNull Object dataSource) {
        Object invalidData;
        if (data == null) {
            DataManagerImpl.$$$reportNull$$$0(5);
        }
        if (dataId == null) {
            DataManagerImpl.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            DataManagerImpl.$$$reportNull$$$0(7);
        }
        if ((invalidData = DataValidator.findInvalidData(dataId, data, dataSource)) != null) {
            return null;
        }
        return data;
    }

    @NotNull
    public DataContext getDataContext(Component component) {
        MyDataContext myDataContext = new MyDataContext(component);
        if (myDataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(8);
        }
        return myDataContext;
    }

    @NotNull
    public DataContext getDataContext(@NotNull Component component, int x, int y) {
        if (component == null) {
            DataManagerImpl.$$$reportNull$$$0(9);
        }
        if (x < 0 || x >= component.getWidth() || y < 0 || y >= component.getHeight()) {
            throw new IllegalArgumentException("wrong point: x=" + x + "; y=" + y);
        }
        if (component instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component;
            int index = tabbedPane.getUI().tabForCoordinate(tabbedPane, x, y);
            DataContext dataContext = this.getDataContext(index != -1 ? tabbedPane.getComponentAt(index) : tabbedPane);
            if (dataContext == null) {
                DataManagerImpl.$$$reportNull$$$0(10);
            }
            return dataContext;
        }
        DataContext dataContext = this.getDataContext(component);
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(11);
        }
        return dataContext;
    }

    public void setWindowManager(WindowManagerEx windowManager) {
        this.myWindowManager = windowManager;
    }

    @NotNull
    public DataContext getDataContext() {
        Component component = null;
        if (Registry.is((String)"actionSystem.getContextByRecentMouseEvent")) {
            component = SwingHelper.getComponentFromRecentMouseEvent();
        }
        DataContext dataContext = this.getDataContext(component != null ? component : this.getFocusedComponent());
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(12);
        }
        return dataContext;
    }

    @NotNull
    public Promise<DataContext> getDataContextFromFocusAsync() {
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> result2.setResult((Object)this.getDataContext()), ModalityState.any());
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            DataManagerImpl.$$$reportNull$$$0(13);
        }
        return asyncPromise;
    }

    @NotNull
    public DataContext getDataContextTest(Component component) {
        DataContext dataContext = this.getDataContext(component);
        if (this.myWindowManager == null) {
            DataContext dataContext2 = dataContext;
            if (dataContext2 == null) {
                DataManagerImpl.$$$reportNull$$$0(14);
            }
            return dataContext2;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Component focusedComponent = this.myWindowManager.getFocusedComponent(project);
        if (focusedComponent != null) {
            dataContext = this.getDataContext(focusedComponent);
        }
        DataContext dataContext3 = dataContext;
        if (dataContext3 == null) {
            DataManagerImpl.$$$reportNull$$$0(15);
        }
        return dataContext3;
    }

    @Nullable
    private Component getFocusedComponent() {
        if (this.myWindowManager == null) {
            return null;
        }
        Window activeWindow = this.myWindowManager.getMostRecentFocusedWindow();
        if (activeWindow == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
            return null;
        }
        if (activeWindow instanceof FloatingDecorator) {
            boolean toolWindowIsNotFocused;
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            boolean bl = toolWindowIsNotFocused = this.myWindowManager.getFocusedComponent(activeWindow) == null;
            if (toolWindowIsNotFocused && lastFocusedWindow != null) {
                activeWindow = lastFocusedWindow;
            }
        }
        Component focusedComponent = null;
        for (Window window = activeWindow; window != null && (focusedComponent = this.myWindowManager.getFocusedComponent(window)) == null; window = window.getOwner()) {
        }
        if (focusedComponent == null) {
            focusedComponent = activeWindow;
        }
        return focusedComponent;
    }

    private void registerRules() {
        this.myDataConstantToRuleMap.put(PlatformDataKeys.COPY_PROVIDER.getName(), new CopyProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.CUT_PROVIDER.getName(), new CutProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.PASTE_PROVIDER.getName(), new PasteProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_TEXT.getName(), new FileTextRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_EDITOR.getName(), new FileEditorRule());
        this.myDataConstantToRuleMap.put(CommonDataKeys.NAVIGATABLE_ARRAY.getName(), new NavigatableArrayRule());
        this.myDataConstantToRuleMap.put(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getName(), new InactiveEditorRule());
    }

    public <T> void saveInDataContext(DataContext dataContext, @NotNull Key<T> dataKey, @Nullable T data) {
        if (dataKey == null) {
            DataManagerImpl.$$$reportNull$$$0(16);
        }
        if (dataContext instanceof UserDataHolder) {
            ((UserDataHolder)dataContext).putUserData(dataKey, data);
        }
    }

    @Nullable
    public <T> T loadFromDataContext(@NotNull DataContext dataContext, @NotNull Key<T> dataKey) {
        if (dataContext == null) {
            DataManagerImpl.$$$reportNull$$$0(17);
        }
        if (dataKey == null) {
            DataManagerImpl.$$$reportNull$$$0(18);
        }
        return (T)(dataContext instanceof UserDataHolder ? ((UserDataHolder)dataContext).getUserData(dataKey) : null);
    }

    @Nullable
    public static Editor validateEditor(Editor editor) {
        JComponent jComponent;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JComponent && (jComponent = (JComponent)focusOwner).getClientProperty("AuxEditorComponent") != null) {
            return null;
        }
        return editor;
    }

    private /* synthetic */ Object lambda$getDataFromProvider$0(DataProvider provider, Set ids, String id) {
        return this.getDataFromProvider(provider, id, ids);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/DataManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/DataManagerImpl";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextFromFocusAsync";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataRule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRuleFromMap";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validated";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDataContext";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "saveInDataContext";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDataContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    public static class MyDataContext
    implements DataContext,
    UserDataHolder {
        private int myEventCount = -1;
        private final Reference<Component> myRef;
        private Map<Key, Object> myUserData;
        private final Map<String, Object> myCachedData = ContainerUtil.createWeakValueMap();

        public MyDataContext(@Nullable Component component) {
            this.myRef = component == null ? null : new WeakReference<Component>(component);
        }

        public void setEventCount(int eventCount, Object caller) {
            assert (caller instanceof IdeKeyEventDispatcher) : "This method might be accessible from " + IdeKeyEventDispatcher.class.getName() + " only";
            this.myCachedData.clear();
            this.myEventCount = eventCount;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyDataContext.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            if (ApplicationManager.getApplication().isDispatchThread()) {
                int currentEventCount = IdeEventQueue.getInstance().getEventCount();
                if (this.myEventCount != -1 && this.myEventCount != currentEventCount) {
                    LOG.error("cannot share data context between Swing events; initial event count = " + this.myEventCount + "; current event count = " + currentEventCount);
                    return this.doGetData(dataId);
                }
            }
            if (ourSafeKeys.contains(dataId)) {
                Object answer = this.myCachedData.get(dataId);
                if (answer == null) {
                    answer = this.doGetData(dataId);
                    this.myCachedData.put(dataId, answer == null ? NullResult.INSTANCE : answer);
                }
                return answer != NullResult.INSTANCE ? answer : null;
            }
            return this.doGetData(dataId);
        }

        @Nullable
        private Object doGetData(@NotNull String dataId) {
            if (dataId == null) {
                MyDataContext.$$$reportNull$$$0(1);
            }
            Component component = (Component)SoftReference.dereference(this.myRef);
            if (PlatformDataKeys.IS_MODAL_CONTEXT.is(dataId)) {
                if (component == null) {
                    return null;
                }
                return IdeKeyEventDispatcher.isModalContext(component);
            }
            if (PlatformDataKeys.CONTEXT_COMPONENT.is(dataId)) {
                return component;
            }
            if (PlatformDataKeys.MODALITY_STATE.is(dataId)) {
                return component != null ? ModalityState.stateForComponent((Component)component) : ModalityState.NON_MODAL;
            }
            if (CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId)) {
                return DataManagerImpl.validateEditor((Editor)this.calcData(dataId, component));
            }
            return this.calcData(dataId, component);
        }

        protected Object calcData(@NotNull String dataId, Component component) {
            if (dataId == null) {
                MyDataContext.$$$reportNull$$$0(2);
            }
            return ((DataManagerImpl)DataManager.getInstance()).getData(dataId, component);
        }

        @NonNls
        public String toString() {
            return "component=" + SoftReference.dereference(this.myRef);
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                MyDataContext.$$$reportNull$$$0(3);
            }
            return (T)this.getOrCreateMap().get(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                MyDataContext.$$$reportNull$$$0(4);
            }
            this.getOrCreateMap().put(key, value);
        }

        @NotNull
        private Map<Key, Object> getOrCreateMap() {
            Map userData = this.myUserData;
            if (userData == null) {
                this.myUserData = userData = ContainerUtil.createWeakValueMap();
            }
            Map map2 = userData;
            if (map2 == null) {
                MyDataContext.$$$reportNull$$$0(5);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/impl/DataManagerImpl$MyDataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/impl/DataManagerImpl$MyDataContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doGetData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserData";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "putUserData";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NullResult {
        public static final NullResult INSTANCE = new NullResult();

        private NullResult() {
        }
    }
}

