# AsyncMicroBenchmark
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L28)</span>

Asynchronous benchmarks must provide this trait. The `apply` method defines a
single iteration in a sample. Each phase of the sample completes when the
given `AsyncBenchContinue` has its `complete` method invoked. Setup and
Teardown are defined by the `before` and `after` methods respectively. The
`before` method runs before a sample of benchmarks and `after` runs after
the all iterations in the sample have completed. If your benchmark requires
setup and/or teardown to occur beween each iteration of the benchmark, then
you can use `before_iteration` and `after_iteration` methods respectively
that run before/after each iteration.


```pony
trait iso AsyncMicroBenchmark
```

## Public Functions

### name
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L40)</span>


```pony
fun box name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### config
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L41)</span>


```pony
fun box config()
: BenchConfig val
```

#### Returns

* [BenchConfig](ponybench-BenchConfig.md) val

---

### overhead
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L42)</span>


```pony
fun box overhead()
: AsyncMicroBenchmark iso^
```

#### Returns

* [AsyncMicroBenchmark](ponybench-AsyncMicroBenchmark.md) iso^

---

### before
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L43)</span>


```pony
fun ref before(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### before_iteration
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L44)</span>


```pony
fun ref before_iteration(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### apply
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L45)</span>


```pony
fun ref apply(
  c: AsyncBenchContinue val)
: None val ?
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### after
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L46)</span>


```pony
fun ref after(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

### after_iteration
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L47)</span>


```pony
fun ref after_iteration(
  c: AsyncBenchContinue val)
: None val
```
#### Parameters

*   c: [AsyncBenchContinue](ponybench-AsyncBenchContinue.md) val

#### Returns

* [None](builtin-None.md) val

---

