/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.io.File;
import java.util.Comparator;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.util.Callback;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.selection.multiple.NumericalSortFilenameComparator;
import org.pdfsam.ui.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;

public enum FileColumn implements SelectionTableColumn<File>
{
    NAME{

        @Override
        public String getColumnTitle() {
            return DefaultI18nContext.getInstance().i18n("Name");
        }

        @Override
        public ObservableValue<File> getObservableValue(SelectionTableRowData data) {
            return new ReadOnlyObjectWrapper((Object)data.descriptor().getFile());
        }

        @Override
        public String getTextValue(File item) {
            return item != null ? item.getName() : "";
        }

        @Override
        public Callback<TableColumn<SelectionTableRowData, File>, TableCell<SelectionTableRowData, File>> cellFactory() {
            return new Callback<TableColumn<SelectionTableRowData, File>, TableCell<SelectionTableRowData, File>>(){

                public TableCell<SelectionTableRowData, File> call(TableColumn<SelectionTableRowData, File> param) {
                    return new TableCell<SelectionTableRowData, File>(){

                        public void updateItem(File item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setText(this.getTextValue(item));
                            if (item != null) {
                                this.setTooltip(new Tooltip(item.getAbsolutePath()));
                            } else {
                                this.setTooltip(null);
                            }
                        }
                    };
                }
            };
        }

        @Override
        public Comparator<File> comparator() {
            return new NumericalSortFilenameComparator().thenComparing(f -> f.getName().toLowerCase());
        }
    };

}

