/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.split;

import java.io.File;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.util.HumanReadableSize;
import org.sejda.impl.sambox.component.PagesExtractor;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.split.NextOutputStrategy;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPdfSplitter<T extends AbstractPdfOutputParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPdfSplitter.class);
    private PDDocument document;
    private T parameters;
    private int totalPages;
    private MultipleOutputWriter outputWriter;
    private boolean optimize = false;
    private boolean discardOutline = false;

    public AbstractPdfSplitter(PDDocument document, T parameters, boolean optimize, boolean discardOutline) {
        this.document = document;
        this.parameters = parameters;
        this.totalPages = document.getNumberOfPages();
        this.optimize = optimize;
        this.discardOutline = discardOutline;
    }

    public void split(TaskExecutionContext executionContext, String outputPrefix, PdfSource<?> source) throws TaskException {
        this.nextOutputStrategy().ensureIsValid();
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)this.parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
        NameGenerator nameGen = NameGenerator.nameGenerator((String)outputPrefix);
        try (PagesExtractor extractor = this.supplyPagesExtractor(this.document);){
            File tmpFile = null;
            for (int page = 1; page <= this.totalPages; ++page) {
                executionContext.assertTaskNotCancelled();
                if (this.nextOutputStrategy().isOpening(Integer.valueOf(page))) {
                    LOG.debug("Starting split at page {} of the original document", (Object)page);
                    this.onOpen(page);
                    tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)this.parameters.getOutput());
                    LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
                    String outName = nameGen.generate(this.enrichNameGenerationRequest(NameGenerationRequest.nameRequest().page(page).originalName(source.getName()).fileNumber(executionContext.incrementAndGetOutputDocumentsCounter())));
                    this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
                }
                LOG.trace("Retaining page {} of the original document", (Object)page);
                this.onRetain(page);
                extractor.retain(page, executionContext);
                ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)executionContext.notifiableTaskMetadata()).stepsCompleted(page).outOf(this.totalPages);
                if (!this.nextOutputStrategy().isClosing(Integer.valueOf(page)) && page != this.totalPages) continue;
                this.onClose(page);
                extractor.setVersion(this.parameters.getVersion());
                extractor.setCompress(this.parameters.isCompress());
                if (this.optimize) {
                    extractor.optimize();
                }
                extractor.save(tmpFile, this.discardOutline);
                extractor.reset();
                LOG.debug("Ending split at page {} of the original document, generated document size is {}", (Object)page, (Object)HumanReadableSize.toString((long)tmpFile.length()));
            }
        }
        this.parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
    }

    abstract NameGenerationRequest enrichNameGenerationRequest(NameGenerationRequest var1);

    abstract NextOutputStrategy nextOutputStrategy();

    protected void onOpen(int page) throws TaskException {
    }

    protected void onRetain(int page) throws TaskException {
    }

    protected void onClose(int page) throws TaskException {
    }

    protected PagesExtractor supplyPagesExtractor(PDDocument document) {
        return new PagesExtractor(document);
    }
}

