/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dnd;

import java.io.File;
import javax.inject.Inject;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.pdf.SingleFileDroppedEvent;
import org.pdfsam.support.io.FileType;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Auto;

@Auto
public class SingleFileDropController {
    @Inject
    public SingleFileDropController() {
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void request(SingleFileDroppedEvent event) {
        event.files.stream().filter(f -> FileType.PDF.matches(f.getName())).filter(File::isFile).map(PdfDocumentDescriptor::newDescriptorNoPassword).findFirst().ifPresent(file -> {
            PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(event.getOwnerModule());
            loadEvent.add(file);
            StaticStudio.eventStudio().broadcast((Object)loadEvent, event.getOwnerModule());
        });
    }
}

