"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.colorSchemas = exports.vislibColorMaps = exports.ColorSchemas = void 0;

var _i18n = require("@kbn/i18n");

var _vislibColorMaps;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var ColorSchemas;
exports.ColorSchemas = ColorSchemas;

(function (ColorSchemas) {
  ColorSchemas["Blues"] = "Blues";
  ColorSchemas["Greens"] = "Greens";
  ColorSchemas["Greys"] = "Greys";
  ColorSchemas["Reds"] = "Reds";
  ColorSchemas["YellowToRed"] = "Yellow to Red";
  ColorSchemas["GreenToRed"] = "Green to Red";
})(ColorSchemas || (exports.ColorSchemas = ColorSchemas = {}));

var vislibColorMaps = (_vislibColorMaps = {}, _defineProperty(_vislibColorMaps, ColorSchemas.Blues, {
  id: ColorSchemas.Blues,
  label: _i18n.i18n.translate('common.ui.vislib.colormaps.bluesText', {
    defaultMessage: 'Blues'
  }),
  value: [[0.0, [0.969, 0.984, 1.0]], [0.002, [0.969, 0.984, 1.0]], [0.004, [0.966, 0.982, 0.999]], [0.006, [0.966, 0.982, 0.999]], [0.008, [0.962, 0.98, 0.998]], [0.01, [0.962, 0.98, 0.998]], [0.012, [0.959, 0.978, 0.997]], [0.014, [0.959, 0.978, 0.997]], [0.016, [0.956, 0.976, 0.996]], [0.018, [0.956, 0.976, 0.996]], [0.02, [0.953, 0.974, 0.995]], [0.022, [0.953, 0.974, 0.995]], [0.023, [0.95, 0.973, 0.994]], [0.025, [0.95, 0.973, 0.994]], [0.027, [0.947, 0.971, 0.993]], [0.029, [0.947, 0.971, 0.993]], [0.031, [0.944, 0.969, 0.992]], [0.033, [0.944, 0.969, 0.992]], [0.035, [0.941, 0.967, 0.991]], [0.037, [0.941, 0.967, 0.991]], [0.039, [0.938, 0.965, 0.99]], [0.041, [0.938, 0.965, 0.99]], [0.043, [0.935, 0.963, 0.989]], [0.045, [0.935, 0.963, 0.989]], [0.047, [0.932, 0.961, 0.988]], [0.049, [0.932, 0.961, 0.988]], [0.051, [0.929, 0.959, 0.987]], [0.053, [0.929, 0.959, 0.987]], [0.055, [0.926, 0.957, 0.986]], [0.057, [0.926, 0.957, 0.986]], [0.059, [0.922, 0.955, 0.985]], [0.061, [0.922, 0.955, 0.985]], [0.063, [0.919, 0.953, 0.984]], [0.065, [0.919, 0.953, 0.984]], [0.067, [0.916, 0.951, 0.983]], [0.068, [0.916, 0.951, 0.983]], [0.07, [0.913, 0.949, 0.982]], [0.072, [0.913, 0.949, 0.982]], [0.074, [0.91, 0.947, 0.981]], [0.076, [0.91, 0.947, 0.981]], [0.078, [0.907, 0.945, 0.98]], [0.08, [0.907, 0.945, 0.98]], [0.082, [0.904, 0.943, 0.979]], [0.084, [0.904, 0.943, 0.979]], [0.086, [0.901, 0.941, 0.978]], [0.088, [0.901, 0.941, 0.978]], [0.09, [0.898, 0.939, 0.977]], [0.092, [0.898, 0.939, 0.977]], [0.094, [0.895, 0.937, 0.976]], [0.096, [0.895, 0.937, 0.976]], [0.098, [0.892, 0.935, 0.975]], [0.1, [0.892, 0.935, 0.975]], [0.102, [0.889, 0.933, 0.974]], [0.104, [0.889, 0.933, 0.974]], [0.106, [0.886, 0.931, 0.973]], [0.108, [0.886, 0.931, 0.973]], [0.11, [0.883, 0.929, 0.972]], [0.112, [0.883, 0.929, 0.972]], [0.114, [0.879, 0.927, 0.971]], [0.115, [0.879, 0.927, 0.971]], [0.117, [0.876, 0.925, 0.97]], [0.119, [0.876, 0.925, 0.97]], [0.121, [0.873, 0.923, 0.969]], [0.123, [0.873, 0.923, 0.969]], [0.125, [0.87, 0.921, 0.969]], [0.127, [0.87, 0.921, 0.969]], [0.129, [0.867, 0.919, 0.968]], [0.131, [0.867, 0.919, 0.968]], [0.133, [0.864, 0.917, 0.967]], [0.135, [0.864, 0.917, 0.967]], [0.137, [0.861, 0.915, 0.966]], [0.139, [0.861, 0.915, 0.966]], [0.141, [0.858, 0.913, 0.965]], [0.143, [0.858, 0.913, 0.965]], [0.145, [0.855, 0.911, 0.964]], [0.147, [0.855, 0.911, 0.964]], [0.149, [0.853, 0.91, 0.963]], [0.151, [0.853, 0.91, 0.963]], [0.153, [0.85, 0.908, 0.962]], [0.155, [0.85, 0.908, 0.962]], [0.157, [0.847, 0.906, 0.961]], [0.159, [0.847, 0.906, 0.961]], [0.16, [0.844, 0.904, 0.96]], [0.162, [0.844, 0.904, 0.96]], [0.164, [0.841, 0.902, 0.959]], [0.166, [0.841, 0.902, 0.959]], [0.168, [0.838, 0.9, 0.958]], [0.17, [0.838, 0.9, 0.958]], [0.172, [0.835, 0.898, 0.957]], [0.174, [0.835, 0.898, 0.957]], [0.176, [0.832, 0.896, 0.956]], [0.178, [0.832, 0.896, 0.956]], [0.18, [0.829, 0.894, 0.955]], [0.182, [0.829, 0.894, 0.955]], [0.184, [0.826, 0.892, 0.954]], [0.186, [0.826, 0.892, 0.954]], [0.188, [0.823, 0.89, 0.953]], [0.19, [0.823, 0.89, 0.953]], [0.192, [0.82, 0.888, 0.952]], [0.194, [0.82, 0.888, 0.952]], [0.196, [0.817, 0.886, 0.951]], [0.198, [0.817, 0.886, 0.951]], [0.2, [0.814, 0.884, 0.95]], [0.202, [0.814, 0.884, 0.95]], [0.204, [0.811, 0.882, 0.949]], [0.205, [0.811, 0.882, 0.949]], [0.207, [0.808, 0.88, 0.948]], [0.209, [0.808, 0.88, 0.948]], [0.211, [0.805, 0.878, 0.947]], [0.213, [0.805, 0.878, 0.947]], [0.215, [0.802, 0.876, 0.946]], [0.217, [0.802, 0.876, 0.946]], [0.219, [0.799, 0.874, 0.945]], [0.221, [0.799, 0.874, 0.945]], [0.223, [0.796, 0.872, 0.944]], [0.225, [0.796, 0.872, 0.944]], [0.227, [0.793, 0.87, 0.943]], [0.229, [0.793, 0.87, 0.943]], [0.231, [0.79, 0.868, 0.942]], [0.233, [0.79, 0.868, 0.942]], [0.235, [0.788, 0.866, 0.941]], [0.237, [0.788, 0.866, 0.941]], [0.239, [0.785, 0.864, 0.94]], [0.241, [0.785, 0.864, 0.94]], [0.243, [0.782, 0.862, 0.939]], [0.245, [0.782, 0.862, 0.939]], [0.247, [0.779, 0.86, 0.938]], [0.249, [0.779, 0.86, 0.938]], [0.25, [0.775, 0.858, 0.937]], [0.252, [0.775, 0.858, 0.937]], [0.254, [0.77, 0.856, 0.935]], [0.256, [0.77, 0.856, 0.935]], [0.258, [0.765, 0.854, 0.933]], [0.26, [0.765, 0.854, 0.933]], [0.262, [0.76, 0.852, 0.932]], [0.264, [0.76, 0.852, 0.932]], [0.266, [0.756, 0.85, 0.93]], [0.268, [0.756, 0.85, 0.93]], [0.27, [0.751, 0.848, 0.928]], [0.272, [0.751, 0.848, 0.928]], [0.274, [0.746, 0.846, 0.926]], [0.276, [0.746, 0.846, 0.926]], [0.278, [0.741, 0.844, 0.925]], [0.28, [0.741, 0.844, 0.925]], [0.282, [0.736, 0.842, 0.923]], [0.284, [0.736, 0.842, 0.923]], [0.286, [0.731, 0.839, 0.921]], [0.288, [0.731, 0.839, 0.921]], [0.29, [0.726, 0.837, 0.92]], [0.292, [0.726, 0.837, 0.92]], [0.294, [0.721, 0.835, 0.918]], [0.295, [0.721, 0.835, 0.918]], [0.297, [0.716, 0.833, 0.916]], [0.299, [0.716, 0.833, 0.916]], [0.301, [0.711, 0.831, 0.914]], [0.303, [0.711, 0.831, 0.914]], [0.305, [0.706, 0.829, 0.913]], [0.307, [0.706, 0.829, 0.913]], [0.309, [0.701, 0.827, 0.911]], [0.311, [0.701, 0.827, 0.911]], [0.313, [0.697, 0.825, 0.909]], [0.315, [0.697, 0.825, 0.909]], [0.317, [0.692, 0.823, 0.908]], [0.319, [0.692, 0.823, 0.908]], [0.321, [0.687, 0.821, 0.906]], [0.323, [0.687, 0.821, 0.906]], [0.325, [0.682, 0.819, 0.904]], [0.327, [0.682, 0.819, 0.904]], [0.329, [0.677, 0.816, 0.902]], [0.331, [0.677, 0.816, 0.902]], [0.333, [0.672, 0.814, 0.901]], [0.335, [0.672, 0.814, 0.901]], [0.337, [0.667, 0.812, 0.899]], [0.339, [0.667, 0.812, 0.899]], [0.341, [0.662, 0.81, 0.897]], [0.342, [0.662, 0.81, 0.897]], [0.344, [0.657, 0.808, 0.895]], [0.346, [0.657, 0.808, 0.895]], [0.348, [0.652, 0.806, 0.894]], [0.35, [0.652, 0.806, 0.894]], [0.352, [0.647, 0.804, 0.892]], [0.354, [0.647, 0.804, 0.892]], [0.356, [0.642, 0.802, 0.89]], [0.358, [0.642, 0.802, 0.89]], [0.36, [0.637, 0.8, 0.889]], [0.362, [0.637, 0.8, 0.889]], [0.364, [0.633, 0.798, 0.887]], [0.366, [0.633, 0.798, 0.887]], [0.368, [0.628, 0.796, 0.885]], [0.37, [0.628, 0.796, 0.885]], [0.372, [0.623, 0.793, 0.883]], [0.374, [0.623, 0.793, 0.883]], [0.376, [0.617, 0.791, 0.882]], [0.378, [0.617, 0.791, 0.882]], [0.38, [0.611, 0.787, 0.88]], [0.382, [0.611, 0.787, 0.88]], [0.384, [0.605, 0.784, 0.879]], [0.386, [0.605, 0.784, 0.879]], [0.387, [0.598, 0.781, 0.878]], [0.389, [0.598, 0.781, 0.878]], [0.391, [0.592, 0.777, 0.876]], [0.393, [0.592, 0.777, 0.876]], [0.395, [0.586, 0.774, 0.875]], [0.397, [0.586, 0.774, 0.875]], [0.399, [0.58, 0.77, 0.874]], [0.401, [0.58, 0.77, 0.874]], [0.403, [0.573, 0.767, 0.872]], [0.405, [0.573, 0.767, 0.872]], [0.407, [0.567, 0.763, 0.871]], [0.409, [0.567, 0.763, 0.871]], [0.411, [0.561, 0.76, 0.87]], [0.413, [0.561, 0.76, 0.87]], [0.415, [0.555, 0.756, 0.868]], [0.417, [0.555, 0.756, 0.868]], [0.419, [0.548, 0.753, 0.867]], [0.421, [0.548, 0.753, 0.867]], [0.423, [0.542, 0.75, 0.866]], [0.425, [0.542, 0.75, 0.866]], [0.427, [0.536, 0.746, 0.864]], [0.429, [0.536, 0.746, 0.864]], [0.431, [0.529, 0.743, 0.863]], [0.432, [0.529, 0.743, 0.863]], [0.434, [0.523, 0.739, 0.862]], [0.436, [0.523, 0.739, 0.862]], [0.438, [0.517, 0.736, 0.86]], [0.44, [0.517, 0.736, 0.86]], [0.442, [0.511, 0.732, 0.859]], [0.444, [0.511, 0.732, 0.859]], [0.446, [0.504, 0.729, 0.857]], [0.448, [0.504, 0.729, 0.857]], [0.45, [0.498, 0.725, 0.856]], [0.452, [0.498, 0.725, 0.856]], [0.454, [0.492, 0.722, 0.855]], [0.456, [0.492, 0.722, 0.855]], [0.458, [0.485, 0.719, 0.853]], [0.46, [0.485, 0.719, 0.853]], [0.462, [0.479, 0.715, 0.852]], [0.464, [0.479, 0.715, 0.852]], [0.466, [0.473, 0.712, 0.851]], [0.468, [0.473, 0.712, 0.851]], [0.47, [0.467, 0.708, 0.849]], [0.472, [0.467, 0.708, 0.849]], [0.474, [0.46, 0.705, 0.848]], [0.476, [0.46, 0.705, 0.848]], [0.477, [0.454, 0.701, 0.847]], [0.479, [0.454, 0.701, 0.847]], [0.481, [0.448, 0.698, 0.845]], [0.483, [0.448, 0.698, 0.845]], [0.485, [0.442, 0.694, 0.844]], [0.487, [0.442, 0.694, 0.844]], [0.489, [0.435, 0.691, 0.843]], [0.491, [0.435, 0.691, 0.843]], [0.493, [0.429, 0.688, 0.841]], [0.495, [0.429, 0.688, 0.841]], [0.497, [0.423, 0.684, 0.84]], [0.499, [0.423, 0.684, 0.84]], [0.501, [0.417, 0.681, 0.838]], [0.503, [0.417, 0.681, 0.838]], [0.505, [0.412, 0.677, 0.836]], [0.507, [0.412, 0.677, 0.836]], [0.509, [0.407, 0.674, 0.834]], [0.511, [0.407, 0.674, 0.834]], [0.513, [0.402, 0.67, 0.832]], [0.515, [0.402, 0.67, 0.832]], [0.517, [0.397, 0.667, 0.83]], [0.519, [0.397, 0.667, 0.83]], [0.521, [0.392, 0.663, 0.828]], [0.523, [0.392, 0.663, 0.828]], [0.524, [0.387, 0.66, 0.826]], [0.526, [0.387, 0.66, 0.826]], [0.528, [0.382, 0.657, 0.824]], [0.53, [0.382, 0.657, 0.824]], [0.532, [0.377, 0.653, 0.822]], [0.534, [0.377, 0.653, 0.822]], [0.536, [0.372, 0.65, 0.821]], [0.538, [0.372, 0.65, 0.821]], [0.54, [0.367, 0.646, 0.819]], [0.542, [0.367, 0.646, 0.819]], [0.544, [0.362, 0.643, 0.817]], [0.546, [0.362, 0.643, 0.817]], [0.548, [0.357, 0.639, 0.815]], [0.55, [0.357, 0.639, 0.815]], [0.552, [0.352, 0.636, 0.813]], [0.554, [0.352, 0.636, 0.813]], [0.556, [0.346, 0.632, 0.811]], [0.558, [0.346, 0.632, 0.811]], [0.56, [0.341, 0.629, 0.809]], [0.562, [0.341, 0.629, 0.809]], [0.564, [0.336, 0.626, 0.807]], [0.566, [0.336, 0.626, 0.807]], [0.568, [0.331, 0.622, 0.805]], [0.569, [0.331, 0.622, 0.805]], [0.571, [0.326, 0.619, 0.803]], [0.573, [0.326, 0.619, 0.803]], [0.575, [0.321, 0.615, 0.801]], [0.577, [0.321, 0.615, 0.801]], [0.579, [0.316, 0.612, 0.799]], [0.581, [0.316, 0.612, 0.799]], [0.583, [0.311, 0.608, 0.797]], [0.585, [0.311, 0.608, 0.797]], [0.587, [0.306, 0.605, 0.795]], [0.589, [0.306, 0.605, 0.795]], [0.591, [0.301, 0.601, 0.793]], [0.593, [0.301, 0.601, 0.793]], [0.595, [0.296, 0.598, 0.791]], [0.597, [0.296, 0.598, 0.791]], [0.599, [0.291, 0.595, 0.789]], [0.601, [0.291, 0.595, 0.789]], [0.603, [0.286, 0.591, 0.787]], [0.605, [0.286, 0.591, 0.787]], [0.607, [0.281, 0.588, 0.785]], [0.609, [0.281, 0.588, 0.785]], [0.611, [0.276, 0.584, 0.783]], [0.613, [0.276, 0.584, 0.783]], [0.614, [0.271, 0.581, 0.781]], [0.616, [0.271, 0.581, 0.781]], [0.618, [0.266, 0.577, 0.779]], [0.62, [0.266, 0.577, 0.779]], [0.622, [0.261, 0.574, 0.777]], [0.624, [0.261, 0.574, 0.777]], [0.626, [0.256, 0.57, 0.775]], [0.628, [0.256, 0.57, 0.775]], [0.63, [0.252, 0.566, 0.773]], [0.632, [0.252, 0.566, 0.773]], [0.634, [0.248, 0.562, 0.771]], [0.636, [0.248, 0.562, 0.771]], [0.638, [0.244, 0.558, 0.769]], [0.64, [0.244, 0.558, 0.769]], [0.642, [0.24, 0.554, 0.767]], [0.644, [0.24, 0.554, 0.767]], [0.646, [0.236, 0.55, 0.765]], [0.648, [0.236, 0.55, 0.765]], [0.65, [0.232, 0.546, 0.763]], [0.652, [0.232, 0.546, 0.763]], [0.654, [0.228, 0.542, 0.761]], [0.656, [0.228, 0.542, 0.761]], [0.658, [0.224, 0.538, 0.758]], [0.659, [0.224, 0.538, 0.758]], [0.661, [0.22, 0.533, 0.756]], [0.663, [0.22, 0.533, 0.756]], [0.665, [0.216, 0.529, 0.754]], [0.667, [0.216, 0.529, 0.754]], [0.669, [0.212, 0.525, 0.752]], [0.671, [0.212, 0.525, 0.752]], [0.673, [0.208, 0.521, 0.75]], [0.675, [0.208, 0.521, 0.75]], [0.677, [0.204, 0.517, 0.748]], [0.679, [0.204, 0.517, 0.748]], [0.681, [0.199, 0.513, 0.746]], [0.683, [0.199, 0.513, 0.746]], [0.685, [0.195, 0.509, 0.744]], [0.687, [0.195, 0.509, 0.744]], [0.689, [0.191, 0.505, 0.742]], [0.691, [0.191, 0.505, 0.742]], [0.693, [0.187, 0.501, 0.74]], [0.695, [0.187, 0.501, 0.74]], [0.697, [0.183, 0.497, 0.738]], [0.699, [0.183, 0.497, 0.738]], [0.701, [0.179, 0.493, 0.735]], [0.703, [0.179, 0.493, 0.735]], [0.705, [0.175, 0.489, 0.733]], [0.706, [0.175, 0.489, 0.733]], [0.708, [0.171, 0.485, 0.731]], [0.71, [0.171, 0.485, 0.731]], [0.712, [0.167, 0.481, 0.729]], [0.714, [0.167, 0.481, 0.729]], [0.716, [0.163, 0.477, 0.727]], [0.718, [0.163, 0.477, 0.727]], [0.72, [0.159, 0.473, 0.725]], [0.722, [0.159, 0.473, 0.725]], [0.724, [0.155, 0.469, 0.723]], [0.726, [0.155, 0.469, 0.723]], [0.728, [0.151, 0.464, 0.721]], [0.73, [0.151, 0.464, 0.721]], [0.732, [0.147, 0.46, 0.719]], [0.734, [0.147, 0.46, 0.719]], [0.736, [0.143, 0.456, 0.717]], [0.738, [0.143, 0.456, 0.717]], [0.74, [0.139, 0.452, 0.715]], [0.742, [0.139, 0.452, 0.715]], [0.744, [0.134, 0.448, 0.712]], [0.746, [0.134, 0.448, 0.712]], [0.748, [0.13, 0.444, 0.71]], [0.75, [0.13, 0.444, 0.71]], [0.751, [0.127, 0.44, 0.707]], [0.753, [0.127, 0.44, 0.707]], [0.755, [0.124, 0.436, 0.704]], [0.757, [0.124, 0.436, 0.704]], [0.759, [0.121, 0.432, 0.701]], [0.761, [0.121, 0.432, 0.701]], [0.763, [0.118, 0.428, 0.698]], [0.765, [0.118, 0.428, 0.698]], [0.767, [0.115, 0.424, 0.695]], [0.769, [0.115, 0.424, 0.695]], [0.771, [0.112, 0.42, 0.692]], [0.773, [0.112, 0.42, 0.692]], [0.775, [0.109, 0.417, 0.689]], [0.777, [0.109, 0.417, 0.689]], [0.779, [0.106, 0.413, 0.686]], [0.781, [0.106, 0.413, 0.686]], [0.783, [0.102, 0.409, 0.683]], [0.785, [0.102, 0.409, 0.683]], [0.787, [0.099, 0.405, 0.68]], [0.789, [0.099, 0.405, 0.68]], [0.791, [0.096, 0.401, 0.677]], [0.793, [0.096, 0.401, 0.677]], [0.795, [0.093, 0.397, 0.674]], [0.796, [0.093, 0.397, 0.674]], [0.798, [0.09, 0.393, 0.671]], [0.8, [0.09, 0.393, 0.671]], [0.802, [0.087, 0.389, 0.668]], [0.804, [0.087, 0.389, 0.668]], [0.806, [0.084, 0.385, 0.664]], [0.808, [0.084, 0.385, 0.664]], [0.81, [0.081, 0.381, 0.661]], [0.812, [0.081, 0.381, 0.661]], [0.814, [0.078, 0.377, 0.658]], [0.816, [0.078, 0.377, 0.658]], [0.818, [0.075, 0.373, 0.655]], [0.82, [0.075, 0.373, 0.655]], [0.822, [0.072, 0.369, 0.652]], [0.824, [0.072, 0.369, 0.652]], [0.826, [0.069, 0.365, 0.649]], [0.828, [0.069, 0.365, 0.649]], [0.83, [0.066, 0.361, 0.646]], [0.832, [0.066, 0.361, 0.646]], [0.834, [0.063, 0.358, 0.643]], [0.836, [0.063, 0.358, 0.643]], [0.838, [0.059, 0.354, 0.64]], [0.84, [0.059, 0.354, 0.64]], [0.841, [0.056, 0.35, 0.637]], [0.843, [0.056, 0.35, 0.637]], [0.845, [0.053, 0.346, 0.634]], [0.847, [0.053, 0.346, 0.634]], [0.849, [0.05, 0.342, 0.631]], [0.851, [0.05, 0.342, 0.631]], [0.853, [0.047, 0.338, 0.628]], [0.855, [0.047, 0.338, 0.628]], [0.857, [0.044, 0.334, 0.624]], [0.859, [0.044, 0.334, 0.624]], [0.861, [0.041, 0.33, 0.621]], [0.863, [0.041, 0.33, 0.621]], [0.865, [0.038, 0.326, 0.618]], [0.867, [0.038, 0.326, 0.618]], [0.869, [0.035, 0.322, 0.615]], [0.871, [0.035, 0.322, 0.615]], [0.873, [0.032, 0.318, 0.612]], [0.875, [0.032, 0.318, 0.612]], [0.877, [0.031, 0.314, 0.606]], [0.879, [0.031, 0.314, 0.606]], [0.881, [0.031, 0.31, 0.6]], [0.883, [0.031, 0.31, 0.6]], [0.885, [0.031, 0.306, 0.594]], [0.886, [0.031, 0.306, 0.594]], [0.888, [0.031, 0.302, 0.588]], [0.89, [0.031, 0.302, 0.588]], [0.892, [0.031, 0.298, 0.582]], [0.894, [0.031, 0.298, 0.582]], [0.896, [0.031, 0.294, 0.576]], [0.898, [0.031, 0.294, 0.576]], [0.9, [0.031, 0.29, 0.57]], [0.902, [0.031, 0.29, 0.57]], [0.904, [0.031, 0.286, 0.564]], [0.906, [0.031, 0.286, 0.564]], [0.908, [0.031, 0.282, 0.558]], [0.91, [0.031, 0.282, 0.558]], [0.912, [0.031, 0.278, 0.552]], [0.914, [0.031, 0.278, 0.552]], [0.916, [0.031, 0.273, 0.546]], [0.918, [0.031, 0.273, 0.546]], [0.92, [0.031, 0.269, 0.54]], [0.922, [0.031, 0.269, 0.54]], [0.924, [0.031, 0.265, 0.534]], [0.926, [0.031, 0.265, 0.534]], [0.928, [0.031, 0.261, 0.528]], [0.93, [0.031, 0.261, 0.528]], [0.932, [0.031, 0.257, 0.522]], [0.933, [0.031, 0.257, 0.522]], [0.935, [0.031, 0.253, 0.516]], [0.937, [0.031, 0.253, 0.516]], [0.939, [0.031, 0.249, 0.51]], [0.941, [0.031, 0.249, 0.51]], [0.943, [0.031, 0.245, 0.504]], [0.945, [0.031, 0.245, 0.504]], [0.947, [0.031, 0.241, 0.498]], [0.949, [0.031, 0.241, 0.498]], [0.951, [0.031, 0.237, 0.492]], [0.953, [0.031, 0.237, 0.492]], [0.955, [0.031, 0.233, 0.486]], [0.957, [0.031, 0.233, 0.486]], [0.959, [0.031, 0.229, 0.48]], [0.961, [0.031, 0.229, 0.48]], [0.963, [0.031, 0.225, 0.474]], [0.965, [0.031, 0.225, 0.474]], [0.967, [0.031, 0.221, 0.468]], [0.969, [0.031, 0.221, 0.468]], [0.971, [0.031, 0.217, 0.462]], [0.973, [0.031, 0.217, 0.462]], [0.975, [0.031, 0.213, 0.456]], [0.977, [0.031, 0.213, 0.456]], [0.978, [0.031, 0.209, 0.45]], [0.98, [0.031, 0.209, 0.45]], [0.982, [0.031, 0.204, 0.444]], [0.984, [0.031, 0.204, 0.444]], [0.986, [0.031, 0.2, 0.438]], [0.988, [0.031, 0.2, 0.438]], [0.99, [0.031, 0.196, 0.432]], [0.992, [0.031, 0.196, 0.432]], [0.994, [0.031, 0.192, 0.426]], [0.996, [0.031, 0.192, 0.426]], [0.998, [0.031, 0.188, 0.42]], [1.0, [0.031, 0.188, 0.42]]]
}), _defineProperty(_vislibColorMaps, ColorSchemas.Greens, {
  id: ColorSchemas.Greens,
  label: _i18n.i18n.translate('common.ui.vislib.colormaps.greensText', {
    defaultMessage: 'Greens'
  }),
  value: [[0.0, [0.969, 0.988, 0.961]], [0.002, [0.969, 0.988, 0.961]], [0.004, [0.966, 0.987, 0.958]], [0.006, [0.966, 0.987, 0.958]], [0.008, [0.964, 0.987, 0.956]], [0.01, [0.964, 0.987, 0.956]], [0.012, [0.962, 0.986, 0.953]], [0.014, [0.962, 0.986, 0.953]], [0.016, [0.96, 0.985, 0.95]], [0.018, [0.96, 0.985, 0.95]], [0.02, [0.958, 0.984, 0.948]], [0.022, [0.958, 0.984, 0.948]], [0.023, [0.955, 0.983, 0.945]], [0.025, [0.955, 0.983, 0.945]], [0.027, [0.953, 0.982, 0.943]], [0.029, [0.953, 0.982, 0.943]], [0.031, [0.951, 0.981, 0.94]], [0.033, [0.951, 0.981, 0.94]], [0.035, [0.949, 0.98, 0.938]], [0.037, [0.949, 0.98, 0.938]], [0.039, [0.946, 0.98, 0.935]], [0.041, [0.946, 0.98, 0.935]], [0.043, [0.944, 0.979, 0.932]], [0.045, [0.944, 0.979, 0.932]], [0.047, [0.942, 0.978, 0.93]], [0.049, [0.942, 0.978, 0.93]], [0.051, [0.94, 0.977, 0.927]], [0.053, [0.94, 0.977, 0.927]], [0.055, [0.938, 0.976, 0.925]], [0.057, [0.938, 0.976, 0.925]], [0.059, [0.935, 0.975, 0.922]], [0.061, [0.935, 0.975, 0.922]], [0.063, [0.933, 0.974, 0.919]], [0.065, [0.933, 0.974, 0.919]], [0.067, [0.931, 0.974, 0.917]], [0.068, [0.931, 0.974, 0.917]], [0.07, [0.929, 0.973, 0.914]], [0.072, [0.929, 0.973, 0.914]], [0.074, [0.927, 0.972, 0.912]], [0.076, [0.927, 0.972, 0.912]], [0.078, [0.924, 0.971, 0.909]], [0.08, [0.924, 0.971, 0.909]], [0.082, [0.922, 0.97, 0.907]], [0.084, [0.922, 0.97, 0.907]], [0.086, [0.92, 0.969, 0.904]], [0.088, [0.92, 0.969, 0.904]], [0.09, [0.918, 0.968, 0.901]], [0.092, [0.918, 0.968, 0.901]], [0.094, [0.915, 0.968, 0.899]], [0.096, [0.915, 0.968, 0.899]], [0.098, [0.913, 0.967, 0.896]], [0.1, [0.913, 0.967, 0.896]], [0.102, [0.911, 0.966, 0.894]], [0.104, [0.911, 0.966, 0.894]], [0.106, [0.909, 0.965, 0.891]], [0.108, [0.909, 0.965, 0.891]], [0.11, [0.907, 0.964, 0.888]], [0.112, [0.907, 0.964, 0.888]], [0.114, [0.904, 0.963, 0.886]], [0.115, [0.904, 0.963, 0.886]], [0.117, [0.902, 0.962, 0.883]], [0.119, [0.902, 0.962, 0.883]], [0.121, [0.9, 0.962, 0.881]], [0.123, [0.9, 0.962, 0.881]], [0.125, [0.898, 0.961, 0.878]], [0.127, [0.898, 0.961, 0.878]], [0.129, [0.894, 0.959, 0.874]], [0.131, [0.894, 0.959, 0.874]], [0.133, [0.89, 0.958, 0.87]], [0.135, [0.89, 0.958, 0.87]], [0.137, [0.887, 0.956, 0.866]], [0.139, [0.887, 0.956, 0.866]], [0.141, [0.883, 0.955, 0.862]], [0.143, [0.883, 0.955, 0.862]], [0.145, [0.879, 0.953, 0.858]], [0.147, [0.879, 0.953, 0.858]], [0.149, [0.875, 0.952, 0.854]], [0.151, [0.875, 0.952, 0.854]], [0.153, [0.872, 0.95, 0.85]], [0.155, [0.872, 0.95, 0.85]], [0.157, [0.868, 0.949, 0.846]], [0.159, [0.868, 0.949, 0.846]], [0.16, [0.864, 0.947, 0.843]], [0.162, [0.864, 0.947, 0.843]], [0.164, [0.861, 0.946, 0.839]], [0.166, [0.861, 0.946, 0.839]], [0.168, [0.857, 0.944, 0.835]], [0.17, [0.857, 0.944, 0.835]], [0.172, [0.853, 0.943, 0.831]], [0.174, [0.853, 0.943, 0.831]], [0.176, [0.85, 0.941, 0.827]], [0.178, [0.85, 0.941, 0.827]], [0.18, [0.846, 0.94, 0.823]], [0.182, [0.846, 0.94, 0.823]], [0.184, [0.842, 0.938, 0.819]], [0.186, [0.842, 0.938, 0.819]], [0.188, [0.839, 0.937, 0.815]], [0.19, [0.839, 0.937, 0.815]], [0.192, [0.835, 0.936, 0.811]], [0.194, [0.835, 0.936, 0.811]], [0.196, [0.831, 0.934, 0.807]], [0.198, [0.831, 0.934, 0.807]], [0.2, [0.827, 0.933, 0.803]], [0.202, [0.827, 0.933, 0.803]], [0.204, [0.824, 0.931, 0.799]], [0.205, [0.824, 0.931, 0.799]], [0.207, [0.82, 0.93, 0.795]], [0.209, [0.82, 0.93, 0.795]], [0.211, [0.816, 0.928, 0.791]], [0.213, [0.816, 0.928, 0.791]], [0.215, [0.813, 0.927, 0.787]], [0.217, [0.813, 0.927, 0.787]], [0.219, [0.809, 0.925, 0.783]], [0.221, [0.809, 0.925, 0.783]], [0.223, [0.805, 0.924, 0.78]], [0.225, [0.805, 0.924, 0.78]], [0.227, [0.802, 0.922, 0.776]], [0.229, [0.802, 0.922, 0.776]], [0.231, [0.798, 0.921, 0.772]], [0.233, [0.798, 0.921, 0.772]], [0.235, [0.794, 0.919, 0.768]], [0.237, [0.794, 0.919, 0.768]], [0.239, [0.791, 0.918, 0.764]], [0.241, [0.791, 0.918, 0.764]], [0.243, [0.787, 0.916, 0.76]], [0.245, [0.787, 0.916, 0.76]], [0.247, [0.783, 0.915, 0.756]], [0.249, [0.783, 0.915, 0.756]], [0.25, [0.779, 0.913, 0.752]], [0.252, [0.779, 0.913, 0.752]], [0.254, [0.775, 0.911, 0.747]], [0.256, [0.775, 0.911, 0.747]], [0.258, [0.77, 0.909, 0.743]], [0.26, [0.77, 0.909, 0.743]], [0.262, [0.765, 0.907, 0.738]], [0.264, [0.765, 0.907, 0.738]], [0.266, [0.761, 0.905, 0.734]], [0.268, [0.761, 0.905, 0.734]], [0.27, [0.756, 0.903, 0.729]], [0.272, [0.756, 0.903, 0.729]], [0.274, [0.751, 0.901, 0.724]], [0.276, [0.751, 0.901, 0.724]], [0.278, [0.746, 0.899, 0.72]], [0.28, [0.746, 0.899, 0.72]], [0.282, [0.742, 0.897, 0.715]], [0.284, [0.742, 0.897, 0.715]], [0.286, [0.737, 0.896, 0.711]], [0.288, [0.737, 0.896, 0.711]], [0.29, [0.732, 0.894, 0.706]], [0.292, [0.732, 0.894, 0.706]], [0.294, [0.728, 0.892, 0.702]], [0.295, [0.728, 0.892, 0.702]], [0.297, [0.723, 0.89, 0.697]], [0.299, [0.723, 0.89, 0.697]], [0.301, [0.718, 0.888, 0.693]], [0.303, [0.718, 0.888, 0.693]], [0.305, [0.714, 0.886, 0.688]], [0.307, [0.714, 0.886, 0.688]], [0.309, [0.709, 0.884, 0.684]], [0.311, [0.709, 0.884, 0.684]], [0.313, [0.704, 0.882, 0.679]], [0.315, [0.704, 0.882, 0.679]], [0.317, [0.7, 0.88, 0.674]], [0.319, [0.7, 0.88, 0.674]], [0.321, [0.695, 0.878, 0.67]], [0.323, [0.695, 0.878, 0.67]], [0.325, [0.69, 0.876, 0.665]], [0.327, [0.69, 0.876, 0.665]], [0.329, [0.686, 0.874, 0.661]], [0.331, [0.686, 0.874, 0.661]], [0.333, [0.681, 0.872, 0.656]], [0.335, [0.681, 0.872, 0.656]], [0.337, [0.676, 0.87, 0.652]], [0.339, [0.676, 0.87, 0.652]], [0.341, [0.672, 0.868, 0.647]], [0.342, [0.672, 0.868, 0.647]], [0.344, [0.667, 0.866, 0.643]], [0.346, [0.667, 0.866, 0.643]], [0.348, [0.662, 0.864, 0.638]], [0.35, [0.662, 0.864, 0.638]], [0.352, [0.658, 0.862, 0.633]], [0.354, [0.658, 0.862, 0.633]], [0.356, [0.653, 0.86, 0.629]], [0.358, [0.653, 0.86, 0.629]], [0.36, [0.648, 0.858, 0.624]], [0.362, [0.648, 0.858, 0.624]], [0.364, [0.644, 0.856, 0.62]], [0.366, [0.644, 0.856, 0.62]], [0.368, [0.639, 0.854, 0.615]], [0.37, [0.639, 0.854, 0.615]], [0.372, [0.634, 0.852, 0.611]], [0.374, [0.634, 0.852, 0.611]], [0.376, [0.629, 0.85, 0.606]], [0.378, [0.629, 0.85, 0.606]], [0.38, [0.624, 0.847, 0.602]], [0.382, [0.624, 0.847, 0.602]], [0.384, [0.618, 0.845, 0.597]], [0.386, [0.618, 0.845, 0.597]], [0.387, [0.613, 0.842, 0.592]], [0.389, [0.613, 0.842, 0.592]], [0.391, [0.607, 0.84, 0.588]], [0.393, [0.607, 0.84, 0.588]], [0.395, [0.602, 0.837, 0.583]], [0.397, [0.602, 0.837, 0.583]], [0.399, [0.596, 0.835, 0.579]], [0.401, [0.596, 0.835, 0.579]], [0.403, [0.591, 0.832, 0.574]], [0.405, [0.591, 0.832, 0.574]], [0.407, [0.585, 0.829, 0.57]], [0.409, [0.585, 0.829, 0.57]], [0.411, [0.579, 0.827, 0.565]], [0.413, [0.579, 0.827, 0.565]], [0.415, [0.574, 0.824, 0.561]], [0.417, [0.574, 0.824, 0.561]], [0.419, [0.568, 0.822, 0.556]], [0.421, [0.568, 0.822, 0.556]], [0.423, [0.563, 0.819, 0.552]], [0.425, [0.563, 0.819, 0.552]], [0.427, [0.557, 0.816, 0.547]], [0.429, [0.557, 0.816, 0.547]], [0.431, [0.552, 0.814, 0.542]], [0.432, [0.552, 0.814, 0.542]], [0.434, [0.546, 0.811, 0.538]], [0.436, [0.546, 0.811, 0.538]], [0.438, [0.541, 0.809, 0.533]], [0.44, [0.541, 0.809, 0.533]], [0.442, [0.535, 0.806, 0.529]], [0.444, [0.535, 0.806, 0.529]], [0.446, [0.53, 0.804, 0.524]], [0.448, [0.53, 0.804, 0.524]], [0.45, [0.524, 0.801, 0.52]], [0.452, [0.524, 0.801, 0.52]], [0.454, [0.519, 0.798, 0.515]], [0.456, [0.519, 0.798, 0.515]], [0.458, [0.513, 0.796, 0.511]], [0.46, [0.513, 0.796, 0.511]], [0.462, [0.507, 0.793, 0.506]], [0.464, [0.507, 0.793, 0.506]], [0.466, [0.502, 0.791, 0.501]], [0.468, [0.502, 0.791, 0.501]], [0.47, [0.496, 0.788, 0.497]], [0.472, [0.496, 0.788, 0.497]], [0.474, [0.491, 0.785, 0.492]], [0.476, [0.491, 0.785, 0.492]], [0.477, [0.485, 0.783, 0.488]], [0.479, [0.485, 0.783, 0.488]], [0.481, [0.48, 0.78, 0.483]], [0.483, [0.48, 0.78, 0.483]], [0.485, [0.474, 0.778, 0.479]], [0.487, [0.474, 0.778, 0.479]], [0.489, [0.469, 0.775, 0.474]], [0.491, [0.469, 0.775, 0.474]], [0.493, [0.463, 0.773, 0.47]], [0.495, [0.463, 0.773, 0.47]], [0.497, [0.458, 0.77, 0.465]], [0.499, [0.458, 0.77, 0.465]], [0.501, [0.452, 0.767, 0.461]], [0.503, [0.452, 0.767, 0.461]], [0.505, [0.445, 0.764, 0.458]], [0.507, [0.445, 0.764, 0.458]], [0.509, [0.439, 0.761, 0.455]], [0.511, [0.439, 0.761, 0.455]], [0.513, [0.433, 0.758, 0.452]], [0.515, [0.433, 0.758, 0.452]], [0.517, [0.427, 0.755, 0.449]], [0.519, [0.427, 0.755, 0.449]], [0.521, [0.42, 0.752, 0.446]], [0.523, [0.42, 0.752, 0.446]], [0.524, [0.414, 0.749, 0.443]], [0.526, [0.414, 0.749, 0.443]], [0.528, [0.408, 0.746, 0.44]], [0.53, [0.408, 0.746, 0.44]], [0.532, [0.402, 0.742, 0.437]], [0.534, [0.402, 0.742, 0.437]], [0.536, [0.395, 0.739, 0.434]], [0.538, [0.395, 0.739, 0.434]], [0.54, [0.389, 0.736, 0.43]], [0.542, [0.389, 0.736, 0.43]], [0.544, [0.383, 0.733, 0.427]], [0.546, [0.383, 0.733, 0.427]], [0.548, [0.376, 0.73, 0.424]], [0.55, [0.376, 0.73, 0.424]], [0.552, [0.37, 0.727, 0.421]], [0.554, [0.37, 0.727, 0.421]], [0.556, [0.364, 0.724, 0.418]], [0.558, [0.364, 0.724, 0.418]], [0.56, [0.358, 0.721, 0.415]], [0.562, [0.358, 0.721, 0.415]], [0.564, [0.351, 0.718, 0.412]], [0.566, [0.351, 0.718, 0.412]], [0.568, [0.345, 0.715, 0.409]], [0.569, [0.345, 0.715, 0.409]], [0.571, [0.339, 0.712, 0.406]], [0.573, [0.339, 0.712, 0.406]], [0.575, [0.333, 0.709, 0.403]], [0.577, [0.333, 0.709, 0.403]], [0.579, [0.326, 0.706, 0.4]], [0.581, [0.326, 0.706, 0.4]], [0.583, [0.32, 0.702, 0.397]], [0.585, [0.32, 0.702, 0.397]], [0.587, [0.314, 0.699, 0.394]], [0.589, [0.314, 0.699, 0.394]], [0.591, [0.307, 0.696, 0.39]], [0.593, [0.307, 0.696, 0.39]], [0.595, [0.301, 0.693, 0.387]], [0.597, [0.301, 0.693, 0.387]], [0.599, [0.295, 0.69, 0.384]], [0.601, [0.295, 0.69, 0.384]], [0.603, [0.289, 0.687, 0.381]], [0.605, [0.289, 0.687, 0.381]], [0.607, [0.282, 0.684, 0.378]], [0.609, [0.282, 0.684, 0.378]], [0.611, [0.276, 0.681, 0.375]], [0.613, [0.276, 0.681, 0.375]], [0.614, [0.27, 0.678, 0.372]], [0.616, [0.27, 0.678, 0.372]], [0.618, [0.264, 0.675, 0.369]], [0.62, [0.264, 0.675, 0.369]], [0.622, [0.257, 0.672, 0.366]], [0.624, [0.257, 0.672, 0.366]], [0.626, [0.253, 0.668, 0.363]], [0.628, [0.253, 0.668, 0.363]], [0.63, [0.249, 0.664, 0.36]], [0.632, [0.249, 0.664, 0.36]], [0.634, [0.245, 0.66, 0.357]], [0.636, [0.245, 0.66, 0.357]], [0.638, [0.242, 0.656, 0.354]], [0.64, [0.242, 0.656, 0.354]], [0.642, [0.238, 0.652, 0.351]], [0.644, [0.238, 0.652, 0.351]], [0.646, [0.234, 0.648, 0.348]], [0.648, [0.234, 0.648, 0.348]], [0.65, [0.23, 0.645, 0.345]], [0.652, [0.23, 0.645, 0.345]], [0.654, [0.227, 0.641, 0.342]], [0.656, [0.227, 0.641, 0.342]], [0.658, [0.223, 0.637, 0.339]], [0.659, [0.223, 0.637, 0.339]], [0.661, [0.219, 0.633, 0.336]], [0.663, [0.219, 0.633, 0.336]], [0.665, [0.216, 0.629, 0.333]], [0.667, [0.216, 0.629, 0.333]], [0.669, [0.212, 0.625, 0.33]], [0.671, [0.212, 0.625, 0.33]], [0.673, [0.208, 0.621, 0.327]], [0.675, [0.208, 0.621, 0.327]], [0.677, [0.205, 0.617, 0.324]], [0.679, [0.205, 0.617, 0.324]], [0.681, [0.201, 0.613, 0.322]], [0.683, [0.201, 0.613, 0.322]], [0.685, [0.197, 0.609, 0.319]], [0.687, [0.197, 0.609, 0.319]], [0.689, [0.194, 0.605, 0.316]], [0.691, [0.194, 0.605, 0.316]], [0.693, [0.19, 0.601, 0.313]], [0.695, [0.19, 0.601, 0.313]], [0.697, [0.186, 0.597, 0.31]], [0.699, [0.186, 0.597, 0.31]], [0.701, [0.182, 0.593, 0.307]], [0.703, [0.182, 0.593, 0.307]], [0.705, [0.179, 0.589, 0.304]], [0.706, [0.179, 0.589, 0.304]], [0.708, [0.175, 0.585, 0.301]], [0.71, [0.175, 0.585, 0.301]], [0.712, [0.171, 0.582, 0.298]], [0.714, [0.171, 0.582, 0.298]], [0.716, [0.168, 0.578, 0.295]], [0.718, [0.168, 0.578, 0.295]], [0.72, [0.164, 0.574, 0.292]], [0.722, [0.164, 0.574, 0.292]], [0.724, [0.16, 0.57, 0.289]], [0.726, [0.16, 0.57, 0.289]], [0.728, [0.157, 0.566, 0.286]], [0.73, [0.157, 0.566, 0.286]], [0.732, [0.153, 0.562, 0.283]], [0.734, [0.153, 0.562, 0.283]], [0.736, [0.149, 0.558, 0.28]], [0.738, [0.149, 0.558, 0.28]], [0.74, [0.146, 0.554, 0.277]], [0.742, [0.146, 0.554, 0.277]], [0.744, [0.142, 0.55, 0.274]], [0.746, [0.142, 0.55, 0.274]], [0.748, [0.138, 0.546, 0.271]], [0.75, [0.138, 0.546, 0.271]], [0.751, [0.134, 0.542, 0.268]], [0.753, [0.134, 0.542, 0.268]], [0.755, [0.13, 0.539, 0.265]], [0.757, [0.13, 0.539, 0.265]], [0.759, [0.125, 0.535, 0.262]], [0.761, [0.125, 0.535, 0.262]], [0.763, [0.121, 0.531, 0.259]], [0.765, [0.121, 0.531, 0.259]], [0.767, [0.117, 0.528, 0.256]], [0.769, [0.117, 0.528, 0.256]], [0.771, [0.112, 0.524, 0.253]], [0.773, [0.112, 0.524, 0.253]], [0.775, [0.108, 0.52, 0.25]], [0.777, [0.108, 0.52, 0.25]], [0.779, [0.104, 0.516, 0.247]], [0.781, [0.104, 0.516, 0.247]], [0.783, [0.1, 0.513, 0.244]], [0.785, [0.1, 0.513, 0.244]], [0.787, [0.095, 0.509, 0.241]], [0.789, [0.095, 0.509, 0.241]], [0.791, [0.091, 0.505, 0.238]], [0.793, [0.091, 0.505, 0.238]], [0.795, [0.087, 0.502, 0.234]], [0.796, [0.087, 0.502, 0.234]], [0.798, [0.082, 0.498, 0.231]], [0.8, [0.082, 0.498, 0.231]], [0.802, [0.078, 0.494, 0.228]], [0.804, [0.078, 0.494, 0.228]], [0.806, [0.074, 0.491, 0.225]], [0.808, [0.074, 0.491, 0.225]], [0.81, [0.069, 0.487, 0.222]], [0.812, [0.069, 0.487, 0.222]], [0.814, [0.065, 0.483, 0.219]], [0.816, [0.065, 0.483, 0.219]], [0.818, [0.061, 0.48, 0.216]], [0.82, [0.061, 0.48, 0.216]], [0.822, [0.057, 0.476, 0.213]], [0.824, [0.057, 0.476, 0.213]], [0.826, [0.052, 0.472, 0.21]], [0.828, [0.052, 0.472, 0.21]], [0.83, [0.048, 0.469, 0.207]], [0.832, [0.048, 0.469, 0.207]], [0.834, [0.044, 0.465, 0.204]], [0.836, [0.044, 0.465, 0.204]], [0.838, [0.039, 0.461, 0.201]], [0.84, [0.039, 0.461, 0.201]], [0.841, [0.035, 0.457, 0.198]], [0.843, [0.035, 0.457, 0.198]], [0.845, [0.031, 0.454, 0.194]], [0.847, [0.031, 0.454, 0.194]], [0.849, [0.026, 0.45, 0.191]], [0.851, [0.026, 0.45, 0.191]], [0.853, [0.022, 0.446, 0.188]], [0.855, [0.022, 0.446, 0.188]], [0.857, [0.018, 0.443, 0.185]], [0.859, [0.018, 0.443, 0.185]], [0.861, [0.013, 0.439, 0.182]], [0.863, [0.013, 0.439, 0.182]], [0.865, [0.009, 0.435, 0.179]], [0.867, [0.009, 0.435, 0.179]], [0.869, [0.005, 0.432, 0.176]], [0.871, [0.005, 0.432, 0.176]], [0.873, [0.001, 0.428, 0.173]], [0.875, [0.001, 0.428, 0.173]], [0.877, [0.0, 0.423, 0.171]], [0.879, [0.0, 0.423, 0.171]], [0.881, [0.0, 0.418, 0.169]], [0.883, [0.0, 0.418, 0.169]], [0.885, [0.0, 0.413, 0.167]], [0.886, [0.0, 0.413, 0.167]], [0.888, [0.0, 0.408, 0.164]], [0.89, [0.0, 0.408, 0.164]], [0.892, [0.0, 0.403, 0.162]], [0.894, [0.0, 0.403, 0.162]], [0.896, [0.0, 0.398, 0.16]], [0.898, [0.0, 0.398, 0.16]], [0.9, [0.0, 0.393, 0.158]], [0.902, [0.0, 0.393, 0.158]], [0.904, [0.0, 0.388, 0.156]], [0.906, [0.0, 0.388, 0.156]], [0.908, [0.0, 0.383, 0.154]], [0.91, [0.0, 0.383, 0.154]], [0.912, [0.0, 0.378, 0.152]], [0.914, [0.0, 0.378, 0.152]], [0.916, [0.0, 0.373, 0.15]], [0.918, [0.0, 0.373, 0.15]], [0.92, [0.0, 0.368, 0.148]], [0.922, [0.0, 0.368, 0.148]], [0.924, [0.0, 0.363, 0.146]], [0.926, [0.0, 0.363, 0.146]], [0.928, [0.0, 0.357, 0.144]], [0.93, [0.0, 0.357, 0.144]], [0.932, [0.0, 0.352, 0.141]], [0.933, [0.0, 0.352, 0.141]], [0.935, [0.0, 0.347, 0.139]], [0.937, [0.0, 0.347, 0.139]], [0.939, [0.0, 0.342, 0.137]], [0.941, [0.0, 0.342, 0.137]], [0.943, [0.0, 0.337, 0.135]], [0.945, [0.0, 0.337, 0.135]], [0.947, [0.0, 0.332, 0.133]], [0.949, [0.0, 0.332, 0.133]], [0.951, [0.0, 0.327, 0.131]], [0.953, [0.0, 0.327, 0.131]], [0.955, [0.0, 0.322, 0.129]], [0.957, [0.0, 0.322, 0.129]], [0.959, [0.0, 0.317, 0.127]], [0.961, [0.0, 0.317, 0.127]], [0.963, [0.0, 0.312, 0.125]], [0.965, [0.0, 0.312, 0.125]], [0.967, [0.0, 0.307, 0.123]], [0.969, [0.0, 0.307, 0.123]], [0.971, [0.0, 0.302, 0.121]], [0.973, [0.0, 0.302, 0.121]], [0.975, [0.0, 0.297, 0.118]], [0.977, [0.0, 0.297, 0.118]], [0.978, [0.0, 0.292, 0.116]], [0.98, [0.0, 0.292, 0.116]], [0.982, [0.0, 0.287, 0.114]], [0.984, [0.0, 0.287, 0.114]], [0.986, [0.0, 0.282, 0.112]], [0.988, [0.0, 0.282, 0.112]], [0.99, [0.0, 0.277, 0.11]], [0.992, [0.0, 0.277, 0.11]], [0.994, [0.0, 0.272, 0.108]], [0.996, [0.0, 0.272, 0.108]], [0.998, [0.0, 0.267, 0.106]], [1.0, [0.0, 0.267, 0.106]]]
}), _defineProperty(_vislibColorMaps, ColorSchemas.Greys, {
  id: ColorSchemas.Greys,
  label: _i18n.i18n.translate('common.ui.vislib.colormaps.greysText', {
    defaultMessage: 'Greys'
  }),
  value: [[0.0, [1.0, 1.0, 1.0]], [0.002, [1.0, 1.0, 1.0]], [0.004, [0.998, 0.998, 0.998]], [0.006, [0.998, 0.998, 0.998]], [0.008, [0.996, 0.996, 0.996]], [0.01, [0.996, 0.996, 0.996]], [0.012, [0.994, 0.994, 0.994]], [0.014, [0.994, 0.994, 0.994]], [0.016, [0.993, 0.993, 0.993]], [0.018, [0.993, 0.993, 0.993]], [0.02, [0.991, 0.991, 0.991]], [0.022, [0.991, 0.991, 0.991]], [0.023, [0.989, 0.989, 0.989]], [0.025, [0.989, 0.989, 0.989]], [0.027, [0.987, 0.987, 0.987]], [0.029, [0.987, 0.987, 0.987]], [0.031, [0.985, 0.985, 0.985]], [0.033, [0.985, 0.985, 0.985]], [0.035, [0.983, 0.983, 0.983]], [0.037, [0.983, 0.983, 0.983]], [0.039, [0.982, 0.982, 0.982]], [0.041, [0.982, 0.982, 0.982]], [0.043, [0.98, 0.98, 0.98]], [0.045, [0.98, 0.98, 0.98]], [0.047, [0.978, 0.978, 0.978]], [0.049, [0.978, 0.978, 0.978]], [0.051, [0.976, 0.976, 0.976]], [0.053, [0.976, 0.976, 0.976]], [0.055, [0.974, 0.974, 0.974]], [0.057, [0.974, 0.974, 0.974]], [0.059, [0.972, 0.972, 0.972]], [0.061, [0.972, 0.972, 0.972]], [0.063, [0.97, 0.97, 0.97]], [0.065, [0.97, 0.97, 0.97]], [0.067, [0.969, 0.969, 0.969]], [0.068, [0.969, 0.969, 0.969]], [0.07, [0.967, 0.967, 0.967]], [0.072, [0.967, 0.967, 0.967]], [0.074, [0.965, 0.965, 0.965]], [0.076, [0.965, 0.965, 0.965]], [0.078, [0.963, 0.963, 0.963]], [0.08, [0.963, 0.963, 0.963]], [0.082, [0.961, 0.961, 0.961]], [0.084, [0.961, 0.961, 0.961]], [0.086, [0.959, 0.959, 0.959]], [0.088, [0.959, 0.959, 0.959]], [0.09, [0.958, 0.958, 0.958]], [0.092, [0.958, 0.958, 0.958]], [0.094, [0.956, 0.956, 0.956]], [0.096, [0.956, 0.956, 0.956]], [0.098, [0.954, 0.954, 0.954]], [0.1, [0.954, 0.954, 0.954]], [0.102, [0.952, 0.952, 0.952]], [0.104, [0.952, 0.952, 0.952]], [0.106, [0.95, 0.95, 0.95]], [0.108, [0.95, 0.95, 0.95]], [0.11, [0.948, 0.948, 0.948]], [0.112, [0.948, 0.948, 0.948]], [0.114, [0.946, 0.946, 0.946]], [0.115, [0.946, 0.946, 0.946]], [0.117, [0.945, 0.945, 0.945]], [0.119, [0.945, 0.945, 0.945]], [0.121, [0.943, 0.943, 0.943]], [0.123, [0.943, 0.943, 0.943]], [0.125, [0.941, 0.941, 0.941]], [0.127, [0.941, 0.941, 0.941]], [0.129, [0.938, 0.938, 0.938]], [0.131, [0.938, 0.938, 0.938]], [0.133, [0.935, 0.935, 0.935]], [0.135, [0.935, 0.935, 0.935]], [0.137, [0.932, 0.932, 0.932]], [0.139, [0.932, 0.932, 0.932]], [0.141, [0.93, 0.93, 0.93]], [0.143, [0.93, 0.93, 0.93]], [0.145, [0.927, 0.927, 0.927]], [0.147, [0.927, 0.927, 0.927]], [0.149, [0.924, 0.924, 0.924]], [0.151, [0.924, 0.924, 0.924]], [0.153, [0.921, 0.921, 0.921]], [0.155, [0.921, 0.921, 0.921]], [0.157, [0.918, 0.918, 0.918]], [0.159, [0.918, 0.918, 0.918]], [0.16, [0.915, 0.915, 0.915]], [0.162, [0.915, 0.915, 0.915]], [0.164, [0.913, 0.913, 0.913]], [0.166, [0.913, 0.913, 0.913]], [0.168, [0.91, 0.91, 0.91]], [0.17, [0.91, 0.91, 0.91]], [0.172, [0.907, 0.907, 0.907]], [0.174, [0.907, 0.907, 0.907]], [0.176, [0.904, 0.904, 0.904]], [0.178, [0.904, 0.904, 0.904]], [0.18, [0.901, 0.901, 0.901]], [0.182, [0.901, 0.901, 0.901]], [0.184, [0.898, 0.898, 0.898]], [0.186, [0.898, 0.898, 0.898]], [0.188, [0.896, 0.896, 0.896]], [0.19, [0.896, 0.896, 0.896]], [0.192, [0.893, 0.893, 0.893]], [0.194, [0.893, 0.893, 0.893]], [0.196, [0.89, 0.89, 0.89]], [0.198, [0.89, 0.89, 0.89]], [0.2, [0.887, 0.887, 0.887]], [0.202, [0.887, 0.887, 0.887]], [0.204, [0.884, 0.884, 0.884]], [0.205, [0.884, 0.884, 0.884]], [0.207, [0.881, 0.881, 0.881]], [0.209, [0.881, 0.881, 0.881]], [0.211, [0.879, 0.879, 0.879]], [0.213, [0.879, 0.879, 0.879]], [0.215, [0.876, 0.876, 0.876]], [0.217, [0.876, 0.876, 0.876]], [0.219, [0.873, 0.873, 0.873]], [0.221, [0.873, 0.873, 0.873]], [0.223, [0.87, 0.87, 0.87]], [0.225, [0.87, 0.87, 0.87]], [0.227, [0.867, 0.867, 0.867]], [0.229, [0.867, 0.867, 0.867]], [0.231, [0.864, 0.864, 0.864]], [0.233, [0.864, 0.864, 0.864]], [0.235, [0.862, 0.862, 0.862]], [0.237, [0.862, 0.862, 0.862]], [0.239, [0.859, 0.859, 0.859]], [0.241, [0.859, 0.859, 0.859]], [0.243, [0.856, 0.856, 0.856]], [0.245, [0.856, 0.856, 0.856]], [0.247, [0.853, 0.853, 0.853]], [0.249, [0.853, 0.853, 0.853]], [0.25, [0.85, 0.85, 0.85]], [0.252, [0.85, 0.85, 0.85]], [0.254, [0.847, 0.847, 0.847]], [0.256, [0.847, 0.847, 0.847]], [0.258, [0.843, 0.843, 0.843]], [0.26, [0.843, 0.843, 0.843]], [0.262, [0.84, 0.84, 0.84]], [0.264, [0.84, 0.84, 0.84]], [0.266, [0.836, 0.836, 0.836]], [0.268, [0.836, 0.836, 0.836]], [0.27, [0.833, 0.833, 0.833]], [0.272, [0.833, 0.833, 0.833]], [0.274, [0.829, 0.829, 0.829]], [0.276, [0.829, 0.829, 0.829]], [0.278, [0.826, 0.826, 0.826]], [0.28, [0.826, 0.826, 0.826]], [0.282, [0.823, 0.823, 0.823]], [0.284, [0.823, 0.823, 0.823]], [0.286, [0.819, 0.819, 0.819]], [0.288, [0.819, 0.819, 0.819]], [0.29, [0.816, 0.816, 0.816]], [0.292, [0.816, 0.816, 0.816]], [0.294, [0.812, 0.812, 0.812]], [0.295, [0.812, 0.812, 0.812]], [0.297, [0.809, 0.809, 0.809]], [0.299, [0.809, 0.809, 0.809]], [0.301, [0.805, 0.805, 0.805]], [0.303, [0.805, 0.805, 0.805]], [0.305, [0.802, 0.802, 0.802]], [0.307, [0.802, 0.802, 0.802]], [0.309, [0.798, 0.798, 0.798]], [0.311, [0.798, 0.798, 0.798]], [0.313, [0.795, 0.795, 0.795]], [0.315, [0.795, 0.795, 0.795]], [0.317, [0.792, 0.792, 0.792]], [0.319, [0.792, 0.792, 0.792]], [0.321, [0.788, 0.788, 0.788]], [0.323, [0.788, 0.788, 0.788]], [0.325, [0.785, 0.785, 0.785]], [0.327, [0.785, 0.785, 0.785]], [0.329, [0.781, 0.781, 0.781]], [0.331, [0.781, 0.781, 0.781]], [0.333, [0.778, 0.778, 0.778]], [0.335, [0.778, 0.778, 0.778]], [0.337, [0.774, 0.774, 0.774]], [0.339, [0.774, 0.774, 0.774]], [0.341, [0.771, 0.771, 0.771]], [0.342, [0.771, 0.771, 0.771]], [0.344, [0.767, 0.767, 0.767]], [0.346, [0.767, 0.767, 0.767]], [0.348, [0.764, 0.764, 0.764]], [0.35, [0.764, 0.764, 0.764]], [0.352, [0.761, 0.761, 0.761]], [0.354, [0.761, 0.761, 0.761]], [0.356, [0.757, 0.757, 0.757]], [0.358, [0.757, 0.757, 0.757]], [0.36, [0.754, 0.754, 0.754]], [0.362, [0.754, 0.754, 0.754]], [0.364, [0.75, 0.75, 0.75]], [0.366, [0.75, 0.75, 0.75]], [0.368, [0.747, 0.747, 0.747]], [0.37, [0.747, 0.747, 0.747]], [0.372, [0.743, 0.743, 0.743]], [0.374, [0.743, 0.743, 0.743]], [0.376, [0.739, 0.739, 0.739]], [0.378, [0.739, 0.739, 0.739]], [0.38, [0.735, 0.735, 0.735]], [0.382, [0.735, 0.735, 0.735]], [0.384, [0.73, 0.73, 0.73]], [0.386, [0.73, 0.73, 0.73]], [0.387, [0.725, 0.725, 0.725]], [0.389, [0.725, 0.725, 0.725]], [0.391, [0.72, 0.72, 0.72]], [0.393, [0.72, 0.72, 0.72]], [0.395, [0.715, 0.715, 0.715]], [0.397, [0.715, 0.715, 0.715]], [0.399, [0.711, 0.711, 0.711]], [0.401, [0.711, 0.711, 0.711]], [0.403, [0.706, 0.706, 0.706]], [0.405, [0.706, 0.706, 0.706]], [0.407, [0.701, 0.701, 0.701]], [0.409, [0.701, 0.701, 0.701]], [0.411, [0.696, 0.696, 0.696]], [0.413, [0.696, 0.696, 0.696]], [0.415, [0.691, 0.691, 0.691]], [0.417, [0.691, 0.691, 0.691]], [0.419, [0.687, 0.687, 0.687]], [0.421, [0.687, 0.687, 0.687]], [0.423, [0.682, 0.682, 0.682]], [0.425, [0.682, 0.682, 0.682]], [0.427, [0.677, 0.677, 0.677]], [0.429, [0.677, 0.677, 0.677]], [0.431, [0.672, 0.672, 0.672]], [0.432, [0.672, 0.672, 0.672]], [0.434, [0.667, 0.667, 0.667]], [0.436, [0.667, 0.667, 0.667]], [0.438, [0.663, 0.663, 0.663]], [0.44, [0.663, 0.663, 0.663]], [0.442, [0.658, 0.658, 0.658]], [0.444, [0.658, 0.658, 0.658]], [0.446, [0.653, 0.653, 0.653]], [0.448, [0.653, 0.653, 0.653]], [0.45, [0.648, 0.648, 0.648]], [0.452, [0.648, 0.648, 0.648]], [0.454, [0.643, 0.643, 0.643]], [0.456, [0.643, 0.643, 0.643]], [0.458, [0.639, 0.639, 0.639]], [0.46, [0.639, 0.639, 0.639]], [0.462, [0.634, 0.634, 0.634]], [0.464, [0.634, 0.634, 0.634]], [0.466, [0.629, 0.629, 0.629]], [0.468, [0.629, 0.629, 0.629]], [0.47, [0.624, 0.624, 0.624]], [0.472, [0.624, 0.624, 0.624]], [0.474, [0.619, 0.619, 0.619]], [0.476, [0.619, 0.619, 0.619]], [0.477, [0.615, 0.615, 0.615]], [0.479, [0.615, 0.615, 0.615]], [0.481, [0.61, 0.61, 0.61]], [0.483, [0.61, 0.61, 0.61]], [0.485, [0.605, 0.605, 0.605]], [0.487, [0.605, 0.605, 0.605]], [0.489, [0.6, 0.6, 0.6]], [0.491, [0.6, 0.6, 0.6]], [0.493, [0.595, 0.595, 0.595]], [0.495, [0.595, 0.595, 0.595]], [0.497, [0.591, 0.591, 0.591]], [0.499, [0.591, 0.591, 0.591]], [0.501, [0.586, 0.586, 0.586]], [0.503, [0.586, 0.586, 0.586]], [0.505, [0.582, 0.582, 0.582]], [0.507, [0.582, 0.582, 0.582]], [0.509, [0.577, 0.577, 0.577]], [0.511, [0.577, 0.577, 0.577]], [0.513, [0.573, 0.573, 0.573]], [0.515, [0.573, 0.573, 0.573]], [0.517, [0.569, 0.569, 0.569]], [0.519, [0.569, 0.569, 0.569]], [0.521, [0.565, 0.565, 0.565]], [0.523, [0.565, 0.565, 0.565]], [0.524, [0.56, 0.56, 0.56]], [0.526, [0.56, 0.56, 0.56]], [0.528, [0.556, 0.556, 0.556]], [0.53, [0.556, 0.556, 0.556]], [0.532, [0.552, 0.552, 0.552]], [0.534, [0.552, 0.552, 0.552]], [0.536, [0.547, 0.547, 0.547]], [0.538, [0.547, 0.547, 0.547]], [0.54, [0.543, 0.543, 0.543]], [0.542, [0.543, 0.543, 0.543]], [0.544, [0.539, 0.539, 0.539]], [0.546, [0.539, 0.539, 0.539]], [0.548, [0.534, 0.534, 0.534]], [0.55, [0.534, 0.534, 0.534]], [0.552, [0.53, 0.53, 0.53]], [0.554, [0.53, 0.53, 0.53]], [0.556, [0.526, 0.526, 0.526]], [0.558, [0.526, 0.526, 0.526]], [0.56, [0.521, 0.521, 0.521]], [0.562, [0.521, 0.521, 0.521]], [0.564, [0.517, 0.517, 0.517]], [0.566, [0.517, 0.517, 0.517]], [0.568, [0.513, 0.513, 0.513]], [0.569, [0.513, 0.513, 0.513]], [0.571, [0.509, 0.509, 0.509]], [0.573, [0.509, 0.509, 0.509]], [0.575, [0.504, 0.504, 0.504]], [0.577, [0.504, 0.504, 0.504]], [0.579, [0.5, 0.5, 0.5]], [0.581, [0.5, 0.5, 0.5]], [0.583, [0.496, 0.496, 0.496]], [0.585, [0.496, 0.496, 0.496]], [0.587, [0.491, 0.491, 0.491]], [0.589, [0.491, 0.491, 0.491]], [0.591, [0.487, 0.487, 0.487]], [0.593, [0.487, 0.487, 0.487]], [0.595, [0.483, 0.483, 0.483]], [0.597, [0.483, 0.483, 0.483]], [0.599, [0.478, 0.478, 0.478]], [0.601, [0.478, 0.478, 0.478]], [0.603, [0.474, 0.474, 0.474]], [0.605, [0.474, 0.474, 0.474]], [0.607, [0.47, 0.47, 0.47]], [0.609, [0.47, 0.47, 0.47]], [0.611, [0.466, 0.466, 0.466]], [0.613, [0.466, 0.466, 0.466]], [0.614, [0.461, 0.461, 0.461]], [0.616, [0.461, 0.461, 0.461]], [0.618, [0.457, 0.457, 0.457]], [0.62, [0.457, 0.457, 0.457]], [0.622, [0.453, 0.453, 0.453]], [0.624, [0.453, 0.453, 0.453]], [0.626, [0.448, 0.448, 0.448]], [0.628, [0.448, 0.448, 0.448]], [0.63, [0.444, 0.444, 0.444]], [0.632, [0.444, 0.444, 0.444]], [0.634, [0.44, 0.44, 0.44]], [0.636, [0.44, 0.44, 0.44]], [0.638, [0.436, 0.436, 0.436]], [0.64, [0.436, 0.436, 0.436]], [0.642, [0.432, 0.432, 0.432]], [0.644, [0.432, 0.432, 0.432]], [0.646, [0.428, 0.428, 0.428]], [0.648, [0.428, 0.428, 0.428]], [0.65, [0.424, 0.424, 0.424]], [0.652, [0.424, 0.424, 0.424]], [0.654, [0.42, 0.42, 0.42]], [0.656, [0.42, 0.42, 0.42]], [0.658, [0.416, 0.416, 0.416]], [0.659, [0.416, 0.416, 0.416]], [0.661, [0.412, 0.412, 0.412]], [0.663, [0.412, 0.412, 0.412]], [0.665, [0.408, 0.408, 0.408]], [0.667, [0.408, 0.408, 0.408]], [0.669, [0.404, 0.404, 0.404]], [0.671, [0.404, 0.404, 0.404]], [0.673, [0.4, 0.4, 0.4]], [0.675, [0.4, 0.4, 0.4]], [0.677, [0.396, 0.396, 0.396]], [0.679, [0.396, 0.396, 0.396]], [0.681, [0.392, 0.392, 0.392]], [0.683, [0.392, 0.392, 0.392]], [0.685, [0.388, 0.388, 0.388]], [0.687, [0.388, 0.388, 0.388]], [0.689, [0.383, 0.383, 0.383]], [0.691, [0.383, 0.383, 0.383]], [0.693, [0.379, 0.379, 0.379]], [0.695, [0.379, 0.379, 0.379]], [0.697, [0.375, 0.375, 0.375]], [0.699, [0.375, 0.375, 0.375]], [0.701, [0.371, 0.371, 0.371]], [0.703, [0.371, 0.371, 0.371]], [0.705, [0.367, 0.367, 0.367]], [0.706, [0.367, 0.367, 0.367]], [0.708, [0.363, 0.363, 0.363]], [0.71, [0.363, 0.363, 0.363]], [0.712, [0.359, 0.359, 0.359]], [0.714, [0.359, 0.359, 0.359]], [0.716, [0.355, 0.355, 0.355]], [0.718, [0.355, 0.355, 0.355]], [0.72, [0.351, 0.351, 0.351]], [0.722, [0.351, 0.351, 0.351]], [0.724, [0.347, 0.347, 0.347]], [0.726, [0.347, 0.347, 0.347]], [0.728, [0.343, 0.343, 0.343]], [0.73, [0.343, 0.343, 0.343]], [0.732, [0.339, 0.339, 0.339]], [0.734, [0.339, 0.339, 0.339]], [0.736, [0.335, 0.335, 0.335]], [0.738, [0.335, 0.335, 0.335]], [0.74, [0.331, 0.331, 0.331]], [0.742, [0.331, 0.331, 0.331]], [0.744, [0.327, 0.327, 0.327]], [0.746, [0.327, 0.327, 0.327]], [0.748, [0.323, 0.323, 0.323]], [0.75, [0.323, 0.323, 0.323]], [0.751, [0.317, 0.317, 0.317]], [0.753, [0.317, 0.317, 0.317]], [0.755, [0.312, 0.312, 0.312]], [0.757, [0.312, 0.312, 0.312]], [0.759, [0.306, 0.306, 0.306]], [0.761, [0.306, 0.306, 0.306]], [0.763, [0.301, 0.301, 0.301]], [0.765, [0.301, 0.301, 0.301]], [0.767, [0.295, 0.295, 0.295]], [0.769, [0.295, 0.295, 0.295]], [0.771, [0.29, 0.29, 0.29]], [0.773, [0.29, 0.29, 0.29]], [0.775, [0.284, 0.284, 0.284]], [0.777, [0.284, 0.284, 0.284]], [0.779, [0.279, 0.279, 0.279]], [0.781, [0.279, 0.279, 0.279]], [0.783, [0.273, 0.273, 0.273]], [0.785, [0.273, 0.273, 0.273]], [0.787, [0.268, 0.268, 0.268]], [0.789, [0.268, 0.268, 0.268]], [0.791, [0.262, 0.262, 0.262]], [0.793, [0.262, 0.262, 0.262]], [0.795, [0.257, 0.257, 0.257]], [0.796, [0.257, 0.257, 0.257]], [0.798, [0.251, 0.251, 0.251]], [0.8, [0.251, 0.251, 0.251]], [0.802, [0.245, 0.245, 0.245]], [0.804, [0.245, 0.245, 0.245]], [0.806, [0.24, 0.24, 0.24]], [0.808, [0.24, 0.24, 0.24]], [0.81, [0.234, 0.234, 0.234]], [0.812, [0.234, 0.234, 0.234]], [0.814, [0.229, 0.229, 0.229]], [0.816, [0.229, 0.229, 0.229]], [0.818, [0.223, 0.223, 0.223]], [0.82, [0.223, 0.223, 0.223]], [0.822, [0.218, 0.218, 0.218]], [0.824, [0.218, 0.218, 0.218]], [0.826, [0.212, 0.212, 0.212]], [0.828, [0.212, 0.212, 0.212]], [0.83, [0.207, 0.207, 0.207]], [0.832, [0.207, 0.207, 0.207]], [0.834, [0.201, 0.201, 0.201]], [0.836, [0.201, 0.201, 0.201]], [0.838, [0.196, 0.196, 0.196]], [0.84, [0.196, 0.196, 0.196]], [0.841, [0.19, 0.19, 0.19]], [0.843, [0.19, 0.19, 0.19]], [0.845, [0.185, 0.185, 0.185]], [0.847, [0.185, 0.185, 0.185]], [0.849, [0.179, 0.179, 0.179]], [0.851, [0.179, 0.179, 0.179]], [0.853, [0.173, 0.173, 0.173]], [0.855, [0.173, 0.173, 0.173]], [0.857, [0.168, 0.168, 0.168]], [0.859, [0.168, 0.168, 0.168]], [0.861, [0.162, 0.162, 0.162]], [0.863, [0.162, 0.162, 0.162]], [0.865, [0.157, 0.157, 0.157]], [0.867, [0.157, 0.157, 0.157]], [0.869, [0.151, 0.151, 0.151]], [0.871, [0.151, 0.151, 0.151]], [0.873, [0.146, 0.146, 0.146]], [0.875, [0.146, 0.146, 0.146]], [0.877, [0.141, 0.141, 0.141]], [0.879, [0.141, 0.141, 0.141]], [0.881, [0.137, 0.137, 0.137]], [0.883, [0.137, 0.137, 0.137]], [0.885, [0.132, 0.132, 0.132]], [0.886, [0.132, 0.132, 0.132]], [0.888, [0.127, 0.127, 0.127]], [0.89, [0.127, 0.127, 0.127]], [0.892, [0.123, 0.123, 0.123]], [0.894, [0.123, 0.123, 0.123]], [0.896, [0.118, 0.118, 0.118]], [0.898, [0.118, 0.118, 0.118]], [0.9, [0.114, 0.114, 0.114]], [0.902, [0.114, 0.114, 0.114]], [0.904, [0.109, 0.109, 0.109]], [0.906, [0.109, 0.109, 0.109]], [0.908, [0.105, 0.105, 0.105]], [0.91, [0.105, 0.105, 0.105]], [0.912, [0.1, 0.1, 0.1]], [0.914, [0.1, 0.1, 0.1]], [0.916, [0.096, 0.096, 0.096]], [0.918, [0.096, 0.096, 0.096]], [0.92, [0.091, 0.091, 0.091]], [0.922, [0.091, 0.091, 0.091]], [0.924, [0.086, 0.086, 0.086]], [0.926, [0.086, 0.086, 0.086]], [0.928, [0.082, 0.082, 0.082]], [0.93, [0.082, 0.082, 0.082]], [0.932, [0.077, 0.077, 0.077]], [0.933, [0.077, 0.077, 0.077]], [0.935, [0.073, 0.073, 0.073]], [0.937, [0.073, 0.073, 0.073]], [0.939, [0.068, 0.068, 0.068]], [0.941, [0.068, 0.068, 0.068]], [0.943, [0.064, 0.064, 0.064]], [0.945, [0.064, 0.064, 0.064]], [0.947, [0.059, 0.059, 0.059]], [0.949, [0.059, 0.059, 0.059]], [0.951, [0.055, 0.055, 0.055]], [0.953, [0.055, 0.055, 0.055]], [0.955, [0.05, 0.05, 0.05]], [0.957, [0.05, 0.05, 0.05]], [0.959, [0.046, 0.046, 0.046]], [0.961, [0.046, 0.046, 0.046]], [0.963, [0.041, 0.041, 0.041]], [0.965, [0.041, 0.041, 0.041]], [0.967, [0.036, 0.036, 0.036]], [0.969, [0.036, 0.036, 0.036]], [0.971, [0.032, 0.032, 0.032]], [0.973, [0.032, 0.032, 0.032]], [0.975, [0.027, 0.027, 0.027]], [0.977, [0.027, 0.027, 0.027]], [0.978, [0.023, 0.023, 0.023]], [0.98, [0.023, 0.023, 0.023]], [0.982, [0.018, 0.018, 0.018]], [0.984, [0.018, 0.018, 0.018]], [0.986, [0.014, 0.014, 0.014]], [0.988, [0.014, 0.014, 0.014]], [0.99, [0.009, 0.009, 0.009]], [0.992, [0.009, 0.009, 0.009]], [0.994, [0.005, 0.005, 0.005]], [0.996, [0.005, 0.005, 0.005]], [0.998, [0.0, 0.0, 0.0]], [1.0, [0.0, 0.0, 0.0]]]
}), _defineProperty(_vislibColorMaps, ColorSchemas.Reds, {
  id: ColorSchemas.Reds,
  label: _i18n.i18n.translate('common.ui.vislib.colormaps.redsText', {
    defaultMessage: 'Reds'
  }),
  value: [[0.0, [1.0, 0.961, 0.941]], [0.002, [1.0, 0.961, 0.941]], [0.004, [1.0, 0.958, 0.937]], [0.006, [1.0, 0.958, 0.937]], [0.008, [1.0, 0.956, 0.934]], [0.01, [1.0, 0.956, 0.934]], [0.012, [1.0, 0.953, 0.93]], [0.014, [1.0, 0.953, 0.93]], [0.016, [1.0, 0.95, 0.926]], [0.018, [1.0, 0.95, 0.926]], [0.02, [0.999, 0.948, 0.923]], [0.022, [0.999, 0.948, 0.923]], [0.023, [0.999, 0.945, 0.919]], [0.025, [0.999, 0.945, 0.919]], [0.027, [0.999, 0.943, 0.915]], [0.029, [0.999, 0.943, 0.915]], [0.031, [0.999, 0.94, 0.912]], [0.033, [0.999, 0.94, 0.912]], [0.035, [0.999, 0.938, 0.908]], [0.037, [0.999, 0.938, 0.908]], [0.039, [0.999, 0.935, 0.904]], [0.041, [0.999, 0.935, 0.904]], [0.043, [0.999, 0.932, 0.901]], [0.045, [0.999, 0.932, 0.901]], [0.047, [0.999, 0.93, 0.897]], [0.049, [0.999, 0.93, 0.897]], [0.051, [0.998, 0.927, 0.893]], [0.053, [0.998, 0.927, 0.893]], [0.055, [0.998, 0.925, 0.89]], [0.057, [0.998, 0.925, 0.89]], [0.059, [0.998, 0.922, 0.886]], [0.061, [0.998, 0.922, 0.886]], [0.063, [0.998, 0.919, 0.882]], [0.065, [0.998, 0.919, 0.882]], [0.067, [0.998, 0.917, 0.878]], [0.068, [0.998, 0.917, 0.878]], [0.07, [0.998, 0.914, 0.875]], [0.072, [0.998, 0.914, 0.875]], [0.074, [0.998, 0.912, 0.871]], [0.076, [0.998, 0.912, 0.871]], [0.078, [0.998, 0.909, 0.867]], [0.08, [0.998, 0.909, 0.867]], [0.082, [0.997, 0.907, 0.864]], [0.084, [0.997, 0.907, 0.864]], [0.086, [0.997, 0.904, 0.86]], [0.088, [0.997, 0.904, 0.86]], [0.09, [0.997, 0.901, 0.856]], [0.092, [0.997, 0.901, 0.856]], [0.094, [0.997, 0.899, 0.853]], [0.096, [0.997, 0.899, 0.853]], [0.098, [0.997, 0.896, 0.849]], [0.1, [0.997, 0.896, 0.849]], [0.102, [0.997, 0.894, 0.845]], [0.104, [0.997, 0.894, 0.845]], [0.106, [0.997, 0.891, 0.842]], [0.108, [0.997, 0.891, 0.842]], [0.11, [0.997, 0.888, 0.838]], [0.112, [0.997, 0.888, 0.838]], [0.114, [0.996, 0.886, 0.834]], [0.115, [0.996, 0.886, 0.834]], [0.117, [0.996, 0.883, 0.83]], [0.119, [0.996, 0.883, 0.83]], [0.121, [0.996, 0.881, 0.827]], [0.123, [0.996, 0.881, 0.827]], [0.125, [0.996, 0.878, 0.823]], [0.127, [0.996, 0.878, 0.823]], [0.129, [0.996, 0.873, 0.817]], [0.131, [0.996, 0.873, 0.817]], [0.133, [0.996, 0.869, 0.811]], [0.135, [0.996, 0.869, 0.811]], [0.137, [0.995, 0.864, 0.805]], [0.139, [0.995, 0.864, 0.805]], [0.141, [0.995, 0.86, 0.799]], [0.143, [0.995, 0.86, 0.799]], [0.145, [0.995, 0.855, 0.793]], [0.147, [0.995, 0.855, 0.793]], [0.149, [0.995, 0.851, 0.787]], [0.151, [0.995, 0.851, 0.787]], [0.153, [0.994, 0.846, 0.781]], [0.155, [0.994, 0.846, 0.781]], [0.157, [0.994, 0.841, 0.775]], [0.159, [0.994, 0.841, 0.775]], [0.16, [0.994, 0.837, 0.769]], [0.162, [0.994, 0.837, 0.769]], [0.164, [0.994, 0.832, 0.762]], [0.166, [0.994, 0.832, 0.762]], [0.168, [0.993, 0.828, 0.756]], [0.17, [0.993, 0.828, 0.756]], [0.172, [0.993, 0.823, 0.75]], [0.174, [0.993, 0.823, 0.75]], [0.176, [0.993, 0.819, 0.744]], [0.178, [0.993, 0.819, 0.744]], [0.18, [0.993, 0.814, 0.738]], [0.182, [0.993, 0.814, 0.738]], [0.184, [0.992, 0.81, 0.732]], [0.186, [0.992, 0.81, 0.732]], [0.188, [0.992, 0.805, 0.726]], [0.19, [0.992, 0.805, 0.726]], [0.192, [0.992, 0.8, 0.72]], [0.194, [0.992, 0.8, 0.72]], [0.196, [0.992, 0.796, 0.714]], [0.198, [0.992, 0.796, 0.714]], [0.2, [0.991, 0.791, 0.708]], [0.202, [0.991, 0.791, 0.708]], [0.204, [0.991, 0.787, 0.702]], [0.205, [0.991, 0.787, 0.702]], [0.207, [0.991, 0.782, 0.696]], [0.209, [0.991, 0.782, 0.696]], [0.211, [0.991, 0.778, 0.69]], [0.213, [0.991, 0.778, 0.69]], [0.215, [0.99, 0.773, 0.684]], [0.217, [0.99, 0.773, 0.684]], [0.219, [0.99, 0.769, 0.678]], [0.221, [0.99, 0.769, 0.678]], [0.223, [0.99, 0.764, 0.672]], [0.225, [0.99, 0.764, 0.672]], [0.227, [0.99, 0.76, 0.666]], [0.229, [0.99, 0.76, 0.666]], [0.231, [0.989, 0.755, 0.66]], [0.233, [0.989, 0.755, 0.66]], [0.235, [0.989, 0.75, 0.654]], [0.237, [0.989, 0.75, 0.654]], [0.239, [0.989, 0.746, 0.648]], [0.241, [0.989, 0.746, 0.648]], [0.243, [0.989, 0.741, 0.642]], [0.245, [0.989, 0.741, 0.642]], [0.247, [0.988, 0.737, 0.636]], [0.249, [0.988, 0.737, 0.636]], [0.25, [0.988, 0.732, 0.63]], [0.252, [0.988, 0.732, 0.63]], [0.254, [0.988, 0.727, 0.624]], [0.256, [0.988, 0.727, 0.624]], [0.258, [0.988, 0.722, 0.618]], [0.26, [0.988, 0.722, 0.618]], [0.262, [0.988, 0.717, 0.613]], [0.264, [0.988, 0.717, 0.613]], [0.266, [0.988, 0.712, 0.607]], [0.268, [0.988, 0.712, 0.607]], [0.27, [0.988, 0.707, 0.601]], [0.272, [0.988, 0.707, 0.601]], [0.274, [0.988, 0.702, 0.595]], [0.276, [0.988, 0.702, 0.595]], [0.278, [0.988, 0.697, 0.589]], [0.28, [0.988, 0.697, 0.589]], [0.282, [0.988, 0.692, 0.584]], [0.284, [0.988, 0.692, 0.584]], [0.286, [0.988, 0.687, 0.578]], [0.288, [0.988, 0.687, 0.578]], [0.29, [0.988, 0.682, 0.572]], [0.292, [0.988, 0.682, 0.572]], [0.294, [0.988, 0.677, 0.566]], [0.295, [0.988, 0.677, 0.566]], [0.297, [0.988, 0.672, 0.561]], [0.299, [0.988, 0.672, 0.561]], [0.301, [0.988, 0.666, 0.555]], [0.303, [0.988, 0.666, 0.555]], [0.305, [0.988, 0.661, 0.549]], [0.307, [0.988, 0.661, 0.549]], [0.309, [0.988, 0.656, 0.543]], [0.311, [0.988, 0.656, 0.543]], [0.313, [0.988, 0.651, 0.537]], [0.315, [0.988, 0.651, 0.537]], [0.317, [0.988, 0.646, 0.532]], [0.319, [0.988, 0.646, 0.532]], [0.321, [0.988, 0.641, 0.526]], [0.323, [0.988, 0.641, 0.526]], [0.325, [0.988, 0.636, 0.52]], [0.327, [0.988, 0.636, 0.52]], [0.329, [0.988, 0.631, 0.514]], [0.331, [0.988, 0.631, 0.514]], [0.333, [0.988, 0.626, 0.508]], [0.335, [0.988, 0.626, 0.508]], [0.337, [0.988, 0.621, 0.503]], [0.339, [0.988, 0.621, 0.503]], [0.341, [0.988, 0.616, 0.497]], [0.342, [0.988, 0.616, 0.497]], [0.344, [0.988, 0.611, 0.491]], [0.346, [0.988, 0.611, 0.491]], [0.348, [0.988, 0.606, 0.485]], [0.35, [0.988, 0.606, 0.485]], [0.352, [0.988, 0.601, 0.48]], [0.354, [0.988, 0.601, 0.48]], [0.356, [0.988, 0.596, 0.474]], [0.358, [0.988, 0.596, 0.474]], [0.36, [0.988, 0.591, 0.468]], [0.362, [0.988, 0.591, 0.468]], [0.364, [0.988, 0.586, 0.462]], [0.366, [0.988, 0.586, 0.462]], [0.368, [0.988, 0.581, 0.456]], [0.37, [0.988, 0.581, 0.456]], [0.372, [0.988, 0.576, 0.451]], [0.374, [0.988, 0.576, 0.451]], [0.376, [0.988, 0.571, 0.445]], [0.378, [0.988, 0.571, 0.445]], [0.38, [0.988, 0.566, 0.44]], [0.382, [0.988, 0.566, 0.44]], [0.384, [0.988, 0.561, 0.435]], [0.386, [0.988, 0.561, 0.435]], [0.387, [0.988, 0.556, 0.43]], [0.389, [0.988, 0.556, 0.43]], [0.391, [0.988, 0.551, 0.426]], [0.393, [0.988, 0.551, 0.426]], [0.395, [0.988, 0.546, 0.421]], [0.397, [0.988, 0.546, 0.421]], [0.399, [0.987, 0.541, 0.416]], [0.401, [0.987, 0.541, 0.416]], [0.403, [0.987, 0.536, 0.411]], [0.405, [0.987, 0.536, 0.411]], [0.407, [0.987, 0.531, 0.406]], [0.409, [0.987, 0.531, 0.406]], [0.411, [0.987, 0.526, 0.401]], [0.413, [0.987, 0.526, 0.401]], [0.415, [0.987, 0.521, 0.396]], [0.417, [0.987, 0.521, 0.396]], [0.419, [0.987, 0.517, 0.391]], [0.421, [0.987, 0.517, 0.391]], [0.423, [0.987, 0.512, 0.386]], [0.425, [0.987, 0.512, 0.386]], [0.427, [0.987, 0.507, 0.381]], [0.429, [0.987, 0.507, 0.381]], [0.431, [0.986, 0.502, 0.376]], [0.432, [0.986, 0.502, 0.376]], [0.434, [0.986, 0.497, 0.371]], [0.436, [0.986, 0.497, 0.371]], [0.438, [0.986, 0.492, 0.366]], [0.44, [0.986, 0.492, 0.366]], [0.442, [0.986, 0.487, 0.362]], [0.444, [0.986, 0.487, 0.362]], [0.446, [0.986, 0.482, 0.357]], [0.448, [0.986, 0.482, 0.357]], [0.45, [0.986, 0.477, 0.352]], [0.452, [0.986, 0.477, 0.352]], [0.454, [0.986, 0.472, 0.347]], [0.456, [0.986, 0.472, 0.347]], [0.458, [0.986, 0.467, 0.342]], [0.46, [0.986, 0.467, 0.342]], [0.462, [0.985, 0.462, 0.337]], [0.464, [0.985, 0.462, 0.337]], [0.466, [0.985, 0.458, 0.332]], [0.468, [0.985, 0.458, 0.332]], [0.47, [0.985, 0.453, 0.327]], [0.472, [0.985, 0.453, 0.327]], [0.474, [0.985, 0.448, 0.322]], [0.476, [0.985, 0.448, 0.322]], [0.477, [0.985, 0.443, 0.317]], [0.479, [0.985, 0.443, 0.317]], [0.481, [0.985, 0.438, 0.312]], [0.483, [0.985, 0.438, 0.312]], [0.485, [0.985, 0.433, 0.307]], [0.487, [0.985, 0.433, 0.307]], [0.489, [0.985, 0.428, 0.302]], [0.491, [0.985, 0.428, 0.302]], [0.493, [0.984, 0.423, 0.298]], [0.495, [0.984, 0.423, 0.298]], [0.497, [0.984, 0.418, 0.293]], [0.499, [0.984, 0.418, 0.293]], [0.501, [0.984, 0.413, 0.288]], [0.503, [0.984, 0.413, 0.288]], [0.505, [0.982, 0.407, 0.285]], [0.507, [0.982, 0.407, 0.285]], [0.509, [0.981, 0.401, 0.281]], [0.511, [0.981, 0.401, 0.281]], [0.513, [0.979, 0.395, 0.277]], [0.515, [0.979, 0.395, 0.277]], [0.517, [0.978, 0.39, 0.274]], [0.519, [0.978, 0.39, 0.274]], [0.521, [0.976, 0.384, 0.27]], [0.523, [0.976, 0.384, 0.27]], [0.524, [0.975, 0.378, 0.266]], [0.526, [0.975, 0.378, 0.266]], [0.528, [0.973, 0.372, 0.263]], [0.53, [0.973, 0.372, 0.263]], [0.532, [0.972, 0.367, 0.259]], [0.534, [0.972, 0.367, 0.259]], [0.536, [0.97, 0.361, 0.255]], [0.538, [0.97, 0.361, 0.255]], [0.54, [0.969, 0.355, 0.251]], [0.542, [0.969, 0.355, 0.251]], [0.544, [0.967, 0.349, 0.248]], [0.546, [0.967, 0.349, 0.248]], [0.548, [0.966, 0.343, 0.244]], [0.55, [0.966, 0.343, 0.244]], [0.552, [0.964, 0.338, 0.24]], [0.554, [0.964, 0.338, 0.24]], [0.556, [0.963, 0.332, 0.237]], [0.558, [0.963, 0.332, 0.237]], [0.56, [0.961, 0.326, 0.233]], [0.562, [0.961, 0.326, 0.233]], [0.564, [0.96, 0.32, 0.229]], [0.566, [0.96, 0.32, 0.229]], [0.568, [0.958, 0.314, 0.226]], [0.569, [0.958, 0.314, 0.226]], [0.571, [0.957, 0.309, 0.222]], [0.573, [0.957, 0.309, 0.222]], [0.575, [0.956, 0.303, 0.218]], [0.577, [0.956, 0.303, 0.218]], [0.579, [0.954, 0.297, 0.215]], [0.581, [0.954, 0.297, 0.215]], [0.583, [0.953, 0.291, 0.211]], [0.585, [0.953, 0.291, 0.211]], [0.587, [0.951, 0.286, 0.207]], [0.589, [0.951, 0.286, 0.207]], [0.591, [0.95, 0.28, 0.203]], [0.593, [0.95, 0.28, 0.203]], [0.595, [0.948, 0.274, 0.2]], [0.597, [0.948, 0.274, 0.2]], [0.599, [0.947, 0.268, 0.196]], [0.601, [0.947, 0.268, 0.196]], [0.603, [0.945, 0.262, 0.192]], [0.605, [0.945, 0.262, 0.192]], [0.607, [0.944, 0.257, 0.189]], [0.609, [0.944, 0.257, 0.189]], [0.611, [0.942, 0.251, 0.185]], [0.613, [0.942, 0.251, 0.185]], [0.614, [0.941, 0.245, 0.181]], [0.616, [0.941, 0.245, 0.181]], [0.618, [0.939, 0.239, 0.178]], [0.62, [0.939, 0.239, 0.178]], [0.622, [0.938, 0.234, 0.174]], [0.624, [0.938, 0.234, 0.174]], [0.626, [0.934, 0.229, 0.171]], [0.628, [0.934, 0.229, 0.171]], [0.63, [0.93, 0.224, 0.17]], [0.632, [0.93, 0.224, 0.17]], [0.634, [0.926, 0.22, 0.168]], [0.636, [0.926, 0.22, 0.168]], [0.638, [0.921, 0.216, 0.166]], [0.64, [0.921, 0.216, 0.166]], [0.642, [0.917, 0.211, 0.164]], [0.644, [0.917, 0.211, 0.164]], [0.646, [0.912, 0.207, 0.162]], [0.648, [0.912, 0.207, 0.162]], [0.65, [0.908, 0.203, 0.16]], [0.652, [0.908, 0.203, 0.16]], [0.654, [0.903, 0.199, 0.158]], [0.656, [0.903, 0.199, 0.158]], [0.658, [0.899, 0.194, 0.157]], [0.659, [0.899, 0.194, 0.157]], [0.661, [0.895, 0.19, 0.155]], [0.663, [0.895, 0.19, 0.155]], [0.665, [0.89, 0.186, 0.153]], [0.667, [0.89, 0.186, 0.153]], [0.669, [0.886, 0.181, 0.151]], [0.671, [0.886, 0.181, 0.151]], [0.673, [0.881, 0.177, 0.149]], [0.675, [0.881, 0.177, 0.149]], [0.677, [0.877, 0.173, 0.147]], [0.679, [0.877, 0.173, 0.147]], [0.681, [0.872, 0.168, 0.146]], [0.683, [0.872, 0.168, 0.146]], [0.685, [0.868, 0.164, 0.144]], [0.687, [0.868, 0.164, 0.144]], [0.689, [0.864, 0.16, 0.142]], [0.691, [0.864, 0.16, 0.142]], [0.693, [0.859, 0.155, 0.14]], [0.695, [0.859, 0.155, 0.14]], [0.697, [0.855, 0.151, 0.138]], [0.699, [0.855, 0.151, 0.138]], [0.701, [0.85, 0.147, 0.136]], [0.703, [0.85, 0.147, 0.136]], [0.705, [0.846, 0.143, 0.134]], [0.706, [0.846, 0.143, 0.134]], [0.708, [0.841, 0.138, 0.133]], [0.71, [0.841, 0.138, 0.133]], [0.712, [0.837, 0.134, 0.131]], [0.714, [0.837, 0.134, 0.131]], [0.716, [0.833, 0.13, 0.129]], [0.718, [0.833, 0.13, 0.129]], [0.72, [0.828, 0.125, 0.127]], [0.722, [0.828, 0.125, 0.127]], [0.724, [0.824, 0.121, 0.125]], [0.726, [0.824, 0.121, 0.125]], [0.728, [0.819, 0.117, 0.123]], [0.73, [0.819, 0.117, 0.123]], [0.732, [0.815, 0.112, 0.122]], [0.734, [0.815, 0.112, 0.122]], [0.736, [0.81, 0.108, 0.12]], [0.738, [0.81, 0.108, 0.12]], [0.74, [0.806, 0.104, 0.118]], [0.742, [0.806, 0.104, 0.118]], [0.744, [0.802, 0.1, 0.116]], [0.746, [0.802, 0.1, 0.116]], [0.748, [0.797, 0.095, 0.114]], [0.75, [0.797, 0.095, 0.114]], [0.751, [0.793, 0.093, 0.113]], [0.753, [0.793, 0.093, 0.113]], [0.755, [0.788, 0.092, 0.112]], [0.757, [0.788, 0.092, 0.112]], [0.759, [0.783, 0.091, 0.111]], [0.761, [0.783, 0.091, 0.111]], [0.763, [0.779, 0.09, 0.11]], [0.765, [0.779, 0.09, 0.11]], [0.767, [0.774, 0.089, 0.109]], [0.769, [0.774, 0.089, 0.109]], [0.771, [0.769, 0.088, 0.108]], [0.773, [0.769, 0.088, 0.108]], [0.775, [0.765, 0.087, 0.107]], [0.777, [0.765, 0.087, 0.107]], [0.779, [0.76, 0.086, 0.106]], [0.781, [0.76, 0.086, 0.106]], [0.783, [0.755, 0.084, 0.105]], [0.785, [0.755, 0.084, 0.105]], [0.787, [0.75, 0.083, 0.104]], [0.789, [0.75, 0.083, 0.104]], [0.791, [0.746, 0.082, 0.103]], [0.793, [0.746, 0.082, 0.103]], [0.795, [0.741, 0.081, 0.102]], [0.796, [0.741, 0.081, 0.102]], [0.798, [0.736, 0.08, 0.101]], [0.8, [0.736, 0.08, 0.101]], [0.802, [0.732, 0.079, 0.1]], [0.804, [0.732, 0.079, 0.1]], [0.806, [0.727, 0.078, 0.099]], [0.808, [0.727, 0.078, 0.099]], [0.81, [0.722, 0.077, 0.098]], [0.812, [0.722, 0.077, 0.098]], [0.814, [0.718, 0.076, 0.097]], [0.816, [0.718, 0.076, 0.097]], [0.818, [0.713, 0.074, 0.096]], [0.82, [0.713, 0.074, 0.096]], [0.822, [0.708, 0.073, 0.095]], [0.824, [0.708, 0.073, 0.095]], [0.826, [0.704, 0.072, 0.094]], [0.828, [0.704, 0.072, 0.094]], [0.83, [0.699, 0.071, 0.093]], [0.832, [0.699, 0.071, 0.093]], [0.834, [0.694, 0.07, 0.092]], [0.836, [0.694, 0.07, 0.092]], [0.838, [0.69, 0.069, 0.091]], [0.84, [0.69, 0.069, 0.091]], [0.841, [0.685, 0.068, 0.09]], [0.843, [0.685, 0.068, 0.09]], [0.845, [0.68, 0.067, 0.089]], [0.847, [0.68, 0.067, 0.089]], [0.849, [0.676, 0.066, 0.088]], [0.851, [0.676, 0.066, 0.088]], [0.853, [0.671, 0.064, 0.087]], [0.855, [0.671, 0.064, 0.087]], [0.857, [0.666, 0.063, 0.086]], [0.859, [0.666, 0.063, 0.086]], [0.861, [0.662, 0.062, 0.085]], [0.863, [0.662, 0.062, 0.085]], [0.865, [0.657, 0.061, 0.084]], [0.867, [0.657, 0.061, 0.084]], [0.869, [0.652, 0.06, 0.083]], [0.871, [0.652, 0.06, 0.083]], [0.873, [0.648, 0.059, 0.082]], [0.875, [0.648, 0.059, 0.082]], [0.877, [0.64, 0.057, 0.081]], [0.879, [0.64, 0.057, 0.081]], [0.881, [0.633, 0.055, 0.081]], [0.883, [0.633, 0.055, 0.081]], [0.885, [0.625, 0.054, 0.08]], [0.886, [0.625, 0.054, 0.08]], [0.888, [0.618, 0.052, 0.079]], [0.89, [0.618, 0.052, 0.079]], [0.892, [0.61, 0.05, 0.078]], [0.894, [0.61, 0.05, 0.078]], [0.896, [0.602, 0.048, 0.077]], [0.898, [0.602, 0.048, 0.077]], [0.9, [0.595, 0.046, 0.076]], [0.902, [0.595, 0.046, 0.076]], [0.904, [0.587, 0.044, 0.075]], [0.906, [0.587, 0.044, 0.075]], [0.908, [0.579, 0.042, 0.074]], [0.91, [0.579, 0.042, 0.074]], [0.912, [0.572, 0.041, 0.073]], [0.914, [0.572, 0.041, 0.073]], [0.916, [0.564, 0.039, 0.072]], [0.918, [0.564, 0.039, 0.072]], [0.92, [0.556, 0.037, 0.071]], [0.922, [0.556, 0.037, 0.071]], [0.924, [0.549, 0.035, 0.07]], [0.926, [0.549, 0.035, 0.07]], [0.928, [0.541, 0.033, 0.069]], [0.93, [0.541, 0.033, 0.069]], [0.932, [0.534, 0.031, 0.068]], [0.933, [0.534, 0.031, 0.068]], [0.935, [0.526, 0.03, 0.067]], [0.937, [0.526, 0.03, 0.067]], [0.939, [0.518, 0.028, 0.066]], [0.941, [0.518, 0.028, 0.066]], [0.943, [0.511, 0.026, 0.065]], [0.945, [0.511, 0.026, 0.065]], [0.947, [0.503, 0.024, 0.064]], [0.949, [0.503, 0.024, 0.064]], [0.951, [0.495, 0.022, 0.063]], [0.953, [0.495, 0.022, 0.063]], [0.955, [0.488, 0.02, 0.062]], [0.957, [0.488, 0.02, 0.062]], [0.959, [0.48, 0.018, 0.061]], [0.961, [0.48, 0.018, 0.061]], [0.963, [0.473, 0.017, 0.06]], [0.965, [0.473, 0.017, 0.06]], [0.967, [0.465, 0.015, 0.059]], [0.969, [0.465, 0.015, 0.059]], [0.971, [0.457, 0.013, 0.058]], [0.973, [0.457, 0.013, 0.058]], [0.975, [0.45, 0.011, 0.057]], [0.977, [0.45, 0.011, 0.057]], [0.978, [0.442, 0.009, 0.056]], [0.98, [0.442, 0.009, 0.056]], [0.982, [0.434, 0.007, 0.055]], [0.984, [0.434, 0.007, 0.055]], [0.986, [0.427, 0.006, 0.054]], [0.988, [0.427, 0.006, 0.054]], [0.99, [0.419, 0.004, 0.053]], [0.992, [0.419, 0.004, 0.053]], [0.994, [0.412, 0.002, 0.052]], [0.996, [0.412, 0.002, 0.052]], [0.998, [0.404, 0.0, 0.051]], [1.0, [0.404, 0.0, 0.051]]]
}), _defineProperty(_vislibColorMaps, ColorSchemas.YellowToRed, {
  id: ColorSchemas.YellowToRed,
  label: _i18n.i18n.translate('common.ui.vislib.colormaps.yellowToRedText', {
    defaultMessage: 'Yellow to Red'
  }),
  value: [[0.0, [1.0, 1.0, 0.8]], [0.002, [1.0, 1.0, 0.8]], [0.004, [1.0, 0.998, 0.795]], [0.006, [1.0, 0.998, 0.795]], [0.008, [1.0, 0.996, 0.789]], [0.01, [1.0, 0.996, 0.789]], [0.012, [1.0, 0.993, 0.784]], [0.014, [1.0, 0.993, 0.784]], [0.016, [1.0, 0.991, 0.778]], [0.018, [1.0, 0.991, 0.778]], [0.02, [1.0, 0.989, 0.773]], [0.022, [1.0, 0.989, 0.773]], [0.023, [1.0, 0.987, 0.768]], [0.025, [1.0, 0.987, 0.768]], [0.027, [1.0, 0.984, 0.762]], [0.029, [1.0, 0.984, 0.762]], [0.031, [1.0, 0.982, 0.757]], [0.033, [1.0, 0.982, 0.757]], [0.035, [1.0, 0.98, 0.751]], [0.037, [1.0, 0.98, 0.751]], [0.039, [1.0, 0.978, 0.746]], [0.041, [1.0, 0.978, 0.746]], [0.043, [1.0, 0.976, 0.74]], [0.045, [1.0, 0.976, 0.74]], [0.047, [1.0, 0.973, 0.735]], [0.049, [1.0, 0.973, 0.735]], [0.051, [1.0, 0.971, 0.73]], [0.053, [1.0, 0.971, 0.73]], [0.055, [1.0, 0.969, 0.724]], [0.057, [1.0, 0.969, 0.724]], [0.059, [1.0, 0.967, 0.719]], [0.061, [1.0, 0.967, 0.719]], [0.063, [1.0, 0.965, 0.713]], [0.065, [1.0, 0.965, 0.713]], [0.067, [1.0, 0.962, 0.708]], [0.068, [1.0, 0.962, 0.708]], [0.07, [1.0, 0.96, 0.703]], [0.072, [1.0, 0.96, 0.703]], [0.074, [1.0, 0.958, 0.697]], [0.076, [1.0, 0.958, 0.697]], [0.078, [1.0, 0.956, 0.692]], [0.08, [1.0, 0.956, 0.692]], [0.082, [1.0, 0.953, 0.686]], [0.084, [1.0, 0.953, 0.686]], [0.086, [1.0, 0.951, 0.681]], [0.088, [1.0, 0.951, 0.681]], [0.09, [1.0, 0.949, 0.675]], [0.092, [1.0, 0.949, 0.675]], [0.094, [1.0, 0.947, 0.67]], [0.096, [1.0, 0.947, 0.67]], [0.098, [1.0, 0.945, 0.665]], [0.1, [1.0, 0.945, 0.665]], [0.102, [1.0, 0.942, 0.659]], [0.104, [1.0, 0.942, 0.659]], [0.106, [1.0, 0.94, 0.654]], [0.108, [1.0, 0.94, 0.654]], [0.11, [1.0, 0.938, 0.648]], [0.112, [1.0, 0.938, 0.648]], [0.114, [1.0, 0.936, 0.643]], [0.115, [1.0, 0.936, 0.643]], [0.117, [1.0, 0.934, 0.638]], [0.119, [1.0, 0.934, 0.638]], [0.121, [1.0, 0.931, 0.632]], [0.123, [1.0, 0.931, 0.632]], [0.125, [1.0, 0.929, 0.627]], [0.127, [1.0, 0.929, 0.627]], [0.129, [1.0, 0.927, 0.622]], [0.131, [1.0, 0.927, 0.622]], [0.133, [1.0, 0.924, 0.616]], [0.135, [1.0, 0.924, 0.616]], [0.137, [1.0, 0.922, 0.611]], [0.139, [1.0, 0.922, 0.611]], [0.141, [0.999, 0.919, 0.606]], [0.143, [0.999, 0.919, 0.606]], [0.145, [0.999, 0.917, 0.601]], [0.147, [0.999, 0.917, 0.601]], [0.149, [0.999, 0.914, 0.596]], [0.151, [0.999, 0.914, 0.596]], [0.153, [0.999, 0.912, 0.591]], [0.155, [0.999, 0.912, 0.591]], [0.157, [0.999, 0.909, 0.585]], [0.159, [0.999, 0.909, 0.585]], [0.16, [0.999, 0.907, 0.58]], [0.162, [0.999, 0.907, 0.58]], [0.164, [0.999, 0.904, 0.575]], [0.166, [0.999, 0.904, 0.575]], [0.168, [0.999, 0.902, 0.57]], [0.17, [0.999, 0.902, 0.57]], [0.172, [0.999, 0.9, 0.565]], [0.174, [0.999, 0.9, 0.565]], [0.176, [0.998, 0.897, 0.56]], [0.178, [0.998, 0.897, 0.56]], [0.18, [0.998, 0.895, 0.554]], [0.182, [0.998, 0.895, 0.554]], [0.184, [0.998, 0.892, 0.549]], [0.186, [0.998, 0.892, 0.549]], [0.188, [0.998, 0.89, 0.544]], [0.19, [0.998, 0.89, 0.544]], [0.192, [0.998, 0.887, 0.539]], [0.194, [0.998, 0.887, 0.539]], [0.196, [0.998, 0.885, 0.534]], [0.198, [0.998, 0.885, 0.534]], [0.2, [0.998, 0.882, 0.529]], [0.202, [0.998, 0.882, 0.529]], [0.204, [0.998, 0.88, 0.523]], [0.205, [0.998, 0.88, 0.523]], [0.207, [0.997, 0.877, 0.518]], [0.209, [0.997, 0.877, 0.518]], [0.211, [0.997, 0.875, 0.513]], [0.213, [0.997, 0.875, 0.513]], [0.215, [0.997, 0.873, 0.508]], [0.217, [0.997, 0.873, 0.508]], [0.219, [0.997, 0.87, 0.503]], [0.221, [0.997, 0.87, 0.503]], [0.223, [0.997, 0.868, 0.498]], [0.225, [0.997, 0.868, 0.498]], [0.227, [0.997, 0.865, 0.492]], [0.229, [0.997, 0.865, 0.492]], [0.231, [0.997, 0.863, 0.487]], [0.233, [0.997, 0.863, 0.487]], [0.235, [0.997, 0.86, 0.482]], [0.237, [0.997, 0.86, 0.482]], [0.239, [0.996, 0.858, 0.477]], [0.241, [0.996, 0.858, 0.477]], [0.243, [0.996, 0.855, 0.472]], [0.245, [0.996, 0.855, 0.472]], [0.247, [0.996, 0.853, 0.467]], [0.249, [0.996, 0.853, 0.467]], [0.25, [0.996, 0.85, 0.461]], [0.252, [0.996, 0.85, 0.461]], [0.254, [0.996, 0.845, 0.456]], [0.256, [0.996, 0.845, 0.456]], [0.258, [0.996, 0.84, 0.451]], [0.26, [0.996, 0.84, 0.451]], [0.262, [0.996, 0.835, 0.446]], [0.264, [0.996, 0.835, 0.446]], [0.266, [0.996, 0.831, 0.441]], [0.268, [0.996, 0.831, 0.441]], [0.27, [0.996, 0.826, 0.436]], [0.272, [0.996, 0.826, 0.436]], [0.274, [0.996, 0.821, 0.43]], [0.276, [0.996, 0.821, 0.43]], [0.278, [0.996, 0.816, 0.425]], [0.28, [0.996, 0.816, 0.425]], [0.282, [0.996, 0.811, 0.42]], [0.284, [0.996, 0.811, 0.42]], [0.286, [0.996, 0.807, 0.415]], [0.288, [0.996, 0.807, 0.415]], [0.29, [0.996, 0.802, 0.41]], [0.292, [0.996, 0.802, 0.41]], [0.294, [0.996, 0.797, 0.405]], [0.295, [0.996, 0.797, 0.405]], [0.297, [0.996, 0.792, 0.399]], [0.299, [0.996, 0.792, 0.399]], [0.301, [0.996, 0.787, 0.394]], [0.303, [0.996, 0.787, 0.394]], [0.305, [0.996, 0.783, 0.389]], [0.307, [0.996, 0.783, 0.389]], [0.309, [0.996, 0.778, 0.384]], [0.311, [0.996, 0.778, 0.384]], [0.313, [0.996, 0.773, 0.379]], [0.315, [0.996, 0.773, 0.379]], [0.317, [0.996, 0.768, 0.374]], [0.319, [0.996, 0.768, 0.374]], [0.321, [0.996, 0.763, 0.368]], [0.323, [0.996, 0.763, 0.368]], [0.325, [0.996, 0.759, 0.363]], [0.327, [0.996, 0.759, 0.363]], [0.329, [0.996, 0.754, 0.358]], [0.331, [0.996, 0.754, 0.358]], [0.333, [0.996, 0.749, 0.353]], [0.335, [0.996, 0.749, 0.353]], [0.337, [0.996, 0.744, 0.348]], [0.339, [0.996, 0.744, 0.348]], [0.341, [0.996, 0.739, 0.343]], [0.342, [0.996, 0.739, 0.343]], [0.344, [0.996, 0.735, 0.337]], [0.346, [0.996, 0.735, 0.337]], [0.348, [0.996, 0.73, 0.332]], [0.35, [0.996, 0.73, 0.332]], [0.352, [0.996, 0.725, 0.327]], [0.354, [0.996, 0.725, 0.327]], [0.356, [0.996, 0.72, 0.322]], [0.358, [0.996, 0.72, 0.322]], [0.36, [0.996, 0.715, 0.317]], [0.362, [0.996, 0.715, 0.317]], [0.364, [0.996, 0.711, 0.312]], [0.366, [0.996, 0.711, 0.312]], [0.368, [0.996, 0.706, 0.306]], [0.37, [0.996, 0.706, 0.306]], [0.372, [0.996, 0.701, 0.301]], [0.374, [0.996, 0.701, 0.301]], [0.376, [0.996, 0.696, 0.297]], [0.378, [0.996, 0.696, 0.297]], [0.38, [0.996, 0.692, 0.295]], [0.382, [0.996, 0.692, 0.295]], [0.384, [0.996, 0.687, 0.293]], [0.386, [0.996, 0.687, 0.293]], [0.387, [0.996, 0.683, 0.291]], [0.389, [0.996, 0.683, 0.291]], [0.391, [0.996, 0.678, 0.289]], [0.393, [0.996, 0.678, 0.289]], [0.395, [0.995, 0.674, 0.287]], [0.397, [0.995, 0.674, 0.287]], [0.399, [0.995, 0.669, 0.285]], [0.401, [0.995, 0.669, 0.285]], [0.403, [0.995, 0.664, 0.284]], [0.405, [0.995, 0.664, 0.284]], [0.407, [0.995, 0.66, 0.282]], [0.409, [0.995, 0.66, 0.282]], [0.411, [0.995, 0.655, 0.28]], [0.413, [0.995, 0.655, 0.28]], [0.415, [0.995, 0.651, 0.278]], [0.417, [0.995, 0.651, 0.278]], [0.419, [0.995, 0.646, 0.276]], [0.421, [0.995, 0.646, 0.276]], [0.423, [0.995, 0.642, 0.274]], [0.425, [0.995, 0.642, 0.274]], [0.427, [0.994, 0.637, 0.272]], [0.429, [0.994, 0.637, 0.272]], [0.431, [0.994, 0.633, 0.27]], [0.432, [0.994, 0.633, 0.27]], [0.434, [0.994, 0.628, 0.268]], [0.436, [0.994, 0.628, 0.268]], [0.438, [0.994, 0.623, 0.266]], [0.44, [0.994, 0.623, 0.266]], [0.442, [0.994, 0.619, 0.264]], [0.444, [0.994, 0.619, 0.264]], [0.446, [0.994, 0.614, 0.262]], [0.448, [0.994, 0.614, 0.262]], [0.45, [0.994, 0.61, 0.26]], [0.452, [0.994, 0.61, 0.26]], [0.454, [0.994, 0.605, 0.258]], [0.456, [0.994, 0.605, 0.258]], [0.458, [0.993, 0.601, 0.256]], [0.46, [0.993, 0.601, 0.256]], [0.462, [0.993, 0.596, 0.254]], [0.464, [0.993, 0.596, 0.254]], [0.466, [0.993, 0.592, 0.252]], [0.468, [0.993, 0.592, 0.252]], [0.47, [0.993, 0.587, 0.25]], [0.472, [0.993, 0.587, 0.25]], [0.474, [0.993, 0.583, 0.248]], [0.476, [0.993, 0.583, 0.248]], [0.477, [0.993, 0.578, 0.246]], [0.479, [0.993, 0.578, 0.246]], [0.481, [0.993, 0.573, 0.244]], [0.483, [0.993, 0.573, 0.244]], [0.485, [0.993, 0.569, 0.242]], [0.487, [0.993, 0.569, 0.242]], [0.489, [0.992, 0.564, 0.24]], [0.491, [0.992, 0.564, 0.24]], [0.493, [0.992, 0.56, 0.238]], [0.495, [0.992, 0.56, 0.238]], [0.497, [0.992, 0.555, 0.236]], [0.499, [0.992, 0.555, 0.236]], [0.501, [0.992, 0.549, 0.234]], [0.503, [0.992, 0.549, 0.234]], [0.505, [0.992, 0.541, 0.232]], [0.507, [0.992, 0.541, 0.232]], [0.509, [0.992, 0.534, 0.23]], [0.511, [0.992, 0.534, 0.23]], [0.513, [0.992, 0.526, 0.228]], [0.515, [0.992, 0.526, 0.228]], [0.517, [0.992, 0.518, 0.225]], [0.519, [0.992, 0.518, 0.225]], [0.521, [0.991, 0.51, 0.223]], [0.523, [0.991, 0.51, 0.223]], [0.524, [0.991, 0.503, 0.221]], [0.526, [0.991, 0.503, 0.221]], [0.528, [0.991, 0.495, 0.219]], [0.53, [0.991, 0.495, 0.219]], [0.532, [0.991, 0.487, 0.216]], [0.534, [0.991, 0.487, 0.216]], [0.536, [0.991, 0.479, 0.214]], [0.538, [0.991, 0.479, 0.214]], [0.54, [0.991, 0.472, 0.212]], [0.542, [0.991, 0.472, 0.212]], [0.544, [0.991, 0.464, 0.21]], [0.546, [0.991, 0.464, 0.21]], [0.548, [0.991, 0.456, 0.208]], [0.55, [0.991, 0.456, 0.208]], [0.552, [0.99, 0.448, 0.205]], [0.554, [0.99, 0.448, 0.205]], [0.556, [0.99, 0.441, 0.203]], [0.558, [0.99, 0.441, 0.203]], [0.56, [0.99, 0.433, 0.201]], [0.562, [0.99, 0.433, 0.201]], [0.564, [0.99, 0.425, 0.199]], [0.566, [0.99, 0.425, 0.199]], [0.568, [0.99, 0.417, 0.197]], [0.569, [0.99, 0.417, 0.197]], [0.571, [0.99, 0.41, 0.194]], [0.573, [0.99, 0.41, 0.194]], [0.575, [0.99, 0.402, 0.192]], [0.577, [0.99, 0.402, 0.192]], [0.579, [0.99, 0.394, 0.19]], [0.581, [0.99, 0.394, 0.19]], [0.583, [0.99, 0.386, 0.188]], [0.585, [0.99, 0.386, 0.188]], [0.587, [0.989, 0.379, 0.185]], [0.589, [0.989, 0.379, 0.185]], [0.591, [0.989, 0.371, 0.183]], [0.593, [0.989, 0.371, 0.183]], [0.595, [0.989, 0.363, 0.181]], [0.597, [0.989, 0.363, 0.181]], [0.599, [0.989, 0.355, 0.179]], [0.601, [0.989, 0.355, 0.179]], [0.603, [0.989, 0.348, 0.177]], [0.605, [0.989, 0.348, 0.177]], [0.607, [0.989, 0.34, 0.174]], [0.609, [0.989, 0.34, 0.174]], [0.611, [0.989, 0.332, 0.172]], [0.613, [0.989, 0.332, 0.172]], [0.614, [0.989, 0.324, 0.17]], [0.616, [0.989, 0.324, 0.17]], [0.618, [0.988, 0.317, 0.168]], [0.62, [0.988, 0.317, 0.168]], [0.622, [0.988, 0.309, 0.166]], [0.624, [0.988, 0.309, 0.166]], [0.626, [0.986, 0.302, 0.164]], [0.628, [0.986, 0.302, 0.164]], [0.63, [0.983, 0.295, 0.162]], [0.632, [0.983, 0.295, 0.162]], [0.634, [0.98, 0.289, 0.16]], [0.636, [0.98, 0.289, 0.16]], [0.638, [0.977, 0.283, 0.158]], [0.64, [0.977, 0.283, 0.158]], [0.642, [0.974, 0.276, 0.157]], [0.644, [0.974, 0.276, 0.157]], [0.646, [0.971, 0.27, 0.155]], [0.648, [0.971, 0.27, 0.155]], [0.65, [0.968, 0.263, 0.153]], [0.652, [0.968, 0.263, 0.153]], [0.654, [0.965, 0.257, 0.152]], [0.656, [0.965, 0.257, 0.152]], [0.658, [0.962, 0.251, 0.15]], [0.659, [0.962, 0.251, 0.15]], [0.661, [0.959, 0.244, 0.148]], [0.663, [0.959, 0.244, 0.148]], [0.665, [0.956, 0.238, 0.146]], [0.667, [0.956, 0.238, 0.146]], [0.669, [0.952, 0.232, 0.145]], [0.671, [0.952, 0.232, 0.145]], [0.673, [0.949, 0.225, 0.143]], [0.675, [0.949, 0.225, 0.143]], [0.677, [0.946, 0.219, 0.141]], [0.679, [0.946, 0.219, 0.141]], [0.681, [0.943, 0.212, 0.14]], [0.683, [0.943, 0.212, 0.14]], [0.685, [0.94, 0.206, 0.138]], [0.687, [0.94, 0.206, 0.138]], [0.689, [0.937, 0.2, 0.136]], [0.691, [0.937, 0.2, 0.136]], [0.693, [0.934, 0.193, 0.134]], [0.695, [0.934, 0.193, 0.134]], [0.697, [0.931, 0.187, 0.133]], [0.699, [0.931, 0.187, 0.133]], [0.701, [0.928, 0.18, 0.131]], [0.703, [0.928, 0.18, 0.131]], [0.705, [0.925, 0.174, 0.129]], [0.706, [0.925, 0.174, 0.129]], [0.708, [0.922, 0.168, 0.127]], [0.71, [0.922, 0.168, 0.127]], [0.712, [0.919, 0.161, 0.126]], [0.714, [0.919, 0.161, 0.126]], [0.716, [0.916, 0.155, 0.124]], [0.718, [0.916, 0.155, 0.124]], [0.72, [0.912, 0.148, 0.122]], [0.722, [0.912, 0.148, 0.122]], [0.724, [0.909, 0.142, 0.121]], [0.726, [0.909, 0.142, 0.121]], [0.728, [0.906, 0.136, 0.119]], [0.73, [0.906, 0.136, 0.119]], [0.732, [0.903, 0.129, 0.117]], [0.734, [0.903, 0.129, 0.117]], [0.736, [0.9, 0.123, 0.115]], [0.738, [0.9, 0.123, 0.115]], [0.74, [0.897, 0.116, 0.114]], [0.742, [0.897, 0.116, 0.114]], [0.744, [0.894, 0.11, 0.112]], [0.746, [0.894, 0.11, 0.112]], [0.748, [0.891, 0.104, 0.11]], [0.75, [0.891, 0.104, 0.11]], [0.751, [0.887, 0.1, 0.111]], [0.753, [0.887, 0.1, 0.111]], [0.755, [0.882, 0.096, 0.112]], [0.757, [0.882, 0.096, 0.112]], [0.759, [0.877, 0.093, 0.113]], [0.761, [0.877, 0.093, 0.113]], [0.763, [0.873, 0.09, 0.114]], [0.765, [0.873, 0.09, 0.114]], [0.767, [0.868, 0.087, 0.116]], [0.769, [0.868, 0.087, 0.116]], [0.771, [0.863, 0.084, 0.117]], [0.773, [0.863, 0.084, 0.117]], [0.775, [0.859, 0.08, 0.118]], [0.777, [0.859, 0.08, 0.118]], [0.779, [0.854, 0.077, 0.119]], [0.781, [0.854, 0.077, 0.119]], [0.783, [0.849, 0.074, 0.121]], [0.785, [0.849, 0.074, 0.121]], [0.787, [0.845, 0.071, 0.122]], [0.789, [0.845, 0.071, 0.122]], [0.791, [0.84, 0.068, 0.123]], [0.793, [0.84, 0.068, 0.123]], [0.795, [0.835, 0.064, 0.124]], [0.796, [0.835, 0.064, 0.124]], [0.798, [0.831, 0.061, 0.125]], [0.8, [0.831, 0.061, 0.125]], [0.802, [0.826, 0.058, 0.127]], [0.804, [0.826, 0.058, 0.127]], [0.806, [0.821, 0.055, 0.128]], [0.808, [0.821, 0.055, 0.128]], [0.81, [0.817, 0.052, 0.129]], [0.812, [0.817, 0.052, 0.129]], [0.814, [0.812, 0.048, 0.13]], [0.816, [0.812, 0.048, 0.13]], [0.818, [0.807, 0.045, 0.132]], [0.82, [0.807, 0.045, 0.132]], [0.822, [0.803, 0.042, 0.133]], [0.824, [0.803, 0.042, 0.133]], [0.826, [0.798, 0.039, 0.134]], [0.828, [0.798, 0.039, 0.134]], [0.83, [0.793, 0.036, 0.135]], [0.832, [0.793, 0.036, 0.135]], [0.834, [0.789, 0.032, 0.137]], [0.836, [0.789, 0.032, 0.137]], [0.838, [0.784, 0.029, 0.138]], [0.84, [0.784, 0.029, 0.138]], [0.841, [0.779, 0.026, 0.139]], [0.843, [0.779, 0.026, 0.139]], [0.845, [0.774, 0.023, 0.14]], [0.847, [0.774, 0.023, 0.14]], [0.849, [0.77, 0.02, 0.141]], [0.851, [0.77, 0.02, 0.141]], [0.853, [0.765, 0.016, 0.143]], [0.855, [0.765, 0.016, 0.143]], [0.857, [0.76, 0.013, 0.144]], [0.859, [0.76, 0.013, 0.144]], [0.861, [0.756, 0.01, 0.145]], [0.863, [0.756, 0.01, 0.145]], [0.865, [0.751, 0.007, 0.146]], [0.867, [0.751, 0.007, 0.146]], [0.869, [0.746, 0.004, 0.148]], [0.871, [0.746, 0.004, 0.148]], [0.873, [0.742, 0.0, 0.149]], [0.875, [0.742, 0.0, 0.149]], [0.877, [0.735, 0.0, 0.149]], [0.879, [0.735, 0.0, 0.149]], [0.881, [0.727, 0.0, 0.149]], [0.883, [0.727, 0.0, 0.149]], [0.885, [0.72, 0.0, 0.149]], [0.886, [0.72, 0.0, 0.149]], [0.888, [0.712, 0.0, 0.149]], [0.89, [0.712, 0.0, 0.149]], [0.892, [0.705, 0.0, 0.149]], [0.894, [0.705, 0.0, 0.149]], [0.896, [0.697, 0.0, 0.149]], [0.898, [0.697, 0.0, 0.149]], [0.9, [0.69, 0.0, 0.149]], [0.902, [0.69, 0.0, 0.149]], [0.904, [0.682, 0.0, 0.149]], [0.906, [0.682, 0.0, 0.149]], [0.908, [0.675, 0.0, 0.149]], [0.91, [0.675, 0.0, 0.149]], [0.912, [0.667, 0.0, 0.149]], [0.914, [0.667, 0.0, 0.149]], [0.916, [0.66, 0.0, 0.149]], [0.918, [0.66, 0.0, 0.149]], [0.92, [0.652, 0.0, 0.149]], [0.922, [0.652, 0.0, 0.149]], [0.924, [0.645, 0.0, 0.149]], [0.926, [0.645, 0.0, 0.149]], [0.928, [0.637, 0.0, 0.149]], [0.93, [0.637, 0.0, 0.149]], [0.932, [0.63, 0.0, 0.149]], [0.933, [0.63, 0.0, 0.149]], [0.935, [0.622, 0.0, 0.149]], [0.937, [0.622, 0.0, 0.149]], [0.939, [0.615, 0.0, 0.149]], [0.941, [0.615, 0.0, 0.149]], [0.943, [0.607, 0.0, 0.149]], [0.945, [0.607, 0.0, 0.149]], [0.947, [0.6, 0.0, 0.149]], [0.949, [0.6, 0.0, 0.149]], [0.951, [0.592, 0.0, 0.149]], [0.953, [0.592, 0.0, 0.149]], [0.955, [0.585, 0.0, 0.149]], [0.957, [0.585, 0.0, 0.149]], [0.959, [0.577, 0.0, 0.149]], [0.961, [0.577, 0.0, 0.149]], [0.963, [0.57, 0.0, 0.149]], [0.965, [0.57, 0.0, 0.149]], [0.967, [0.562, 0.0, 0.149]], [0.969, [0.562, 0.0, 0.149]], [0.971, [0.554, 0.0, 0.149]], [0.973, [0.554, 0.0, 0.149]], [0.975, [0.547, 0.0, 0.149]], [0.977, [0.547, 0.0, 0.149]], [0.978, [0.539, 0.0, 0.149]], [0.98, [0.539, 0.0, 0.149]], [0.982, [0.532, 0.0, 0.149]], [0.984, [0.532, 0.0, 0.149]], [0.986, [0.524, 0.0, 0.149]], [0.988, [0.524, 0.0, 0.149]], [0.99, [0.517, 0.0, 0.149]], [0.992, [0.517, 0.0, 0.149]], [0.994, [0.509, 0.0, 0.149]], [0.996, [0.509, 0.0, 0.149]], [0.998, [0.502, 0.0, 0.149]], [1.0, [0.502, 0.0, 0.149]]]
}), _defineProperty(_vislibColorMaps, ColorSchemas.GreenToRed, {
  id: ColorSchemas.GreenToRed,
  label: _i18n.i18n.translate('common.ui.vislib.colormaps.greenToRedText', {
    defaultMessage: 'Green to Red'
  }),
  value: [[0, [0, 0.408, 0.216]], [0.002, [0, 0.408, 0.216]], [0.004, [0.004, 0.415, 0.22]], [0.006, [0.004, 0.415, 0.22]], [0.008, [0.008, 0.423, 0.223]], [0.01, [0.008, 0.423, 0.223]], [0.012, [0.012, 0.43, 0.227]], [0.014, [0.012, 0.43, 0.227]], [0.016, [0.016, 0.437, 0.231]], [0.018, [0.016, 0.437, 0.231]], [0.02, [0.02, 0.445, 0.235]], [0.022, [0.02, 0.445, 0.235]], [0.023, [0.024, 0.452, 0.239]], [0.025, [0.024, 0.452, 0.239]], [0.027, [0.028, 0.46, 0.243]], [0.029, [0.028, 0.46, 0.243]], [0.031, [0.032, 0.467, 0.246]], [0.033, [0.032, 0.467, 0.246]], [0.035, [0.036, 0.474, 0.25]], [0.037, [0.036, 0.474, 0.25]], [0.039, [0.04, 0.482, 0.254]], [0.041, [0.04, 0.482, 0.254]], [0.043, [0.044, 0.489, 0.258]], [0.045, [0.044, 0.489, 0.258]], [0.047, [0.048, 0.496, 0.262]], [0.049, [0.048, 0.496, 0.262]], [0.051, [0.052, 0.504, 0.266]], [0.053, [0.052, 0.504, 0.266]], [0.055, [0.056, 0.511, 0.27]], [0.057, [0.056, 0.511, 0.27]], [0.059, [0.06, 0.519, 0.273]], [0.061, [0.06, 0.519, 0.273]], [0.063, [0.064, 0.526, 0.277]], [0.065, [0.064, 0.526, 0.277]], [0.067, [0.068, 0.533, 0.281]], [0.068, [0.068, 0.533, 0.281]], [0.07, [0.072, 0.541, 0.285]], [0.072, [0.072, 0.541, 0.285]], [0.074, [0.076, 0.548, 0.289]], [0.076, [0.076, 0.548, 0.289]], [0.078, [0.08, 0.555, 0.293]], [0.08, [0.08, 0.555, 0.293]], [0.082, [0.084, 0.563, 0.296]], [0.084, [0.084, 0.563, 0.296]], [0.086, [0.088, 0.57, 0.3]], [0.088, [0.088, 0.57, 0.3]], [0.09, [0.092, 0.578, 0.304]], [0.092, [0.092, 0.578, 0.304]], [0.094, [0.096, 0.585, 0.308]], [0.096, [0.096, 0.585, 0.308]], [0.098, [0.1, 0.592, 0.312]], [0.1, [0.1, 0.592, 0.312]], [0.102, [0.108, 0.599, 0.315]], [0.104, [0.108, 0.599, 0.315]], [0.106, [0.119, 0.605, 0.318]], [0.108, [0.119, 0.605, 0.318]], [0.11, [0.131, 0.61, 0.321]], [0.112, [0.131, 0.61, 0.321]], [0.114, [0.143, 0.616, 0.324]], [0.115, [0.143, 0.616, 0.324]], [0.117, [0.155, 0.622, 0.327]], [0.119, [0.155, 0.622, 0.327]], [0.121, [0.166, 0.627, 0.33]], [0.123, [0.166, 0.627, 0.33]], [0.125, [0.178, 0.633, 0.333]], [0.127, [0.178, 0.633, 0.333]], [0.129, [0.19, 0.639, 0.336]], [0.131, [0.19, 0.639, 0.336]], [0.133, [0.201, 0.644, 0.339]], [0.135, [0.201, 0.644, 0.339]], [0.137, [0.213, 0.65, 0.341]], [0.139, [0.213, 0.65, 0.341]], [0.141, [0.225, 0.656, 0.344]], [0.143, [0.225, 0.656, 0.344]], [0.145, [0.236, 0.662, 0.347]], [0.147, [0.236, 0.662, 0.347]], [0.149, [0.248, 0.667, 0.35]], [0.151, [0.248, 0.667, 0.35]], [0.153, [0.26, 0.673, 0.353]], [0.155, [0.26, 0.673, 0.353]], [0.157, [0.271, 0.679, 0.356]], [0.159, [0.271, 0.679, 0.356]], [0.16, [0.283, 0.684, 0.359]], [0.162, [0.283, 0.684, 0.359]], [0.164, [0.295, 0.69, 0.362]], [0.166, [0.295, 0.69, 0.362]], [0.168, [0.306, 0.696, 0.365]], [0.17, [0.306, 0.696, 0.365]], [0.172, [0.318, 0.701, 0.368]], [0.174, [0.318, 0.701, 0.368]], [0.176, [0.33, 0.707, 0.371]], [0.178, [0.33, 0.707, 0.371]], [0.18, [0.342, 0.713, 0.374]], [0.182, [0.342, 0.713, 0.374]], [0.184, [0.353, 0.718, 0.377]], [0.186, [0.353, 0.718, 0.377]], [0.188, [0.365, 0.724, 0.379]], [0.19, [0.365, 0.724, 0.379]], [0.192, [0.377, 0.73, 0.382]], [0.194, [0.377, 0.73, 0.382]], [0.196, [0.388, 0.735, 0.385]], [0.198, [0.388, 0.735, 0.385]], [0.2, [0.4, 0.741, 0.388]], [0.202, [0.4, 0.741, 0.388]], [0.204, [0.41, 0.745, 0.389]], [0.205, [0.41, 0.745, 0.389]], [0.207, [0.42, 0.75, 0.39]], [0.209, [0.42, 0.75, 0.39]], [0.211, [0.43, 0.754, 0.391]], [0.213, [0.43, 0.754, 0.391]], [0.215, [0.439, 0.758, 0.393]], [0.217, [0.439, 0.758, 0.393]], [0.219, [0.449, 0.763, 0.394]], [0.221, [0.449, 0.763, 0.394]], [0.223, [0.459, 0.767, 0.395]], [0.225, [0.459, 0.767, 0.395]], [0.227, [0.469, 0.771, 0.396]], [0.229, [0.469, 0.771, 0.396]], [0.231, [0.479, 0.776, 0.397]], [0.233, [0.479, 0.776, 0.397]], [0.235, [0.489, 0.78, 0.398]], [0.237, [0.489, 0.78, 0.398]], [0.239, [0.498, 0.784, 0.399]], [0.241, [0.498, 0.784, 0.399]], [0.243, [0.508, 0.789, 0.4]], [0.245, [0.508, 0.789, 0.4]], [0.247, [0.518, 0.793, 0.401]], [0.249, [0.518, 0.793, 0.401]], [0.25, [0.528, 0.797, 0.402]], [0.252, [0.528, 0.797, 0.402]], [0.254, [0.538, 0.801, 0.403]], [0.256, [0.538, 0.801, 0.403]], [0.258, [0.548, 0.806, 0.404]], [0.26, [0.548, 0.806, 0.404]], [0.262, [0.557, 0.81, 0.405]], [0.264, [0.557, 0.81, 0.405]], [0.266, [0.567, 0.814, 0.407]], [0.268, [0.567, 0.814, 0.407]], [0.27, [0.577, 0.819, 0.408]], [0.272, [0.577, 0.819, 0.408]], [0.274, [0.587, 0.823, 0.409]], [0.276, [0.587, 0.823, 0.409]], [0.278, [0.597, 0.827, 0.41]], [0.28, [0.597, 0.827, 0.41]], [0.282, [0.607, 0.832, 0.411]], [0.284, [0.607, 0.832, 0.411]], [0.286, [0.617, 0.836, 0.412]], [0.288, [0.617, 0.836, 0.412]], [0.29, [0.626, 0.84, 0.413]], [0.292, [0.626, 0.84, 0.413]], [0.294, [0.636, 0.845, 0.414]], [0.295, [0.636, 0.845, 0.414]], [0.297, [0.646, 0.849, 0.415]], [0.299, [0.646, 0.849, 0.415]], [0.301, [0.655, 0.853, 0.418]], [0.303, [0.655, 0.853, 0.418]], [0.305, [0.663, 0.856, 0.423]], [0.307, [0.663, 0.856, 0.423]], [0.309, [0.671, 0.859, 0.428]], [0.311, [0.671, 0.859, 0.428]], [0.313, [0.678, 0.863, 0.433]], [0.315, [0.678, 0.863, 0.433]], [0.317, [0.686, 0.866, 0.439]], [0.319, [0.686, 0.866, 0.439]], [0.321, [0.694, 0.87, 0.444]], [0.323, [0.694, 0.87, 0.444]], [0.325, [0.702, 0.873, 0.449]], [0.327, [0.702, 0.873, 0.449]], [0.329, [0.71, 0.876, 0.454]], [0.331, [0.71, 0.876, 0.454]], [0.333, [0.718, 0.88, 0.459]], [0.335, [0.718, 0.88, 0.459]], [0.337, [0.725, 0.883, 0.464]], [0.339, [0.725, 0.883, 0.464]], [0.341, [0.733, 0.887, 0.469]], [0.342, [0.733, 0.887, 0.469]], [0.344, [0.741, 0.89, 0.474]], [0.346, [0.741, 0.89, 0.474]], [0.348, [0.749, 0.893, 0.479]], [0.35, [0.749, 0.893, 0.479]], [0.352, [0.757, 0.897, 0.484]], [0.354, [0.757, 0.897, 0.484]], [0.356, [0.765, 0.9, 0.489]], [0.358, [0.765, 0.9, 0.489]], [0.36, [0.773, 0.903, 0.494]], [0.362, [0.773, 0.903, 0.494]], [0.364, [0.78, 0.907, 0.499]], [0.366, [0.78, 0.907, 0.499]], [0.368, [0.788, 0.91, 0.504]], [0.37, [0.788, 0.91, 0.504]], [0.372, [0.796, 0.914, 0.51]], [0.374, [0.796, 0.914, 0.51]], [0.376, [0.804, 0.917, 0.515]], [0.378, [0.804, 0.917, 0.515]], [0.38, [0.812, 0.92, 0.52]], [0.382, [0.812, 0.92, 0.52]], [0.384, [0.82, 0.924, 0.525]], [0.386, [0.82, 0.924, 0.525]], [0.387, [0.827, 0.927, 0.53]], [0.389, [0.827, 0.927, 0.53]], [0.391, [0.835, 0.93, 0.535]], [0.393, [0.835, 0.93, 0.535]], [0.395, [0.843, 0.934, 0.54]], [0.397, [0.843, 0.934, 0.54]], [0.399, [0.851, 0.937, 0.545]], [0.401, [0.851, 0.937, 0.545]], [0.403, [0.857, 0.94, 0.553]], [0.405, [0.857, 0.94, 0.553]], [0.407, [0.863, 0.942, 0.561]], [0.409, [0.863, 0.942, 0.561]], [0.411, [0.869, 0.945, 0.569]], [0.413, [0.869, 0.945, 0.569]], [0.415, [0.874, 0.947, 0.577]], [0.417, [0.874, 0.947, 0.577]], [0.419, [0.88, 0.95, 0.585]], [0.421, [0.88, 0.95, 0.585]], [0.423, [0.886, 0.952, 0.593]], [0.425, [0.886, 0.952, 0.593]], [0.427, [0.892, 0.954, 0.601]], [0.429, [0.892, 0.954, 0.601]], [0.431, [0.898, 0.957, 0.609]], [0.432, [0.898, 0.957, 0.609]], [0.434, [0.904, 0.959, 0.617]], [0.436, [0.904, 0.959, 0.617]], [0.438, [0.909, 0.962, 0.625]], [0.44, [0.909, 0.962, 0.625]], [0.442, [0.915, 0.964, 0.633]], [0.444, [0.915, 0.964, 0.633]], [0.446, [0.921, 0.967, 0.641]], [0.448, [0.921, 0.967, 0.641]], [0.45, [0.927, 0.969, 0.649]], [0.452, [0.927, 0.969, 0.649]], [0.454, [0.933, 0.972, 0.657]], [0.456, [0.933, 0.972, 0.657]], [0.458, [0.939, 0.974, 0.665]], [0.46, [0.939, 0.974, 0.665]], [0.462, [0.944, 0.977, 0.673]], [0.464, [0.944, 0.977, 0.673]], [0.466, [0.95, 0.979, 0.681]], [0.468, [0.95, 0.979, 0.681]], [0.47, [0.956, 0.982, 0.689]], [0.472, [0.956, 0.982, 0.689]], [0.474, [0.962, 0.984, 0.697]], [0.476, [0.962, 0.984, 0.697]], [0.477, [0.968, 0.986, 0.705]], [0.479, [0.968, 0.986, 0.705]], [0.481, [0.974, 0.989, 0.713]], [0.483, [0.974, 0.989, 0.713]], [0.485, [0.98, 0.991, 0.721]], [0.487, [0.98, 0.991, 0.721]], [0.489, [0.985, 0.994, 0.729]], [0.491, [0.985, 0.994, 0.729]], [0.493, [0.991, 0.996, 0.737]], [0.495, [0.991, 0.996, 0.737]], [0.497, [0.997, 0.999, 0.745]], [0.499, [0.997, 0.999, 0.745]], [0.501, [1, 0.998, 0.745]], [0.503, [1, 0.998, 0.745]], [0.505, [1, 0.993, 0.737]], [0.507, [1, 0.993, 0.737]], [0.509, [1, 0.988, 0.729]], [0.511, [1, 0.988, 0.729]], [0.513, [0.999, 0.983, 0.721]], [0.515, [0.999, 0.983, 0.721]], [0.517, [0.999, 0.979, 0.713]], [0.519, [0.999, 0.979, 0.713]], [0.521, [0.999, 0.974, 0.705]], [0.523, [0.999, 0.974, 0.705]], [0.524, [0.999, 0.969, 0.697]], [0.526, [0.999, 0.969, 0.697]], [0.528, [0.999, 0.964, 0.689]], [0.53, [0.999, 0.964, 0.689]], [0.532, [0.999, 0.959, 0.681]], [0.534, [0.999, 0.959, 0.681]], [0.536, [0.999, 0.955, 0.673]], [0.538, [0.999, 0.955, 0.673]], [0.54, [0.998, 0.95, 0.665]], [0.542, [0.998, 0.95, 0.665]], [0.544, [0.998, 0.945, 0.657]], [0.546, [0.998, 0.945, 0.657]], [0.548, [0.998, 0.94, 0.649]], [0.55, [0.998, 0.94, 0.649]], [0.552, [0.998, 0.936, 0.641]], [0.554, [0.998, 0.936, 0.641]], [0.556, [0.998, 0.931, 0.633]], [0.558, [0.998, 0.931, 0.633]], [0.56, [0.998, 0.926, 0.625]], [0.562, [0.998, 0.926, 0.625]], [0.564, [0.997, 0.921, 0.617]], [0.566, [0.997, 0.921, 0.617]], [0.568, [0.997, 0.917, 0.609]], [0.569, [0.997, 0.917, 0.609]], [0.571, [0.997, 0.912, 0.601]], [0.573, [0.997, 0.912, 0.601]], [0.575, [0.997, 0.907, 0.593]], [0.577, [0.997, 0.907, 0.593]], [0.579, [0.997, 0.902, 0.585]], [0.581, [0.997, 0.902, 0.585]], [0.583, [0.997, 0.898, 0.577]], [0.585, [0.997, 0.898, 0.577]], [0.587, [0.997, 0.893, 0.569]], [0.589, [0.997, 0.893, 0.569]], [0.591, [0.996, 0.888, 0.561]], [0.593, [0.996, 0.888, 0.561]], [0.595, [0.996, 0.883, 0.553]], [0.597, [0.996, 0.883, 0.553]], [0.599, [0.996, 0.878, 0.545]], [0.601, [0.996, 0.878, 0.545]], [0.603, [0.996, 0.871, 0.539]], [0.605, [0.996, 0.871, 0.539]], [0.607, [0.996, 0.863, 0.532]], [0.609, [0.996, 0.863, 0.532]], [0.611, [0.996, 0.855, 0.526]], [0.613, [0.996, 0.855, 0.526]], [0.614, [0.995, 0.848, 0.519]], [0.616, [0.995, 0.848, 0.519]], [0.618, [0.995, 0.84, 0.513]], [0.62, [0.995, 0.84, 0.513]], [0.622, [0.995, 0.832, 0.506]], [0.624, [0.995, 0.832, 0.506]], [0.626, [0.995, 0.825, 0.5]], [0.628, [0.995, 0.825, 0.5]], [0.63, [0.995, 0.817, 0.493]], [0.632, [0.995, 0.817, 0.493]], [0.634, [0.995, 0.809, 0.487]], [0.636, [0.995, 0.809, 0.487]], [0.638, [0.995, 0.802, 0.481]], [0.64, [0.995, 0.802, 0.481]], [0.642, [0.994, 0.794, 0.474]], [0.644, [0.994, 0.794, 0.474]], [0.646, [0.994, 0.786, 0.468]], [0.648, [0.994, 0.786, 0.468]], [0.65, [0.994, 0.778, 0.461]], [0.652, [0.994, 0.778, 0.461]], [0.654, [0.994, 0.771, 0.455]], [0.656, [0.994, 0.771, 0.455]], [0.658, [0.994, 0.763, 0.448]], [0.659, [0.994, 0.763, 0.448]], [0.661, [0.994, 0.755, 0.442]], [0.663, [0.994, 0.755, 0.442]], [0.665, [0.993, 0.748, 0.435]], [0.667, [0.993, 0.748, 0.435]], [0.669, [0.993, 0.74, 0.429]], [0.671, [0.993, 0.74, 0.429]], [0.673, [0.993, 0.732, 0.422]], [0.675, [0.993, 0.732, 0.422]], [0.677, [0.993, 0.725, 0.416]], [0.679, [0.993, 0.725, 0.416]], [0.681, [0.993, 0.717, 0.409]], [0.683, [0.993, 0.717, 0.409]], [0.685, [0.993, 0.709, 0.403]], [0.687, [0.993, 0.709, 0.403]], [0.689, [0.993, 0.702, 0.397]], [0.691, [0.993, 0.702, 0.397]], [0.693, [0.992, 0.694, 0.39]], [0.695, [0.992, 0.694, 0.39]], [0.697, [0.992, 0.686, 0.384]], [0.699, [0.992, 0.686, 0.384]], [0.701, [0.991, 0.677, 0.378]], [0.703, [0.991, 0.677, 0.378]], [0.705, [0.99, 0.667, 0.373]], [0.706, [0.99, 0.667, 0.373]], [0.708, [0.989, 0.657, 0.369]], [0.71, [0.989, 0.657, 0.369]], [0.712, [0.987, 0.647, 0.364]], [0.714, [0.987, 0.647, 0.364]], [0.716, [0.986, 0.637, 0.36]], [0.718, [0.986, 0.637, 0.36]], [0.72, [0.985, 0.627, 0.355]], [0.722, [0.985, 0.627, 0.355]], [0.724, [0.983, 0.617, 0.35]], [0.726, [0.983, 0.617, 0.35]], [0.728, [0.982, 0.607, 0.346]], [0.73, [0.982, 0.607, 0.346]], [0.732, [0.98, 0.597, 0.341]], [0.734, [0.98, 0.597, 0.341]], [0.736, [0.979, 0.587, 0.337]], [0.738, [0.979, 0.587, 0.337]], [0.74, [0.978, 0.577, 0.332]], [0.742, [0.978, 0.577, 0.332]], [0.744, [0.976, 0.567, 0.327]], [0.746, [0.976, 0.567, 0.327]], [0.748, [0.975, 0.557, 0.323]], [0.75, [0.975, 0.557, 0.323]], [0.751, [0.973, 0.547, 0.318]], [0.753, [0.973, 0.547, 0.318]], [0.755, [0.972, 0.537, 0.313]], [0.757, [0.972, 0.537, 0.313]], [0.759, [0.971, 0.527, 0.309]], [0.761, [0.971, 0.527, 0.309]], [0.763, [0.969, 0.517, 0.304]], [0.765, [0.969, 0.517, 0.304]], [0.767, [0.968, 0.507, 0.3]], [0.769, [0.968, 0.507, 0.3]], [0.771, [0.967, 0.497, 0.295]], [0.773, [0.967, 0.497, 0.295]], [0.775, [0.965, 0.487, 0.29]], [0.777, [0.965, 0.487, 0.29]], [0.779, [0.964, 0.477, 0.286]], [0.781, [0.964, 0.477, 0.286]], [0.783, [0.962, 0.467, 0.281]], [0.785, [0.962, 0.467, 0.281]], [0.787, [0.961, 0.457, 0.277]], [0.789, [0.961, 0.457, 0.277]], [0.791, [0.96, 0.447, 0.272]], [0.793, [0.96, 0.447, 0.272]], [0.795, [0.958, 0.437, 0.267]], [0.796, [0.958, 0.437, 0.267]], [0.798, [0.957, 0.427, 0.263]], [0.8, [0.957, 0.427, 0.263]], [0.802, [0.952, 0.418, 0.258]], [0.804, [0.952, 0.418, 0.258]], [0.806, [0.948, 0.409, 0.254]], [0.808, [0.948, 0.409, 0.254]], [0.81, [0.943, 0.399, 0.25]], [0.812, [0.943, 0.399, 0.25]], [0.814, [0.939, 0.39, 0.246]], [0.816, [0.939, 0.39, 0.246]], [0.818, [0.935, 0.381, 0.241]], [0.82, [0.935, 0.381, 0.241]], [0.822, [0.93, 0.371, 0.237]], [0.824, [0.93, 0.371, 0.237]], [0.826, [0.926, 0.362, 0.233]], [0.828, [0.926, 0.362, 0.233]], [0.83, [0.921, 0.352, 0.228]], [0.832, [0.921, 0.352, 0.228]], [0.834, [0.917, 0.343, 0.224]], [0.836, [0.917, 0.343, 0.224]], [0.838, [0.912, 0.334, 0.22]], [0.84, [0.912, 0.334, 0.22]], [0.841, [0.908, 0.324, 0.215]], [0.843, [0.908, 0.324, 0.215]], [0.845, [0.903, 0.315, 0.211]], [0.847, [0.903, 0.315, 0.211]], [0.849, [0.899, 0.305, 0.207]], [0.851, [0.899, 0.305, 0.207]], [0.853, [0.894, 0.296, 0.202]], [0.855, [0.894, 0.296, 0.202]], [0.857, [0.89, 0.287, 0.198]], [0.859, [0.89, 0.287, 0.198]], [0.861, [0.886, 0.277, 0.194]], [0.863, [0.886, 0.277, 0.194]], [0.865, [0.881, 0.268, 0.19]], [0.867, [0.881, 0.268, 0.19]], [0.869, [0.877, 0.259, 0.185]], [0.871, [0.877, 0.259, 0.185]], [0.873, [0.872, 0.249, 0.181]], [0.875, [0.872, 0.249, 0.181]], [0.877, [0.868, 0.24, 0.177]], [0.879, [0.868, 0.24, 0.177]], [0.881, [0.863, 0.23, 0.172]], [0.883, [0.863, 0.23, 0.172]], [0.885, [0.859, 0.221, 0.168]], [0.886, [0.859, 0.221, 0.168]], [0.888, [0.854, 0.212, 0.164]], [0.89, [0.854, 0.212, 0.164]], [0.892, [0.85, 0.202, 0.159]], [0.894, [0.85, 0.202, 0.159]], [0.896, [0.845, 0.193, 0.155]], [0.898, [0.845, 0.193, 0.155]], [0.9, [0.839, 0.185, 0.153]], [0.902, [0.839, 0.185, 0.153]], [0.904, [0.832, 0.177, 0.153]], [0.906, [0.832, 0.177, 0.153]], [0.908, [0.824, 0.17, 0.153]], [0.91, [0.824, 0.17, 0.153]], [0.912, [0.816, 0.162, 0.152]], [0.914, [0.816, 0.162, 0.152]], [0.916, [0.809, 0.155, 0.152]], [0.918, [0.809, 0.155, 0.152]], [0.92, [0.801, 0.148, 0.152]], [0.922, [0.801, 0.148, 0.152]], [0.924, [0.793, 0.14, 0.152]], [0.926, [0.793, 0.14, 0.152]], [0.928, [0.785, 0.133, 0.152]], [0.93, [0.785, 0.133, 0.152]], [0.932, [0.778, 0.125, 0.152]], [0.933, [0.778, 0.125, 0.152]], [0.935, [0.77, 0.118, 0.151]], [0.937, [0.77, 0.118, 0.151]], [0.939, [0.762, 0.111, 0.151]], [0.941, [0.762, 0.111, 0.151]], [0.943, [0.755, 0.103, 0.151]], [0.945, [0.755, 0.103, 0.151]], [0.947, [0.747, 0.096, 0.151]], [0.949, [0.747, 0.096, 0.151]], [0.951, [0.739, 0.089, 0.151]], [0.953, [0.739, 0.089, 0.151]], [0.955, [0.732, 0.081, 0.151]], [0.957, [0.732, 0.081, 0.151]], [0.959, [0.724, 0.074, 0.151]], [0.961, [0.724, 0.074, 0.151]], [0.963, [0.716, 0.066, 0.15]], [0.965, [0.716, 0.066, 0.15]], [0.967, [0.709, 0.059, 0.15]], [0.969, [0.709, 0.059, 0.15]], [0.971, [0.701, 0.052, 0.15]], [0.973, [0.701, 0.052, 0.15]], [0.975, [0.693, 0.044, 0.15]], [0.977, [0.693, 0.044, 0.15]], [0.978, [0.686, 0.037, 0.15]], [0.98, [0.686, 0.037, 0.15]], [0.982, [0.678, 0.03, 0.15]], [0.984, [0.678, 0.03, 0.15]], [0.986, [0.67, 0.022, 0.149]], [0.988, [0.67, 0.022, 0.149]], [0.99, [0.662, 0.015, 0.149]], [0.992, [0.662, 0.015, 0.149]], [0.994, [0.655, 0.007, 0.149]], [0.996, [0.655, 0.007, 0.149]], [0.998, [0.647, 0, 0.149]], [1, [0.647, 0, 0.149]]]
}), _vislibColorMaps);
exports.vislibColorMaps = vislibColorMaps;
var colorSchemas = Object.values(vislibColorMaps).map(function (_ref) {
  var id = _ref.id,
      label = _ref.label;
  return {
    value: id,
    text: label
  };
});
exports.colorSchemas = colorSchemas;