import { constant, constIdentity } from './function';
export const URI = 'State';
/**
 * @since 1.0.0
 */
export class State {
    constructor(run) {
        this.run = run;
    }
    eval(s) {
        return this.run(s)[0];
    }
    exec(s) {
        return this.run(s)[1];
    }
    map(f) {
        return new State(s => {
            const [a, s1] = this.run(s);
            return [f(a), s1];
        });
    }
    ap(fab) {
        return fab.chain(f => this.map(f)); // <= derived
    }
    /**
     * Flipped version of `ap`
     */
    ap_(fb) {
        return fb.ap(this);
    }
    /**
     * Combine two effectful actions, keeping only the result of the first
     * @since 1.7.0
     */
    applyFirst(fb) {
        return fb.ap(this.map(constant));
    }
    /**
     * Combine two effectful actions, keeping only the result of the second
     * @since 1.7.0
     */
    applySecond(fb) {
        return fb.ap(this.map(constIdentity));
    }
    chain(f) {
        return new State(s => {
            const [a, s1] = this.run(s);
            return f(a).run(s1);
        });
    }
}
const map = (fa, f) => {
    return fa.map(f);
};
const of = (a) => {
    return new State(s => [a, s]);
};
const ap = (fab, fa) => {
    return fa.ap(fab);
};
const chain = (fa, f) => {
    return fa.chain(f);
};
/**
 * Get the current state
 *
 * @since 1.0.0
 */
export const get = () => {
    return new State(s => [s, s]);
};
/**
 * Set the state
 *
 * @since 1.0.0
 */
export const put = (s) => {
    return new State(() => [undefined, s]);
};
/**
 * Modify the state by applying a function to the current state
 *
 * @since 1.0.0
 */
export const modify = (f) => {
    return new State(s => [undefined, f(s)]);
};
/**
 * Get a value which depends on the current state
 *
 * @since 1.0.0
 */
export const gets = (f) => {
    return new State(s => [f(s), s]);
};
/**
 * @since 1.0.0
 */
export const state = {
    URI,
    map,
    of,
    ap,
    chain
};
