"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var mobx_react_1 = require("mobx-react");
var theme_1 = require("../utils/themes/theme");
var interactions_1 = require("../chart_types/xy_chart/utils/interactions");
var light_theme_1 = require("../utils/themes/light_theme");
exports.DEFAULT_TOOLTIP_TYPE = interactions_1.TooltipType.VerticalCursor;
exports.DEFAULT_TOOLTIP_SNAP = true;
function isTooltipProps(config) {
    return typeof config === 'object';
}
function isTooltipType(config) {
    return typeof config === 'string';
}
function getTheme(baseTheme, theme) {
    var base = baseTheme ? baseTheme : light_theme_1.LIGHT_THEME;
    if (Array.isArray(theme)) {
        var _a = __read(theme), firstTheme = _a[0], axillaryThemes = _a.slice(1);
        return theme_1.mergeWithDefaultTheme(firstTheme, base, axillaryThemes);
    }
    return theme ? theme_1.mergeWithDefaultTheme(theme, base) : base;
}
function updateChartStore(props) {
    var chartStore = props.chartStore, theme = props.theme, baseTheme = props.baseTheme, rotation = props.rotation, rendering = props.rendering, animateData = props.animateData, showLegend = props.showLegend, tooltip = props.tooltip, legendPosition = props.legendPosition, showLegendDisplayValue = props.showLegendDisplayValue, onElementClick = props.onElementClick, onElementOver = props.onElementOver, onElementOut = props.onElementOut, onBrushEnd = props.onBrushEnd, onLegendItemOver = props.onLegendItemOver, onLegendItemOut = props.onLegendItemOut, onLegendItemClick = props.onLegendItemClick, onLegendItemMinusClick = props.onLegendItemMinusClick, onLegendItemPlusClick = props.onLegendItemPlusClick, onRenderChange = props.onRenderChange, onCursorUpdate = props.onCursorUpdate, debug = props.debug, xDomain = props.xDomain, resizeDebounce = props.resizeDebounce;
    if (!chartStore) {
        return;
    }
    chartStore.chartTheme = getTheme(baseTheme, theme);
    chartStore.chartRotation = rotation;
    chartStore.chartRendering = rendering;
    chartStore.animateData = animateData;
    chartStore.debug = debug;
    chartStore.resizeDebounce = resizeDebounce;
    if (tooltip && isTooltipProps(tooltip)) {
        var type = tooltip.type, snap = tooltip.snap, headerFormatter = tooltip.headerFormatter;
        chartStore.tooltipType.set(type);
        chartStore.tooltipSnap.set(snap);
        chartStore.tooltipHeaderFormatter = headerFormatter;
    }
    else if (tooltip && isTooltipType(tooltip)) {
        chartStore.tooltipType.set(tooltip);
    }
    chartStore.setShowLegend(showLegend);
    if (legendPosition) {
        chartStore.legendPosition.set(legendPosition);
    }
    chartStore.showLegendDisplayValue.set(showLegendDisplayValue);
    chartStore.customXDomain = xDomain;
    if (onElementOver) {
        chartStore.setOnElementOverListener(onElementOver);
    }
    if (onElementClick) {
        chartStore.setOnElementClickListener(onElementClick);
    }
    if (onElementOut) {
        chartStore.setOnElementOutListener(onElementOut);
    }
    if (onBrushEnd) {
        chartStore.setOnBrushEndListener(onBrushEnd);
    }
    if (onLegendItemOver) {
        chartStore.setOnLegendItemOverListener(onLegendItemOver);
    }
    if (onLegendItemOut) {
        chartStore.setOnLegendItemOutListener(onLegendItemOut);
    }
    if (onLegendItemClick) {
        chartStore.setOnLegendItemClickListener(onLegendItemClick);
    }
    if (onLegendItemPlusClick) {
        chartStore.setOnLegendItemPlusClickListener(onLegendItemPlusClick);
    }
    if (onLegendItemMinusClick) {
        chartStore.setOnLegendItemMinusClickListener(onLegendItemMinusClick);
    }
    if (onCursorUpdate) {
        chartStore.setOnCursorUpdateListener(onCursorUpdate);
    }
    if (onRenderChange) {
        chartStore.setOnRenderChangeListener(onRenderChange);
    }
}
var SettingsComponent = /** @class */ (function (_super) {
    __extends(SettingsComponent, _super);
    function SettingsComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SettingsComponent.prototype.componentDidMount = function () {
        updateChartStore(this.props);
    };
    SettingsComponent.prototype.componentDidUpdate = function () {
        updateChartStore(this.props);
    };
    SettingsComponent.prototype.render = function () {
        return null;
    };
    SettingsComponent.defaultProps = {
        rendering: 'canvas',
        rotation: 0,
        animateData: true,
        showLegend: false,
        resizeDebounce: 10,
        debug: false,
        tooltip: {
            type: exports.DEFAULT_TOOLTIP_TYPE,
            snap: exports.DEFAULT_TOOLTIP_SNAP,
        },
        showLegendDisplayValue: true,
    };
    return SettingsComponent;
}(react_1.PureComponent));
exports.SettingsComponent = SettingsComponent;
exports.Settings = mobx_react_1.inject('chartStore')(SettingsComponent);
//# sourceMappingURL=settings.js.map