/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.jboss.marshalling.util.IdentityIntMap;

@Immutable
public class EnumSetExternalizer
extends AbstractExternalizer<Set> {
    private static final int UNKNOWN_ENUM_SET = 0;
    private static final int ENUM_SET = 1;
    private static final int REGULAR_ENUM_SET = 2;
    private static final int JUMBO_ENUM_SET = 3;
    private static final int MINI_ENUM_SET = 4;
    private static final int HUGE_ENUM_SET = 5;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(3);

    public EnumSetExternalizer() {
        this.numbers.put(EnumSet.class, 1);
        this.addEnumSetClass(this.getRegularEnumSetClass(), 2);
        this.addEnumSetClass(this.getJumboEnumSetClass(), 3);
        this.addEnumSetClass(this.getMiniEnumSetClass(), 4);
        this.addEnumSetClass(this.getHugeEnumSetClass(), 5);
    }

    private void addEnumSetClass(Class<EnumSet> clazz, int index) {
        if (clazz != null) {
            this.numbers.put(clazz, index);
        }
    }

    public void writeObject(ObjectOutput output, Set set) throws IOException {
        int number = this.numbers.get(set.getClass(), 0);
        if (number == 0) {
            output.writeObject(set);
        } else {
            output.writeByte(number);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)set.size());
            for (Object o : set) {
                output.writeObject(o);
            }
        }
    }

    public Set readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        if (magicNumber == 0) {
            return (Set)input.readObject();
        }
        EnumSet<Enum> enumSet = null;
        int size = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        block3: for (int i = 0; i < size; ++i) {
            switch (magicNumber) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (i == 0) {
                        enumSet = EnumSet.of((Enum)input.readObject());
                        continue block3;
                    }
                    enumSet.add((Enum)input.readObject());
                }
            }
        }
        return enumSet;
    }

    public Integer getId() {
        return 63;
    }

    public Set<Class<? extends Set>> getTypeClasses() {
        HashSet<Class<? extends Set>> set = new HashSet<Class<? extends Set>>();
        set.add(EnumSet.class);
        this.addEnumSetType(this.getRegularEnumSetClass(), set);
        this.addEnumSetType(this.getJumboEnumSetClass(), set);
        this.addEnumSetType(this.getMiniEnumSetClass(), set);
        this.addEnumSetType(this.getHugeEnumSetClass(), set);
        return set;
    }

    private void addEnumSetType(Class<? extends Set> clazz, Set<Class<? extends Set>> typeSet) {
        if (clazz != null) {
            typeSet.add(clazz);
        }
    }

    private Class<EnumSet> getJumboEnumSetClass() {
        return this.getEnumSetClass("java.util.JumboEnumSet");
    }

    private Class<EnumSet> getRegularEnumSetClass() {
        return this.getEnumSetClass("java.util.RegularEnumSet");
    }

    private Class<EnumSet> getMiniEnumSetClass() {
        return this.getEnumSetClass("java.util.MiniEnumSet");
    }

    private Class<EnumSet> getHugeEnumSetClass() {
        return this.getEnumSetClass("java.util.HugeEnumSet");
    }

    private Class<EnumSet> getEnumSetClass(String className) {
        try {
            return Util.loadClassStrict((String)className, (ClassLoader)EnumSet.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

