/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso.coarse;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.web.cache.sso.SessionsFactory;
import org.wildfly.clustering.web.cache.sso.coarse.CoarseSessions;
import org.wildfly.clustering.web.cache.sso.coarse.SessionFilter;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessionsKey;
import org.wildfly.clustering.web.infinispan.sso.coarse.SessionsFilter;
import org.wildfly.clustering.web.sso.Sessions;

public class CoarseSessionsFactory<D, S>
implements SessionsFactory<Map<D, S>, D, S> {
    private final SessionsFilter<D, S> filter = new SessionsFilter();
    private final Cache<CoarseSessionsKey, Map<D, S>> cache;
    private final CacheProperties properties;

    public CoarseSessionsFactory(Cache<CoarseSessionsKey, Map<D, S>> cache, CacheProperties properties) {
        this.cache = cache;
        this.properties = properties;
    }

    public Sessions<D, S> createSessions(String ssoId, Map<D, S> value) {
        CoarseSessionsKey key = new CoarseSessionsKey(ssoId);
        CacheEntryMutator mutator = new CacheEntryMutator(this.cache, (Object)key, value);
        return new CoarseSessions(value, (Mutator)mutator);
    }

    public Map<D, S> createValue(String id, Void context) {
        AbstractMap sessions = this.properties.isLockOnRead() ? new HashMap() : new ConcurrentHashMap();
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)new CoarseSessionsKey(id), sessions);
        return sessions;
    }

    public Map<D, S> findValue(String id) {
        return (Map)this.cache.get((Object)new CoarseSessionsKey(id));
    }

    public Map.Entry<String, Map<D, S>> findEntryContaining(S session) {
        SessionFilter filter = new SessionFilter(session);
        Cache<CoarseSessionsKey, Map<D, S>> cache = this.cache;
        try (CacheStream stream = cache.entrySet().stream();){
            Map.Entry entry = stream.filter(this.filter).map(this.filter).filter((Predicate<S>)filter).findAny().orElse(null);
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = entry != null ? new AbstractMap.SimpleImmutableEntry(((CoarseSessionsKey)((Object)entry.getKey())).getValue(), entry.getValue()) : null;
            return simpleImmutableEntry;
        }
    }

    public boolean remove(String id) {
        return this.cache.getAdvancedCache().remove((Object)new CoarseSessionsKey(id)) != null;
    }
}

