/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.store.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.StartTlsResponse;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPContextManager;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPUtil;
import org.keycloak.storage.ldap.mappers.LDAPOperationDecorator;

public class LDAPOperationManager {
    private static final Logger logger = Logger.getLogger(LDAPOperationManager.class);
    private static final Logger perfLogger = Logger.getLogger(LDAPOperationManager.class, (String)"perf");
    private final KeycloakSession session;
    private final LDAPConfig config;

    public LDAPOperationManager(KeycloakSession session, LDAPConfig config) {
        this.session = session;
        this.config = config;
    }

    public void modifyAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, attribute)};
        this.modifyAttributes(dn, mods, null);
    }

    public void modifyAttributes(String dn, NamingEnumeration<Attribute> attributes) {
        try {
            ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>();
            while (attributes.hasMore()) {
                ModificationItem modItem = new ModificationItem(2, attributes.next());
                modItems.add(modItem);
            }
            this.modifyAttributes(dn, modItems.toArray(new ModificationItem[0]), null);
        }
        catch (NamingException ne) {
            throw new ModelException("Could not modify attributes on entry from DN [" + dn + "]", (Throwable)ne);
        }
    }

    public void removeAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, attribute)};
        this.modifyAttributes(dn, mods, null);
    }

    public void addAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, attribute)};
        this.modifyAttributes(dn, mods, null);
    }

    public void removeEntry(final String entryDn) {
        try {
            this.execute(new LdapOperation<SearchResult>(){

                @Override
                public SearchResult execute(LdapContext context) throws NamingException {
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Removing entry with DN [%s]", (Object)entryDn);
                    }
                    LDAPOperationManager.this.destroySubcontext(context, entryDn);
                    return null;
                }

                public String toString() {
                    return "LdapOperation: remove\n" + " dn: " + entryDn;
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Could not remove entry from DN [" + entryDn + "]", (Throwable)e);
        }
    }

    public String renameEntry(final String oldDn, final String newDn, final boolean fallback) {
        try {
            String newNonConflictingDn = this.execute(new LdapOperation<String>(){

                @Override
                public String execute(LdapContext context) throws NamingException {
                    String dn = newDn;
                    int max = 5;
                    for (int i = 0; i < max; ++i) {
                        try {
                            context.rename(new LdapName(oldDn), new LdapName(dn));
                            return dn;
                        }
                        catch (NameAlreadyBoundException ex) {
                            if (!fallback) {
                                throw ex;
                            }
                            String failedDn = dn;
                            if (i >= max) {
                                logger.warnf("Failed all fallbacks for renaming [%s]", (Object)oldDn);
                                throw ex;
                            }
                            dn = LDAPOperationManager.this.findNextDNForFallback(newDn, i);
                            logger.warnf("Failed to rename DN [%s] to [%s]. Will try to fallback to DN [%s]", (Object)oldDn, (Object)failedDn, (Object)dn);
                            continue;
                        }
                    }
                    throw new ModelException("Could not rename entry from DN [" + oldDn + "] to new DN [" + newDn + "]. All fallbacks failed");
                }

                public String toString() {
                    return "LdapOperation: renameEntry\n" + " oldDn: " + oldDn + "\n" + " newDn: " + newDn;
                }
            });
            return newNonConflictingDn;
        }
        catch (NamingException e) {
            throw new ModelException("Could not rename entry from DN [" + oldDn + "] to new DN [" + newDn + "]", (Throwable)e);
        }
    }

    private String findNextDNForFallback(String newDn, int counter) {
        LDAPDn dn = LDAPDn.fromString(newDn);
        String rdnAttrName = dn.getFirstRdnAttrName();
        String rdnAttrVal = dn.getFirstRdnAttrValue();
        LDAPDn parentDn = dn.getParentDn();
        parentDn.addFirst(rdnAttrName, rdnAttrVal + counter);
        return parentDn.toString();
    }

    public List<SearchResult> search(final String baseDN, final String filter, final Collection<String> returningAttributes, final int searchScope) throws NamingException {
        final ArrayList result = new ArrayList();
        final SearchControls cons = this.getSearchControls(returningAttributes, searchScope);
        try {
            return this.execute(new LdapOperation<List<SearchResult>>(){

                @Override
                public List<SearchResult> execute(LdapContext context) throws NamingException {
                    NamingEnumeration<SearchResult> search = context.search((Name)new LdapName(baseDN), filter, cons);
                    while (search.hasMoreElements()) {
                        result.add(search.nextElement());
                    }
                    search.close();
                    return result;
                }

                public String toString() {
                    return "LdapOperation: search\n" + " baseDn: " + baseDN + "\n" + " filter: " + filter + "\n" + " searchScope: " + searchScope + "\n" + " returningAttrs: " + returningAttributes + "\n" + " resultSize: " + result.size();
                }
            });
        }
        catch (NamingException e) {
            logger.errorf((Throwable)e, "Could not query server using DN [%s] and filter [%s]", (Object)baseDN, (Object)filter);
            throw e;
        }
    }

    public List<SearchResult> searchPaginated(final String baseDN, final String filter, final LDAPQuery identityQuery) throws NamingException {
        final ArrayList result = new ArrayList();
        final SearchControls cons = this.getSearchControls(identityQuery.getReturningLdapAttributes(), identityQuery.getSearchScope());
        if (identityQuery.getPaginationContext() == null) {
            identityQuery.initPagination();
        }
        try {
            return this.execute(new LdapOperation<List<SearchResult>>(){

                @Override
                public List<SearchResult> execute(LdapContext context) throws NamingException {
                    try {
                        byte[] cookie = identityQuery.getPaginationContext().getCookie();
                        PagedResultsControl pagedControls = new PagedResultsControl(identityQuery.getLimit(), cookie, true);
                        context.setRequestControls(new Control[]{pagedControls});
                        NamingEnumeration<SearchResult> search = context.search((Name)new LdapName(baseDN), filter, cons);
                        while (search.hasMoreElements()) {
                            result.add(search.nextElement());
                        }
                        search.close();
                        Control[] responseControls = context.getResponseControls();
                        if (responseControls != null) {
                            for (Control respControl : responseControls) {
                                if (!(respControl instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)respControl;
                                cookie = prrc.getCookie();
                                identityQuery.getPaginationContext().setCookie(cookie);
                            }
                        }
                        return result;
                    }
                    catch (IOException ioe) {
                        logger.errorf((Throwable)ioe, "Could not query server with paginated query using DN [%s], filter [%s]", (Object)baseDN, (Object)filter);
                        throw new NamingException(ioe.getMessage());
                    }
                }

                public String toString() {
                    return "LdapOperation: searchPaginated\n" + " baseDn: " + baseDN + "\n" + " filter: " + filter + "\n" + " searchScope: " + identityQuery.getSearchScope() + "\n" + " returningAttrs: " + identityQuery.getReturningLdapAttributes() + "\n" + " limit: " + identityQuery.getLimit() + "\n" + " resultSize: " + result.size();
                }
            }, identityQuery.getPaginationContext().getLdapContext(), null);
        }
        catch (NamingException e) {
            logger.errorf((Throwable)e, "Could not query server using DN [%s] and filter [%s]", (Object)baseDN, (Object)filter);
            throw e;
        }
    }

    private SearchControls getSearchControls(Collection<String> returningAttributes, int searchScope) {
        SearchControls cons = new SearchControls();
        cons.setSearchScope(searchScope);
        cons.setReturningObjFlag(false);
        returningAttributes = this.getReturningAttributes(returningAttributes);
        cons.setReturningAttributes(returningAttributes.toArray(new String[returningAttributes.size()]));
        return cons;
    }

    public String getFilterById(String id) {
        String filter = null;
        if (this.config.isObjectGUID()) {
            final String strObjectGUID = "<GUID=" + id + ">";
            try {
                Attributes attributes = this.execute(new LdapOperation<Attributes>(){

                    @Override
                    public Attributes execute(LdapContext context) throws NamingException {
                        return context.getAttributes(strObjectGUID);
                    }

                    public String toString() {
                        return "LdapOperation: GUIDResolve\n" + " strObjectGUID: " + strObjectGUID;
                    }
                });
                byte[] objectGUID = (byte[])attributes.get("objectGUID").get();
                filter = "(&(objectClass=*)(" + this.getUuidAttributeName() + "=" + LDAPUtil.convertObjectGUIDToByteString(objectGUID) + "))";
            }
            catch (NamingException ne) {
                filter = null;
            }
        }
        if (filter == null) {
            filter = "(&(objectClass=*)(" + this.getUuidAttributeName() + "=" + id + "))";
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Using filter for lookup user by LDAP ID: %s", filter);
        }
        return filter;
    }

    public SearchResult lookupById(final String baseDN, String id, final Collection<String> returningAttributes) {
        final String filter = this.getFilterById(id);
        try {
            final SearchControls cons = this.getSearchControls(returningAttributes, this.config.getSearchScope());
            return this.execute(new LdapOperation<SearchResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public SearchResult execute(LdapContext context) throws NamingException {
                    try (NamingEnumeration<SearchResult> search = context.search((Name)new LdapName(baseDN), filter, cons);){
                        if (search.hasMoreElements()) {
                            SearchResult searchResult = search.next();
                            return searchResult;
                        }
                    }
                    return null;
                }

                public String toString() {
                    return "LdapOperation: lookupById\n" + " baseDN: " + baseDN + "\n" + " filter: " + filter + "\n" + " searchScope: " + cons.getSearchScope() + "\n" + " returningAttrs: " + returningAttributes;
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Could not query server using DN [" + baseDN + "] and filter [" + filter + "]", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySubcontext(LdapContext context, String dn) {
        try {
            NamingEnumeration<Binding> enumeration = null;
            try {
                enumeration = context.listBindings(new LdapName(dn));
                while (enumeration.hasMore()) {
                    Binding binding = enumeration.next();
                    String name = binding.getNameInNamespace();
                    this.destroySubcontext(context, name);
                }
                context.unbind(new LdapName(dn));
            }
            finally {
                try {
                    enumeration.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            throw new ModelException("Could not unbind DN [" + dn + "]", (Throwable)e);
        }
    }

    public void authenticate(String dn, String password) throws AuthenticationException {
        if (password == null || password.isEmpty()) {
            throw new AuthenticationException("Empty password used");
        }
        Context authCtx = null;
        StartTlsResponse tlsResponse = null;
        try {
            Hashtable<Object, Object> env = LDAPContextManager.getConnectionProperties(this.config);
            env.put("com.sun.jndi.ldap.connect.pool", "false");
            if (!this.config.isStartTls()) {
                env.put("java.naming.security.authentication", this.config.getAuthType());
                env.put("java.naming.security.principal", dn);
                env.put("java.naming.security.credentials", password);
            }
            authCtx = new InitialLdapContext(env, null);
            if (this.config.isStartTls()) {
                tlsResponse = LDAPContextManager.startTLS((LdapContext)authCtx, this.config.getAuthType(), dn, password.toCharArray());
            }
        }
        catch (AuthenticationException ae) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)ae, "Authentication failed for DN [%s]", (Object)dn);
            }
            throw ae;
        }
        catch (Exception e) {
            logger.errorf((Throwable)e, "Unexpected exception when validating password of DN [%s]", (Object)dn);
            throw new AuthenticationException("Unexpected exception when validating password of user");
        }
        finally {
            if (tlsResponse != null) {
                try {
                    tlsResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (authCtx != null) {
                try {
                    authCtx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void modifyAttributesNaming(final String dn, final ModificationItem[] mods, LDAPOperationDecorator decorator) throws NamingException {
        if (logger.isTraceEnabled()) {
            logger.tracef("Modifying attributes for entry [%s]: [", (Object)dn);
            for (ModificationItem item : mods) {
                Object values = item.getAttribute().size() > 0 ? item.getAttribute().get() : "No values";
                String attrName = item.getAttribute().getID().toUpperCase();
                if (attrName.contains("PASSWORD") || attrName.contains("UNICODEPWD")) {
                    values = "********************";
                }
                logger.tracef("  Op [%s]: %s = %s", item.getModificationOp(), (Object)item.getAttribute().getID(), values);
            }
            logger.tracef("]", new Object[0]);
        }
        this.execute(new LdapOperation<Void>(){

            @Override
            public Void execute(LdapContext context) throws NamingException {
                context.modifyAttributes(new LdapName(dn), mods);
                return null;
            }

            public String toString() {
                return "LdapOperation: modify\n" + " dn: " + dn + "\n" + " modificationsSize: " + mods.length;
            }
        }, decorator);
    }

    public void modifyAttributes(String dn, ModificationItem[] mods, LDAPOperationDecorator decorator) {
        try {
            this.modifyAttributesNaming(dn, mods, decorator);
        }
        catch (NamingException e) {
            throw new ModelException("Could not modify attribute for DN [" + dn + "]", (Throwable)e);
        }
    }

    public void createSubContext(final String name, final Attributes attributes) {
        try {
            if (logger.isTraceEnabled()) {
                logger.tracef("Creating entry [%s] with attributes: [", (Object)name);
                NamingEnumeration<? extends Attribute> all = attributes.getAll();
                while (all.hasMore()) {
                    Attribute attribute = all.next();
                    String attrName = attribute.getID().toUpperCase();
                    Object attrVal = attribute.get();
                    if (attrName.contains("PASSWORD") || attrName.contains("UNICODEPWD")) {
                        attrVal = "********************";
                    }
                    logger.tracef("  %s = %s", (Object)attribute.getID(), attrVal);
                }
                logger.tracef("]", new Object[0]);
            }
            this.execute(new LdapOperation<Void>(){

                @Override
                public Void execute(LdapContext context) throws NamingException {
                    DirContext subcontext = context.createSubcontext(new LdapName(name), attributes);
                    subcontext.close();
                    return null;
                }

                public String toString() {
                    return "LdapOperation: create\n" + " dn: " + name + "\n" + " attributesSize: " + attributes.size();
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Error creating subcontext [" + name + "]", (Throwable)e);
        }
    }

    private String getUuidAttributeName() {
        return this.config.getUuidLDAPAttributeName();
    }

    public Attributes getAttributes(String entryUUID, String baseDN, Set<String> returningAttributes) {
        SearchResult search = this.lookupById(baseDN, entryUUID, returningAttributes);
        if (search == null) {
            throw new ModelException("Couldn't find item with ID [" + entryUUID + " under base DN [" + baseDN + "]");
        }
        return search.getAttributes();
    }

    public String decodeEntryUUID(Object entryUUID) {
        if (entryUUID instanceof byte[]) {
            if (this.config.isObjectGUID()) {
                return LDAPUtil.decodeObjectGUID((byte[])entryUUID);
            }
            if (this.config.isEdirectory() && this.config.isEdirectoryGUID()) {
                return LDAPUtil.decodeGuid((byte[])entryUUID);
            }
        }
        return entryUUID.toString();
    }

    private <R> R execute(LdapOperation<R> operation) throws NamingException {
        return this.execute(operation, null);
    }

    private <R> R execute(LdapOperation<R> operation, LDAPOperationDecorator decorator) throws NamingException {
        try (LDAPContextManager ldapContextManager = LDAPContextManager.create(this.session, this.config);){
            R r = this.execute(operation, ldapContextManager.getLdapContext(), decorator);
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R execute(LdapOperation<R> operation, LdapContext context, LDAPOperationDecorator decorator) throws NamingException {
        if (context == null) {
            throw new IllegalArgumentException("Ldap context cannot be null");
        }
        Long start = null;
        if (perfLogger.isDebugEnabled()) {
            start = Time.currentTimeMillis();
        }
        try {
            if (decorator != null) {
                decorator.beforeLDAPOperation(context, operation);
            }
            R r = operation.execute(context);
            return r;
        }
        finally {
            if (perfLogger.isDebugEnabled()) {
                long took = Time.currentTimeMillis() - start;
                if (took > 100L) {
                    perfLogger.debugf("\n%s\ntook: %d ms\n", (Object)operation.toString(), (Object)took);
                } else if (perfLogger.isTraceEnabled()) {
                    perfLogger.tracef("\n%s\ntook: %d ms\n", (Object)operation.toString(), (Object)took);
                }
            }
        }
    }

    private Set<String> getReturningAttributes(Collection<String> returningAttributes) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(returningAttributes);
        result.add(this.getUuidAttributeName());
        result.add("objectclass");
        return result;
    }

    public static interface LdapOperation<R> {
        public R execute(LdapContext var1) throws NamingException;
    }
}

